/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.function;

import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.AggregationFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.SumFunction;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.common.EASBizException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class AvgFunction
extends AggregationFunction {
    @Override
    public DataInfo execute(DataInfo args, String columnNames) throws EASBizException {
        List<BigDecimal> listForCalculate = CheckPointUtils.getListForCalculate(args, columnNames);
        if (listForCalculate == null || listForCalculate.isEmpty()) {
            return args;
        }
        BigDecimal result = SumFunction.getSum(listForCalculate);
        args.setType(ModelTypeEnum.Field);
        FieldModelInfo fieldModelInfo = new FieldModelInfo();
        fieldModelInfo.setF(columnNames);
        fieldModelInfo.setV(listForCalculate.size() == 0 ? BigDecimal.ZERO : result.divide(new BigDecimal(listForCalculate.size()), 2, 4).stripTrailingZeros().toPlainString());
        ArrayList<FieldModelInfo> fieldModelInfos = new ArrayList<FieldModelInfo>();
        fieldModelInfos.add(fieldModelInfo);
        args.setFieldModels(fieldModelInfos);
        return args;
    }

    @Override
    public String getFunctionName() {
        return "avg";
    }

    @Override
    public String getFunctionAlias() {
        return "\u6c42\u5e73\u5747\u503c(" + this.getFunctionName() + ")";
    }

    @Override
    public String getFunctionDesc() {
        return "\u6c42\u5e73\u5747\u503c\u51fd\u6570\uff1a\u4e00\u4e2a\u53c2\u6570\uff0c\u6570\u5b57\u7c7b\u578b\u3002\n\u53c2\u6570\u4e00\u822c\u8bbe\u7f6e\u5206\u5f55\u5b57\u6bb5\uff0c\u6c42\u591a\u6761\u5206\u5f55\u8be5\u5b57\u6bb5\u7684\u5e73\u5747\u503c\u3002\u8fc7\u7a0b\u4e2d\u5982\u679c\u51fa\u73b0\u5f02\u5e38(\u5982\u4f20\u503c\u4e0d\u662f\u6570\u5b57),\u5219\u8fd4\u56de\u7a7a\u3002";
    }

    @Override
    public String getFuncParamType() {
        return "0:false";
    }
}

