/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.CompareManager;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.data.DynamicAttributeData;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.data.EntityData;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.data.IData;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.data.SqlData;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.handler.AbstractExprHandler;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.SQLInfo;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class CommonExprHandler
extends AbstractExprHandler {
    public CommonExprHandler(RuleEntryInfo ruleEntryInfo) {
        super(ruleEntryInfo);
    }

    @Override
    public DataInfo getExprRealValue(Context ctx, String expr) throws BOSException, EASBizException {
        CheckpointDataSetInfo dataSetInfo = this.ruleEntryInfo.getDataSetInfo();
        DataInfo info = null;
        if (expr.contains("{$")) {
            String alias = this.verifyColumn(expr);
            SQLInfo sqlInfo = this.ruleEntryInfo.getSqlInfo();
            IData data = sqlInfo != null ? (sqlInfo.getFromItem().contains(" " + dataSetInfo.getEntityalias()) ? new SqlData(expr) : (alias.startsWith(dataSetInfo.getEntityalias()) ? new EntityData(expr) : new SqlData(expr))) : new EntityData(expr);
            info = data.getData(ctx, this.ruleEntryInfo);
        } else if (expr.contains("{@")) {
            DynamicAttributeData data = new DynamicAttributeData(expr);
            info = data.getData(ctx, this.ruleEntryInfo);
        } else {
            info = CheckPointUtils.genFieldModelDataInfo(expr, expr);
        }
        info.setExpr(expr);
        return info;
    }

    private String verifyColumn(String expr) throws EASBizException {
        Matcher matcher;
        String alias = "";
        String column = "";
        try {
            matcher = CompareManager.pattern3.matcher(expr);
            if (matcher.find()) {
                alias = matcher.group(0);
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "get expr's alias failed\uff01expr:" + expr), (Throwable)e);
        }
        try {
            matcher = CompareManager.pattern1.matcher(expr);
            if (matcher.find()) {
                column = matcher.group(1);
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "get expr's column failed\uff01expr:" + expr), (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)alias) || StringUtils.isEmpty((CharSequence)column)) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "get expr's alias or column failed\uff01expr:" + expr));
        }
        return alias;
    }
}

