/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkscheme.node.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.AssignException;
import com.kingdee.eas.base.ssc.BillTypeFactory;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.CheckRangeCollection;
import com.kingdee.eas.base.ssc.CheckRangeInfo;
import com.kingdee.eas.base.ssc.CheckSchemeInfo;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.RecheckStateEnum;
import com.kingdee.eas.base.ssc.ReviseStateEnum;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.SampleStateEnum;
import com.kingdee.eas.base.ssc.SampleTaskStateEnum;
import com.kingdee.eas.base.ssc.app.assign.node.pojo.NodeTrackPojo;
import com.kingdee.eas.base.ssc.app.checkscheme.node.impl.AbstractCheckSchemeNode;
import com.kingdee.eas.base.ssc.app.checkscheme.thread.GetDataThread;
import com.kingdee.eas.base.ssc.app.checkscheme.thread.TaskInfo;
import com.kingdee.eas.base.ssc.assign.AssignFlowNodeInfo;
import com.kingdee.eas.base.ssc.assign.AssignModelInfo;
import com.kingdee.eas.base.ssc.tool.SSCBaseBillUtils;
import com.kingdee.eas.base.ssc.tool.SSCDbUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

public class FilterJobByRuleNode
extends AbstractCheckSchemeNode {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAssignee4MatchSuccess(Context ctx, AssignFlowNodeInfo assignFlowNode, AssignModelInfo modelInfo) throws AssignException {
        CheckSchemeInfo checkSchemeInfo = (CheckSchemeInfo)modelInfo.getDynamicAttributes("schemeInfo");
        NodeTrackPojo nodeTrack = new NodeTrackPojo("\u6839\u636e\u65b9\u6848\u89c4\u5219\u5b9a\u4e49\u8fc7\u6ee4\u4efb\u52a1");
        try {
            StringBuilder baseQuerySql = (StringBuilder)modelInfo.getDynamicAttributes("baseQuerySql");
            Object[] timeParams = (Object[])modelInfo.getDynamicAttributes("timeParams");
            String querySql = baseQuerySql.toString();
            try {
                List<SampleLibraryQualityTaskInfo> queryTaskInfos = this.getQueryTaskInfos(ctx, querySql, timeParams, checkSchemeInfo, nodeTrack);
                modelInfo.setDynamicAttributes("queryTaskInfos", queryTaskInfos);
                modelInfo.removeDynamicAttributes("baseQuerySql");
                modelInfo.removeDynamicAttributes("timeParams");
            }
            catch (Exception e) {
                throw new AssignException(new NumericExceptionSubItem("XX", "\u83b7\u53d6\u4efb\u52a1\u6570\u91cf\u5931\u8d25\uff01"), e);
            }
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                this.saveNodeTrack(ctx, modelInfo, nodeTrack.getValues());
            }
            catch (Exception e) {
                logger.error((Object)("\u4fdd\u5b58\u8282\u70b9\u8ddf\u8e2a\u8bb0\u5f55\u5931\u8d25" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private List<SampleLibraryQualityTaskInfo> getQueryTaskInfos(Context ctx, String querySql, Object[] timeParams, CheckSchemeInfo checkSchemeInfo, NodeTrackPojo nodeTrack) throws BOSException, UuidException, SQLException, EASBizException {
        int i;
        ArrayList<SampleLibraryQualityTaskInfo> qualityTasks = new ArrayList<SampleLibraryQualityTaskInfo>();
        IRowSet rowset = null;
        querySql = "/*dialect*/" + querySql;
        CheckRangeCollection checkRangeCollection = checkSchemeInfo.getCheckRange();
        StringBuilder expr = new StringBuilder();
        if (checkRangeCollection != null && checkRangeCollection.size() > 0) {
            int len = checkRangeCollection.size();
            for (i = 0; i < len; ++i) {
                CheckRangeInfo entryInfo = checkRangeCollection.get(i);
                expr.append(StringUtils.isEmpty((CharSequence)entryInfo.getLeftBracket()) ? "" : entryInfo.getLeftBracket() + " ");
                expr.append(StringUtils.isEmpty((CharSequence)entryInfo.getPropertyName()) ? "" : entryInfo.getPropertyName() + ":").append(entryInfo.getProperty() + " ");
                expr.append(StringUtils.isEmpty((CharSequence)entryInfo.getCompareType()) ? "" : entryInfo.getCompareType() + " ");
                expr.append(StringUtils.isEmpty((CharSequence)entryInfo.getCompareValueName()) ? "" : entryInfo.getCompareValueName() + ":").append(entryInfo.getCompareValue() + " ");
                expr.append(StringUtils.isEmpty((CharSequence)entryInfo.getRightBracket()) ? "" : entryInfo.getRightBracket() + " ");
                expr.append(StringUtils.isEmpty((CharSequence)entryInfo.getFilterItem()) ? "" : entryInfo.getFilterItem() + " ");
            }
        }
        if (expr.length() > 0) {
            nodeTrack.setDesc(nodeTrack.getDesc() + "\u65b9\u6848\u8bbe\u7f6e\u7684\u89c4\u5219\u5b9a\u4e49\u8868\u8fbe\u5f0f\uff1a\u3010" + expr + "\u3011\uff1b");
        } else {
            nodeTrack.setDesc(nodeTrack.getDesc() + "\u65b9\u6848\u6ca1\u6709\u8bbe\u7f6e\u89c4\u5219\u5b9a\u4e49\uff1b");
        }
        HashSet<String> billSet = new HashSet<String>();
        for (i = 0; i < 20; ++i) {
            long begTime = System.currentTimeMillis();
            rowset = SSCDbUtil.executeQuery(ctx, querySql, timeParams, i * 10000, 10000);
            int n = 0;
            while (rowset.next()) {
                if (billSet.contains(rowset.getString("fbillId"))) continue;
                billSet.add(rowset.getString("fbillId"));
                ++n;
            }
            long endTime = System.currentTimeMillis();
            nodeTrack.setDesc(nodeTrack.getDesc() + "\u7b2c" + (i + 1) + "\u6b21\u67e5\u8be2\u5f97\u5230\u5355\u636e\u6570\u91cf: " + n + "\u6761\uff0c\u8017\u65f6: " + (endTime - begTime) + "ms\uff1b");
            rowset.beforeFirst();
            qualityTasks.addAll(this.getTaskInfos(ctx, rowset, checkSchemeInfo, nodeTrack));
            if (rowset.size() < 10000) break;
        }
        return qualityTasks;
    }

    private List<SampleLibraryQualityTaskInfo> getTaskInfos(Context ctx, IRowSet rowset, CheckSchemeInfo checkSchemeInfo, NodeTrackPojo nodeTrack) throws SQLException, EASBizException, BOSException {
        List<SampleLibraryQualityTaskInfo> qualityTasks = new ArrayList<SampleLibraryQualityTaskInfo>();
        if (rowset != null) {
            CheckRangeCollection checkRangeCollection = checkSchemeInfo.getCheckRange();
            if (checkRangeCollection != null && checkRangeCollection.size() > 0) {
                qualityTasks = this.filterRule(ctx, rowset, checkSchemeInfo);
                nodeTrack.setDesc(nodeTrack.getDesc() + "\u6839\u636e\u89c4\u5219\u5b9a\u4e49\u8fc7\u6ee4\u540e\u5f97\u5230\u7684\u5355\u636e\u6570\uff1a" + qualityTasks.size() + "\u6761\uff1b");
            } else {
                SampleLibraryQualityTaskInfo qtyTaskInfo = null;
                HashSet<String> billSet = new HashSet<String>(rowset.size());
                while (rowset.next()) {
                    if (billSet.contains(rowset.getString("FBILLID"))) continue;
                    billSet.add(rowset.getString("FBILLID"));
                    qtyTaskInfo = this.createSampleLibraryQualityTaskInfoByRowSet(rowset);
                    qualityTasks.add(qtyTaskInfo);
                }
                nodeTrack.setDesc(nodeTrack.getDesc() + "\u5f97\u5230\u7684\u5355\u636e\u6570\uff1a" + qualityTasks.size() + "\u6761\uff1b");
            }
        }
        return qualityTasks;
    }

    private List<SampleLibraryQualityTaskInfo> filterRule(Context ctx, IRowSet rowset, CheckSchemeInfo checkSchemeInfo) throws SQLException, EASBizException, BOSException {
        Future<TaskInfo> taskInfoFuture;
        ArrayList<SampleLibraryQualityTaskInfo> result = new ArrayList<SampleLibraryQualityTaskInfo>();
        CheckRangeCollection checkRangeCollection = checkSchemeInfo.getCheckRange();
        List<String> attrColumn = this.getRuleColumn(checkRangeCollection, "^\\{@\\S*}$");
        List<String> billColumn = this.getRuleColumn(checkRangeCollection, "^\\{\\$\\S*}$");
        ArrayList<SampleLibraryQualityTaskInfo> taskInfoList = new ArrayList<SampleLibraryQualityTaskInfo>();
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo("select bindBillEntry where id = '" + checkSchemeInfo.getBilltype().getId().toString() + "'");
        int number = 0;
        ArrayList<Future<TaskInfo>> futureList = new ArrayList<Future<TaskInfo>>();
        HashSet<String> billSet = new HashSet<String>(rowset.size());
        while (rowset.next()) {
            if (number < 1000) {
                if (billSet.contains(rowset.getString("FBILLID"))) continue;
                billSet.add(rowset.getString("FBILLID"));
                ++number;
                taskInfoList.add(this.createSampleLibraryQualityTaskInfoByRowSet(rowset));
                continue;
            }
            number = 0;
            taskInfoFuture = this.getPool(ctx).submit(new GetDataThread(ctx, taskInfoList, attrColumn, billColumn, billTypeInfo.getBindBillEntry(), checkRangeCollection));
            futureList.add(taskInfoFuture);
            taskInfoList = new ArrayList();
        }
        if (taskInfoList.size() > 0) {
            taskInfoFuture = this.getPool(ctx).submit(new GetDataThread(ctx, taskInfoList, attrColumn, billColumn, billTypeInfo.getBindBillEntry(), checkRangeCollection));
            futureList.add(taskInfoFuture);
        }
        try {
            while (futureList.size() > 0) {
                Iterator iterable = futureList.iterator();
                while (iterable.hasNext()) {
                    Future future = (Future)iterable.next();
                    if (future.isDone() && !future.isCancelled()) {
                        TaskInfo i = (TaskInfo)future.get();
                        if (i != null) {
                            result.addAll(i.getFilterList());
                        }
                        iterable.remove();
                        continue;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (Exception e) {
            throw new AssignException(new NumericExceptionSubItem("00", "\u7b49\u5f85\u7ebf\u7a0b\u8fd4\u56de\u7ed3\u679c\u65f6\u53d1\u751f\u9519\u8bef\uff01" + e.getMessage()), e);
        }
        return result;
    }

    private List<String> getRuleColumn(CheckRangeCollection checkRangeCollection, String regex) {
        HashSet<String> attrColumn = new HashSet<String>();
        int len = checkRangeCollection.size();
        for (int i = 0; i < len; ++i) {
            CheckRangeInfo entryInfo = checkRangeCollection.get(i);
            String key = entryInfo.getProperty();
            Map<Integer, String> exprs = SSCBaseBillUtils.getKeyV_key(key);
            attrColumn.addAll(SSCBaseBillUtils.getColumns(exprs, regex));
            key = entryInfo.getCompareValue();
            exprs = SSCBaseBillUtils.getKeyV_key(key);
            attrColumn.addAll(SSCBaseBillUtils.getColumns(exprs, regex));
        }
        return new ArrayList<String>(attrColumn);
    }

    private SampleLibraryQualityTaskInfo createSampleLibraryQualityTaskInfoByRowSet(IRowSet rowset) throws SQLException {
        SampleLibraryQualityTaskInfo qtyTaskInfo = new SampleLibraryQualityTaskInfo();
        qtyTaskInfo.setSubject(rowset.getString("FSUBJECT"));
        qtyTaskInfo.setBillId(rowset.getString("FBILLID"));
        qtyTaskInfo.setJobHisId(rowset.getString("FID"));
        qtyTaskInfo.setShareCenterId(rowset.getString("FShareCenterID"));
        if (rowset.getString("ORGFID") != null) {
            OrgInfo orgInfo = new OrgInfo();
            orgInfo.setId(BOSUuid.read((String)rowset.getString("ORGFID")));
            qtyTaskInfo.setOrg(orgInfo);
        }
        qtyTaskInfo.setTaskState(SampleStateEnum.Undistributed);
        if (rowset.getString("BTID") != null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)rowset.getString("BTID")));
            qtyTaskInfo.setBillType(billType);
        }
        qtyTaskInfo.setRecheckstate(RecheckStateEnum.Normal);
        qtyTaskInfo.setTaskStateN(SampleTaskStateEnum.NORMAL);
        qtyTaskInfo.setReviseState(ReviseStateEnum.NotRevised);
        return qtyTaskInfo;
    }
}

