/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkscheme.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.CheckRangeCollection;
import com.kingdee.eas.base.ssc.CheckRangeInfo;
import com.kingdee.eas.base.ssc.DynValueHisCollection;
import com.kingdee.eas.base.ssc.DynValueHisFactory;
import com.kingdee.eas.base.ssc.DynValueHisInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.app.assign.util.DataTransferUtils;
import com.kingdee.eas.base.ssc.app.checkscheme.thread.TaskInfo;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.base.ssc.tool.SSCBaseBillUtils;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.tool.samplelib.DealInfo;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class GetDataThread
implements Callable<TaskInfo> {
    private static Logger logger = Logger.getLogger(GetDataThread.class);
    private List<SampleLibraryQualityTaskInfo> list;
    private Context ctx;
    List<String> attrColumn;
    List<String> billColumn;
    private String sourceBillClass;
    private CheckRangeCollection checkRangeCollection;
    private static ScriptEngineManager manager = new ScriptEngineManager();
    private static ScriptEngine engine = manager.getEngineByName("JavaScript");

    public GetDataThread(Context ctx, List<SampleLibraryQualityTaskInfo> list, List<String> attrColumn, List<String> billColumn, String sourceBillClass, CheckRangeCollection checkRangeCollection) {
        this.ctx = ctx;
        this.list = list;
        this.attrColumn = attrColumn;
        this.billColumn = billColumn;
        this.sourceBillClass = sourceBillClass;
        this.checkRangeCollection = checkRangeCollection;
    }

    @Override
    public TaskInfo call() throws Exception {
        if (this.list == null || this.list.isEmpty()) {
            return null;
        }
        TaskInfo taskInfo = new TaskInfo();
        HashSet<String> billIds = new HashSet<String>();
        HashSet<String> jobIds = new HashSet<String>();
        int len = this.list.size();
        for (int i = 0; i < len; ++i) {
            SampleLibraryQualityTaskInfo qualityTaskInfo = this.list.get(i);
            billIds.add(qualityTaskInfo.getBillId());
            jobIds.add(qualityTaskInfo.getJobHisId());
        }
        try {
            Map<String, Map<String, String>> billValue = this.queryBillValue(billIds);
            Map<String, Map<String, String>> attriValue = this.queryAttriValue(jobIds);
            for (int i = this.list.size() - 1; i >= 0; --i) {
                SampleLibraryQualityTaskInfo qualityTaskInfo = this.list.get(i);
                String billId = qualityTaskInfo.getBillId();
                String jobhisId = qualityTaskInfo.getJobHisId();
                Map<String, String> billValueMap = billValue.get(billId);
                Map<String, String> attriValueMap = attriValue.get(jobhisId);
                try {
                    if (this.checkRule(billValueMap, attriValueMap)) continue;
                    this.list.remove(i);
                    continue;
                }
                catch (Exception e) {
                    taskInfo.getErrMsg().append("\u8fc7\u6ee4\u5355\u636e\uff1a[" + billId + "]\u65f6\u51fa\u9519\u4e86\uff1b" + DataTransferUtils.getExceptionDetail(e) + "\\n");
                }
            }
            taskInfo.getFilterList().addAll(this.list);
        }
        catch (Exception e) {
            taskInfo.getErrMsg().append(DataTransferUtils.getExceptionDetail(e) + "\\n");
        }
        return taskInfo;
    }

    private boolean checkRule(Map<String, String> billValueMap, Map<String, String> attriValueMap) throws ScriptException, NoSuchMethodException {
        ArrayList<DealInfo> listBool = new ArrayList<DealInfo>();
        for (int i = 0; i < this.checkRangeCollection.size(); ++i) {
            CheckRangeInfo entryInfo = this.checkRangeCollection.get(i);
            DealInfo dealInfo = new DealInfo();
            dealInfo.setLeftBracket(entryInfo.getLeftBracket());
            dealInfo.setRightBracket(entryInfo.getRightBracket());
            String key = entryInfo.getProperty();
            String realKey = this.getValue(this.ctx, key, billValueMap, attriValueMap);
            String value = entryInfo.getCompareValue();
            String realValue = this.getValue(this.ctx, value, billValueMap, attriValueMap);
            boolean b = SSCCompareUtils.compare(entryInfo.getCompareType(), realKey, realValue);
            dealInfo.setBool(b);
            String luogi = "";
            if (!StringUtils.isEmpty((String)entryInfo.getFilterItem())) {
                luogi = "and".equals(entryInfo.getFilterItem()) ? "&&" : "||";
            }
            dealInfo.setLuogi(luogi);
            listBool.add(dealInfo);
        }
        boolean endBool = true;
        String luoj = " && ";
        if (listBool.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < listBool.size(); ++j) {
                DealInfo dealInfo = (DealInfo)listBool.get(j);
                sb.append(StringUtils.isEmpty((String)dealInfo.getLeftBracket()) ? "" : dealInfo.getLeftBracket());
                sb.append(dealInfo.isBool());
                sb.append(StringUtils.isEmpty((String)dealInfo.getRightBracket()) ? "" : dealInfo.getRightBracket());
                String luoji = dealInfo.getLuogi();
                if (j >= listBool.size() - 1) continue;
                if (!StringUtils.isEmpty((String)luoji)) {
                    sb.append(dealInfo.getLuogi());
                    continue;
                }
                sb.append(luoj);
            }
            engine.eval("function t() {return " + sb.toString() + ";}");
            Invocable invocable = (Invocable)((Object)engine);
            Object o = invocable.invokeFunction("t", new Object[0]);
            endBool = Boolean.parseBoolean(o.toString());
            return endBool;
        }
        return endBool;
    }

    private String getValue(Context ctx, String key, Map<String, String> billValueMap, Map<String, String> attriValueMap) throws ScriptException, NoSuchMethodException {
        Map<Integer, String> keyV = SSCBaseBillUtils.getKeyV_key(key);
        Map<Integer, String> keyRealV = GetDataThread.getKeyV_value(ctx, keyV, billValueMap, attriValueMap);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyRealV.size(); ++i) {
            String keyRealValue = keyRealV.get(i);
            if (keyRealV.size() > 1 && keyRealValue.startsWith("{") && keyRealValue.endsWith("}")) {
                Map map = JSONUtil.jsonToMap(keyRealValue);
                Iterator iterator = map.values().iterator();
                keyRealValue = "";
                while (iterator.hasNext()) {
                    keyRealValue = keyRealValue + iterator.next();
                }
                keyRealV.put(i, keyRealValue);
            }
            sb.append(keyRealValue);
        }
        String endStr = sb.toString();
        if (SSCCompareUtils.isStringDateTime(endStr)) {
            return endStr;
        }
        if (endStr.replaceAll("[\\d+-\\\\*/()]", "").trim().equals("")) {
            engine.eval("function t() {return " + endStr + ";}");
            Invocable invocable = (Invocable)((Object)engine);
            Object o = invocable.invokeFunction("t", new Object[0]);
            String str = o.toString();
            BigDecimal big = new BigDecimal(str).setScale(0, 4);
            BigDecimal bigd = new BigDecimal(str);
            if (big.compareTo(bigd) == 0) {
                return big.toString();
            }
            return bigd.toString();
        }
        sb = new StringBuilder();
        for (int i = 0; i < keyRealV.size(); ++i) {
            String tmp;
            String keyRealValue = keyRealV.get(i);
            if ("+".equals(keyRealValue) || "+".equals(keyRealValue) || "-".equals(keyRealValue) || "*".equals(keyRealValue) || "/".equals(keyRealValue)) continue;
            try {
                tmp = (String)JSONUtils.convertJsonToObject((Context)ctx, (String)keyRealValue, String.class);
            }
            catch (Exception e) {
                tmp = keyRealValue;
            }
            tmp = tmp.replace("null", " ");
            sb.append(tmp);
        }
        return sb.toString();
    }

    private static Map<Integer, String> getKeyV_value(Context ctx, Map<Integer, String> keyV, Map<String, String> billValueMap, Map<String, String> attriValueMap) {
        for (int i = 0; i < keyV.size(); ++i) {
            String key;
            String value = keyV.get(i);
            if (value.trim().matches("^\\{@\\S*}$")) {
                key = SSCBaseBillUtils.spiltString(keyV.get(i));
                value = attriValueMap.get(key);
                keyV.put(i, value);
                continue;
            }
            if (value.trim().matches("^\\{\\$\\S*}$")) {
                key = SSCBaseBillUtils.spiltString(keyV.get(i));
                try {
                    value = billValueMap.get(key);
                }
                catch (Exception e) {
                    value = "";
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                keyV.put(i, value);
                continue;
            }
            keyV.put(i, value);
        }
        return keyV;
    }

    private Map<String, Map<String, String>> queryAttriValue(Set<String> jobIds) throws BOSException, SSCException {
        SampleLibraryQualityTaskInfo sampleLibraryQualityTaskInfo = this.list.get(0);
        String billTypeId = sampleLibraryQualityTaskInfo.getBillType().getId().toString();
        String scOrgId = sampleLibraryQualityTaskInfo.getShareCenterId();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.billType", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.billType.id", (Object)billTypeId));
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.fromBill", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.fromBill", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.fromBill", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.shareCenterId", (Object)scOrgId));
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.shareCenterId", (Object)ShareCenterUtils.getTopShareCenter(this.ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("dynamicID.shareCenterId", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("jobId", jobIds, CompareType.INCLUDE));
        filter.setMaskString("(#0 or #1) and (#2 or #3 or #4) and (#5 or #6 or #7) and #8");
        entityViewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("dynamicID.number"));
        sic.add(new SelectorItemInfo("dynamicID.type"));
        sic.add(new SelectorItemInfo("dinamicValue"));
        sic.add(new SelectorItemInfo("digiValue"));
        sic.add(new SelectorItemInfo("jobID"));
        entityViewInfo.setSelector(sic);
        DynValueHisCollection dynValueHisCollection = DynValueHisFactory.getLocalInstance(this.ctx).getDynValueHisCollection(entityViewInfo);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (dynValueHisCollection != null && dynValueHisCollection.size() > 0) {
            String value = "";
            for (int j = 0; j < dynValueHisCollection.size(); ++j) {
                DynValueHisInfo dynInfo = dynValueHisCollection.get(j);
                value = "1".equals(dynInfo.getDynamicID().getType().getValue()) ? dynInfo.getDigiValue() + "" : (dynInfo.getDinamicValue() != null ? dynInfo.getDinamicValue().trim() : dynInfo.getDinamicValue());
                String jobID = dynInfo.getJobID().getId().toString();
                if (!result.containsKey(jobID)) {
                    result.put(jobID, new HashMap(this.attrColumn.size()));
                }
                ((Map)result.get(jobID)).put(dynInfo.getDynamicID().getNumber(), value);
            }
        }
        return result;
    }

    private Map<String, Map<String, String>> queryBillValue(Set<String> billIds) throws Exception {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (billIds == null || billIds.isEmpty() || this.billColumn == null || this.billColumn.isEmpty() || StringUtils.isEmpty((String)this.sourceBillClass)) {
            return new HashMap<String, Map<String, String>>();
        }
        String sourceFactoryClass = this.sourceBillClass.replace(".app.", ".") + "Factory";
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < this.billColumn.size(); ++i) {
            sic.add(new SelectorItemInfo(this.billColumn.get(i)));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIds, CompareType.INCLUDE));
        entityViewInfo.setSelector(sic);
        entityViewInfo.setFilter(filter);
        Class<?> bizCollBillFacadeClass = Class.forName(sourceFactoryClass);
        Method bizCollBillMethod = bizCollBillFacadeClass.getMethod("getLocalInstance", Context.class);
        Object object = bizCollBillMethod.invoke(null, this.ctx);
        Class<?> iCoreBase = object.getClass();
        Method method = iCoreBase.getMethod("getCollection", EntityViewInfo.class);
        IObjectCollection dataColl = (IObjectCollection)method.invoke(object, entityViewInfo);
        int len = dataColl.size();
        for (int j = 0; j < len; ++j) {
            IObjectValue iObj = dataColl.getObject(j);
            Map<String, String> sourceBillAttribute = SSCBaseBillUtils.getSourceBillAttribute(this.ctx, this.billColumn, iObj);
            result.put(iObj.getString("id"), sourceBillAttribute);
        }
        return result;
    }
}

