/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.impl.taxi;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.erp.check.exception.CheckException;
import com.kingdee.eas.base.ssc.app.erp.check.impl.BaseCheckService;
import com.kingdee.eas.base.ssc.app.erp.check.util.InvoiceUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TaxiInvoiceSequentialInspection
extends BaseCheckService {
    @Override
    public Map<String, String> check(Map map) {
        String billId = this.getBillId(map);
        Context ctx = (Context)map.get("ctx");
        try {
            List<Map<String, String>> invoiceList = InvoiceUtil.getTaixInvoices(ctx, billId);
            if (invoiceList.size() <= 1) {
                return this.printLogAndReturnMap("true", null, null);
            }
            for (Map<String, String> invoice : invoiceList) {
                if (StringUtils.isBlank((CharSequence)invoice.get("InvoiceCode"))) {
                    throw new CheckException("InvoiceCode\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
                }
                if (!StringUtils.isBlank((CharSequence)invoice.get("invoiceNo"))) continue;
                throw new CheckException("invoiceNo\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
            }
            int len = invoiceList.size();
            Object[] number = new BigDecimal[len];
            for (int i = 0; i < len; ++i) {
                Map<String, String> invoice = invoiceList.get(i);
                number[i] = new BigDecimal(invoice.get("InvoiceCode") + invoice.get("invoiceNo"));
            }
            Arrays.sort(number);
            HashMap<String, HashSet<String>> exceptionInvoiceMap = new HashMap<String, HashSet<String>>();
            for (int i = 0; i < number.length - 1; ++i) {
                if (((BigDecimal)number[i + 1]).subtract((BigDecimal)number[i]).compareTo(BigDecimal.ONE) != 0) continue;
                String temp1 = String.valueOf(number[i]);
                String temp2 = String.valueOf(number[i + 1]);
                String temp1Code = temp1.substring(0, 12);
                String temp1No = temp1.substring(12);
                String temp2No = temp2.substring(12);
                HashSet<String> numSet = (HashSet<String>)exceptionInvoiceMap.get(temp1Code);
                if (numSet == null) {
                    numSet = new HashSet<String>();
                }
                numSet.add(temp1No);
                numSet.add(temp2No);
                exceptionInvoiceMap.put(temp1Code, numSet);
            }
            if (!exceptionInvoiceMap.isEmpty()) {
                StringBuffer msg = new StringBuffer("\u7684\u58eb\u53d1\u7968");
                for (Map.Entry entry : exceptionInvoiceMap.entrySet()) {
                    String invoiceCode = (String)entry.getKey();
                    Set invoiceNo = (Set)entry.getValue();
                    msg.append(invoiceCode + invoiceNo.toString() + ",");
                }
                msg.deleteCharAt(msg.length() - 1);
                msg.append("\u5b58\u5728\u8fde\u53f7\uff01");
                return this.printLogAndReturnMap("false", msg.toString(), null);
            }
        }
        catch (CheckException e) {
            String msg = "\u7684\u58eb\u8fde\u53f7\u68c0\u67e5-" + e.getMessage();
            String errorCode = "ctx:" + ctx.toString() + ",billId:" + billId + "," + e.getCause().getMessage();
            return this.printLogAndReturnMap("false", msg, errorCode);
        }
        return this.printLogAndReturnMap("true", null, null);
    }
}

