/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.eas;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.ExtendERPCfgCollection;
import com.kingdee.eas.base.ssc.ExtendERPCfgFactory;
import com.kingdee.eas.base.ssc.ExtendERPCfgInfo;
import com.kingdee.eas.base.ssc.ExtendERPCfgValueCollection;
import com.kingdee.eas.base.ssc.ExtendERPCfgValueFactory;
import com.kingdee.eas.base.ssc.ExtendERPCfgValueInfo;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.app.DBTypeEnum;
import com.kingdee.eas.base.ssc.app.ImageSysEnum;
import com.kingdee.eas.base.ssc.app.erp.eas.EASWebServiceHandler;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.base.ssc.tool.MD5Utils;
import com.kingdee.eas.base.ssc.tool.cache.SSCCacheManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.LMBCSUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EASCfgUtil {
    private static Cache<String, Object> cacheMap = CacheBuilder.newBuilder().maximumSize(15L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static Logger logger = Logger.getLogger(EASCfgUtil.class);
    public static String CONFIG_DIR;
    public static String EASLOGIN_PATH;
    public static String REMOTE_PATH;
    public static String LTPATOKEN_PATH;
    public static final String DEFAULT_SSC_KEY = "default_key";
    public static final Properties defaultValueProperties;
    public static final Properties defaultDescriptionProperties;
    public static final Set<String> cfgTableKeys;

    public static String getValue(Context ctx, ExtendERPInfo erp, String key, String defaultValue) throws BOSException {
        String value = EASCfgUtil.getValue(ctx, erp, key);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    @Deprecated
    public static String getValue1(ExtendERPInfo erp, String key) {
        Properties properties;
        Map<String, Properties> cfgMap = new HashMap();
        Object cacheObj = SSCCacheManager.getValue("erp_config_properties_map");
        if (cacheObj != null && cacheObj instanceof Map) {
            cfgMap = (Map)cacheObj;
        }
        if ((properties = (Properties)cfgMap.get(erp.getNumber())) == null) {
            properties = new Properties();
            if (CONFIG_DIR == null) {
                EASCfgUtil.setConfigDir();
            }
            EASCfgUtil.load(properties, CONFIG_DIR + erp.getCfgFolder() + "/" + EASLOGIN_PATH);
            EASCfgUtil.load(properties, CONFIG_DIR + erp.getCfgFolder() + "/" + REMOTE_PATH);
            cfgMap.put(erp.getNumber(), properties);
        }
        SSCCacheManager.put("erp_config_properties_map", cfgMap);
        return properties.getProperty(key);
    }

    public static String getCache(String key) {
        Object cacheObj = null;
        cacheObj = !StringUtils.isEmpty((String)key) ? cacheMap.getIfPresent((Object)key) : cacheMap;
        if (cacheObj == null) {
            return "";
        }
        return JSONUtil.bean2json(cacheObj);
    }

    public static String getValue(Context ctx, ExtendERPInfo erp, String key) {
        Map<String, Properties> cfgMap = new HashMap();
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((String)dbId)) {
            dbId = DEFAULT_SSC_KEY;
        }
        Object cacheObj = null;
        try {
            cacheObj = SSCCacheManager.getValue("erp_config_properties_map");
            if (cacheObj == null) {
                cacheObj = cacheMap.getIfPresent((Object)"erp_config_properties_map");
            }
        }
        catch (Exception e) {
            cacheObj = cacheMap.getIfPresent((Object)"erp_config_properties_map");
        }
        if (cacheObj != null && cacheObj instanceof Map) {
            cfgMap = (Map)cacheObj;
        }
        Properties prop = (Properties)cfgMap.get(dbId);
        Properties properties = null;
        if (prop == null) {
            prop = new Properties();
        }
        if ((properties = (Properties)prop.get(erp.getId())) != null && properties.size() > 0) {
            return properties.getProperty(key);
        }
        ExtendERPCfgInfo cfg = EASCfgUtil.getCfg(ctx, erp.getId());
        if (null != cfg) {
            properties = EASCfgUtil.properAdapter(ctx, cfg);
        } else {
            properties = new Properties(defaultValueProperties);
            if (CONFIG_DIR == null) {
                EASCfgUtil.setConfigDir();
            }
            String cfgFolder = erp.getCfgFolder();
            EASCfgUtil.load(properties, CONFIG_DIR + cfgFolder, "/" + EASLOGIN_PATH);
            EASCfgUtil.load(properties, CONFIG_DIR + cfgFolder, "/" + REMOTE_PATH);
            EASCfgUtil.load(properties, CONFIG_DIR + "/" + LTPATOKEN_PATH);
            EASCfgUtil.saveProperties2Db(ctx, properties, erp);
        }
        prop.put(erp.getId(), properties);
        cfgMap.put(dbId, prop);
        cacheMap.put((Object)"erp_config_properties_map", cfgMap);
        SSCCacheManager.put("erp_config_properties_map", cfgMap);
        return properties.getProperty(key);
    }

    private static void saveProperties2Db(Context ctx, Properties properties, ExtendERPInfo erp) {
        String url;
        ExtendERPCfgInfo info = new ExtendERPCfgInfo();
        info.setExtendERPId(erp.getId().toString());
        defaultDescriptionProperties.setProperty("cookie.domain", "\u5355\u70b9\u76f8\u5173\u914d\u7f6e,cookie\u57df");
        defaultDescriptionProperties.setProperty("token.expiration", "\u5355\u70b9\u76f8\u5173\u914d\u7f6e,\u8d85\u65f6\u65f6\u95f4");
        defaultDescriptionProperties.setProperty("domino.secret", "\u5355\u70b9\u76f8\u5173\u914d\u7f6e,\u5355\u70b9\u79d8\u94a5");
        defaultDescriptionProperties.setProperty("erp.ip", "\u5916\u90e8\u7cfb\u7edfip,\u4ee5T_SSC_ExtendERPCfg\u8868\u4e0a\u5b58\u7684\u503c\u4e3a\u51c6");
        defaultDescriptionProperties.setProperty("erp.port", "\u5916\u90e8\u7cfb\u7edf\u7aef\u53e3");
        defaultDescriptionProperties.setProperty("userName", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u4f7f\u7528\u7684\u7528\u6237\u540d");
        defaultDescriptionProperties.setProperty("password", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u4f7f\u7528\u7684\u5bc6\u7801");
        defaultDescriptionProperties.setProperty("dcName", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u6570\u636e\u4e2d\u5fc3");
        defaultDescriptionProperties.setProperty("dbType", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u7684\u6570\u636e\u4e2d\u5fc3\u7c7b\u578b");
        defaultDescriptionProperties.setProperty("image.ip", "\u5f71\u50cf\u7cfb\u7edfIP");
        defaultDescriptionProperties.setProperty("image.port", "\u5f71\u50cf\u7cfb\u7edf\u7aef\u53e3");
        if (properties.containsKey("erp.ip") && properties.containsKey("erp.port")) {
            info.setBizIP(properties.getProperty("erp.ip"));
            info.setBizIP(properties.getProperty("erp.port"));
        } else {
            url = properties.getProperty("eas.login.wsdl");
            String workflowWsdlUrl = properties.getProperty("eas.workflow.notify.wsdl");
            url = StringUtils.isEmpty((String)url) ? workflowWsdlUrl : url;
            String ip = url.split("/")[2];
            String port = "6888";
            int index = ip.indexOf(":");
            if (index > -1) {
                String[] tmpStrs = ip.split(":");
                ip = tmpStrs[0];
                port = tmpStrs[1];
            }
            info.setBizIP(ip);
            info.setBizPort(port);
        }
        if (properties.containsKey("image.ip") && properties.containsKey("image.port")) {
            info.setImageIP(properties.getProperty("image.ip"));
            info.setImagePort(properties.getProperty("image.port"));
        } else {
            url = properties.getProperty("image.picture.url");
            String ip = url.split("/")[2];
            String port = "80";
            int index = ip.indexOf(":");
            if (index > -1) {
                String[] tmpStrs = ip.split(":");
                ip = tmpStrs[0];
                port = tmpStrs[1];
            }
            info.setImageIP(ip);
            info.setImagePort(port);
        }
        info.setDCenterIP(properties.getProperty("dcName"));
        DBTypeEnum dbType = DBTypeEnum.getEnum(properties.getProperty("dbType"));
        if (dbType == null) {
            dbType = DBTypeEnum.Oracle;
        }
        info.setDBType(dbType);
        info.setEASUser(properties.getProperty("userName"));
        String pw = "";
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)properties.getProperty("password"))) {
            try {
                pw = MD5Utils.md5Encode(properties.getProperty("password"));
            }
            catch (Exception e) {
                pw = properties.getProperty("password");
            }
        }
        info.setPasword(pw);
        ImageSysEnum imSys = ImageSysEnum.getEnum(properties.getProperty("image.system.type"));
        if (imSys == null) {
            imSys = ImageSysEnum.DKWS;
        }
        info.setImageSys(imSys);
        int deployType = "1".equals(properties.getProperty("deployType")) ? 1 : 0;
        info.setDeployType(deployType);
        info.setCookieDomain(properties.getProperty("cookie.domain"));
        info.setTokenExpiration(properties.getProperty("token.expiration"));
        info.setDominoSecret(properties.getProperty("domino.secret"));
        IObjectPK pk = null;
        try {
            pk = ExtendERPCfgFactory.getLocalInstance(ctx).addnew(info);
            info.setId(H.UID(pk.toString()));
        }
        catch (EASBizException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        Set<String> keys = properties.stringPropertyNames();
        keys.removeAll(cfgTableKeys);
        Iterator<String> it = keys.iterator();
        CoreBaseCollection coll = new CoreBaseCollection();
        while (it.hasNext()) {
            String _key = it.next();
            String _value = properties.getProperty(_key);
            ExtendERPCfgValueInfo valueInfo = new ExtendERPCfgValueInfo();
            valueInfo.setExtendERPCfg(info);
            valueInfo.setKey(_key);
            valueInfo.setValue(_value);
            valueInfo.setDescription(defaultDescriptionProperties.getProperty(_key));
            coll.add((CoreBaseInfo)valueInfo);
        }
        try {
            ExtendERPCfgValueFactory.getLocalInstance(ctx).addnewBatchData(coll);
        }
        catch (EASBizException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static void load(Properties properties, String path, String name) {
        File file = new File(path, name);
        if (!file.exists()) {
            path = CONFIG_DIR + "eas";
        }
        EASCfgUtil.load(properties, path + name);
    }

    private static Properties properAdapter(Context ctx, ExtendERPCfgInfo cfg) {
        String httpHead;
        String photoTail = null;
        ExtendERPCfgValueCollection values = cfg.getCfgValue();
        Properties prop = new Properties(defaultValueProperties);
        String key = null;
        String value = null;
        HashSet<String> existKeySet = new HashSet<String>();
        if (values != null && !values.isEmpty()) {
            for (int i = 0; i < values.size(); ++i) {
                key = values.get(i).getKey();
                value = values.get(i).getValue();
                if (StringUtils.isEmpty((String)key)) continue;
                existKeySet.add(key);
                prop.setProperty(key, value == null ? "" : value);
            }
        }
        photoTail = ImageSysEnum.GXHC.equals((Object)cfg.getImageSys()) ? prop.getProperty("image.picture.url.tail.GXHC") : (ImageSysEnum.TCZT.equals((Object)cfg.getImageSys()) ? prop.getProperty("image.picture.url.tail.TCZT") : (ImageSysEnum.DKWS.equals((Object)cfg.getImageSys()) ? prop.getProperty("image.picture.url.tail.DKWS") : prop.getProperty("image.picture.url.tail")));
        String deployType = cfg.getDeployType() + "";
        if (!EASWebServiceHandler.DPLOY_TYPE_INDEPENDENT.equals(deployType)) {
            deployType = EASWebServiceHandler.DPLOY_TYPE_UNION;
        }
        String erpIp = cfg.getBizIP();
        String erpPort = cfg.getBizPort();
        if (!StringUtils.isEmpty((String)erpIp) && !StringUtils.isEmpty((String)erpPort)) {
            httpHead = prop.getProperty("erpHttpHead");
            String ipAndPortHead = httpHead + erpIp + ":" + erpPort;
            String login = ipAndPortHead + prop.getProperty("eas.login.wsdl.tail");
            String loginLtpa = ipAndPortHead + prop.getProperty("eas.login.ltpa.url.tail");
            String message = ipAndPortHead + prop.getProperty("eas.messagecenter.wsdl.tail");
            String org = ipAndPortHead + prop.getProperty("eas.orgfacade.wsdl.tail");
            String person = ipAndPortHead + prop.getProperty("eas.userfacade.wsdl.tail");
            String workflow = ipAndPortHead + prop.getProperty("eas.workflow.notify.wsdl.tail");
            String pictureUrl = ipAndPortHead + prop.getProperty("eas.picture.url.tail");
            String discardForCmpUrl = ipAndPortHead + prop.getProperty("eas.discard.for.cpt.url.tail");
            prop.setProperty("eas.messagecenter.wsdl", message);
            if (prop.containsKey("eas.login.ltpa.url")) {
                String ltpaUrl = prop.getProperty("eas.login.ltpa.url");
                if (ltpaUrl.contains("/portal/index2sso.jsp?isNotCheckRelogin=true&redirectTo=")) {
                    prop.setProperty("eas.login.ltpa.url", ipAndPortHead + "/portal/index2sso.jsp?isNotCheckRelogin=true&redirectTo=");
                } else {
                    prop.setProperty("eas.login.ltpa.url", loginLtpa);
                }
            } else {
                prop.setProperty("eas.login.ltpa.url", loginLtpa);
            }
            prop.setProperty("eas.login.wsdl", login);
            prop.setProperty("eas.workflow.notify.wsdl", workflow);
            prop.setProperty("eas.orgfacade.wsdl", org);
            prop.setProperty("eas.userfacade.wsdl", person);
            prop.setProperty("eas.picture.url", pictureUrl);
            prop.setProperty("eas.discard.for.cpt.url", discardForCmpUrl);
            prop.setProperty("erp.ip", erpIp);
            prop.setProperty("erp.port", erpPort);
        }
        if (!StringUtils.isEmpty((String)cfg.getEASUser())) {
            prop.setProperty("userName", cfg.getEASUser());
        }
        if (StringUtils.isEmpty((String)cfg.getPasword())) {
            prop.setProperty("password", "");
        } else {
            String pw = "";
            try {
                pw = MD5Utils.md5Decode(cfg.getPasword());
            }
            catch (Exception e) {
                logger.error((Object)("\u89e3\u5bc6\u51fa\u9519\uff0c\u4f7f\u7528\u6570\u636e\u5e93\u4e2d\u7684\u5bc6\u7801:" + cfg.getPasword()));
                pw = cfg.getPasword();
            }
            prop.setProperty("password", pw);
        }
        if (!StringUtils.isEmpty((String)cfg.getDCenterIP())) {
            prop.setProperty("dcName", cfg.getDCenterIP());
        }
        prop.setProperty("dbType", cfg.getDBType().getValue());
        if (!StringUtils.isEmpty((String)cfg.getImageIP()) && !StringUtils.isEmpty((String)cfg.getImagePort())) {
            httpHead = prop.getProperty("imageHttpHead");
            String photo = httpHead + cfg.getImageIP() + ":" + cfg.getImagePort() + photoTail;
            prop.setProperty("image.picture.url", photo);
            prop.setProperty("image.ip", cfg.getImageIP());
            prop.setProperty("image.port", cfg.getImagePort());
        }
        prop.setProperty("image.system.type", cfg.getImageSys().getValue());
        prop.setProperty("deployType", deployType);
        prop.setProperty("image.picture.url.tail", photoTail);
        if (cfg.getCookieDomain() != null) {
            prop.setProperty("cookie.domain", cfg.getCookieDomain());
        }
        if (cfg.getTokenExpiration() != null) {
            prop.setProperty("token.expiration", cfg.getTokenExpiration());
        }
        if (cfg.getDominoSecret() != null) {
            prop.setProperty("domino.secret", cfg.getDominoSecret());
        }
        Set<String> keys = prop.stringPropertyNames();
        keys.removeAll(cfgTableKeys);
        keys.removeAll(existKeySet);
        Iterator<String> it = keys.iterator();
        CoreBaseCollection coll = new CoreBaseCollection();
        while (it.hasNext()) {
            String _key = it.next();
            String _value = prop.getProperty(_key);
            ExtendERPCfgValueInfo valueInfo = new ExtendERPCfgValueInfo();
            valueInfo.setExtendERPCfg(cfg);
            valueInfo.setKey(_key);
            valueInfo.setValue(_value);
            valueInfo.setDescription(defaultDescriptionProperties.getProperty(_key));
            coll.add((CoreBaseInfo)valueInfo);
        }
        try {
            ExtendERPCfgValueFactory.getLocalInstance(ctx).addnewBatchData(coll);
        }
        catch (EASBizException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        CoreBaseCollection collsUpdate = new CoreBaseCollection();
        if (values != null && !values.isEmpty()) {
            for (int i = 0; i < values.size(); ++i) {
                key = values.get(i).getKey();
                String string = value = values.get(i).getValue() == null ? "" : values.get(i).getValue();
                if (StringUtils.isEmpty((String)key) || prop.getProperty(key).equals(value)) continue;
                values.get(i).setValue(prop.getProperty(key));
                collsUpdate.add((CoreBaseInfo)values.get(i));
            }
        }
        try {
            ExtendERPCfgValueFactory.getLocalInstance(ctx).updateBatchData(collsUpdate);
        }
        catch (EASBizException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return prop;
    }

    private static void setERPCfgValue(Context ctx, BOSUuid id, Properties prop) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Properties properties, String fileName) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            properties.load(fileInputStream);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    public static void clearCache() {
        cacheMap.invalidateAll();
        SSCCacheManager.clearCache("erp_config_properties_map");
    }

    public static void setConfigDir() {
        try {
            String tmp = System.getProperty("java.security.auth.login.config");
            if (tmp == null) {
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u672a\u914d\u7f6e!");
                return;
            }
            int i = tmp.lastIndexOf("/");
            if (i < 0) {
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u914d\u7f6e\u7684\u8def\u5f84\u4e2d\u6ca1\u6709 /!");
                return;
            }
            CONFIG_DIR = tmp.substring(0, i) + "/ssc/";
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String getPassword(Context ctx, ExtendERPInfo erp, String userNumber) {
        if (CONFIG_DIR == null) {
            EASCfgUtil.setConfigDir();
        }
        LtpaToken token = LtpaTokenManager.generate((String)userNumber, (String)(CONFIG_DIR + "/" + LTPATOKEN_PATH));
        logger.error((Object)("*****userNumber************" + userNumber));
        logger.error((Object)("*****old token*************" + token.toString()));
        String newToken = token.toString();
        try {
            newToken = URLDecoder.decode(URLDecoder.decode(token.toString(), "UTF-8"), "UTF-8");
            logger.info((Object)("****newToken 3 times decode****" + URLDecoder.decode(newToken, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        logger.info((Object)("****newToken****" + newToken));
        return token.toString();
    }

    private static LtpaToken getToken(String canonicalUser, boolean isLMBCSEncode, String dominoSecret, String tokenExpiration) {
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = Integer.parseInt(tokenExpiration);
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        if (isLMBCSEncode) {
            ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes((String)canonicalUser));
        } else {
            try {
                ltpa.setUser(canonicalUser.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ltpa.setUser(canonicalUser.getBytes());
            }
        }
        byte[] token = null;
        calendar.setTime(creationDate);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        calendar.setTime(expirationDate);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        token = LMBCSUtil.concatenate(token, (byte[])ltpa.getHeader());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getCreation());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getExpires());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getUser());
        md.update(token);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes((String)dominoSecret));
        ltpa.setDigest(digest);
        token = LMBCSUtil.concatenate((byte[])token, (byte[])digest);
        String tokenStr = BASE64Util.encode((byte[])token);
        String result = "";
        StringTokenizer st = new StringTokenizer(tokenStr);
        while (st.hasMoreTokens()) {
            result = result + st.nextToken();
        }
        return new LtpaToken(result);
    }

    private static ExtendERPCfgInfo getCfg(Context ctx, BOSUuid erpId) {
        if (null == erpId) {
            return null;
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("select *,cfgValue.* where ExtendERPId = '").append(erpId.toString()).append("'");
        try {
            if (null == ctx) {
                ctx = ContextUtils.getContextFromSession();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        try {
            ExtendERPCfgCollection collection = ExtendERPCfgFactory.getLocalInstance(ctx).getExtendERPCfgCollection(sb.toString());
            if (null != collection && collection.size() > 0) {
                return collection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)"EASCfgUtil attemper getCfg Fail");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)"EASCfgUtil attemper getCfg Fail");
        }
        return null;
    }

    static {
        EASLOGIN_PATH = "EASLogin.properties";
        REMOTE_PATH = "remote.properties";
        LTPATOKEN_PATH = "eas/LtpaToken.properties";
        defaultValueProperties = new Properties();
        defaultDescriptionProperties = new Properties();
        cfgTableKeys = new HashSet<String>();
        cfgTableKeys.add("erp.ip");
        cfgTableKeys.add("erp.port");
        cfgTableKeys.add("image.ip");
        cfgTableKeys.add("image.port");
        cfgTableKeys.add("image.ip");
        cfgTableKeys.add("image.port");
        cfgTableKeys.add("dcName");
        cfgTableKeys.add("dbType");
        cfgTableKeys.add("userName");
        cfgTableKeys.add("password");
        cfgTableKeys.add("image.system.type");
        cfgTableKeys.add("deployType");
        cfgTableKeys.add("cookie.domain");
        cfgTableKeys.add("token.expiration");
        cfgTableKeys.add("domino.secret");
        defaultValueProperties.setProperty("erpHttpHead", "http://");
        defaultDescriptionProperties.setProperty("eas.login.wsdl.tail", "\u4efb\u52a1\u5e73\u53f0\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3\u7684\u524d\u7f00,https://\u6216http://");
        defaultValueProperties.setProperty("imageHttpHead", "http://");
        defaultDescriptionProperties.setProperty("eas.login.wsdl.tail", "\u4efb\u52a1\u5e73\u53f0\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3\u7684\u524d\u7f00,https://\u6216http://");
        defaultValueProperties.setProperty("eas.login.wsdl.tail", "/ormrpc/services/EASLogin?wsdl");
        defaultDescriptionProperties.setProperty("eas.login.wsdl.tail", "\u4efb\u52a1\u5e73\u53f0\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("eas.login.ltpa.url.tail", "/easportal/index2sso.jsp?isNotCheckRelogin=true&redirectTo=");
        defaultDescriptionProperties.setProperty("eas.login.ltpa.url.tail", "\u4efb\u52a1\u5e73\u53f0\u5355\u70b9\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("eas.messagecenter.wsdl.tail", "/ormrpc/services/WSWsMessageCenterFacade?wsdl");
        defaultDescriptionProperties.setProperty("eas.messagecenter.wsdl.tail", "\u4efb\u52a1\u5e73\u53f0\u53cd\u5199\u5916\u90e8\u7cfb\u6d88\u606f\u4e2d\u5fc3\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("eas.orgfacade.wsdl.tail", "/ormrpc/services/WSEASOrgFacade?wsdl");
        defaultDescriptionProperties.setProperty("eas.orgfacade.wsdl.tail", "\u4efb\u52a1\u5e73\u53f0\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u7ec4\u7ec7\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3\u7684\u540e\u7f00,");
        defaultValueProperties.setProperty("eas.userfacade.wsdl.tail", "/ormrpc/services/WSAdminOrgUnitUserFacade?wsdl");
        defaultDescriptionProperties.setProperty("eas.userfacade.wsdl.tail", "\u4efb\u52a1\u5e73\u53f0\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u7528\u6237\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("eas.workflow.notify.wsdl.tail", "/ormrpc/services/MultiapproveOpertationWebService?wsdl");
        defaultDescriptionProperties.setProperty("eas.workflow.notify.wsdl.tail", "\u4efb\u52a1\u5e73\u53f0\u53cd\u5199\u5916\u90e8\u7cfb\u6d88\u606f\u4e2d\u5fc3\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("eas.picture.url.tail", "/ormrpc/services/WSSSCTaskCenterBaseSeviceFacade?wsdl");
        defaultDescriptionProperties.setProperty("eas.picture.url.tail", "\u4efb\u52a1\u5e73\u53f0\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u67e5\u770b\u5f71\u50cfwebservice\u63a5\u53e3\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("eas.bill.url", "/easweb/");
        defaultDescriptionProperties.setProperty("eas.bill.url", "\u5904\u7406\u4efb\u52a1\u65f6,\u5185\u5d4c\u5355\u636e\u9875\u9762\u7684\u901a\u7528\u540e\u7f00");
        defaultValueProperties.setProperty("eas.workflow.url", "/easweb/webviews/workflow/viewProcessDiagram.jsp");
        defaultDescriptionProperties.setProperty("eas.workflow.url", "\u67e5\u770b\u5916\u90e8\u7cfb\u7edf\u6d41\u7a0b\u56fe\u4f7f\u7528\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("eas.discard.for.cpt.url.tail", "/ormrpc/services/WSEASSignatureFacade?wsdl");
        defaultDescriptionProperties.setProperty("eas.discard.for.cpt.url.tail", "\u4efb\u52a1\u5e73\u53f0\u53cd\u5199\u5916\u90e8\u7cfb\u7edf\u5df2\u5b8c\u6210\u5e9f\u5f03webservice\u540e\u7f00");
        defaultValueProperties.setProperty("image.picture.url.tail", "/X-Smart.WebService/services/IScanWebServiceImplService.asmx?WSDL");
        defaultDescriptionProperties.setProperty("image.picture.url.tail", "\u8c03\u7528\u5f71\u50cf\u7cfb\u7edfwebservice\u9ed8\u8ba4\u540e\u7f00,\u6807\u51c6\u5bf9\u63a5\u7684\u4ee5\u5916\u7684\u5f71\u50cf\u7cfb\u7edf\u4f7f\u7528\u7684\u540e\u7f00");
        defaultValueProperties.setProperty("image.picture.url.tail.DKWS", "/X-Smart.WebService/services/IScanWebServiceImplService.asmx?WSDL");
        defaultDescriptionProperties.setProperty("image.picture.url.tail.DKWS", "\u8c03\u7528\u9053\u53ef\u7ef4\u65af\u5f71\u50cf\u7cfb\u7edfwebservice\u540e\u7f00");
        defaultValueProperties.setProperty("image.picture.url.tail.GXHC", "/SiitFrameWs/services/AutoImageCenter.ws?wsdl");
        defaultDescriptionProperties.setProperty("image.picture.url.tail.GXHC", "\u8c03\u7528\u56fd\u4fe1\u5408\u6210\u5f71\u50cf\u7cfb\u7edfwebservice\u540e\u7f00");
        defaultValueProperties.setProperty("image.picture.url.tail.TCZT", "/TIMS-Server/services/ImageForCommonService");
        defaultDescriptionProperties.setProperty("image.picture.url.tail.TCZT", "\u8c03\u7528\u5929\u521b\u5f81\u817e\u5f71\u50cf\u7cfb\u7edfwebservice\u540e\u7f00");
        defaultValueProperties.setProperty("deployType", EASWebServiceHandler.DPLOY_TYPE_UNION);
        defaultDescriptionProperties.setProperty("deployType", EASWebServiceHandler.DPLOY_TYPE_UNION + "\u4e3a\u8054\u5408\u90e8\u7f72\u72b6\u6001,\u8868\u793a\u5171\u4eab\u5e73\u53f0\u4f7f\u7528\u81ea\u8eab\u6240\u5728EAS\u4f5c\u4e3a\u5916\u90e8\u7cfb\u7edf.");
        defaultValueProperties.setProperty("isShowJobAttachment", "true");
        defaultDescriptionProperties.setProperty("isShowJobAttachment", "\u5904\u7406\u4efb\u52a1\u65f6\u662f\u5426\u663e\u793a\u4efb\u52a1\u9644\u4ef6");
        defaultValueProperties.setProperty("eas.histore.agreement.url", "/easweb/webviews/workflow/flowRelatedInfo.jsp");
        defaultDescriptionProperties.setProperty("eas.histore.agreement.url", "\u67e5\u770b\u5916\u90e8\u7cfb\u7edf\u5de5\u4f5c\u6d41\u5ba1\u6279\u8bb0\u5f55\u4f7f\u7528\u7684\u9875\u9762\u540e\u7f00");
        defaultValueProperties.setProperty("slnName", "eas");
        defaultDescriptionProperties.setProperty("slnName", "\u89e3\u51b3\u65b9\u6848\u540d\u79f0,\u4e00\u822c\u9ed8\u8ba4eas");
        defaultValueProperties.setProperty("language", "L2");
        defaultDescriptionProperties.setProperty("language", "\u591a\u8bed\u8a00\u4e2d\u8868\u793a\u4e2d\u6587");
        defaultValueProperties.setProperty("cookie.domain", ".kingdee.com");
        defaultDescriptionProperties.setProperty("cookie.domain", "\u5355\u70b9\u76f8\u5173\u914d\u7f6e,cookie\u57df");
        defaultValueProperties.setProperty("token.expiration", "30");
        defaultDescriptionProperties.setProperty("token.expiration", "\u5355\u70b9\u76f8\u5173\u914d\u7f6e,\u8d85\u65f6\u65f6\u95f4");
        defaultValueProperties.setProperty("domino.secret", "BTfa8F+HwNejYEGtuZSJTWOZ/t8\\=");
        defaultDescriptionProperties.setProperty("domino.secret", "\u5355\u70b9\u76f8\u5173\u914d\u7f6e,\u5355\u70b9\u79d8\u94a5");
        defaultDescriptionProperties.setProperty("eas.messagecenter.wsdl", "\u53cd\u5199\u5916\u90e8\u7cfb\u7edf\u6d88\u606f\u4e2d\u5fc3webservice,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("eas.login.wsdl", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edfwebsercie,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("eas.workflow.notify.wsdl", "\u53cd\u5199\u5916\u90e8\u7cfb\u7edf\u5de5\u4f5c\u6d41websercie,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("eas.orgfacade.wsdl", "\u4efb\u52a1\u5e73\u53f0\u83b7\u53d6\u5916\u90e8\u7cfb\u7edf\u7ec4\u7ec7\u6240\u4f7f\u7528\u7684webservice\u63a5\u53e3,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("eas.picture.url", "\u4efb\u52a1\u5e73\u53f0\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u67e5\u770b\u5f71\u50cfwebservice\u63a5\u53e3,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("eas.login.ltpa.url", "\u4efb\u52a1\u5e73\u53f0\u5355\u70b9\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u7684\u5730\u5740,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("eas.discard.for.cpt.url", "\u4efb\u52a1\u5e73\u53f0\u53cd\u5199\u5916\u90e8\u7cfb\u7edf\u5df2\u5b8c\u6210\u5e9f\u5f03webservice,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("image.picture.url", "\u8c03\u7528\u5f71\u50cf\u7cfb\u7edfwebservice,\u6b64\u503c\u7531\u524d\u7f00,ip,\u7aef\u53e3,\u4ee5\u53ca\u540e\u7f00\u76f4\u63a5\u62fc\u63a5\u800c\u6210.\u5982\u679c\u4fee\u6539,\u8bf7\u540c\u6b65\u4fee\u6539.");
        defaultDescriptionProperties.setProperty("erp.ip", "\u5916\u90e8\u7cfb\u7edfip,\u4ee5T_SSC_ExtendERPCfg\u8868\u4e0a\u5b58\u7684\u503c\u4e3a\u51c6");
        defaultDescriptionProperties.setProperty("erp.port", "\u5916\u90e8\u7cfb\u7edf\u7aef\u53e3");
        defaultDescriptionProperties.setProperty("userName", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u4f7f\u7528\u7684\u7528\u6237\u540d");
        defaultDescriptionProperties.setProperty("password", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u4f7f\u7528\u7684\u5bc6\u7801");
        defaultDescriptionProperties.setProperty("dcName", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u6570\u636e\u4e2d\u5fc3");
        defaultDescriptionProperties.setProperty("dbType", "\u767b\u5f55\u5916\u90e8\u7cfb\u7edf\u7684\u6570\u636e\u4e2d\u5fc3\u7c7b\u578b");
        defaultDescriptionProperties.setProperty("image.ip", "\u5f71\u50cf\u7cfb\u7edfIP");
        defaultDescriptionProperties.setProperty("image.port", "\u5f71\u50cf\u7cfb\u7edf\u7aef\u53e3");
    }
}

