/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.license.file.Coder;
import com.kingdee.eas.base.license.file.MD5Helper;
import com.kingdee.eas.base.ssc.SscJobCfgInfo;
import com.kingdee.eas.base.ssc.common.RSA;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SscJobConfig {
    private static Logger logger = Logger.getLogger(SscJobConfig.class);
    private static String PATH = "sscJobConfig.properties";
    private static String MD5 = "MD5";
    private Map<String, SscJobCfgInfo> cfgMap = new TreeMap<String, SscJobCfgInfo>();
    private Map<String, String> bosType_ModelCode_Map = new HashMap<String, String>();
    private static SscJobConfig sscCfg = new SscJobConfig();

    private SscJobConfig() {
        this.loadCfg();
    }

    public static SscJobConfig getInstance() {
        return sscCfg;
    }

    public Map<String, String> getBosType_ModelCode_Map() {
        return this.bosType_ModelCode_Map;
    }

    public Map getCfgMap() {
        return this.cfgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCfg() {
        FileInputStream fis = null;
        try {
            TreeMap<String, SscJobCfgInfo> _cfgMap = new TreeMap<String, SscJobCfgInfo>();
            String md5 = "";
            Properties prop = new Properties();
            String sscFullName = SscJobConfig.getSSCProFullName(PATH);
            fis = new FileInputStream(sscFullName);
            prop.load(fis);
            Set<Object> keys = prop.keySet();
            if (keys != null) {
                for (String string : keys) {
                    String value = prop.getProperty(string);
                    if (!string.equals(MD5)) {
                        SscJobCfgInfo info = new SscJobCfgInfo();
                        String bostype = value.split(";")[0];
                        String modelCode = value.split(";")[1];
                        this.bosType_ModelCode_Map.put(bostype, modelCode);
                        info.setBillType(string);
                        info.setBosType(bostype);
                        info.setModelCode(modelCode);
                        _cfgMap.put(string, info);
                        continue;
                    }
                    md5 = value;
                }
                boolean bl = this.checkMD5(_cfgMap, md5);
                if (bl) {
                    this.cfgMap = _cfgMap;
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean checkMD5(Map<String, SscJobCfgInfo> cfgMap, String encryptMd5) throws Exception {
        if (cfgMap == null || cfgMap.size() == 0) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, SscJobCfgInfo> entry : cfgMap.entrySet()) {
            SscJobCfgInfo info = entry.getValue();
            sb.append(info.getBillType()).append(info.getBosType()).append(info.getModelCode());
        }
        String checkMd5 = MD5Helper.getStringMD5((String)sb.toString());
        String encrypt = Coder.hexStr2Str((String)encryptMd5);
        byte[] base64 = Coder.decryptBASE64((String)encrypt);
        if (checkMd5.equals(new String(RSA.getInstance().decrypt(base64)))) {
            return true;
        }
        logger.error((Object)"sscJobConfig.properties is no legal file or file is damaged");
        return false;
    }

    public boolean checkBillIdAndBillSource(Context ctx, String billId, String billSource, String billType) {
        if (this.cfgMap.size() == 0 || StringUtils.isEmpty((String)billSource) || StringUtils.isEmpty((String)billId)) {
            return false;
        }
        ObjectUuidPK uipk = null;
        String bosType = "";
        try {
            uipk = new ObjectUuidPK(billId);
            if (uipk != null) {
                bosType = uipk.getObjectType().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("getBosTypeById error!billId:" + billId), (Throwable)e);
        }
        boolean isStandard = this.isStandardBosType(bosType);
        if (isStandard) {
            if (StringUtils.isEmpty((String)billSource) || "NotStandard".equals(billSource)) {
                billSource = this.getBillTypeByBosType(bosType);
                String sql = "UPDATE t_ssc_billtype bt SET FBILLSOURCEidid = (SELECT fid FROM T_ssc_billtypecfg btc where btc.FNUMBER = '" + billSource + "') WHERE fnumber = '" + billType + "'";
                try {
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
                catch (Exception e) {
                    logger.error((Object)("\u6570\u636e\u4fee\u6539\u9519\u8bef,sql:" + sql));
                }
            }
            if (null != this.cfgMap.get(billSource)) {
                String standard_bosType = this.cfgMap.get(billSource).getBosType();
                return bosType.equals(standard_bosType);
            }
            return false;
        }
        return !this.cfgMap.containsKey(billSource);
    }

    public String getBillTypeByBosType(String bosType) {
        for (Map.Entry<String, SscJobCfgInfo> entry : this.cfgMap.entrySet()) {
            SscJobCfgInfo info = entry.getValue();
            if (!bosType.equals(info.getBosType()) || "40284E81".equals(bosType) || "FA44FD5B".equals(bosType) || "2A607F02".equals(bosType)) continue;
            return info.getBillType();
        }
        return null;
    }

    public boolean isStandardBosType(String bosType) {
        for (SscJobCfgInfo info : this.cfgMap.values()) {
            if (!info.getBosType().equals(bosType)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getBussAttr2ModelCode() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, SscJobCfgInfo> entry : this.cfgMap.entrySet()) {
            SscJobCfgInfo info = entry.getValue();
            map.put(info.getBillType(), info.getModelCode());
        }
        return map;
    }

    public Map<String, String> getBillType2ModelCode() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, SscJobCfgInfo> entry : this.cfgMap.entrySet()) {
            SscJobCfgInfo info = entry.getValue();
            map.put(info.getBillType(), info.getModelCode());
        }
        return map;
    }

    private static String getSSCProFullName(String relativeFileName) {
        String portalConfig = System.getProperty("EAS_HOME") + "/server/properties/ssc";
        if (StringUtils.isEmpty((String)portalConfig)) {
            logger.info((Object)"[Eas Portal] please set system property [portal.config].");
        }
        File portalConfigFile = new File(portalConfig);
        String configPath = portalConfigFile.getAbsolutePath() + "/" + relativeFileName;
        return configPath;
    }
}

