/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.common.script.custom;

import com.kingdee.eas.base.ssc.DynamicAttributeInfo;
import com.kingdee.eas.base.ssc.DynamicValueCollection;
import com.kingdee.eas.base.ssc.DynamicValueInfo;
import com.kingdee.eas.base.ssc.FieldType;
import com.kingdee.eas.base.ssc.common.script.custom.CustomIsNotNullMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomIsNullMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomLeftLikeMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomLikeMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomNotLeftLikeMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomNotLikeMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomNotRightLikeMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomRightLikeMethod;
import com.kingdee.eas.base.ssc.common.script.custom.CustomScriptMethod;
import java.util.ArrayList;
import java.util.HashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ScriptEngineUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.script.ScriptEngineUtil");
    public static final String DEFAULT_ENGINE_NAME = "ELite";
    public static final CustomScriptMethod[] customScriptMethods = ScriptEngineUtil.initCustomScriptMethods();

    public static CustomScriptMethod[] initCustomScriptMethods() {
        try {
            CustomScriptMethod[] array = new CustomScriptMethod[]{new CustomLikeMethod(), new CustomNotLikeMethod(), new CustomLeftLikeMethod(), new CustomNotLeftLikeMethod(), new CustomRightLikeMethod(), new CustomNotRightLikeMethod(), new CustomIsNullMethod(), new CustomIsNotNullMethod()};
            return array;
        }
        catch (Exception e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5de5\u5177\u7c7bScriptEngineUtil\u5931\u8d25!", (Throwable)e);
            return null;
        }
    }

    public static ScriptEngine getScriptEngine() {
        return ScriptEngineUtil.getScriptEngine(DEFAULT_ENGINE_NAME);
    }

    public static ScriptEngine getScriptEngine(String scriptEngineName) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        return scriptEngineManager.getEngineByName(scriptEngineName);
    }

    public static String changeCustomScript(String scriptEngineName, String script) {
        try {
            for (int i = 0; i < customScriptMethods.length; ++i) {
                script = customScriptMethods[i].changeCustomScript(scriptEngineName, script);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u811a\u672c\u81ea\u5b9a\u4e49\u65b9\u6cd5\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return script;
    }

    public static String changeCustomScript(String script) {
        return ScriptEngineUtil.changeCustomScript(DEFAULT_ENGINE_NAME, script);
    }

    public static boolean isRuleMatch(String script, DynamicValueCollection dynamicValueCollection) {
        if (StringUtils.isEmpty((CharSequence)script)) {
            return false;
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        if (script.contains(".") && null != dynamicValueCollection && 0 < dynamicValueCollection.size()) {
            for (int i = 0; i < dynamicValueCollection.size(); ++i) {
                String number = dynamicValueCollection.get(i).getDynamicID().getNumber();
                if (!number.contains(".") || !script.contains(number)) continue;
                String tempNumber = number.replaceAll("\\.", "_");
                tempMap.put(number, tempNumber);
                script = script.replaceAll(number, tempNumber);
            }
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(DEFAULT_ENGINE_NAME);
        DynamicValueInfo dynamicValueInfo = null;
        if (null != dynamicValueCollection && 0 < dynamicValueCollection.size()) {
            for (int i = 0; i < dynamicValueCollection.size(); ++i) {
                String value;
                dynamicValueInfo = dynamicValueCollection.get(i);
                DynamicAttributeInfo attrInfo = dynamicValueInfo.getDynamicID();
                if (FieldType.NUMBER.equals((Object)attrInfo.getType())) {
                    try {
                        Double b = dynamicValueInfo.getDigiValue() == null ? 0.0 : Double.valueOf(dynamicValueInfo.getDigiValue().setScale(4, 5).toString());
                        if (null != tempMap.get(attrInfo.getNumber())) {
                            scriptEngine.put((String)tempMap.get(attrInfo.getNumber()), b);
                        } else {
                            scriptEngine.put(attrInfo.getNumber(), b);
                        }
                        script = ScriptEngineUtil.formatScript(attrInfo.getNumber(), script);
                    }
                    catch (NumberFormatException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                String string = value = "null".equals(dynamicValueInfo.getDinamicValue()) ? null : dynamicValueInfo.getDinamicValue();
                if (null != tempMap.get(attrInfo.getNumber())) {
                    scriptEngine.put((String)tempMap.get(attrInfo.getNumber()), value);
                    continue;
                }
                scriptEngine.put(attrInfo.getNumber(), value);
            }
        }
        Boolean assignResult = false;
        try {
            script = ScriptEngineUtil.changeCustomScript(DEFAULT_ENGINE_NAME, script);
            assignResult = (Boolean)scriptEngine.eval(script);
            logger.info((Object)("***script*" + script + "***assignResult=" + assignResult));
        }
        catch (ScriptException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            assignResult = false;
        }
        return assignResult;
    }

    private static String formatScript(String key, String script) {
        int i;
        if (script.indexOf(key) == -1) {
            return script;
        }
        ArrayList<String> param = new ArrayList<String>();
        int beginIndex = script.indexOf("'");
        while (beginIndex != -1) {
            int endIndex = script.indexOf("'", beginIndex + 1);
            param.add(script.substring(beginIndex, endIndex + 1));
            beginIndex = script.indexOf("'", endIndex + 1);
        }
        String tempScript = script;
        for (int i2 = 0; i2 < param.size(); ++i2) {
            tempScript = tempScript.replaceFirst((String)param.get(i2), "{" + i2 + "}");
        }
        int j = -1;
        String[] condition = tempScript.split("\\|\\||&&");
        for (i = 0; i < condition.length; ++i) {
            if (!condition[i].matches(".+\\{\\d+\\}")) continue;
            ++j;
            if (!condition[i].startsWith(key + "==") && !condition[i].startsWith(key + ">") && !condition[i].startsWith(key + "<") && !condition[i].startsWith(key + "!=")) continue;
            param.set(j, ((String)param.get(j)).replaceAll("'", ""));
        }
        for (i = 0; i < param.size(); ++i) {
            tempScript = tempScript.replace("{" + i + "}", (CharSequence)param.get(i));
        }
        return tempScript;
    }
}

