/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.viewOnline;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Properties;

public class DocConverter {
    private String fileName;
    private File pdfFile;
    private File swfFile;
    private File docFile;

    public DocConverter(String fileString) {
        this.ini(fileString);
    }

    public void setFile(String fileString) {
        this.ini(fileString);
    }

    private void ini(String fileString) {
        this.fileName = fileString.substring(0, fileString.lastIndexOf("."));
        this.docFile = new File(fileString);
        this.pdfFile = new File(this.fileName + ".pdf");
        this.swfFile = new File(this.fileName + ".swf");
    }

    private void doc2pdf() throws Exception {
        if (this.docFile.exists()) {
            if (!this.pdfFile.exists()) {
                SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection(8100);
                try {
                    connection.connect();
                    OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter((OpenOfficeConnection)connection);
                    converter.convert(this.docFile, this.pdfFile);
                    connection.disconnect();
                    System.out.println("****pdf\u8f6c\u6362\u6210\u529f\uff0cPDF\u8f93\u51fa\uff1a" + this.pdfFile.getPath() + "****");
                }
                catch (ConnectException e) {
                    e.printStackTrace();
                    System.out.println("****swf\u8f6c\u6362\u5668\u5f02\u5e38\uff0copenoffice\u670d\u52a1\u672a\u542f\u52a8\uff01****");
                    throw e;
                }
                catch (OpenOfficeException e) {
                    e.printStackTrace();
                    System.out.println("****swf\u8f6c\u6362\u5668\u5f02\u5e38\uff0c\u8bfb\u53d6\u8f6c\u6362\u6587\u4ef6\u5931\u8d25****");
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            } else {
                System.out.println("****\u5df2\u7ecf\u8f6c\u6362\u4e3apdf\uff0c\u4e0d\u9700\u8981\u518d\u8fdb\u884c\u8f6c\u5316****");
            }
        } else {
            System.out.println("****swf\u8f6c\u6362\u5668\u5f02\u5e38\uff0c\u9700\u8981\u8f6c\u6362\u7684\u6587\u6863\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8f6c\u6362****");
        }
    }

    static String loadStream(InputStream in) throws IOException {
        int ptr = 0;
        in = new BufferedInputStream(in);
        StringBuffer buffer = new StringBuffer();
        while ((ptr = in.read()) != -1) {
            buffer.append((char)ptr);
        }
        return buffer.toString();
    }

    public static boolean isWin() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        return os.startsWith("win") || os.startsWith("Win");
    }

    public static boolean isLinux() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        return os.startsWith("linux") || os.startsWith("Linux");
    }

    public static boolean isMac() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        return os.startsWith("mac") || os.startsWith("Mac");
    }

    public boolean conver() {
        if (this.swfFile.exists()) {
            System.out.println("****swf\u8f6c\u6362\u5668\u5f00\u59cb\u5de5\u4f5c\uff0c\u8be5\u6587\u4ef6\u5df2\u7ecf\u8f6c\u6362\u4e3aswf****");
            return true;
        }
        if (DocConverter.isWin()) {
            System.out.println("****swf\u8f6c\u6362\u5668\u5f00\u59cb\u5de5\u4f5c\uff0c\u5f53\u524d\u8bbe\u7f6e\u8fd0\u884c\u73af\u5883windows****");
        } else {
            System.out.println("****swf\u8f6c\u6362\u5668\u5f00\u59cb\u5de5\u4f5c\uff0c\u5f53\u524d\u8bbe\u7f6e\u8fd0\u884c\u73af\u5883linux****");
        }
        try {
            this.doc2pdf();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return this.swfFile.exists();
    }

    public String getswfPath() {
        if (this.swfFile.exists()) {
            String tempString = this.swfFile.getPath();
            tempString = tempString.replaceAll("\\\\", "/");
            return tempString;
        }
        return "";
    }

    public String getPdfPath() {
        if (this.pdfFile.exists()) {
            String tempString = this.pdfFile.getPath();
            tempString = tempString.replaceAll("\\\\", "/");
            return tempString;
        }
        return "";
    }

    public void setOutputPath(String outputPath) {
        if (!outputPath.equals("")) {
            String realName = this.fileName.substring(this.fileName.lastIndexOf("/"), this.fileName.lastIndexOf("."));
            this.swfFile = outputPath.charAt(outputPath.length()) == '/' ? new File(outputPath + realName + ".swf") : new File(outputPath + realName + ".swf");
        }
    }

    public static boolean enableOpenOffice(Context ctx) {
        boolean result = false;
        String sql = "select fvalue from t_ssc_DocViewOnLineCfg where fkey = 'openOffice_enable'";
        try {
            String temp;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && !StringUtils.isEmpty((String)(temp = rs.getString("fvalue")))) {
                result = Boolean.parseBoolean(temp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

