/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssccommon.cost;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssccommon.cost.CostBean;
import com.kingdee.eas.base.ssccommon.utils.timeutils.DateUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CostUtil {
    private static Logger logger = Logger.getLogger((String)"CostUtil");
    private static int originStackIndex = 2;
    private static CostUtil cost;
    private static final String insertLogSql = "INSERT INTO T_SSCCOM_Cost(FID,Fun,Fcost,Funit,FstartTime,FendTime,FinvokeChain) VALUES (newbosid('2E8E4932'),?,?,?,?,?,?)";

    private CostUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CostUtil getInstance() {
        if (cost != null) return cost;
        Class<CostUtil> clazz = CostUtil.class;
        synchronized (CostUtil.class) {
            if (cost != null) return cost;
            cost = new CostUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cost;
        }
    }

    public CostBean startCost(Context ctx, String methodName, long outTime, int unit) throws BOSException {
        if (null == ctx) {
            throw new BOSException("can not find ctx \uff01");
        }
        CostBean obj = new CostBean();
        try {
            StringBuffer sb = new StringBuffer("");
            if (0L > outTime) {
                obj.setLevel(0).setMsg("\u8d85\u65f6\u65f6\u95f4:" + outTime + "\u5c0f\u4e8e0");
                return obj;
            }
            if (StringUtils.isNotBlank((String)methodName)) {
                sb.append(methodName);
            } else {
                sb.append(Thread.currentThread().getStackTrace()[originStackIndex]);
            }
            obj.setOutTime(outTime).setFunctionName(sb.toString()).setBeginTime(new Date()).setUnit(unit).setCtx(ctx);
        }
        catch (Exception e) {
            obj.setLevel(0).setMsg(e.getMessage());
            logger.error((Object)e.getMessage());
        }
        return obj;
    }

    public static CostBean endCost(CostBean obj) {
        try {
            if (obj.getLevel() == 0) {
                return obj;
            }
            Date endTime = new Date();
            if (obj.getLevel() >= 1) {
                String cost = DateUtils.getBetweenTime(endTime, obj.getBeginTime(), obj.getUnit());
                if (Long.valueOf(cost) > obj.getOutTime()) {
                    obj.setCost(cost).setEndTime(endTime).setLevel(2);
                    DbUtil.execute((Context)obj.getCtx(), (String)insertLogSql, (Object[])new Object[]{obj.getFunctionName(), obj.getCost(), obj.getUnit(), new Timestamp(obj.getBeginTime().getTime()), new Timestamp(obj.getEndTime().getTime()), ""});
                } else {
                    obj.setLevel(1);
                }
            }
        }
        catch (Exception e) {
            obj.setLevel(0).setMsg(e.getMessage());
            logger.error((Object)e.getMessage());
        }
        return obj;
    }

    public static String getFileName() {
        return Thread.currentThread().getStackTrace()[originStackIndex].getFileName();
    }

    private static String defaultFunction() {
        StringBuffer sb = new StringBuffer(CostUtil.getClassName()).append(".").append(CostUtil.getMethodName());
        return sb.toString();
    }

    public static String getClassName() {
        return Thread.currentThread().getStackTrace()[originStackIndex].getClassName();
    }

    public static String getMethodName() {
        return Thread.currentThread().getStackTrace()[originStackIndex].getMethodName();
    }

    public static int getLineNumber() {
        return Thread.currentThread().getStackTrace()[originStackIndex].getLineNumber();
    }

    public static void writeLogger(Logger logger, String message, String remark) {
        StackTraceElement ste = Thread.currentThread().getStackTrace()[originStackIndex];
        CostUtil.writeLogger(logger, ste.getLineNumber(), ste.getMethodName(), remark, message);
    }

    public static void writeException(Logger logger, String remark, Throwable e) {
        StackTraceElement ste = Thread.currentThread().getStackTrace()[originStackIndex];
        CostUtil.writeException(logger, ste.getLineNumber(), ste.getMethodName(), remark, e);
    }

    private static void writeLogger(Logger logger, int number, String methodName, String remark, String message) {
        logger.info((Object)(CostUtil.message(number, methodName, remark) + message));
    }

    private static void writeErrorLogger(Logger logger, int number, String methodName, String remark, String message) {
        logger.error((Object)(CostUtil.message(number, methodName, remark) + message));
    }

    private static void writeWarnLogger(Logger logger, int number, String methodName, String remark, String message) {
        logger.warn((Object)(CostUtil.message(number, methodName, remark) + message));
    }

    private static void writeDebugLogger(Logger logger, int number, String methodName, String remark, String message) {
        logger.debug((Object)(CostUtil.message(number, methodName, remark) + message));
    }

    private static void writeException(Logger logger, int number, String methodName, String remark, Throwable e) {
        logger.info((Object)CostUtil.message(number, methodName, remark), e);
    }

    private static void writeErrorException(Logger logger, int number, String methodName, String remark, Throwable e) {
        logger.error((Object)CostUtil.message(number, methodName, remark), e);
    }

    private static void writeWarnException(Logger logger, int number, String methodName, String remark, Throwable e) {
        logger.warn((Object)CostUtil.message(number, methodName, remark), e);
    }

    private static void writeDebugException(Logger logger, int number, String methodName, String remark, Throwable e) {
        logger.debug((Object)CostUtil.message(number, methodName, remark), e);
    }

    private static String message(int number, String methodName, String remark) {
        return "\u3010\u7b2c" + number + "\u884c\u3011\u3010" + methodName + "\u3011\u3010" + remark + "\u3011";
    }
}

