/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.ComMenuFunctionCollection;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.MainFunctionInfo;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class EASMainMenuCacheUtil {
    public static final String PERM_ID = "PERMISSION_ID";
    protected static final Logger logger = Logger.getLogger(EASMainMenuCacheUtil.class);
    private static final String ID = "id";
    private static final String LONG_NUMBER = "ln";
    private static final String NAME = "n_";
    private static final String IMAGE_PATH = "ip";
    private static final String IS_REPORT = "ir";
    private static final String IS_LEAF = "il";
    private static final String IS_VISIABLE = "iv";
    private static final String LEVEL = "lv";
    private static final String ORDER = "o";
    private static final String ENABLE = "en";
    private static final String UI_CLASS_NAME = "ucn";
    private static final String UI_CLASS_PARAM = "ucp";
    private static final String UI_OPRT = "uo";
    private static final String OPEN_METHOD = "om";
    private static final String SHORTCUT_CODE = "sc";
    private static final String NUMBER = "num";
    private static final String PARENT = "pa";
    private static final String FUNCTION = "fun";
    private static final String DIR = "dir";
    private static final String MenuFunctionID = "mfi";
    private static final String MENUITEMNAME = "mn_";

    public static void writeCacheMenu(MainFunctionInfo fInfo, String fileName, Locale l) throws IOException {
        if (fInfo == null) {
            return;
        }
        String dirName = fileName.substring(0, fileName.lastIndexOf("/"));
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Document doc = new Document();
        Element root = new Element("EAS_MainMenu");
        doc.setRootElement(root);
        Element subSystemMenu = new Element("SubSystemMenu");
        root.addContent((Content)subSystemMenu);
        MainMenuItemCollection cols = fInfo.getTopLeverMenuCollection();
        MainMenuItemInfo menuInfo = null;
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            menuInfo = cols.get(i);
            subSystemMenu.addContent((Content)EASMainMenuCacheUtil.createMenuElement(menuInfo, l));
        }
        Element subMenu = new Element("SubMenu");
        root.addContent((Content)subMenu);
        HashMap subMenuMap = fInfo.getSubItemMap();
        Iterator iter = subMenuMap.entrySet().iterator();
        Map.Entry entry = null;
        List menuList = null;
        while (iter.hasNext()) {
            entry = iter.next();
            Element longNumElement = new Element("L_Num");
            longNumElement.setAttribute("value", entry.getKey().toString());
            subMenu.addContent((Content)longNumElement);
            menuList = (List)entry.getValue();
            for (int i = 0; i < menuList.size(); ++i) {
                menuInfo = (MainMenuItemInfo)menuList.get(i);
                longNumElement.addContent((Content)EASMainMenuCacheUtil.createMenuElement(menuInfo, l));
            }
        }
        XMLOutputter outp = null;
        FileOutputStream out = null;
        try {
            Format format = Format.getCompactFormat();
            format.setEncoding("utf-8");
            format.setIndent("   ");
            outp = new XMLOutputter(format);
            File f = new File(fileName);
            out = new FileOutputStream(f);
            outp.output(doc, (OutputStream)out);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outp != null) {
                outp.clone();
            }
        }
    }

    public static void writeComFuncCache(ComMenuFunctionCollection cols, String fileName, Locale l) throws IOException {
        if (cols == null) {
            return;
        }
        String dirName = fileName.substring(0, fileName.lastIndexOf("/"));
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Document doc = new Document();
        Element root = new Element("root");
        doc.setRootElement(root);
        Element subSystemMenu = new Element("child");
        root.addContent((Content)subSystemMenu);
        ComMenuFunctionInfo menuInfo = null;
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            menuInfo = cols.get(i);
            subSystemMenu.addContent((Content)EASMainMenuCacheUtil.createComMenuElement(menuInfo, l));
        }
        XMLOutputter outp = null;
        FileOutputStream out = null;
        try {
            Format format = Format.getCompactFormat();
            format.setEncoding("utf-8");
            format.setIndent("   ");
            outp = new XMLOutputter(format);
            File f = new File(fileName);
            out = new FileOutputStream(f);
            outp.output(doc, (OutputStream)out);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outp != null) {
                outp.clone();
            }
        }
    }

    public static MainFunctionInfo readCacheMenu(String fileName, Locale l) throws Exception {
        long t1 = System.currentTimeMillis();
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        File file = null;
        file = new File(fileName);
        doc = sb.build(file);
        Element root = doc.getRootElement();
        Element subSystemMenu = root.getChild("SubSystemMenu");
        Element menuElement = null;
        MainMenuItemCollection cols = new MainMenuItemCollection();
        int size = subSystemMenu.getChildren().size();
        for (int i = 0; i < size; ++i) {
            menuElement = (Element)subSystemMenu.getChildren().get(i);
            cols.add(EASMainMenuCacheUtil.createMenuItemInfo(menuElement, l));
        }
        Element subMenu = root.getChild("SubMenu");
        Element longNumElement = null;
        ArrayList<MainMenuItemInfo> subMenuList = null;
        String longNumber = null;
        HashMap subMenuMap = new HashMap();
        int size2 = subMenu.getChildren().size();
        for (int i = 0; i < size2; ++i) {
            longNumElement = (Element)subMenu.getChildren().get(i);
            longNumber = longNumElement.getAttributeValue("value");
            subMenuList = new ArrayList<MainMenuItemInfo>();
            int length = longNumElement.getChildren().size();
            for (int t = 0; t < length; ++t) {
                menuElement = (Element)longNumElement.getChildren().get(t);
                subMenuList.add(EASMainMenuCacheUtil.createMenuItemInfo(menuElement, l));
            }
            subMenuMap.put(longNumber, subMenuList);
        }
        MainFunctionInfo fInfo = new MainFunctionInfo();
        fInfo.setTopLeverMenuCollection(cols);
        fInfo.setSubItemMap(subMenuMap);
        return fInfo;
    }

    public static ComMenuFunctionCollection readComFuncCache(String fileName, Locale l) throws Exception {
        long t1 = System.currentTimeMillis();
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        File file = null;
        file = new File(fileName);
        doc = sb.build(file);
        Element root = doc.getRootElement();
        Element subSystemMenu = root.getChild("child");
        Element conFuncElement = null;
        ComMenuFunctionCollection cols = new ComMenuFunctionCollection();
        int size = subSystemMenu.getChildren().size();
        for (int i = 0; i < size; ++i) {
            conFuncElement = (Element)subSystemMenu.getChildren().get(i);
            cols.add(EASMainMenuCacheUtil.createConFuncMenuItemInfo(conFuncElement, l));
        }
        return cols;
    }

    private static ComMenuFunctionInfo createConFuncMenuItemInfo(Element comMenuElement, Locale l) {
        ComMenuFunctionInfo confuncInfo = new ComMenuFunctionInfo();
        confuncInfo.setId(BOSUuid.read((String)comMenuElement.getChild(ID).getText()));
        confuncInfo.setLongNumber(comMenuElement.getChild(LONG_NUMBER).getText());
        confuncInfo.setName(comMenuElement.getChild(NAME + l.toString()).getText(), l);
        confuncInfo.setIsLeaf(Boolean.valueOf(comMenuElement.getChild(IS_LEAF).getText()).booleanValue());
        confuncInfo.setLevel(new Integer(comMenuElement.getChild(LEVEL).getText()).intValue());
        confuncInfo.setOrder(new Integer(comMenuElement.getChild(ORDER).getText()).intValue());
        confuncInfo.setDir(Boolean.valueOf(comMenuElement.getChild(DIR).getText()).booleanValue());
        MainMenuItemInfo menuItem = new MainMenuItemInfo();
        menuItem.setId(BOSUuid.read((String)comMenuElement.getChild(MenuFunctionID).getText()));
        if (comMenuElement.getChild(MENUITEMNAME) != null) {
            menuItem.setName(comMenuElement.getChild(MENUITEMNAME).getText());
        }
        if (comMenuElement.getChild(UI_CLASS_NAME) != null) {
            menuItem.setUiClassName(comMenuElement.getChild(UI_CLASS_NAME).getText());
        }
        if (comMenuElement.getChild(UI_CLASS_PARAM) != null) {
            menuItem.setUiClassParam(comMenuElement.getChild(UI_CLASS_PARAM).getText());
        }
        if (comMenuElement.getChild(UI_OPRT) != null) {
            menuItem.setUiOprt(comMenuElement.getChild(UI_OPRT).getText());
        }
        if (comMenuElement.getChild(OPEN_METHOD) != null) {
            menuItem.setOpenMethod(OpenMethod.getEnum(Integer.parseInt(comMenuElement.getChild(OPEN_METHOD).getText())));
        }
        if (comMenuElement.getChild(ENABLE) != null) {
            menuItem.setEnabled(Boolean.valueOf(comMenuElement.getChild(ENABLE).getText()).booleanValue());
        }
        confuncInfo.setMenuFunction(menuItem);
        return confuncInfo;
    }

    private static MainMenuItemInfo createMenuItemInfo(Element menuElement, Locale l) {
        MainMenuItemInfo menuInfo = new MainMenuItemInfo();
        menuInfo.setId(BOSUuid.read((String)menuElement.getChild(ID).getText()));
        menuInfo.setLongNumber(menuElement.getChild(LONG_NUMBER).getText());
        menuInfo.setName(menuElement.getChild(NAME + l.toString()).getText(), l);
        menuInfo.setImagePath(menuElement.getChild(IMAGE_PATH).getText());
        menuInfo.setIsReport(Boolean.valueOf(menuElement.getChild(IS_REPORT).getText()).booleanValue());
        menuInfo.setIsLeaf(Boolean.valueOf(menuElement.getChild(IS_LEAF).getText()).booleanValue());
        menuInfo.setVisible(Boolean.valueOf(menuElement.getChild(IS_VISIABLE).getText()).booleanValue());
        menuInfo.setLevel(new Integer(menuElement.getChild(LEVEL).getText()).intValue());
        menuInfo.setOrder(menuElement.getChild(ORDER).getText());
        menuInfo.setEnabled(Boolean.valueOf(menuElement.getChild(ENABLE).getText()).booleanValue());
        if (menuElement.getChild(UI_CLASS_NAME) != null) {
            menuInfo.setUiClassName(menuElement.getChild(UI_CLASS_NAME).getText());
        }
        if (menuElement.getChild(UI_CLASS_PARAM) != null) {
            menuInfo.setUiClassParam(menuElement.getChild(UI_CLASS_PARAM).getText());
        }
        if (menuElement.getChild(UI_OPRT) != null) {
            menuInfo.setUiOprt(menuElement.getChild(UI_OPRT).getText());
        }
        if (menuElement.getChild(OPEN_METHOD) != null) {
            menuInfo.setOpenMethod(OpenMethod.getEnum(new Integer(menuElement.getChild(OPEN_METHOD).getText())));
        }
        if (menuElement.getChild(SHORTCUT_CODE) != null) {
            menuInfo.setShortcutCode(menuElement.getChild(SHORTCUT_CODE).getText());
        }
        menuInfo.setNumber(menuElement.getChild(NUMBER).getText());
        if (menuElement.getChild(PARENT) == null || StringUtils.isEmpty((String)menuElement.getChild(PARENT).getText())) {
            menuInfo.setParent(null);
        } else {
            MainMenuItemInfo parentInfo = new MainMenuItemInfo();
            parentInfo.setId(BOSUuid.read((String)menuElement.getChild(PARENT).getText()));
            menuInfo.setParent(parentInfo);
        }
        if (menuElement.getChild(FUNCTION) != null) {
            menuInfo.put(PERM_ID, (Object)menuElement.getChild(FUNCTION).getText());
        }
        return menuInfo;
    }

    private static Element createComMenuElement(ComMenuFunctionInfo comMenuInfo, Locale l) {
        Element field = new Element("child");
        field.addContent((Content)new Element(ID).setText(comMenuInfo.getId().toString()));
        field.addContent((Content)new Element(LONG_NUMBER).setText(comMenuInfo.getLongNumber()));
        field.addContent((Content)new Element(NAME + l.toString()).setText(comMenuInfo.getName(l)));
        field.addContent((Content)new Element(IS_LEAF).setText(Boolean.toString(comMenuInfo.isIsLeaf())));
        field.addContent((Content)new Element(LEVEL).setText(new Integer(comMenuInfo.getLevel()).toString()));
        field.addContent((Content)new Element(ORDER).setText(new Integer(comMenuInfo.getOrder()).toString()));
        field.addContent((Content)new Element(DIR).setText(String.valueOf(comMenuInfo.isDir())));
        field.addContent((Content)new Element(MenuFunctionID).setText(comMenuInfo.getMenuFunction().getId().toString()));
        if (!StringUtils.isEmpty((String)comMenuInfo.getMenuFunction().getUiClassName())) {
            field.addContent((Content)new Element(UI_CLASS_NAME).setText(comMenuInfo.getMenuFunction().getUiClassName()));
        }
        if (!StringUtils.isEmpty((String)comMenuInfo.getMenuFunction().getUiClassParam())) {
            field.addContent((Content)new Element(UI_CLASS_PARAM).setText(comMenuInfo.getMenuFunction().getUiClassParam()));
        }
        if (comMenuInfo.getMenuFunction().getOpenMethod() != null) {
            field.addContent((Content)new Element(OPEN_METHOD).setText(new Integer(comMenuInfo.getMenuFunction().getOpenMethod().getValue()).toString()));
        }
        String uiOprt = StringUtils.cnulls((String)comMenuInfo.getMenuFunction().getUiOprt());
        field.addContent((Content)new Element(UI_OPRT).setText(uiOprt));
        field.addContent((Content)new Element(ENABLE).setText(Boolean.toString(comMenuInfo.getMenuFunction().isEnabled())));
        field.addContent((Content)new Element(MENUITEMNAME).setText(comMenuInfo.getMenuFunction().getName()));
        return field;
    }

    private static Element createMenuElement(MainMenuItemInfo menuInfo, Locale l) {
        Element field = new Element("menu");
        field.addContent((Content)new Element(ID).setText(menuInfo.getId().toString()));
        field.addContent((Content)new Element(LONG_NUMBER).setText(menuInfo.getLongNumber()));
        field.addContent((Content)new Element(NAME + l.toString()).setText(menuInfo.getName(l)));
        field.addContent((Content)new Element(IMAGE_PATH).setText(menuInfo.getImagePath()));
        field.addContent((Content)new Element(IS_REPORT).setText(Boolean.toString(menuInfo.isIsReport())));
        field.addContent((Content)new Element(IS_LEAF).setText(Boolean.toString(menuInfo.isIsLeaf())));
        field.addContent((Content)new Element(IS_VISIABLE).setText(Boolean.toString(menuInfo.isVisible())));
        field.addContent((Content)new Element(LEVEL).setText(new Integer(menuInfo.getLevel()).toString()));
        field.addContent((Content)new Element(ORDER).setText(menuInfo.getOrder()));
        field.addContent((Content)new Element(ENABLE).setText(Boolean.toString(menuInfo.isEnabled())));
        if (!StringUtils.isEmpty((String)menuInfo.getUiClassName())) {
            field.addContent((Content)new Element(UI_CLASS_NAME).setText(menuInfo.getUiClassName()));
        }
        if (!StringUtils.isEmpty((String)menuInfo.getUiClassParam())) {
            field.addContent((Content)new Element(UI_CLASS_PARAM).setText(menuInfo.getUiClassParam()));
        }
        if (!StringUtils.isEmpty((String)menuInfo.getUiOprt())) {
            field.addContent((Content)new Element(UI_OPRT).setText(menuInfo.getUiOprt()));
        }
        field.addContent((Content)new Element(OPEN_METHOD).setText(new Integer(menuInfo.getOpenMethod().getValue()).toString()));
        if (!StringUtils.isEmpty((String)menuInfo.getShortcutCode())) {
            field.addContent((Content)new Element(SHORTCUT_CODE).setText(menuInfo.getShortcutCode()));
        }
        field.addContent((Content)new Element(NUMBER).setText(menuInfo.getNumber()));
        if (menuInfo.getParent() != null) {
            field.addContent((Content)new Element(PARENT).setText(menuInfo.getParent().getId().toString()));
        }
        if (menuInfo.get(PERM_ID) != null) {
            field.addContent((Content)new Element(FUNCTION).setText(menuInfo.get(PERM_ID).toString()));
        }
        return field;
    }
}

