/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;

public class FunctionLabel
extends KDLabel {
    private static final Logger logger = CoreUIObject.getLogger(FunctionLabel.class);
    private boolean isDir;
    private ComMenuFunctionInfo menu;
    private Color inColor;
    private Color borderColor;
    private boolean isOpen;
    private boolean isDown;
    private float borderWidth;
    private boolean isMousePressed;

    public FunctionLabel(ComMenuFunctionInfo menu, boolean isDir) {
        this.menu = menu;
        this.isDir = isDir;
        this.initLabel(isDir);
    }

    public boolean isMousePressed() {
        return this.isMousePressed;
    }

    public void setMousePressed(boolean isMousePressed) {
        this.isMousePressed = isMousePressed;
    }

    public boolean isDown() {
        return this.isDown;
    }

    public void setDown(boolean isDown) {
        this.isDown = isDown;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Color getInColor() {
        return this.inColor;
    }

    public void setInColor(Color inColor) {
        this.inColor = inColor;
    }

    public boolean isIsDir() {
        return this.isDir;
    }

    public ComMenuFunctionInfo getMenu() {
        return this.menu;
    }

    public void setAutoToolTipText(boolean auto) {
        super.setAutoToolTipText(auto);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setLightWeightPopupEnabled(false);
        if (auto) {
            toolTipManager.registerComponent((JComponent)((Object)this));
        } else {
            toolTipManager.unregisterComponent((JComponent)((Object)this));
        }
    }

    private void initLabel(boolean isDir) {
        this.setOpaque(false);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setText(this.menu.getName());
        if (isDir) {
            this.setIcon(EASResource.getIcon((String)"image_folderA_1"));
        } else {
            String imagePath = this.menu.getMenuFunction().getImagePath();
            if (imagePath == null) {
                this.setIcon(EASResource.getIcon((String)"imgFunction_billEdit"));
            } else {
                this.setIcon(EASResource.getIcon((String)this.menu.getMenuFunction().getImagePath()));
            }
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.inColor != null) {
            g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.inColor);
            g2d.fillRoundRect(0, 0, w - 1, h - 1, 15, 15);
            g2d.setColor(this.borderColor);
            g2d.setStroke(new BasicStroke(this.borderWidth));
            g2d.drawRoundRect(0, 0, w - 1, h - 1, 15, 15);
        }
        if (this.isOpen) {
            g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GradientPaint gp = null;
            Object gpLeftLine = null;
            Object gpRightLine = null;
            Rectangle2D.Float r2d = null;
            Line2D.Float l2dLeft = null;
            Line2D.Float l2dRight = null;
            Line2D.Float l2dTop = null;
            Line2D.Float l2dBottom = null;
            if (this.isDown) {
                gp = new GradientPaint(1.0f, h + 5, new Color(255, 246, 194), 1.0f, 2 * h / 7, new Color(248, 249, 250));
                r2d = new Rectangle2D.Float(0.0f, 0.0f, w, h + 5);
                l2dLeft = new Line2D.Float(0.0f, h + 5, 0.0f, 0.0f);
                l2dRight = new Line2D.Float(w - 1, 0.0f, w - 1, h + 5);
                l2dTop = new Line2D.Float(0.0f, 0.0f, w - 1, 0.0f);
                l2dBottom = new Line2D.Float(0.0f, h + 5, w - 1, h + 5);
            } else {
                gp = new GradientPaint(1.0f, -5.0f, new Color(255, 246, 194), 1.0f, 5 * h / 7, new Color(248, 249, 250));
                r2d = new Rectangle2D.Float(0.0f, -5.0f, w, h);
                l2dLeft = new Line2D.Float(0.0f, -5.0f, 0.0f, h);
                l2dRight = new Line2D.Float(w - 1, -5.0f, w - 1, h);
                l2dTop = new Line2D.Float(0.0f, -5.0f, w - 1, -5.0f);
                l2dBottom = new Line2D.Float(0.0f, h - 6, w - 1, h - 6);
            }
            g2d.setPaint(gp);
            g2d.setClip(r2d);
            g2d.fill(r2d);
            g2d.setColor(Color.decode("#DEDEDE"));
            g2d.draw(l2dLeft);
            g2d.setColor(Color.decode("#DEDEDE"));
            g2d.draw(l2dRight);
            g2d.setColor(Color.decode("#DEDEDE"));
            g2d.draw(l2dTop);
            g2d.setColor(Color.decode("#DEDEDE"));
            g2d.draw(l2dBottom);
        }
        super.paintComponent(g);
    }
}

