/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.file.cloudRegist.CloudUtils;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.KsmHelper;
import com.kingdee.eas.base.uiframe.app.AbstractMainFrameServiceFacadeControllerBean;
import com.kingdee.eas.base.uiframe.utils.FileProcessUtil;
import com.kingdee.eas.base.uiframe.utils.PropertiesUtils;
import com.kingdee.eas.base.uiframe.utils.RecordFileUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;

public class MainFrameServiceFacadeControllerBean
extends AbstractMainFrameServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.uiframe.app.MainFrameServiceFacadeControllerBean");
    private static final String CHARSET = "utf-8";

    @Override
    protected TimeZone _getServerTimeZone(Context ctx) throws BOSException, EASBizException {
        return TimeZone.getDefault();
    }

    @Override
    protected String _getPortalServerUrl(Context ctx) throws BOSException {
        Configuration config = Configuration.getInstance();
        ConfigurationItem sln = config.getConfigItem("PortalInfo");
        Map slns = sln.getProperties();
        String host = sln.getProperty("host", "localhost");
        String port = sln.getProperty("port", "6888");
        String root = sln.getProperty("contextroot", "/easportal");
        return new StringBuffer(host).append(":").append(port).append(root).toString();
    }

    private String genPath(String[] pathParts) {
        StringBuilder sb = new StringBuilder();
        for (String part : pathParts) {
            sb.append(part).append(File.separator);
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int _getSendFrequence(Context ctx) throws BOSException {
        String easHome = System.getProperty("EAS_HOME");
        String frequencePath = this.genPath(new String[]{easHome, "server", "properties", "frequence.properties"});
        OutputStreamWriter fileWriter = null;
        InputStream inStream = null;
        try {
            File file = new File(frequencePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            Properties properties = new Properties();
            inStream = new FileInputStream(frequencePath);
            PropertiesUtils.load(properties, inStream);
            fileWriter = new FileWriter(file);
            if (properties.getProperty("SEND_TIME") == null) {
                properties.setProperty("SEND_TIME", new Date().getDate() + "");
                properties.setProperty("SEND_FREQUENCE", "1");
                PropertiesUtils.store(properties, fileWriter, "");
                int n = 0;
                return n;
            }
            int time = new Date().getDay();
            if (time == Integer.parseInt(properties.getProperty("SEND_TIME"))) {
                int sendFrequence = Integer.parseInt(properties.getProperty("SEND_FREQUENCE"));
                properties.setProperty("SEND_FREQUENCE", sendFrequence + 1 + "");
                PropertiesUtils.store(properties, fileWriter, "");
                int n = sendFrequence;
                return n;
            }
            properties.setProperty("SEND_TIME", new Date().getDay() + "");
            properties.setProperty("SEND_FREQUENCE", "1");
            PropertiesUtils.store(properties, fileWriter, "");
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"stream close error!");
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourcePatchInfo() {
        String fileName = "systemInfo";
        String easHome = System.getProperty("EAS_HOME");
        String fileFullPath = this.genPath(new String[]{easHome, "server", "properties", fileName});
        String frequencePath = this.genPath(new String[]{easHome, "server", "properties", "frequence.txt"});
        int size = 1024;
        byte[] b = new byte[size];
        StringBuilder patchInfo = new StringBuilder();
        BufferedInputStream bis = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileFullPath);
            bis = new BufferedInputStream(fileInputStream);
            int byteRead = 0;
            while ((byteRead = bis.read(b)) != -1) {
                patchInfo.append(new String(b, 0, byteRead, CHARSET));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return patchInfo.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getZipPatchInfo(String sourcePatchInfo) {
        DeflaterOutputStream gzos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            gzos = new GZIPOutputStream(baos);
            byte[] srcBs = sourcePatchInfo.getBytes(CHARSET);
            gzos.write(srcBs);
            ((GZIPOutputStream)gzos).finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (gzos != null) {
                    gzos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return new byte[0];
    }

    @Override
    protected byte[] _getPatchInfo(Context ctx) throws BOSException {
        String sourcePatchInfo = this.getSourcePatchInfo();
        return this.getZipPatchInfo(sourcePatchInfo);
    }

    @Override
    protected byte[] _getInstanceNum(Context ctx) throws BOSException {
        this.saveDownTimeRecord();
        String instanceInfo = this.getInstanceInfo();
        return instanceInfo.getBytes();
    }

    private void saveDownTimeRecord() {
        String clusterFile = System.getProperty("EAS_HOME") + "/server/cluster/logs/clusterTime.trace";
        String src = System.getProperty("EAS_HOME") + "/admin/logs/ha.log";
        String dest = System.getProperty("EAS_HOME") + "/server/properties/downTimeRecord.trace";
        File srcFile = new File(src);
        if (!new File(dest).exists()) {
            try {
                new File(dest).createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!new File(clusterFile).exists()) {
            try {
                new File(clusterFile).createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        RecordFileUtil.clearInfoForFile(dest);
        List list = RecordFileUtil.readTxtFromFile(new File(src));
        String beforeDate = RecordFileUtil.getBeforeDate();
        for (int i = 0; i < list.size(); ++i) {
            String ss = (String)list.get(i);
            if (!ss.contains(beforeDate) || !ss.contains("stopped") && !ss.contains("starting")) continue;
            String halog = RecordFileUtil.getHalog(ss);
            RecordFileUtil.fileChaseFW(dest, halog);
        }
        List list2 = RecordFileUtil.readTxtFromFile(new File(clusterFile));
        for (int j = 0; j < list2.size(); ++j) {
            String clu = (String)list2.get(j);
            if (!clu.contains(beforeDate)) continue;
            RecordFileUtil.fileChaseFW(dest, clu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstanceInfo() {
        String fileName = "downTimeRecord.trace";
        String easHome = System.getProperty("EAS_HOME");
        String fileFullPath = this.genPath(new String[]{easHome, "server", "properties", fileName});
        try {
            if (!new File(fileFullPath).exists()) {
                new File(fileFullPath).createNewFile();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int size = 1024;
        byte[] b = new byte[size];
        StringBuilder instanceInfo = new StringBuilder();
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(fileFullPath));
            int byteRead = 0;
            while ((byteRead = bis.read(b)) != -1) {
                instanceInfo.append(new String(b, 0, byteRead, CHARSET));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return instanceInfo.toString();
    }

    @Override
    protected KsmHelper _getKsmHelper(Context ctx) throws BOSException {
        KsmHelper ksmHelper = null;
        try {
            ksmHelper = ksmHelper.getInstance();
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (DocumentException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return ksmHelper;
    }

    @Override
    public synchronized void _saveUserBehaviorData(Context ctx, byte[] byteData) throws BOSException {
        if ("true".equals(System.getProperty("SAVE_BEHAVIOR_DATA"))) {
            String fileFullPath;
            File file;
            Calendar cl = Calendar.getInstance();
            cl.set(5, cl.get(5) - 1);
            int year = cl.get(1);
            int month = cl.get(2) + 1;
            int day = cl.get(5);
            String freDate = String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
            String fileName = freDate + ".properties";
            String easHome = System.getProperty("EAS_HOME");
            String filePath = easHome + "/server/properties/userData";
            ByteArrayInputStream ins = new ByteArrayInputStream(byteData);
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(file = new File(fileFullPath = filePath + "/" + fileName)).exists()) {
                try {
                    file.createNewFile();
                    FileProcessUtil.writePropertiesByStream(ins, fileFullPath);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                Map<String, String> clientMap = FileProcessUtil.readPropertiesByStream(ins);
                Map<String, String> serverMap = FileProcessUtil.readProperties(fileFullPath);
                Map<String, String> updateMap = FileProcessUtil.processDataBatch(clientMap, serverMap);
                FileProcessUtil.writeProperties(fileFullPath, updateMap);
            }
        }
    }

    @Override
    protected String _getServiceUrl(Context ctx) throws BOSException {
        String easHome = System.getProperty("EAS_HOME");
        String pathString = easHome + "/server/properties/systemInfo";
        return MainFrameServiceFacadeControllerBean.parseServerInfo(pathString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseServerInfo(String path) {
        String[] split;
        File file = new File(path);
        if (!file.exists()) {
            try {
                file.createNewFile();
                return "";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String ss = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                ss = ss + tempString;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        if (ss.contains("||") && (split = ss.split("\\|\\|")).length == 5 && MainFrameServiceFacadeControllerBean.getNowDate().compareTo(split[0]) >= 0) {
            MainFrameServiceFacadeControllerBean.saveServerFile(path, ss.replace(split[0], MainFrameServiceFacadeControllerBean.getHalfYearDate()));
            return ss;
        }
        return "";
    }

    @Override
    protected void _initUserLicenseInfoByCloud(Context ctx, String licenseInfo) throws UserException, BOSException, EASBizException {
        JSONObject rs;
        if (StringUtils.isEmpty((String)licenseInfo)) {
            try {
                licenseInfo = EasCloud.getUserLicenseInfoByCloud(ctx, ctx.getCaller().toString());
            }
            catch (UserException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (licenseInfo == null) {
                return;
            }
        }
        if ("0".equalsIgnoreCase((rs = JSONObject.parseObject((String)licenseInfo)).getString("errcode"))) {
            UserInfo info = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select number where id='" + ctx.getCaller().toString() + "'");
            JSONObject data = (JSONObject)rs.get((Object)"data");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("version", data.getInteger("version"));
            params.put("key", data.getString("key"));
            params.put("sign", data.getString("sign"));
            try {
                CloudUtils.updateLicenseGroupsInfo((Context)ctx, (String)info.getNumber(), params);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            String descKey = null;
            if ("l1".equalsIgnoreCase(ctx.getLocale().toString())) {
                descKey = EasCloud.DESCRIPTION;
                if (rs.getString(descKey) == null) {
                    descKey = EasCloud.DESCRIPTION_CN;
                }
            } else {
                descKey = EasCloud.DESCRIPTION_CN;
            }
            throw new BOSException(rs.getString(descKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveServerFile(String filePath, String values) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getNowDate() {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(now);
    }

    public static String getHalfYearDate() {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, 6);
        return sd.format(c.getTime());
    }
}

