/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.license.EASCloudEnum;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.BizTypeEnum;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.ISysMenuItem;
import com.kingdee.eas.base.uiframe.LicenseType;
import com.kingdee.eas.base.uiframe.MainFunctionInfo;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuEditException;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.base.uiframe.SysMenuItemFactory;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.base.uiframe.app.AbstractSysMenuFacadeControllerBean;
import com.kingdee.eas.base.uiframe.app.MainFunctionMenuControllerBean;
import com.kingdee.eas.base.uiframe.utils.LongNumberComparator;
import com.kingdee.eas.base.uiframe.utils.MenuInfo;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class SysMenuFacadeControllerBean
extends AbstractSysMenuFacadeControllerBean {
    private LongNumberComparator[] addMenus = null;
    private LongNumberComparator[] updatedMenus = null;
    private LongNumberComparator[] delMenus = null;
    protected Logger logger = Logger.getLogger(MainFunctionMenuControllerBean.class);
    private static final Locale[] locales = new Locale[]{new Locale("L1"), new Locale("L2"), new Locale("L3")};

    @Override
    protected IRowSet _getSubSys(Context ctx) throws BOSException, EASBizException {
        return DbUtil.executeQuery((Context)ctx, (String)"select FID,FName_L1,FName_L2,FName_L3,FDescription_L1,FDescription_L2,FDescription_L3,FLongNumber,FImagePath,FIsReport,FVisible,FIndustry,FNoSuit from T_BAS_SysMenuItem where FParent is NULL and (FMenutype is null or FMenutype=10) order by FOrder");
    }

    @Override
    protected IRowSet _getSubSys(Context ctx, String industry, String menutype) throws BOSException, EASBizException {
        String industrysql;
        StringBuffer bf = new StringBuffer();
        bf.append("select t.FID,t.FName_L1,t.FName_L2,t.FName_L3,t.FDescription_L1,t.FDescription_L2,t.FDescription_L3,t.FLongNumber,t.FImagePath,t.FIsReport,t.FVisible,t.FIndustry,t.FNoSuit from T_BAS_SysMenuItem t where t.FParent is NULL ");
        if (null != menutype && "5".equals(menutype)) {
            bf.append(" and t.FMenutype=").append(menutype);
        }
        if (null != menutype && !"5".equals(menutype)) {
            bf.append(" and (t.FMenutype is null or t.FMenutype=10)");
        }
        if (null != industry && !"".equals(industry) && (industrysql = this.getIndustrySql(industry)).length() > 0) {
            bf.append(" and ");
            bf.append(industrysql);
        }
        bf.append(" order by t.FOrder");
        return DbUtil.executeQuery((Context)ctx, (String)bf.toString());
    }

    @Override
    protected IRowSet _getMenuByParent(Context ctx, String parentLN) throws BOSException, EASBizException {
        String childrenLN = parentLN + "!%";
        Object[] params = new Object[]{parentLN, childrenLN};
        return DbUtil.executeQuery((Context)ctx, (String)"select * from T_BAS_SysMenuItem where (FLongNumber = ? or FLongNumber like ?)  and (FMenutype is null or FMenutype=10) order by FLongNumber , FOrder", (Object[])params);
    }

    @Override
    protected IRowSet _getFavoriteFunction(Context ctx) throws BOSException, EASBizException {
        String currUserID = ctx.getCaller().toString();
        Object[] rootParams = new Object[]{currUserID};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select FLongNumber from T_BAS_ComFunction where FUserID = ? and FParentID is NULL", (Object[])rootParams);
        String longNumber = null;
        try {
            if (!rowset.next()) {
                return null;
            }
            longNumber = rowset.getString("FLongNumber");
            if (rowset.next()) {
                this.logger.error((Object)(UIFrameUtils.getRes("res_2") + currUserID + UIFrameUtils.getRes("res_3")));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("database exception" + UIFrameUtils.getRes("res_1") + e.getMessage()));
            throw new MenuEditException(MenuEditException.GETFAVORMENUEXCEPTION, e);
        }
        return this._getFavoriteFunctionbyParent(ctx, longNumber);
    }

    @Override
    protected IRowSet _getFavoriteFunctionbyParent(Context ctx, String parentLN) throws BOSException, EASBizException {
        if (parentLN == null || parentLN.length() == 0) {
            return null;
        }
        Object[] params = new Object[]{parentLN, parentLN + "!%"};
        return DbUtil.executeQuery((Context)ctx, (String)"select a.FID as FID,a.FUserID as FUserID,a.FMenuFunctionID as FMenuFunctionID,a.FNumber as FNumber,a.FName_L1 as FName_L1,a.FName_L2 as FName_L2,a.FName_L3 as FName_L3,a.FParentID as FParentID,a.FIsLeaf as FIsLeaf,a.FLongNumber as FLongNumber,a.FLevel as FLevel,a.FDescription_L1 as FDescription_L1,a.FDescription_L2 as FDescription_L2,a.FDescription_L3 as FDescription_L3,a.FDir as FDir,a.FOrder as FOrder,b.FOpenMethod as FOpenMethod from T_BAS_ComFunction a  left join T_BAS_SysMenuItem b on a.FMenuFunctionID = b.FID where a.FLongNumber = ? or a.FLongNumber like ? order by a.FLongNumber", (Object[])params);
    }

    @Override
    protected IRowSet _getAllLeafByParent(Context ctx, String parentLN) throws BOSException, EASBizException {
        String childrenLN = parentLN + "!%";
        Object[] params = new Object[]{childrenLN};
        return DbUtil.executeQuery((Context)ctx, (String)"select distinct(FFunction) from T_BAS_SysMenuItem where FLongNumber like ? and FIsleaf=1 and (FMenutype is null or FMenutype=10)", (Object[])params);
    }

    @Override
    protected IObjectCollection _getSubSysByPerm(Context ctx) throws BOSException, EASBizException {
        try {
            MainMenuItemCollection cols = new MainMenuItemCollection();
            MainMenuItemInfo info = null;
            Set functionSet = null;
            IRowSet rowset = this._getSubSys(ctx);
            functionSet = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissions();
            String longNumber = null;
            IRowSet leafRowset = null;
            String function = null;
            block2: while (rowset.next()) {
                longNumber = rowset.getString("FLongNumber");
                leafRowset = this._getAllLeafByParent(ctx, longNumber);
                while (leafRowset.next()) {
                    function = leafRowset.getString("FFunction");
                    if (!StringUtils.isEmpty((String)function) && !functionSet.contains(function)) continue;
                    info = new MainMenuItemInfo();
                    info.setId(BOSUuid.read((String)rowset.getString(1)));
                    info.setName(rowset.getString(2));
                    info.setLongNumber(rowset.getString(3));
                    info.setImagePath(rowset.getString(4));
                    cols.add(info);
                    continue block2;
                }
            }
            return cols;
        }
        catch (SQLException ex) {
            this.logger.error((Object)("database exception" + UIFrameUtils.getRes("res_1") + ex.getMessage()));
            throw new MenuEditException(MenuEditException.BUILDSYSMENUEXCEPTION, ex);
        }
    }

    @Override
    protected boolean _isNumberRepeat(Context ctx, String number, String id, String[] changeedMenusID) throws BOSException, EASBizException {
        boolean flag = false;
        if (number != null && number.trim().length() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            if (null != id && id.trim().length() > 0) {
                idList.add(id);
            }
            if (null != changeedMenusID && 0 < changeedMenusID.length) {
                for (int i = 0; i < changeedMenusID.length; ++i) {
                    idList.add(changeedMenusID[i]);
                }
            }
            Object[] params = new Object[idList.size() + 1];
            params[0] = number;
            StringBuffer sqlBuff = new StringBuffer("select count(FID) from T_BAS_SysMenuItem where FNumber = ?").append("\r\n");
            if (idList.size() > 0) {
                sqlBuff.append("and FID not in(");
                int j = idList.size();
                for (int i = 0; i < j; ++i) {
                    if (i > 0) {
                        sqlBuff.append(',');
                    }
                    sqlBuff.append("?");
                    params[i + 1] = idList.get(i);
                }
                sqlBuff.append(")");
            }
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params);
            try {
                int i;
                if (null != rowset && rowset.next() && (i = rowset.getInt(1)) != 0) {
                    flag = true;
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)("database exception" + UIFrameUtils.getRes("res_1") + ex.getMessage()));
                throw new MenuEditException(MenuEditException.CHECKNUMBEREXCEPTION, ex);
            }
        }
        return flag;
    }

    @Override
    protected boolean _isShortCodeRepeat(Context ctx, String shortCode, String id, String[] changeedMenusID) throws BOSException, EASBizException {
        boolean flag = false;
        if (shortCode != null && shortCode.trim().length() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            if (null != id && id.trim().length() > 0) {
                idList.add(id);
            }
            if (null != changeedMenusID && 0 < changeedMenusID.length) {
                for (int i = 0; i < changeedMenusID.length; ++i) {
                    idList.add(changeedMenusID[i]);
                }
            }
            Object[] params = new Object[idList.size() + 1];
            params[0] = shortCode;
            StringBuffer sqlBuff = new StringBuffer("select count(FID) from T_BAS_SysMenuItem where FShortcutCode = ?").append("\r\n");
            if (idList.size() > 0) {
                sqlBuff.append("and FID not in(");
                int j = idList.size();
                for (int i = 0; i < j; ++i) {
                    if (i > 0) {
                        sqlBuff.append(',');
                    }
                    sqlBuff.append("?");
                    params[i + 1] = idList.get(i);
                }
                sqlBuff.append(")");
            }
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params);
            try {
                int i;
                if (null != rowset && rowset.next() && (i = rowset.getInt(1)) != 0) {
                    flag = true;
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)("database exception" + UIFrameUtils.getRes("res_1") + ex.getMessage()));
                throw new MenuEditException(MenuEditException.CHECKSHORTCUTCODEEXCEPTION, ex);
            }
        }
        return flag;
    }

    @Override
    protected MainFunctionInfo _getInitMenuData(Context ctx) throws BOSException, EASBizException {
        MainFunctionInfo fInfo = new MainFunctionInfo();
        HashMap<String, ArrayList> subItemMap = new HashMap<String, ArrayList>();
        try {
            MainMenuItemCollection cols = new MainMenuItemCollection();
            MainMenuItemInfo info = null;
            Set functionSet = null;
            functionSet = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissions();
            String longNumber = null;
            IRowSet leafRowset = null;
            String function = null;
            IRowSet rowset = this._getSubSys(ctx);
            block2: while (rowset.next()) {
                longNumber = rowset.getString("FLongNumber");
                leafRowset = this._getAllLeafByParent(ctx, longNumber);
                while (leafRowset.next()) {
                    function = leafRowset.getString("FFunction");
                    if (!StringUtils.isEmpty((String)function) && !functionSet.contains(function)) continue;
                    info = new MainMenuItemInfo();
                    info.setId(BOSUuid.read((String)rowset.getString("FID")));
                    info.setName(rowset.getString(2));
                    info.setLongNumber(rowset.getString("FLongNumber"));
                    info.setImagePath(rowset.getString("FImagePath"));
                    info.setVisible(rowset.getInt("FVisible") != 0);
                    SysMenuFacadeControllerBean.setMultiLangValue(ctx, info, rowset);
                    cols.add(info);
                    subItemMap.put(longNumber, this.getOneSubItemList(ctx, longNumber, functionSet));
                    continue block2;
                }
            }
            fInfo.setTopLeverMenuCollection(cols);
            fInfo.setSubItemMap(subItemMap);
            return fInfo;
        }
        catch (SQLException ex) {
            this.logger.error((Object)("database exception" + UIFrameUtils.getRes("res_1") + ex.getMessage()));
            throw new MenuEditException(MenuEditException.GETINITMENUDATAEXCEPTION, ex);
        }
    }

    private ArrayList getOneSubItemList(Context ctx, String longNumber, Set functionSet) throws EASBizException, BOSException, SQLException {
        ArrayList<MainMenuItemInfo> list = new ArrayList<MainMenuItemInfo>();
        IRowSet rowset = this.getMenuByParent(ctx, longNumber);
        MainMenuItemInfo menuItemInfo = null;
        MainMenuItemInfo parentItemInfo = null;
        while (rowset.next()) {
            if (rowset.getInt("FIsLeaf") == 1 && !StringUtils.isEmpty((String)rowset.getString("FFunction")) && !functionSet.contains(rowset.getString("FFunction"))) continue;
            menuItemInfo = new MainMenuItemInfo();
            menuItemInfo.setId(BOSUuid.read((String)rowset.getString("FID")));
            SysMenuFacadeControllerBean.setMultiLangValue(ctx, menuItemInfo, rowset);
            menuItemInfo.setNumber(rowset.getString("FNumber"));
            menuItemInfo.setLongNumber(rowset.getString("FLongNumber"));
            if (rowset.getString("FParent") != null) {
                parentItemInfo = new MainMenuItemInfo();
                parentItemInfo.setId(BOSUuid.read((String)rowset.getString("FParent")));
                menuItemInfo.setParent(parentItemInfo);
            } else {
                menuItemInfo.setParent(null);
            }
            menuItemInfo.setLevel(rowset.getInt("FLevel"));
            menuItemInfo.setIsLeaf(rowset.getInt("FIsLeaf") != 0);
            menuItemInfo.setOrder(rowset.getString("FOrder"));
            menuItemInfo.setImagePath(rowset.getString("FImagePath"));
            menuItemInfo.setEnabled(rowset.getInt("FEnabled") != 0);
            menuItemInfo.setVisible(rowset.getInt("FVisible") != 0);
            menuItemInfo.setUiClassName(rowset.getString("FUiClassName"));
            menuItemInfo.setUiClassParam(rowset.getString("FUiClassParam"));
            menuItemInfo.setUiOprt(rowset.getString("FUiOprt"));
            menuItemInfo.setOpenMethod(OpenMethod.getEnum(rowset.getInt("FOpenMethod")));
            menuItemInfo.setShortcutCode(rowset.getString("FShortcutCode"));
            list.add(menuItemInfo);
        }
        return list;
    }

    private static void setMultiLangValue(Context ctx, MainMenuItemInfo menuItem, IRowSet rowset) throws SQLException {
        for (int i = 0; i < locales.length; ++i) {
            Locale locale = locales[i];
            String name = rowset.getString("FName_" + locale.toString());
            menuItem.setName(name, locale);
            String description = rowset.getString("FDescription_" + locale.toString());
            menuItem.setDescription(description, locale);
            if (!locale.equals(ctx.getLocale())) continue;
            menuItem.setName(name);
            menuItem.setDescription(description);
        }
    }

    @Override
    protected void _saveAllMenus(Context ctx, HashMap menuCollection) throws BOSException, EASBizException {
        if (menuCollection.size() > 0) {
            int addMenuSize;
            int updatedMenuSize;
            int i;
            int delMenuSize;
            ISysMenuItem iMenu = SysMenuItemFactory.getLocalInstance(ctx);
            this.sortMenuInfoByType(menuCollection);
            int n = delMenuSize = null != this.delMenus ? this.delMenus.length : 0;
            if (delMenuSize > 0) {
                Object[] params = null;
                String updateSql = "update T_PM_MainMenuItem set FSysMenuID = NULL where FSysMenuID = ?";
                for (i = delMenuSize - 1; i >= 0; --i) {
                    iMenu.delete((IObjectPK)new ObjectUuidPK(this.delMenus[i].getMenuInfo().getId()));
                    params = new Object[]{this.delMenus[i].getMenuInfo().getId().toString().trim()};
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
                }
            }
            int n2 = updatedMenuSize = null != this.updatedMenus ? this.updatedMenus.length : 0;
            if (updatedMenuSize > 0) {
                for (int i2 = 0; i2 < updatedMenuSize; ++i2) {
                    iMenu.update((IObjectPK)new ObjectUuidPK(this.updatedMenus[i2].getMenuInfo().getId()), (CoreBaseInfo)((SysMenuItemInfo)this.updatedMenus[i2].getMenuInfo()));
                }
            }
            int n3 = addMenuSize = null != this.addMenus ? this.addMenus.length : 0;
            if (addMenuSize > 0) {
                for (i = 0; i < addMenuSize; ++i) {
                    iMenu.addnew((CoreBaseInfo)this.addMenus[i].getMenuInfo());
                }
            }
            IMainFunctionMenu menuFun = MainFunctionMenuFactory.getLocalInstance(ctx);
            menuFun.updateMenuCache(null);
        }
    }

    private void sortMenuInfoByType(HashMap menuCollection) {
        int delMenuSize;
        int updateMenuSize;
        int addMenuSize;
        int i;
        ArrayList<Object> addMenuList = new ArrayList<Object>();
        ArrayList<Object> updateMenuList = new ArrayList<Object>();
        ArrayList<Object> delMenuList = new ArrayList<Object>();
        int mapSize = menuCollection.size();
        if (mapSize > 0) {
            String[] mapKeys = new String[mapSize];
            menuCollection.keySet().toArray(mapKeys);
            MenuInfo tempEditInfo = null;
            for (i = 0; i < mapSize; ++i) {
                tempEditInfo = (MenuInfo)menuCollection.get(mapKeys[i]);
                if (3 == tempEditInfo.getOperationsType()) {
                    addMenuList.add(tempEditInfo.getMenuInfo());
                    continue;
                }
                if (1 == tempEditInfo.getOperationsType()) {
                    updateMenuList.add(tempEditInfo.getMenuInfo());
                    continue;
                }
                if (4 != tempEditInfo.getOperationsType()) continue;
                delMenuList.add(tempEditInfo.getMenuInfo());
            }
        }
        if ((addMenuSize = addMenuList.size()) > 0) {
            this.addMenus = new LongNumberComparator[addMenuSize];
            for (int i2 = 0; i2 < addMenuSize; ++i2) {
                this.addMenus[i2] = new LongNumberComparator((SysMenuItemInfo)addMenuList.get(i2));
            }
            Arrays.sort(this.addMenus);
        }
        if ((updateMenuSize = updateMenuList.size()) > 0) {
            this.updatedMenus = new LongNumberComparator[updateMenuSize];
            for (i = 0; i < updateMenuSize; ++i) {
                this.updatedMenus[i] = new LongNumberComparator((SysMenuItemInfo)updateMenuList.get(i));
            }
            Arrays.sort(this.updatedMenus);
        }
        if ((delMenuSize = delMenuList.size()) > 0) {
            this.delMenus = new LongNumberComparator[delMenuSize];
            for (int i3 = 0; i3 < delMenuSize; ++i3) {
                this.delMenus[i3] = new LongNumberComparator((SysMenuItemInfo)delMenuList.get(i3));
            }
            Arrays.sort(this.delMenus);
        }
    }

    @Override
    protected IRowSet _getMenuByParentForCust(Context ctx, String parentLN) throws BOSException {
        String childrenLN = parentLN + "!%";
        Object[] params = new Object[]{parentLN, childrenLN};
        StringBuffer buff = new StringBuffer();
        buff.append("select distinct t.FID,");
        buff.append("t.FCreatorID,");
        buff.append("t.FCreateTime,");
        buff.append("t.FLastUpdateUserID,");
        buff.append("t.FLastUpdateTime,");
        buff.append("t.FControlUnitID,");
        buff.append("t.FName_L1,");
        buff.append("t.FShortcutCode,");
        buff.append("t.FName_L2,");
        buff.append("t.FName_L3,");
        buff.append("t.FNumber,");
        buff.append("t.FDescription_L1,");
        buff.append("t.FDescription_L2,");
        buff.append("t.FDescription_L3,");
        buff.append("t.FSimpleName,");
        buff.append("t.FIsLeaf,");
        buff.append("t.FLevel,");
        buff.append("t.FLongNumber,");
        buff.append("t.FDisplayName_L1,");
        buff.append("t.FDisplayName_L2,");
        buff.append("t.FDisplayName_L3,");
        buff.append("t.FOrder,");
        buff.append("t.FImagePath,");
        buff.append("t.FVisible,");
        buff.append("t.FEnabled,");
        buff.append("t.FUiClassName,");
        buff.append("t.FUiClassParam,");
        buff.append("t.FUiOprt,");
        buff.append("t.FOpenMethod,");
        buff.append("t.FIsReport,");
        buff.append("t.FParent,");
        buff.append("t.FFunction,");
        buff.append("t.FIndustry,");
        buff.append("t.FNoSuit,");
        buff.append("t1.FSysMenuID").append("\r\n");
        buff.append("from T_BAS_SysMenuItem t").append("\r\n");
        buff.append("left outer join T_PM_MainMenuItem t1 on t.FID = t1.FSysMenuID").append("\r\n");
        buff.append("where (t.FLongNumber = ? or t.FLongNumber like ?) and (t.FMenutype is null or t.FMenutype=10) order by t.FLongNumber , t.FOrder");
        return DbUtil.executeQuery((Context)ctx, (String)buff.toString(), (Object[])params);
    }

    @Override
    protected IRowSet _getMenuByParentForCust(Context ctx, String parentLN, String industryType) throws BOSException, EASBizException {
        String childrenLN = parentLN + "!%";
        Object[] params = new Object[]{parentLN, childrenLN};
        StringBuffer buff = new StringBuffer();
        buff.append("select distinct t.FID,");
        buff.append("t.FCreatorID,");
        buff.append("t.FCreateTime,");
        buff.append("t.FLastUpdateUserID,");
        buff.append("t.FLastUpdateTime,");
        buff.append("t.FControlUnitID,");
        buff.append("t.FName_L1,");
        buff.append("t.FShortcutCode,");
        buff.append("t.FName_L2,");
        buff.append("t.FName_L3,");
        buff.append("t.FNumber,");
        buff.append("t.FDescription_L1,");
        buff.append("t.FDescription_L2,");
        buff.append("t.FDescription_L3,");
        buff.append("t.FSimpleName,");
        buff.append("t.FIsLeaf,");
        buff.append("t.FLevel,");
        buff.append("t.FLongNumber,");
        buff.append("t.FDisplayName_L1,");
        buff.append("t.FDisplayName_L2,");
        buff.append("t.FDisplayName_L3,");
        buff.append("t.FOrder,");
        buff.append("t.FImagePath,");
        buff.append("t.FVisible,");
        buff.append("t.FEnabled,");
        buff.append("t.FUiClassName,");
        buff.append("t.FUiClassParam,");
        buff.append("t.FUiOprt,");
        buff.append("t.FOpenMethod,");
        buff.append("t.FIsReport,");
        buff.append("t.FParent,");
        buff.append("t.FFunction,");
        buff.append("t.FIndustry,");
        buff.append("t.FNoSuit,");
        buff.append("t1.FSysMenuID").append("\r\n");
        buff.append("from T_BAS_SysMenuItem t").append("\r\n");
        buff.append("left outer join T_PM_MainMenuItem t1 on t.FID = t1.FSysMenuID").append("\r\n");
        buff.append("where (t.FLongNumber = ? or t.FLongNumber like ? ) and (t.FMenutype is null or t.FMenutype=10) and (" + this.getIndustrySql(industryType) + ") order by t.FLongNumber , t.FOrder");
        return DbUtil.executeQuery((Context)ctx, (String)buff.toString(), (Object[])params);
    }

    @Override
    protected IRowSet _getMenuByParentForCust(Context ctx, String parentLN, String industryType, String menutype) throws BOSException, EASBizException {
        String industrysql;
        String childrenLN = parentLN + "!%";
        Object[] params = new Object[]{parentLN, childrenLN};
        StringBuffer buff = new StringBuffer();
        buff.append("select distinct t.FID,");
        buff.append("t.FCreatorID,");
        buff.append("t.FCreateTime,");
        buff.append("t.FLastUpdateUserID,");
        buff.append("t.FLastUpdateTime,");
        buff.append("t.FControlUnitID,");
        buff.append("t.FName_L1,");
        buff.append("t.FShortcutCode,");
        buff.append("t.FName_L2,");
        buff.append("t.FName_L3,");
        buff.append("t.FNumber,");
        buff.append("t.FDescription_L1,");
        buff.append("t.FDescription_L2,");
        buff.append("t.FDescription_L3,");
        buff.append("t.FSimpleName,");
        buff.append("t.FIsLeaf,");
        buff.append("t.FLevel,");
        buff.append("t.FLongNumber,");
        buff.append("t.FDisplayName_L1,");
        buff.append("t.FDisplayName_L2,");
        buff.append("t.FDisplayName_L3,");
        buff.append("t.FOrder,");
        buff.append("t.FImagePath,");
        buff.append("t.FVisible,");
        buff.append("t.FEnabled,");
        buff.append("t.FUiClassName,");
        buff.append("t.FUiClassParam,");
        buff.append("t.FUiOprt,");
        buff.append("t.FOpenMethod,");
        buff.append("t.FIsReport,");
        buff.append("t.FParent,");
        buff.append("t.FFunction,");
        buff.append("t.FIndustry,");
        buff.append("t.FNoSuit,");
        buff.append("t.FMenutype,");
        buff.append("t1.FSysMenuID").append("\r\n");
        buff.append("from T_BAS_SysMenuItem t").append("\r\n");
        buff.append("left outer join T_PM_MainMenuItem t1 on t.FID = t1.FSysMenuID").append("\r\n");
        buff.append("where (t.FLongNumber = ? or t.FLongNumber like ? ) ");
        if (null != menutype && "5".equals(menutype)) {
            buff.append(" and t.FMenutype=").append(menutype);
        }
        if (null != menutype && !"5".equals(menutype)) {
            buff.append(" and (t.FMenutype is null or t.FMenutype=10)");
        }
        if (null != industryType && !"".equals(industryType) && (industrysql = this.getIndustrySql(industryType)).length() > 0) {
            buff.append(" and (");
            buff.append(industrysql);
            buff.append(" )");
        }
        buff.append(" order by t.FLongNumber , t.FOrder");
        return DbUtil.executeQuery((Context)ctx, (String)buff.toString(), (Object[])params);
    }

    private String getIndustrySql(String industryType) {
        String[] industryArray = industryType.split(";");
        StringBuffer bf = new StringBuffer();
        if (industryArray != null && industryArray.length >= 1) {
            for (int i = 0; i < industryArray.length; ++i) {
                if (i > 0) {
                    bf.append(" or ");
                }
                if (industryArray[i].equals("0")) {
                    bf.append("(t.FIndustry = 0 )");
                    continue;
                }
                bf.append("((");
                bf.append(" t.FIndustry=");
                bf.append(industryArray[i]);
                bf.append(")");
                bf.append("or");
                bf.append("(t.FIndustry=0 and ( t.FNoSuit not like '%");
                bf.append(industryArray[i]);
                bf.append("%'");
                bf.append(" or t.FNoSuit is null )))");
            }
        }
        return bf.toString();
    }

    @Override
    protected IRowSet _getMenuByParentForCust(Context ctx, String parentLN, int industryType) throws BOSException {
        String childrenLN = parentLN + "!%";
        String industryLike = "%" + industryType + "%";
        Object[] params = new Object[]{parentLN, childrenLN, new Integer(industryType), industryLike};
        StringBuffer buff = new StringBuffer();
        buff.append("select distinct t.FID,");
        buff.append("t.FCreatorID,");
        buff.append("t.FCreateTime,");
        buff.append("t.FLastUpdateUserID,");
        buff.append("t.FLastUpdateTime,");
        buff.append("t.FControlUnitID,");
        buff.append("t.FName_L1,");
        buff.append("t.FShortcutCode,");
        buff.append("t.FName_L2,");
        buff.append("t.FName_L3,");
        buff.append("t.FNumber,");
        buff.append("t.FDescription_L1,");
        buff.append("t.FDescription_L2,");
        buff.append("t.FDescription_L3,");
        buff.append("t.FSimpleName,");
        buff.append("t.FIsLeaf,");
        buff.append("t.FLevel,");
        buff.append("t.FLongNumber,");
        buff.append("t.FDisplayName_L1,");
        buff.append("t.FDisplayName_L2,");
        buff.append("t.FDisplayName_L3,");
        buff.append("t.FOrder,");
        buff.append("t.FImagePath,");
        buff.append("t.FVisible,");
        buff.append("t.FEnabled,");
        buff.append("t.FUiClassName,");
        buff.append("t.FUiClassParam,");
        buff.append("t.FUiOprt,");
        buff.append("t.FOpenMethod,");
        buff.append("t.FIsReport,");
        buff.append("t.FParent,");
        buff.append("t.FFunction,");
        buff.append("t.FIndustry,");
        buff.append("t.FNoSuit,");
        buff.append("t1.FSysMenuID").append("\r\n");
        buff.append("from T_BAS_SysMenuItem t").append("\r\n");
        buff.append("left outer join T_PM_MainMenuItem t1 on t.FID = t1.FSysMenuID").append("\r\n");
        buff.append("where (t.FLongNumber = ? or t.FLongNumber like ? ) and (t.FIndustry = ? or (t.FIndustry =0 and (t.FNoSuit not like ? or t.FNoSuit is null )) )order by t.FLongNumber , t.FOrder");
        return DbUtil.executeQuery((Context)ctx, (String)buff.toString(), (Object[])params);
    }

    @Override
    protected void _removeImportMenus(Context ctx, String menuLNum) throws BOSException, EASBizException {
        String updateSql = "update T_PM_MainMenuItem set FSysMenuID = NULL where FLongNumber = ? or FLongNumber like ?";
        Object[] params = new Object[]{menuLNum, menuLNum + "!%"};
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
    }

    @Override
    protected void _deleteSysMenu(Context ctx, String sysMenuID, String parentID) throws BOSException, EASBizException {
        try {
            Object[] params = new Object[]{sysMenuID};
            String delSql = "delete from T_BAS_SysMenuItem where FID = ?";
            DbUtil.execute((Context)ctx, (String)delSql, (Object[])params);
            if (null != parentID && parentID.trim().length() > 0) {
                params = new Object[]{parentID};
                String selectSql = "select count(FID) as subCnt from T_BAS_SysMenuItem where FParent = ?";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])params);
                int subCnt = 0;
                if (null != rowSet && rowSet.next()) {
                    subCnt = rowSet.getInt("subCnt");
                }
                if (subCnt < 1) {
                    String updateSql = "update T_BAS_SysMenuItem set FIsLeaf = 1 where FID = ?";
                    params = new Object[]{parentID};
                    DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
                }
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)("database exception" + UIFrameUtils.getRes("res_1") + ex.getMessage()));
            throw new MenuEditException(MenuEditException.DELSYSMENUEXCEPTION, ex);
        }
    }

    @Override
    protected IRowSet _getMenuByParentForMenuType(Context ctx, String parentLN, String menutype) throws BOSException, EASBizException {
        String childrenLN = parentLN + "!%";
        Object[] params = new Object[]{parentLN, childrenLN};
        StringBuffer bf = new StringBuffer();
        bf.append("select * from T_BAS_SysMenuItem where (FLongNumber = ? or FLongNumber like ?)");
        if (null != menutype && !"".equals(menutype)) {
            if ("10".equals(menutype)) {
                bf.append(" and ( FMenutype= 10").append("or FMenutype is null").append(")");
            } else {
                bf.append(" and ( FMenutype=").append(menutype).append(")");
            }
        }
        bf.append(" order by FLongNumber , FOrder");
        return DbUtil.executeQuery((Context)ctx, (String)bf.toString(), (Object[])params);
    }

    @Override
    protected IRowSet _getSubSysForMenuType(Context ctx, String menutype) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("select FID,FName_L1,FName_L2,FName_L3,FDescription_L1,FDescription_L2,FDescription_L3,FLongNumber,FImagePath,FIsReport,FVisible,FIndustry,FNoSuit,FMenutype from T_BAS_SysMenuItem where FParent is NULL");
        if (null != menutype && !"".equals(menutype)) {
            if ("10".equals(menutype)) {
                bf.append(" and ( FMenutype= 10").append("or FMenutype is null").append(")");
            } else {
                bf.append(" and ( FMenutype=").append(menutype).append(")");
            }
        }
        bf.append(" order by FOrder");
        return DbUtil.executeQuery((Context)ctx, (String)bf.toString());
    }

    @Override
    protected IRowSet _getAllMenuTree(Context ctx, BizTypeEnum menuType, String industry) throws BOSException, EASBizException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuffer selectors = new StringBuffer();
        selectors.append(" t.FID,t.FName_").append(ctx.getLocale().toString()).append(",t.FNumber,t.FShortcutCode,t.FParent,t.FIsLeaf,t.FLongNumber,t.FOrder,t.FEnabled,t1.FSysMenuID");
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(selectors).append(" from T_BAS_SysMenuItem t ").append(" LEFT OUTER JOIN T_PM_MainMenuItem t1 on t.FID = t1.FSysMenuID ");
        if (menuType == BizTypeEnum.guimenu) {
            sql.append("where (t.FMenutype is null or t.FMenutype = ?)");
        } else {
            sql.append("where (t.FMenutype = ?)");
        }
        paramList.add(new Integer(menuType.getValue()));
        if (!StringUtils.isEmpty((String)industry)) {
            sql.append("and (");
            String[] industryArray = industry.split(";");
            for (int i = 0; i < industryArray.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                if (industryArray[i].equals(Integer.toString(0))) {
                    sql.append("(t.FIndustry = ? )");
                    paramList.add(0);
                    continue;
                }
                sql.append("((").append(" t.FIndustry = ? ) or (t.FIndustry = ? and ( t.FNoSuit not like ? or t.FNoSuit is null)))");
                paramList.add(Integer.parseInt(industryArray[i]));
                paramList.add(0);
                paramList.add("'%" + industryArray[i] + "%'");
            }
            sql.append(")");
        }
        try {
            EASCloudEnum easCloudEnum = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getRemoteEASCloudVersion();
            LicenseType licenseTypeVisiable = null;
            LicenseType licenseTypeMop = null;
            if (easCloudEnum != null) {
                if (EASCloudEnum.CLOUD_PUBLIC.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.PublicCloudVisible;
                    licenseTypeMop = LicenseType.PublicCloudMonopolize;
                } else if (EASCloudEnum.CLOUD_PRIVATE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.PrivateCloudVisible;
                    licenseTypeMop = LicenseType.PrivateCloudMonopolize;
                } else if (EASCloudEnum.CLOUD_HYBRID.toString().equalsIgnoreCase(easCloudEnum.toString()) || EASCloudEnum.CLOUD_HYBRID_SIMPLE.toString().equalsIgnoreCase(easCloudEnum.toString())) {
                    licenseTypeVisiable = LicenseType.HyBridCloudVisible;
                    licenseTypeMop = LicenseType.HyBridCloudMonopolize;
                }
                sql.append(" and (t.FLicenseType =").append(0);
                if (licenseTypeMop != null) {
                    sql.append(" or t.FLicenseType =").append(licenseTypeMop.getValue());
                }
                if (licenseTypeVisiable != null) {
                    sql.append(" or t.FLicenseType >=").append(licenseTypeVisiable.getValue()).append(")");
                }
            }
        }
        catch (LicenseException e) {
            throw new BOSException((Throwable)e);
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
    }

    @Override
    protected IRowSet _getSysMenuByID(Context ctx, String menuID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)menuID)) {
            return null;
        }
        StringBuffer selectors = new StringBuffer();
        selectors.append(" t.FID,t.FName_L1,t.FName_L2,t.FName_L3,t.FDescription_L1,t.FDescription_L2,t.FDescription_L3,").append("t.FNumber,t.FParent,t.FLevel,t.FIsLeaf,t.FOrder,t.FEnabled,t.FUiClassName,t.FUiClassParam,t.FUiOprt,t.FLongNumber,").append("t.FOpenMethod,t.FShortcutCode,t.FFunction,t.FImagePath,t.FIsReport,t.FVisible,t.FIndustry,t.FNoSuit,t1.FSysMenuID  ");
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(selectors).append("from T_BAS_SysMenuItem t ").append(" LEFT OUTER JOIN T_PM_MainMenuItem t1 on t.FID = t1.FSysMenuID where t.FID = ? ");
        Object[] params = new Object[]{menuID};
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
    }
}

