/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.patch.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.uiframe.patch.PatchInfo;
import com.kingdee.eas.base.uiframe.patch.service.AES;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.DateTimeUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class LocalPatchInfo {
    private URLClassLoader loader = null;
    Object patchService;
    Method getPatchList;
    Method getPatchName;
    Method getModuleName;
    Method getApplyVersion;
    Method getApplyScope;
    Method getInstallDate;
    Method getIssueDate;
    Method getDependRelation;
    Method getIsInstall;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, PatchInfo>> getLocalPatchMap(Context ctx, boolean onlyInstalled) throws BOSException {
        HashMap<String, Map<String, PatchInfo>> versionMap = new HashMap<String, Map<String, PatchInfo>>();
        HashMap patchMap = new HashMap();
        ArrayList rstlst = new ArrayList();
        try {
            this.loadClasses();
            ArrayList patchList = (ArrayList)this.getPatchList.invoke(this.patchService, new Object[0]);
            System.out.println("console\u63a5\u53e3\u8c03\u7528\u6210\u529f");
            if (patchList != null) {
                System.out.println("PatchListSize:" + patchList.size());
            }
            if (patchList != null) {
                HashMap map = (HashMap)patchList.get(0);
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object info = map.get(iterator.next().toString());
                    Boolean b = (Boolean)this.getIsInstall.invoke(info, new Object[0]);
                    String module = (String)this.getModuleName.invoke(info, new Object[0]);
                    String issueDate = String.valueOf(this.getIssueDate.invoke(info, new Object[0]));
                    String applyversion = String.valueOf(this.getApplyVersion.invoke(info, new Object[0]));
                    if (onlyInstalled && b != null && Boolean.FALSE.equals(b) || module == null) continue;
                    HashMap<String, PatchInfo> patchInfoMap = (HashMap<String, PatchInfo>)versionMap.get(applyversion);
                    PatchInfo patchInfo = null;
                    if (patchInfoMap != null) {
                        patchInfo = (PatchInfo)patchInfoMap.get(module);
                        if (issueDate != null && patchInfo != null && patchInfo.getIssueDate() != null && issueDate.compareTo(DateTimeUtils.formatDate((Date)patchInfo.getIssueDate())) <= 0) {
                            continue;
                        }
                    } else {
                        patchInfoMap = new HashMap<String, PatchInfo>();
                    }
                    patchInfo = new PatchInfo();
                    patchInfo.setModuleName(module);
                    patchInfo.setPatchName(String.valueOf(this.getPatchName.invoke(info, new Object[0])));
                    patchInfo.setInstalled(Boolean.valueOf(((Object)b).toString()));
                    patchInfo.setIssueDate(DateTimeUtils.parseDate((String)String.valueOf(this.getIssueDate.invoke(info, new Object[0]))));
                    patchInfo.setDependRelation(String.valueOf(this.getDependRelation.invoke(info, new Object[0])));
                    patchInfo.setApplyScope(String.valueOf(this.getApplyScope.invoke(info, new Object[0])));
                    patchInfo.setApplyVersion(String.valueOf(this.getApplyVersion.invoke(info, new Object[0])));
                    patchInfoMap.put(module, patchInfo);
                    versionMap.put(applyversion, patchInfoMap);
                }
            }
        }
        catch (Exception e) {
            System.out.println("console\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
            String driver = "org.apache.derby.jdbc.EmbeddedDriver";
            String EASHome = System.getProperty("EAS_HOME");
            String url = "jdbc:derby:" + EASHome + "/admin/consoledb;";
            String sql3 = "select isInstall,modulename,patchname,applyversion,applyscope,installdate,issuedate,dependrelation from jta.patch_info order by modulename,installdate desc";
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                patchMap.clear();
                Class.forName(driver).newInstance();
                String encodePwd = "";
                String pwd = "";
                try {
                    encodePwd = LocalPatchInfo.getSystemParam(ctx, "ConsolePwd");
                    pwd = AES.aesDecryptGCM(encodePwd);
                    conn = DriverManager.getConnection(url + "user=jta;password=" + pwd);
                }
                catch (Exception se) {
                    encodePwd = LocalPatchInfo.getSystemParam(ctx, "ConsoleAlternatePwd");
                    pwd = AES.aesDecryptGCM(encodePwd);
                    conn = DriverManager.getConnection(url + "user=jta;password=" + pwd);
                }
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql3);
                System.out.println("\u8bfb\u53d6\u8865\u4e01\u5e93");
                Object patchVOMap = null;
                while (rs.next()) {
                    Boolean b = rs.getBoolean("isInstall");
                    String module = rs.getString("modulename");
                    String issueDate = rs.getString("issuedate");
                    String applyversion = rs.getString("applyversion");
                    if (onlyInstalled && !b.booleanValue() || module == null) continue;
                    HashMap<String, PatchInfo> patchInfoMap = (HashMap<String, PatchInfo>)versionMap.get(applyversion);
                    PatchInfo patchInfo = null;
                    if (patchInfoMap != null) {
                        patchInfo = (PatchInfo)patchInfoMap.get(module);
                        if (issueDate != null && patchInfo != null && patchInfo.getIssueDate() != null && issueDate.compareTo(DateTimeUtils.formatDate((Date)patchInfo.getIssueDate())) <= 0) {
                            continue;
                        }
                    } else {
                        patchInfoMap = new HashMap<String, PatchInfo>();
                    }
                    patchInfo = new PatchInfo();
                    patchInfo.setModuleName(module);
                    patchInfo.setPatchName(rs.getString("patchname"));
                    patchInfo.setInstalled(Boolean.valueOf(b.toString()));
                    patchInfo.setIssueDate(DateTimeUtils.parseDate((String)issueDate));
                    patchInfo.setDependRelation(rs.getString("dependrelation"));
                    patchInfo.setApplyScope(rs.getString("applyscope"));
                    patchInfo.setApplyVersion(applyversion);
                    patchInfoMap.put(module, patchInfo);
                    versionMap.put(applyversion, patchInfoMap);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                throw new BOSException("\u8bfb\u53d6\u63a7\u5236\u53f0\u6570\u636e\u5e93\u5931\u8d25\uff01");
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                        rs = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                        stmt = null;
                    }
                    catch (SQLException sQLException) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (SQLException sQLException) {}
                }
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (Exception eee) {
                    System.out.println("\u91ca\u653eDerby\u8fde\u63a5");
                    System.out.println(eee.getMessage());
                }
            }
        }
        finally {
            if (this.loader != null) {
                try {
                    this.loader.close();
                }
                catch (IOException iOException) {}
            }
            this.getPatchList = null;
        }
        System.out.println("\u83b7\u53d6\u63a7\u5236\u53f0\u8865\u4e01\u5217\u8868\u6210\u529f");
        System.out.println(versionMap);
        this.updateForPTMPatch(versionMap);
        System.out.println("\u5904\u7406PTM\u8865\u4e01\u540e\u7684\u8865\u4e01\u5217\u8868\uff1a");
        System.out.println(versionMap);
        return versionMap;
    }

    private void loadClasses() throws MalformedURLException, URISyntaxException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, DocumentException, IllegalAccessException {
        if (this.getPatchList == null) {
            String home = System.getProperty("EAS_HOME");
            String adminhome = home + "/admin/plugins/";
            String filePath = adminhome + "admin.domain_1.0.0.jar";
            File file = new File(filePath);
            URL[] urls = new URL[3];
            if (file.exists()) {
                urls[0] = file.toURI().toURL();
            }
            if ((file = new File(filePath = adminhome + "admin.framework_1.0.0.jar")).exists()) {
                urls[1] = file.toURI().toURL();
            }
            String jdomPath = home + "/admin/lib/ext/jdom-b9.jar";
            file = new File(jdomPath);
            urls[2] = file.toURI().toURL();
            this.loader = new URLClassLoader(urls);
            String srvcfgFile = home + "/admin/config/server_app.xml";
            String port = "10061";
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(srvcfgFile));
            Node node = document.selectSingleNode("/application/preference/preference/preference/port");
            if (node != null && node.getText() != null) {
                port = node.getText().trim();
                System.out.println("dualrpc port:" + port);
            }
            URI ssapServerURL = new URI("drpc://localhost:" + port);
            Class<?> serviceAccessorClass = this.loader.loadClass("com.kingdee.eas.tools.admin.framework.ssap.ServiceAccessor");
            Class<?> sessionlistener = this.loader.loadClass("com.kingdee.eas.tools.admin.framework.ssap.SessionListener");
            Class<?> vo = this.loader.loadClass("com.kingdee.eas.tools.admin.domain.patch.vo.VoEASPatchInfo");
            Method getinst = serviceAccessorClass.getMethod("getInstance", String.class, sessionlistener);
            Object defaultServiceAccessor = getinst.invoke(null, ssapServerURL.toString(), null);
            Method lookup = defaultServiceAccessor.getClass().getMethod("lookup", Class.class);
            this.patchService = lookup.invoke(defaultServiceAccessor, this.loader.loadClass("com.kingdee.eas.tools.admin.domain.PatchManagerService"));
            this.getPatchList = this.patchService.getClass().getMethod("getPatchList", new Class[0]);
            this.getPatchName = vo.getMethod("getPatchName", new Class[0]);
            this.getModuleName = vo.getMethod("getModuleName", new Class[0]);
            this.getApplyVersion = vo.getMethod("getApplyVersion", new Class[0]);
            this.getApplyScope = vo.getMethod("getApplyScope", new Class[0]);
            this.getInstallDate = vo.getMethod("getInstallDate", new Class[0]);
            this.getIssueDate = vo.getMethod("getIssueDate", new Class[0]);
            this.getDependRelation = vo.getMethod("getDependRelation", new Class[0]);
            this.getIsInstall = vo.getMethod("getIsInstall", new Class[0]);
        }
    }

    public static String getSystemParam(Context ctx, String paramNumber) throws EASBizException, BOSException {
        return ParamManager.getParamValue((Context)ctx, null, (String)paramNumber);
    }

    private void updateForPTMPatch(Map<String, Map<String, PatchInfo>> versionMap) {
        Map<String, PatchInfo> PTMPatchMap = this.getPTMPatchMap();
        if (!PTMPatchMap.isEmpty()) {
            Set<Map.Entry<String, Map<String, PatchInfo>>> entrySet = versionMap.entrySet();
            for (Map.Entry<String, Map<String, PatchInfo>> entry : entrySet) {
                Map<String, PatchInfo> patchInfoMap = entry.getValue();
                for (String moduleName : PTMPatchMap.keySet()) {
                    if (patchInfoMap.containsKey(moduleName)) {
                        PatchInfo PTMPatch = PTMPatchMap.get(moduleName);
                        PatchInfo patch = patchInfoMap.get(moduleName);
                        if (DateTimeUtils.formatDate((Date)patch.getIssueDate()).compareTo(DateTimeUtils.formatDate((Date)PTMPatch.getIssueDate())) > 0) continue;
                        patchInfoMap.put(moduleName, PTMPatch);
                        continue;
                    }
                    patchInfoMap.put(moduleName, PTMPatchMap.get(moduleName));
                }
            }
        }
    }

    private Map<String, PatchInfo> getPTMPatchMap() {
        HashMap<String, PatchInfo> PTMPatchMap = new HashMap<String, PatchInfo>();
        String filePath = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "properties" + File.separator + "bos_version.data";
        File file = new File(filePath);
        if (file.exists()) {
            SAXReader reader = new SAXReader();
            try {
                Document document = reader.read(file);
                Element product = document.getRootElement();
                String patchName = product.attributeValue("patch");
                Element moduleList = product.element("ModuleList");
                Iterator moduleIterator = moduleList.elementIterator();
                while (moduleIterator.hasNext()) {
                    Element module = (Element)moduleIterator.next();
                    PatchInfo info = new PatchInfo();
                    info.setModuleName(module.attributeValue("name"));
                    info.setInstalled(true);
                    info.setPatchName(patchName);
                    info.setIssueDate(DateTimeUtils.parseDate((String)module.attributeValue("version"), (String)"yyyyMMddHHmmss"));
                    PTMPatchMap.put(module.attributeValue("name"), info);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return PTMPatchMap;
    }
}

