/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.patch.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.uiframe.patch.MessageVo;
import com.kingdee.eas.base.uiframe.patch.PatchInfo;
import com.kingdee.eas.base.uiframe.patch.PushPatchFacade;
import com.kingdee.eas.base.uiframe.patch.RemotePatch;
import com.kingdee.eas.base.uiframe.patch.service.EASVersionEnum;
import com.kingdee.eas.base.uiframe.patch.service.LocalPatchInfo;
import com.kingdee.eas.base.uiframe.patch.service.PatchUtil;
import com.kingdee.eas.base.uiframe.patch.service.ReadStatusEnum;
import com.kingdee.eas.base.uiframe.patch.service.SQLUtil;
import com.kingdee.eas.base.usermonitor.UMRegistryCollection;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PatchInterfaceImpl {
    private static Logger logger = Logger.getLogger(PatchInterfaceImpl.class);
    private static final String PACKAGE_PATH = "com.kingdee.eas.base.uiframe.patch.PushPatchFacade";
    private static Date date = null;

    public static void processPatch(Context ctx, RemotePatch remotePatch) throws BOSException {
        try {
            Map<String, Map<String, PatchInfo>> localPatchMap = PatchInterfaceImpl.getLocalMap(ctx, false);
            String version = PatchInterfaceImpl.getEASClientVersion(ctx);
            EASVersionEnum renum = PatchUtil.getVersionEnum(version);
            if (renum == null) {
                logger.info((Object)"\u5f53\u524dEAS\u7248\u672c\u4e0d\u5305\u62ec\u572880\uff0c82\uff0c85\uff0c860\uff0c861,880\u4e2d");
                return;
            }
            Map<String, Map<String, PatchInfo>> remotePatchMap = remotePatch.getRemotePatchMap();
            String knowledgeId = remotePatch.getKnowledgeId();
            logger.info((Object)("knowledgeId\uff1a" + knowledgeId));
            Map<String, PatchInfo> remoteVersionMap = remotePatchMap.get(renum.getRemote());
            if (remoteVersionMap == null) {
                logger.info((Object)"\u672a\u53d1\u653e\u5f53\u524dEAS\u7248\u672c\u7684\u5b89\u5168\u8865\u4e01");
                return;
            }
            if (PatchInterfaceImpl.isSend(ctx, knowledgeId)) {
                logger.info((Object)("knowledgeId\u503c\uff1a" + knowledgeId + "\uff0c\u5df2\u5b58\u5728\u6570\u636e"));
                MessageVo vo = PatchInterfaceImpl.getPatchInfoByKnowledgeId(ctx, knowledgeId);
                Map<String, PatchInfo> localVersionMap = null;
                if (localPatchMap != null) {
                    localVersionMap = localPatchMap.get(renum.getLocal());
                }
                if (!PatchInterfaceImpl.isMessageChange(remotePatch, vo, remoteVersionMap, localVersionMap)) {
                    return;
                }
                PatchInterfaceImpl.deletePatchAndExtend(ctx, knowledgeId);
            }
            MessageVo messageVo = new MessageVo();
            String id = Uuid.randomUUID().toString();
            messageVo.setPatchId(id);
            boolean flag = false;
            if (localPatchMap == null || localPatchMap.get(renum.getLocal()) == null) {
                logger.info((Object)"\u672c\u5730\u8865\u4e01\u4e3a\u7a7a\uff0c\u5b89\u88c5\u5f53\u524d\u7248\u672c\u5168\u90e8\u5b89\u5168\u8865\u4e01");
                for (Map.Entry<String, PatchInfo> entry : remoteVersionMap.entrySet()) {
                    PatchInfo info = entry.getValue();
                    PatchInterfaceImpl.savePatchExtend(ctx, id, renum.getRemote(), info);
                }
                messageVo.setReason(remotePatch.getReason());
                messageVo.setTitle(remotePatch.getTitle());
                messageVo.setEntityUrl(remotePatch.getEntityUrl());
                PatchInterfaceImpl.savePatch(ctx, messageVo, remotePatch.getKnowledgeId(), remotePatch.getCreator());
                return;
            }
            for (Map.Entry<String, PatchInfo> entry : remoteVersionMap.entrySet()) {
                String key = entry.getKey();
                PatchInfo rPatch = entry.getValue();
                Map<String, PatchInfo> localVersionMap = localPatchMap.get(renum.getLocal());
                PatchInfo localPatch = localVersionMap.get(key);
                if (rPatch != null && localPatch != null && localPatch.isInstalled() && (rPatch.getPatchName().equals(localPatch.getPatchName()) || localPatch.getIssueDate().compareTo(rPatch.getIssueDate()) >= 0)) continue;
                flag = true;
                assert (rPatch != null);
                PatchInterfaceImpl.savePatchExtend(ctx, messageVo.getPatchId(), renum.getRemote(), rPatch);
            }
            if (flag) {
                messageVo.setReason(remotePatch.getReason());
                messageVo.setTitle(remotePatch.getTitle());
                messageVo.setEntityUrl(remotePatch.getEntityUrl());
                PatchInterfaceImpl.savePatch(ctx, messageVo, remotePatch.getKnowledgeId(), remotePatch.getCreator());
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u8865\u4e01\u5904\u7406\u5931\u8d25", (Throwable)e);
            throw new BOSException("\u8865\u4e01\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }

    public static Map<String, Object> returnPatchInfo(Context ctx) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<MessageVo> messageVoList = new ArrayList<MessageVo>();
        resultMap.put("status", 0);
        try {
            String sql = "select a.fid,a.freason,a.fcreator,a.ftitle,a.fmessageid,a.fentityurl,b.fversion,b.fmodule,b.fpatchno,b.fissuedate from T_BD_PATCH a inner join T_BD_PATCH_EXTEND b on a.fid = b.fpatchid left join T_BAS_MESSAGE c on a.fmessageid = c.fid where c.fstatus = ? or (a.fstatus=0 and a.fmessageid is null) order by a.fid, a.fcreatetime";
            int[] types = new int[]{SQLType.INT.getSQLType()};
            Object[] params = new Object[]{0};
            ArrayList list = SQLUtil.executeQuery(ctx, sql, types, params);
            String previousId = "";
            ArrayList<PatchInfo> patchList = new ArrayList<PatchInfo>();
            MessageVo vo = new MessageVo();
            for (Map stringObjectMap : list) {
                String id = String.valueOf(stringObjectMap.get("fid"));
                if (StringUtils.isEmpty((String)previousId) || !id.equals(previousId)) {
                    previousId = id;
                    vo = new MessageVo();
                    patchList = new ArrayList();
                    vo.setPatchId(id);
                    vo.setReason(String.valueOf(stringObjectMap.get("freason")));
                    vo.setCreator(String.valueOf(stringObjectMap.get("fcreator")));
                    vo.setTitle(String.valueOf(stringObjectMap.get("ftitle")));
                    vo.setEntityUrl(String.valueOf(stringObjectMap.get("fentityurl")));
                    String messageId = (String)stringObjectMap.get("fmessageid");
                    if (!StringUtils.isEmpty((String)messageId)) {
                        vo.setExist(true);
                        vo.setMessageId(messageId);
                    }
                    messageVoList.add(vo);
                }
                PatchInfo info = new PatchInfo();
                info.setApplyVersion(String.valueOf(stringObjectMap.get("fversion")));
                info.setModuleName(String.valueOf(stringObjectMap.get("fmodule")));
                info.setPatchName(String.valueOf(stringObjectMap.get("fpatchno")));
                info.setIssueDate(DateTimeUtils.parseDate((String)String.valueOf(stringObjectMap.get("fissuedate"))));
                patchList.add(info);
                vo.setPatchList(patchList);
            }
            if (!messageVoList.isEmpty()) {
                for (MessageVo messageVo : messageVoList) {
                    if (messageVo.isExist()) continue;
                    PatchInterfaceImpl.sendMsg(messageVo, ctx);
                }
                resultMap.put("status", 200);
                resultMap.put("result", messageVoList);
            }
        }
        catch (Exception e) {
            resultMap.put("status", 0);
            resultMap.put("errorMsg", e.getMessage());
            logger.error((Object)"\u67e5\u8be2\u672a\u8bfb\u7684\u8865\u4e01\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
        return resultMap;
    }

    public static MessageVo getPatchInfoByKnowledgeId(Context ctx, String knowledgeId) {
        MessageVo vo = new MessageVo();
        try {
            String sql = "select a.fid,a.freason,a.fcreator,a.ftitle,a.fmessageid,a.fentityurl,b.fversion,b.fmodule,b.fpatchno,b.fissuedate from T_BD_PATCH a inner join T_BD_PATCH_EXTEND b on a.fid = b.fpatchid where a.fknowledgeId = ? order by a.fid, a.fcreatetime";
            int[] types = new int[]{SQLType.VARCHAR.getSQLType()};
            Object[] params = new Object[]{knowledgeId};
            ArrayList list = SQLUtil.executeQuery(ctx, sql, types, params);
            ArrayList<PatchInfo> patchList = new ArrayList<PatchInfo>();
            for (Map stringObjectMap : list) {
                String id = String.valueOf(stringObjectMap.get("fid"));
                vo.setPatchId(id);
                vo.setReason(String.valueOf(stringObjectMap.get("freason")));
                vo.setCreator(String.valueOf(stringObjectMap.get("fcreator")));
                vo.setTitle(String.valueOf(stringObjectMap.get("ftitle")));
                vo.setEntityUrl(String.valueOf(stringObjectMap.get("fentityurl")));
                String messageId = (String)stringObjectMap.get("fmessageid");
                if (!StringUtils.isEmpty((String)messageId)) {
                    vo.setExist(true);
                    vo.setMessageId(messageId);
                }
                PatchInfo info = new PatchInfo();
                info.setApplyVersion(String.valueOf(stringObjectMap.get("fversion")));
                info.setModuleName(String.valueOf(stringObjectMap.get("fmodule")));
                info.setPatchName(String.valueOf(stringObjectMap.get("fpatchno")));
                info.setIssueDate(DateTimeUtils.parseDate((String)String.valueOf(stringObjectMap.get("fissuedate"))));
                patchList.add(info);
                vo.setPatchList(patchList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u672a\u8bfb\u7684\u8865\u4e01\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
        return vo;
    }

    public static void sendMsg(MessageVo messageVo, Context ctx) throws BOSException, EASBizException {
        String content;
        String title = messageVo.getTitle();
        String msgId = PatchInterfaceImpl.saveNoticeMsg(title, content = PatchInterfaceImpl.spliceMsgContent(messageVo), ctx);
        if (!StringUtils.isEmpty((String)msgId)) {
            PushPatchFacade facade = new PushPatchFacade(ctx);
            facade.updateMessageId(messageVo.getPatchId(), msgId);
            messageVo.setMessageId(msgId);
        }
    }

    private static String spliceMsgContent(MessageVo messageVo) {
        String reason = messageVo.getReason();
        List<PatchInfo> list = messageVo.getPatchList();
        StringBuilder sb = new StringBuilder();
        sb.append(messageVo.getTitle()).append("\n");
        sb.append(reason).append("\n");
        for (PatchInfo patchInfo : list) {
            sb.append("\u8865\u4e01\u53f7\uff1a").append(patchInfo.getPatchName()).append("\n").append("\u6240\u5c5e\u6a21\u5757\uff1a").append(patchInfo.getModuleName()).append("\n").append("\u8865\u4e01\u53d1\u653e\u65f6\u95f4\uff1a").append(DateTimeUtils.format((Date)patchInfo.getIssueDate(), (String)"yyyy-MM-dd")).append("\n");
        }
        sb.append("\u53d1\u5e03\u4eba\uff1a").append(messageVo.getCreator()).append("\n").append("\u8865\u4e01\u516c\u544a\u94fe\u63a5\uff1a").append(messageVo.getEntityUrl()).append("\n");
        return sb.toString();
    }

    public static String saveNoticeMsg(String title, String content, Context ctx) throws EASBizException, BOSException {
        HashMap<Locale, String> msgTopicMap = new HashMap<Locale, String>();
        HashMap<Locale, String> msgContentMap = new HashMap<Locale, String>();
        HashMap<Locale, String> senderMap = new HashMap<Locale, String>();
        String dataCenterName = SysContext.getSysContext().getDcName();
        if (!ConfigMDUtil.isClient()) {
            dataCenterName = ConfigMDUtil.getContext().getAIS();
        }
        UMRegistryCollection collection = (UMRegistryCollection)UserMonitorFactory.getLocalInstance((Context)ctx).getCollectionUsingOrgRange(dataCenterName);
        UMRegistryInfo info = collection.get(0);
        String sessionId = info.getId();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        String userName = "administrator";
        for (LanguageInfo languageInfo : allLanguage) {
            Locale curLocal = languageInfo.getLocale();
            msgTopicMap.put(curLocal, StringUtils.cnulls((String)title));
            msgContentMap.put(curLocal, StringUtils.cnulls((String)content));
            senderMap.put(curLocal, userName);
        }
        String ais = info.getDataCenterName();
        PushPatchFacade facade = new PushPatchFacade(ctx);
        facade.saveNoticeMsg(ais, sessionId, senderMap, msgTopicMap, msgContentMap);
        String messageId = null;
        int count = 0;
        while (count < 10) {
            try {
                Thread.sleep(1000L);
                messageId = facade.getMsgId(sessionId);
                if (!StringUtils.isEmpty((String)messageId)) break;
                ++count;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return messageId;
    }

    public static void updatePatchById(Context ctx, String id, String type) throws BOSException {
        int newStatus = 0;
        if ("2".equals(type)) {
            newStatus = ReadStatusEnum.WEB_READED.getStatus();
        } else if ("3".equals(type)) {
            newStatus = ReadStatusEnum.CONSOLE_READED.getStatus();
        } else {
            throw new BOSException("type\u4f20\u8f93\u6709\u8bef\uff01");
        }
        String usql = "update t_bd_patch set fstatus=?  where fid = ?";
        int[] utypes = new int[]{SQLType.INT.getSQLType(), SQLType.VARCHAR.getSQLType()};
        Object[] uparams = new Object[]{newStatus, id};
        SQLUtil.executeUpdate(ctx, usql, utypes, uparams);
    }

    private static String getEASClientVersion(Context ctx) throws BOSException {
        ArrayList list = SQLUtil.executeQuery(ctx, "select fmajor,fminor,fbuild from t_sys_datacenter where FTYPE = 'BOS'");
        HashMap map = (HashMap)list.get(0);
        String marjor = map.get("fmajor").toString();
        String minor = map.get("fminor").toString();
        String build = map.get("fbuild").toString();
        return marjor + minor + build;
    }

    private static boolean isRead(Context ctx, String knowledgeId) throws BOSException {
        int[] types = new int[]{SQLType.VARCHAR.getSQLType(), SQLType.INT.getSQLType()};
        Object[] params1 = new Object[]{knowledgeId, 10};
        Object[] params2 = new Object[]{knowledgeId, ReadStatusEnum.UNREAD.getStatus()};
        ArrayList list = SQLUtil.executeQuery(ctx, "select a.fid id from T_BD_PATCH a inner join t_bas_message b on a.fmessageId = b.fid where a.fknowledgeId =? and b.fstatus = ?", types, params1);
        if (!list.isEmpty()) {
            return true;
        }
        list = SQLUtil.executeQuery(ctx, "select a.fid id from T_BD_PATCH a where a.fknowledgeId =? and a.fstatus != ?", types, params2);
        return !list.isEmpty();
    }

    private static boolean isSend(Context ctx, String knowledgeId) throws BOSException {
        String sql = "select fid,freason,fcontent,ftitle from T_BD_PATCH where fknowledgeId =?";
        int[] types = new int[]{SQLType.VARCHAR.getSQLType()};
        Object[] params = new Object[]{knowledgeId};
        ArrayList list = SQLUtil.executeQuery(ctx, sql, types, params);
        return !list.isEmpty();
    }

    private static Map<String, Map<String, PatchInfo>> getLocalMap(Context ctx, boolean isInstalled) throws BOSException {
        LocalPatchInfo localPatchInfo = new LocalPatchInfo();
        return localPatchInfo.getLocalPatchMap(ctx, isInstalled);
    }

    private static void savePatch(Context ctx, MessageVo vo, String knowledgeId, String creator) throws BOSException {
        Date d = new Date();
        String time = DateTimeUtils.format((Date)d);
        String sql = "insert into T_BD_PATCH(FID,FREASON,fknowledgeId,fcreateTime,ftitle,fstatus,fcreator,fentityUrl) values(?,?,?,{ts'" + time + "'},?,?,?,?)";
        int[] types = new int[]{SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType(), SQLType.INT.getSQLType(), SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType()};
        Object[] params = new Object[]{vo.getPatchId(), vo.getReason(), knowledgeId, vo.getTitle(), ReadStatusEnum.UNREAD.getStatus(), creator, vo.getEntityUrl()};
        SQLUtil.executeUpdate(ctx, sql, types, params);
    }

    private static void savePatchExtend(Context ctx, String patchId, String version, PatchInfo info) throws BOSException {
        String time = DateTimeUtils.format((Date)info.getIssueDate());
        String sql = "insert into T_BD_PATCH_EXTEND(fid, fversion,fmodule,fpatchno,fissuedate,fpatchid) values(?,?,?,?,{ts'" + time + "'},?)";
        int[] types = new int[]{SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType(), SQLType.VARCHAR.getSQLType()};
        String id = Uuid.randomUUID().toString();
        Object[] params = new Object[]{id, version, info.getModuleName(), info.getPatchName(), patchId};
        SQLUtil.executeUpdate(ctx, sql, types, params);
    }

    public static boolean isNeedAccessRemote(Context ctx) {
        boolean isTurnOnParam = PatchUtil.isTurnOnPushPatch(ctx);
        if (isTurnOnParam && (date == null || new Date().getTime() - date.getTime() > 0L)) {
            date = new Date();
            return true;
        }
        return false;
    }

    private static boolean isMessageChange(RemotePatch remotePatch, MessageVo vo, Map<String, PatchInfo> remoteVersionMap, Map<String, PatchInfo> localVersionMap) {
        if (!remotePatch.getReason().equals(vo.getReason()) || !remotePatch.getTitle().equals(vo.getTitle())) {
            return true;
        }
        List<PatchInfo> patchList = vo.getPatchList();
        for (Map.Entry<String, PatchInfo> entry : remoteVersionMap.entrySet()) {
            boolean flag = true;
            PatchInfo info = entry.getValue();
            for (PatchInfo p : patchList) {
                if (info.getPatchName().equals(p.getPatchName())) {
                    flag = false;
                    if (!info.getModuleName().equals(p.getModuleName()) || info.getIssueDate().compareTo(p.getIssueDate()) != 0) {
                        return true;
                    }
                }
                if (remoteVersionMap.containsKey(p.getModuleName())) continue;
                return true;
            }
            if (!flag || localVersionMap == null) continue;
            PatchInfo localPatch = localVersionMap.get(entry.getKey());
            if (info != null && localPatch != null && localPatch.isInstalled() && (info.getPatchName().equals(localPatch.getPatchName()) || localPatch.getIssueDate().compareTo(info.getIssueDate()) >= 0)) continue;
            return true;
        }
        return false;
    }

    private static void deletePatchAndExtend(Context ctx, String knowledgeId) throws BOSException {
        String sql = "delete from T_BD_PATCH_EXTEND where fpatchid in (select fid from T_BD_PATCH where fknowledgeId = ?)";
        int[] types = new int[]{SQLType.VARCHAR.getSQLType()};
        Object[] params = new Object[]{knowledgeId};
        SQLUtil.executeUpdate(ctx, sql, types, params);
        String sql2 = "delete from T_BD_PATCH where fknowledgeId = ?";
        SQLUtil.executeUpdate(ctx, sql2, types, params);
    }
}

