/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.util.app.DbUtil;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class DbTransactionUtil {
    private static final Logger logger = Logger.getLogger(DbTransactionUtil.class);
    private static ExecutorService executorService = null;
    private static Future<Boolean> future = null;
    private static int MAX_VALUE = 1;
    private static long MAX_FREE_SECONDS = 60L;
    private static int TIME_OUT = 20;

    public static Boolean tryTruncateTableNo(Context ctx, String table) throws BOSException {
        return DbTransactionUtil.truncateTableNo(ctx, table, TIME_OUT);
    }

    private static Boolean truncateTableNo(Context ctx, String table, int timeOut) throws BOSException {
        if (ctx == null) {
            ctx = ContextUtils.getContextFromSessionNoException();
        }
        final Context innerCtx = ctx;
        final String innerTable = table;
        if (future == null || future.isCancelled() || future.isDone()) {
            future = DbTransactionUtil.getExecutorService().submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        DbTransactionUtil.truncateTableNo(innerCtx, innerTable);
                        return true;
                    }
                    catch (Throwable e) {
                        logger.error((Object)e);
                        throw new BOSException(e);
                    }
                }
            });
        }
        try {
            return future.get(timeOut, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (TimeoutException e) {
            logger.error((Object)e);
            return false;
        }
    }

    private static void truncateTableNo(Context ctx, String table) throws Throwable {
        try {
            Method method = DbTransactionUtil.class.getDeclaredMethod("truncateTable", Context.class, String.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(null);
            txInvoker.invoke(method, new Object[]{ctx, table}, 4);
        }
        catch (Throwable e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private static void truncateTable(Context ctx, String table) throws BOSException {
        if (table.equalsIgnoreCase("T_BAS_COMFUNCMENUCACHE") || table.equalsIgnoreCase("T_BAS_MENUCACHE")) {
            DbUtil.execute((Context)ctx, (String)("truncate table " + table));
        }
    }

    public static void noTransactionInvoke(Object target, String methodName, Class[] paramsClass, Object[] params) throws BOSException {
        try {
            Method method = target.getClass().getDeclaredMethod(methodName, paramsClass);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)target);
            txInvoker.invoke(method, params, 4);
        }
        catch (Throwable e) {
            logger.error((Object)e);
            throw new BOSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getExecutorService() {
        if (executorService != null) {
            return executorService;
        }
        Class<ExecutorService> clazz = ExecutorService.class;
        synchronized (ExecutorService.class) {
            if (executorService == null) {
                executorService = new ThreadPoolExecutor(1, MAX_VALUE, MAX_FREE_SECONDS, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }
}

