/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.KsmHelper;
import com.kingdee.eas.base.uiframe.MainFrameServiceFacadeFactory;
import com.kingdee.eas.base.uiframe.utils.MDEncodeUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class KsmSsoUtils {
    private static final Logger logger = Logger.getLogger(KsmSsoUtils.class);
    private static final String productCode = "productCode";
    private static final String userId = "userId";
    private static final String account = "account";
    private static final String username = "username";
    private static final String email = "email";
    private static final String telephone = "telephone";
    private static final String ts = "ts";
    private static final String token = "token";
    private static final String ksmUrl;
    private static final String key = "fsdoijflajdif";

    public static String getKsmUrl() {
        return KsmSsoUtils.getUrlParamStr(KsmSsoUtils.constructUrlParam());
    }

    private static Map<String, String> constructUrlParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        try {
            String _telephone;
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            IUser user = UserFactory.getRemoteInstance();
            String sn = baseInfo.getSerialNum();
            param.put(productCode, sn);
            String _userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            param.put(userId, URLEncoder.encode(_userId, "UTF-8"));
            String _userName = SysContext.getSysContext().getUserName();
            param.put(username, URLEncoder.encode(_userName, "UTF-8"));
            String _account = "";
            try {
                if (!StringUtils.isEmpty((String)baseInfo.getLicenseTo())) {
                    _account = new String(Base64Encoder.base64ToByteArray((String)baseInfo.getLicenseTo()), "GBK");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            param.put(account, URLEncoder.encode(_account, "UTF-8"));
            UserInfo userInfo = user.getUserInfo((IObjectPK)new ObjectUuidPK(_userId));
            String _email = userInfo.getEmail();
            if (!StringUtils.isEmpty((String)_email)) {
                param.put(email, URLEncoder.encode(_email, "UTF-8"));
            }
            if (!StringUtils.isEmpty((String)(_telephone = userInfo.getCell()))) {
                param.put(telephone, _telephone);
            }
            String _ts = System.currentTimeMillis() + "";
            param.put(ts, _ts);
            String _token = MDEncodeUtil.sha1(sn + _userId + _account + key + _ts);
            param.put(token, _token);
        }
        catch (Exception e) {
            logger.error((Object)"\u6784\u9020KSM\u63a5\u53e3\u53c2\u6570\u5f02\u5e38!", (Throwable)e);
        }
        return param;
    }

    private static String getUrlParamStr(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append("&").append(key).append("=").append(value);
        }
        return ksmUrl + sb.substring(1);
    }

    static {
        StringBuffer finalKsmUrl = new StringBuffer("http://easksm.kingdee.com/ksm4eas.action?");
        try {
            KsmHelper ksmHelper = MainFrameServiceFacadeFactory.getRemoteInstance().getKsmHelper();
            finalKsmUrl = new StringBuffer();
            finalKsmUrl.append(ksmHelper.getKsmAllUrl());
            finalKsmUrl.append("?");
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new RuntimeException("ksmHelp parse error", e);
        }
        ksmUrl = finalKsmUrl.toString();
    }
}

