/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.uiframe.utils.RSAUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class XunTongHelper {
    private static final String MCLOUD_URL = "http://mcloud.kingdee.com";
    private static final String EXTMCLOUD_URL = "http://mcloud.kingdee.com/extmcloud";
    private static final String REGISTER_ACTION = "appKey";
    private static final String REGISTER_URL = "http://mcloud.kingdee.com/extmcloud/open/appKey.action";
    private static final String APP_PRIVATE = "com/kingdee/bos/webframework/component/f7/app_private.key";

    public static String getXunTongToken(String eid, String openId) throws Exception {
        String token = null;
        String data = eid + "|" + openId + "|" + new Date().getTime();
        System.out.println("data to sign:" + data);
        token = RSAUtils.encrypt(data, XunTongHelper.getKey(eid));
        return token;
    }

    public static String getXunTongUrl(String eid, String openId) throws Exception {
        String urlPattern = "KdCloudHub://start/open/close/?eid={0}&openid={1}&token={2}";
        return MessageFormat.format(urlPattern, eid, openId, XunTongHelper.getXunTongToken(eid, openId));
    }

    public static String getXunTongUrl(String eid, String openId, String token) throws Exception {
        String urlPattern = "KdCloudHub://start/open/close/?eid={0}&openid={1}&token={2}";
        return MessageFormat.format(urlPattern, eid, openId, token);
    }

    public static String getXunTongUrlFromEas(String eid, String openId, String token) {
        String urlPattern = "KdCloudHub://open/?from=EAS&eid={0}&openid={1}&token={2}";
        return MessageFormat.format(urlPattern, eid, openId, token);
    }

    private static String signEncrypt(String url, String action, JSONObject dataJSON) {
        try {
            String nonce = UUID.randomUUID().toString();
            Long timestamp = new Long(System.currentTimeMillis() / 1000L);
            String data = RSAUtils.encrypt(dataJSON.toString(), XunTongHelper.initPrivateKey(APP_PRIVATE));
            String signaUrl = "url=" + url + "&timestamp=" + timestamp + "&nonce=" + nonce + "&action=" + action + "&data=" + data;
            byte[] bytes = signaUrl.getBytes("utf-8");
            byte[] signBytes = RSAUtils.sign(bytes, (PrivateKey)XunTongHelper.initPrivateKey(APP_PRIVATE));
            String signature = new String(Base64.encodeBase64((byte[])signBytes));
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("action", (Object)action);
            jsonBody.put("data", (Object)data);
            jsonBody.put("nonce", (Object)nonce);
            jsonBody.put("signature", (Object)signature);
            jsonBody.put("timestamp", (Object)timestamp);
            return jsonBody.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] getKeyFromMCloud(String eid) throws Exception {
        JSONObject o = new JSONObject();
        o.put("eid", (Object)eid);
        o.put("type", (Object)"pri");
        String reponse = XunTongHelper.getResponse(REGISTER_URL, XunTongHelper.signEncrypt(REGISTER_URL, REGISTER_ACTION, o));
        JSONObject responseJSON = JSONObject.parseObject((String)reponse);
        String keyData = (String)responseJSON.get((Object)"data");
        String decryptData = RSAUtils.decrypt(keyData, XunTongHelper.initPrivateKey(APP_PRIVATE));
        return Base64.decodeBase64((byte[])decryptData.getBytes("UTF-8"));
    }

    private static String getResponse(String url, String jsonBody) {
        try {
            HttpClient httpClient = new HttpClient();
            PostMethod httpPost = new PostMethod(url);
            StringRequestEntity entry = new StringRequestEntity(jsonBody, "application/json;charset=utf-8", "UTF-8");
            httpPost.setRequestEntity((RequestEntity)entry);
            int statusCode = httpClient.executeMethod((HttpMethod)httpPost);
            String response = httpPost.getResponseBodyAsString();
            if (statusCode != 200) {
                httpPost.abort();
            }
            byte[] resultBytes = response.getBytes("UTF-8");
            String msgContent = new String(resultBytes, "UTF-8");
            System.out.println(msgContent);
            return msgContent;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Key getKey(String eid) throws Exception {
        byte[] bytes = XunTongHelper.getKeyFromMCloud(eid);
        return RSAUtils.restorePrivateKey(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key initPrivateKey(String keyPath) {
        InputStream in = null;
        PrivateKey privateKey = null;
        try {
            in = XunTongHelper.class.getClassLoader().getResourceAsStream(keyPath);
            byte[] keyData = new byte[in.available()];
            in.read(keyData);
            privateKey = RSAUtils.restorePrivateKey(keyData);
        }
        catch (Exception e) {
            e.printStackTrace();
            PrivateKey privateKey2 = privateKey;
            return privateKey2;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return privateKey;
    }

    public static String getOpenId(Context ctx, String personId) throws BOSException, EASBizException {
        String openId = null;
        try {
            String checkSql = "select * from KSQL_USERTABLES where KSQL_TABNAME='t_pm_easxtusermap'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (!rs.next()) {
                return null;
            }
            String querySql = "select fxtid from t_pm_easxtusermap where fpersonId=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{personId});
            if (rs.next()) {
                openId = rs.getString("fxtid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return openId;
    }

    public static String getOpenIdByUserId(Context ctx, String userId) throws BOSException, EASBizException {
        String openId = null;
        try {
            String checkSql = "select * from KSQL_USERTABLES where KSQL_TABNAME='t_pm_easxtusermap'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (!rs.next()) {
                return null;
            }
            String querySql = "select fxtid from t_pm_easxtusermap where FUserId=?";
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{userId});
            if (rs.next()) {
                openId = rs.getString("fxtid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return openId;
    }
}

