/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor;

import com.kingdee.bos.Context;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.base.usermonitor.IUserMonitorAgent;
import com.kingdee.eas.base.usermonitor.UserMonitorAgent;
import org.apache.log4j.Logger;

public class UserMonitorAgentFactory {
    private static Logger logger = Logger.getLogger((String)UserMonitorAgentFactory.class.getName());
    public static final String USERMONITOR_SERVER_LOCATION = "UserMonitor";

    public static IUserMonitorAgent getInstance(Context ctx) {
        IUserMonitorAgent agent = null;
        String url = null;
        try {
            ORMServiceLocation loc = new ORMServiceLocation(USERMONITOR_SERVER_LOCATION);
            if (loc == null) {
                logger.error((Object)"Invalidate config file! please make sure you have the config item about UserMonitor!");
            } else if (!loc.isLocal()) {
                url = loc.getServiceURL();
                if (url == null || url.trim().length() == 0) {
                    url = "tcp://localhost";
                }
                agent = (IUserMonitorAgent)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.eas.base.usermonitor.UserMonitorAgent", IUserMonitorAgent.class);
            } else {
                agent = new UserMonitorAgent(ctx);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Invalidate config file! please make sure you have the config item about UserMonitor! Error url is: " + url), (Throwable)e);
        }
        return agent;
    }
}

