/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.message.DBTempMsgFacadeFactory;
import com.kingdee.eas.base.message.DBTempMsgInfo;
import com.kingdee.eas.base.message.IDBTempMsgFacade;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.TempMessage;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.simple.JSONArray;
import com.kingdee.eas.cp.common.json.simple.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.request.RequestContext;
import org.apache.log4j.Logger;

public class UserMonitorBuffaloService {
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.base.usermonitor.UserMonitorCommonResource";
    protected static Logger logger = Logger.getLogger(UserMonitorBuffaloService.class);

    public void deleteUserMonitorInfo(String str) {
        HttpServletRequest request = RequestContext.getContext().getHttpRequest();
        String sessionID = request.getSession().getId();
        try {
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            UMRegistryInfo info = (UMRegistryInfo)iUserMonitor.getValue(sessionID);
            if (info != null) {
                String GUIUserId = info.getGUIUserId();
                sessionID = sessionID == null ? GUIUserId : sessionID;
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteUserMonitorPortalUser(String str) {
        HttpServletRequest request = RequestContext.getContext().getHttpRequest();
        String sessionID = request.getSession().getId();
        try {
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            UMRegistryInfo info = (UMRegistryInfo)iUserMonitor.getValue(sessionID);
            if (info != null) {
                String GUIUserId = info.getGUIUserId();
                sessionID = sessionID == null ? GUIUserId : sessionID;
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
            } else {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
                if (ctx != null) {
                    iUserMonitor.deleteSessionAndUserMonitorInfo(ctx.getContextID(), null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONArray procedureOfClient(String str) throws Exception {
        JSONArray msgArray = new JSONArray();
        Map msgMap = MessageCenterFactory.getRemoteInstance().receiveTempMsg();
        if (msgMap.size() == 0) {
            return msgArray;
        }
        Iterator msgItr = msgMap.values().iterator();
        IDBTempMsgFacade iMsgFacade = DBTempMsgFacadeFactory.getRemoteInstance();
        if (iMsgFacade.isCluster()) {
            DBTempMsgInfo info = null;
            while (msgItr.hasNext()) {
                info = (DBTempMsgInfo)msgItr.next();
                JSONObject jsonMsg = new JSONObject();
                jsonMsg.put((Object)"msgTitle", (Object)info.getMsgTitle());
                jsonMsg.put((Object)"msgContent", (Object)info.getMsgContent());
                jsonMsg.put((Object)"msgID", (Object)info.getMsgSendTime());
                jsonMsg.put((Object)"msgLifeCyc", (Object)("" + info.getMsgLifeCyc()));
                jsonMsg.put((Object)"senderName", (Object)info.getSenderName());
                msgArray.add((Object)jsonMsg);
            }
        } else {
            TempMessage tempMsg = null;
            while (msgItr.hasNext()) {
                tempMsg = (TempMessage)msgItr.next();
                JSONObject jsonMsg = new JSONObject();
                long msgID = tempMsg.getMsgID();
                jsonMsg.put((Object)"msgTitle", (Object)tempMsg.getMsgTitle());
                jsonMsg.put((Object)"msgContent", (Object)tempMsg.getMsgContent());
                jsonMsg.put((Object)"msgID", (Object)new Long(msgID));
                jsonMsg.put((Object)"msgLifeCyc", (Object)("" + tempMsg.getMsgLifeCyc()));
                jsonMsg.put((Object)"senderName", (Object)tempMsg.getSenderName());
                msgArray.add((Object)jsonMsg);
            }
        }
        return msgArray;
    }

    public void destroyOverTimeTempMsg(String str) throws EASBizException, BOSException {
        long currentTime = System.currentTimeMillis();
        MessageCenterFactory.getRemoteInstance().destroyOverTimeMsg(currentTime);
    }

    public void deleteUserMonitorAllOtherPortalUser(String username, String dbcenter, String clientIP) {
        try {
            HttpServletRequest request = RequestContext.getContext().getHttpRequest();
            String currentSessionId = request.getSession().getId();
            List userList = UserMonitorFactory.getRemoteInstance().findUsers(dbcenter, username);
            if (userList == null || userList.isEmpty()) {
                return;
            }
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            for (int i = 0; i < userList.size(); ++i) {
                UMRegistryInfo info = (UMRegistryInfo)userList.get(i);
                if (info.getId().equals(currentSessionId)) continue;
                String kickTime = BOSLocaleUtil.getDateTimeFormat().format(new Date());
                Map kickOutMap = this.getSouceInfo("kickOutMessage", clientIP, info.getClientIPAddress(), username, username, kickTime);
                Map userNameMap = this.getSouceInfoBySet(username);
                iUserMonitor.sendMessageToUser(info.getId(), userNameMap, kickOutMap, kickOutMap);
                try {
                    ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
                    String sessionID = null;
                    sessionID = info.getGUIUserId() != null ? info.getGUIUserId() : info.getId();
                    agent.releaseLicenseBySessionID(sessionID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (info.getGUIUserId() != null) {
                    iUserMonitor.deleteSessionAndUserMonitorInfo(info.getGUIUserId(), null);
                    continue;
                }
                iUserMonitor.deleteSessionAndUserMonitorInfo(info.getId(), null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map getSouceInfo(String sourceName, String kickIp, String beKickIp, String kickUserName, String beKickUserName, String kickTime) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            String msgBody = StringUtils.cnulls((String)ResourceBase.getString((String)RESOURCE_FULLNAME, (String)sourceName, (Locale)curLocal));
            String msg = msgBody.replaceAll("beKickUserName", beKickUserName).replaceAll("kickIp", kickIp).replaceAll("kickTime", kickTime).replaceAll("kickUserName", kickUserName);
            sourceMap.put(curLocal, msg);
        }
        return sourceMap;
    }

    private Map getSouceInfoBySet(String value) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            sourceMap.put(curLocal, StringUtils.cnulls((String)value));
        }
        return sourceMap;
    }
}

