/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.web;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class UserMonitorLoginHelper {
    protected static final Logger logger = Logger.getLogger(UserMonitorLoginHelper.class);

    public static UMRegistryInfo createUMRegistryInfo(Context ctx, String sessionId, String ip) {
        CtrlUnitInfo cuInfo;
        UMRegistryInfo reg = new UMRegistryInfo();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        reg.setGUIUserId(ctx.getContextID());
        String id = sessionId;
        reg.setId(id);
        if (StringUtils.isEmpty((String)ip) || ip.equals("127.0.0.1")) {
            logger.info((Object)"get client host ip from context.");
            ip = ctx.getClientHostIP();
        }
        reg.setClientIPAddress(ip);
        reg.setUserId(userInfo.getId().toString());
        reg.setUserName(ctx.getUserName());
        reg.setUserRealName(userInfo.getName());
        reg.setUserType(userInfo.getType().getValue());
        reg.setDataCenterName(ctx.getAIS());
        reg.setFinished(true);
        if (userInfo.getCU() != null) {
            reg.setUserCUName(userInfo.getCU().getName());
        }
        if ((cuInfo = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)) != null) {
            reg.setCurrentMainBizUnitName(cuInfo.getName());
        }
        reg.setOpenWindowTitle("portal");
        if (cuInfo != null) {
            reg.setCurrentCtrlUnitId(cuInfo.getId().toString());
        }
        return reg;
    }

    public static void saveUMRegistryInfo(UMRegistryInfo info, Context ctx) {
        if (info.getId() == null || info.getId().trim().length() == 0) {
            StringBuffer detail = new StringBuffer();
            detail.append("User monitor register err info\uff1asession ID is empty");
            detail.append(System.getProperty("line.separator"));
            detail.append("UMRegistry detail info\uff1a");
            detail.append(info.toString());
            logger.error((Object)detail.toString());
        } else {
            try {
                IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
                iUserMonitor.addnew(info);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

