/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.weibo.WeiboBindPersonInfo;
import com.kingdee.eas.base.weibo.WeiboPrepareInfo;
import com.kingdee.eas.base.weibo.WeiboRegisterInfo;
import com.kingdee.eas.base.weibo.app.AbstractWeiboFacadeControllerBean;
import com.kingdee.eas.base.weibo.app.PersonRegisterInfo;
import com.kingdee.eas.base.weibo.app.WeiboAccessInfo;
import com.kingdee.eas.base.weibo.app.WeiboAppDAO;
import com.kingdee.eas.base.weibo.app.WeiboGlobal;
import com.kingdee.eas.base.weibo.app.WeiboPreCreateUserInfo;
import com.kingdee.eas.base.weibo.app.WeiboServiceBuilder;
import com.kingdee.eas.base.weibo.util.TokenSecureUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import weibo4j.Count;
import weibo4j.DirectMessage;
import weibo4j.Status;
import weibo4j.User;
import weibo4j.UserAndToken;
import weibo4j.UserTokenList;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.AccessToken;
import weibo4j.org.json.JSONException;

public class WeiboFacadeControllerBean
extends AbstractWeiboFacadeControllerBean {
    private static final long serialVersionUID = 7054679236185445618L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.weibo.app.WeiboFacadeControllerBean");

    @Override
    protected boolean _isWeiboEnable(Context ctx) throws BOSException, EASBizException {
        String enable = WeiboGlobal.getEnable(ctx);
        return Boolean.valueOf(enable);
    }

    @Override
    protected String _getDomain(Context ctx) throws BOSException, EASBizException {
        return WeiboGlobal.getDomain(ctx);
    }

    @Override
    protected String _getAppKey(Context ctx) throws BOSException, EASBizException {
        return WeiboGlobal.getAppKey(ctx);
    }

    protected String _getWeiboUrl(Context ctx) throws BOSException, EASBizException {
        return WeiboGlobal.getWeiboUrl(ctx);
    }

    @Override
    protected String _getAppSecret(Context ctx) throws BOSException, EASBizException {
        String secret = WeiboGlobal.getAppSecret(ctx);
        return TokenSecureUtil.decode(secret);
    }

    @Override
    protected WeiboPrepareInfo _getPrepareInfo(Context ctx) throws BOSException, EASBizException {
        WeiboAccessInfo accessInfo;
        String personId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)personId)) {
            logger.error((Object)"\u83b7\u53d6\u4e0d\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u7684\u804c\u5458\u4fe1\u606f");
            return new WeiboPrepareInfo(null, null, null);
        }
        try {
            accessInfo = WeiboAppDAO.getAccessInfo(ctx, personId);
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6AccessToken\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            accessInfo = new WeiboAccessInfo();
        }
        String lgtk = this.getLoginTokenByAccessInfo(ctx, accessInfo);
        return new WeiboPrepareInfo(personId, accessInfo.getEmail(), lgtk);
    }

    private String getLoginTokenByAccessInfo(Context ctx, WeiboAccessInfo accessInfo) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)accessInfo.getToken())) {
            return this.getLoginToken(ctx, accessInfo.getToken(), TokenSecureUtil.decode(accessInfo.getTokenSecret()));
        }
        if (!StringUtils.isEmpty((String)accessInfo.getEmail())) {
            return this.getUnVerifiledLoginToken(ctx, accessInfo.getEmail());
        }
        return this.getAppLoginToken(ctx);
    }

    private String getCurrentPersonId(Context ctx) {
        String personId = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getPerson() != null) {
            personId = userInfo.getPerson().getId().toString();
        }
        return personId;
    }

    private String getLoginToken(Context ctx, String token, String tokenSecret) {
        Weibo weibo = this.getWeibo(ctx);
        weibo.setOAuthAccessToken(token, tokenSecret);
        String lgtk = null;
        try {
            lgtk = weibo.getWebLoginToken();
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u670d\u52a1\u767b\u5f55token\u51fa\u9519", (Throwable)e);
        }
        return lgtk;
    }

    private String getUnVerifiledLoginToken(Context ctx, String email) throws EASBizException, BOSException {
        String domain = this._getDomain(ctx);
        Weibo weibo = this.getWeibo(ctx);
        String lgtk = null;
        try {
            lgtk = weibo.getUnVerifiledLoginToken(email, domain);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u670d\u52a1\u767b\u5f55token\u51fa\u9519", (Throwable)e);
        }
        return lgtk;
    }

    private String getAppLoginToken(Context ctx) throws EASBizException, BOSException {
        String domain = this._getDomain(ctx);
        Weibo weibo = this.getWeibo(ctx);
        String lgtk = null;
        try {
            lgtk = weibo.getAppToken("", domain);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u670d\u52a1\u767b\u5f55token\u51fa\u9519", (Throwable)e);
        }
        return lgtk;
    }

    private Weibo getWeibo(Context ctx) {
        return WeiboServiceBuilder.getWeibo(ctx);
    }

    private Weibo getWeiboNoToken(Context ctx) {
        return WeiboServiceBuilder.getFeedWeiboNoToken(ctx);
    }

    private Weibo getAdminWeibo(Context ctx) {
        return WeiboServiceBuilder.getAdminWeibo(ctx);
    }

    @Override
    protected String _getEmailbyUserId(Context ctx, String userId) throws BOSException, EASBizException {
        try {
            PersonRegisterInfo info = WeiboAppDAO.getPeronInfoByUserId(ctx, userId);
            return info.getEmail();
        }
        catch (SQLException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7684\u90ae\u7bb1\u51fa\u9519:" + userId), (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean _isRegistered(Context ctx, String email) throws BOSException, EASBizException {
        email = email.trim();
        try {
            Weibo weibo = this.getWeibo(ctx);
            return weibo.userExists(email);
        }
        catch (WeiboException e) {
            logger.error((Object)("\u5fae\u535a\u670d\u52a1\u68c0\u67e5\u90ae\u7bb1\u662f\u5426\u6ce8\u518c\u51fa\u9519:" + email), (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _register(Context ctx, String email, boolean isAdmin) throws BOSException, EASBizException {
        String weiboUserId;
        email = email.trim();
        if (isAdmin) {
            this.enableWeiboSystem(ctx, email);
        }
        return !StringUtils.isEmpty((String)(weiboUserId = this.createUnverifiedWeiboUser(ctx, email)));
    }

    private String createUnverifiedWeiboUser(Context ctx, String email) throws BOSException {
        String name = null;
        String department = null;
        String jobTitle = null;
        String personId = null;
        try {
            WeiboPreCreateUserInfo info;
            PersonRegisterInfo personInfo = WeiboAppDAO.getPeronInfoByUserId(ctx, ctx.getCaller().toString());
            if (personInfo != null) {
                personId = personInfo.getPersonId();
                name = personInfo.getName();
            }
            if ((info = this.getWeiboPreCreateUserInfo(ctx, personId)) != null) {
                department = info.getDepartment();
                jobTitle = info.getJobTitle();
            }
        }
        catch (SQLException e2) {
            logger.error((Object)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u76f8\u5173\u7684\u804c\u5458\u4fe1\u606f\u51fa\u9519", (Throwable)e2);
        }
        return this.innerCreateWeiboUser(ctx, personId, email, name, department, jobTitle);
    }

    private String innerCreateWeiboUser(Context ctx, String personId, String email, String name, String dept, String jobTitle) throws BOSException {
        User user = null;
        try {
            user = this.getAdminWeibo(ctx).createUnVerifiedUser(email, StringUtils.cnulls((String)name), StringUtils.cnulls((String)dept), StringUtils.cnulls((String)jobTitle));
        }
        catch (WeiboException e) {
            logger.error((Object)("\u5fae\u535a\u65b9\u521b\u5efa\u672a\u8ba4\u8bc1\u7528\u6237\u51fa\u9519\uff0c\u804c\u5458\u540d\uff1a" + name + "\uff0c\u90ae\u7bb1\uff1a" + email), (Throwable)e);
        }
        if (user != null) {
            String weiboUserId = user.getId();
            WeiboAppDAO.registerMapping(ctx, email, personId, weiboUserId);
            return weiboUserId;
        }
        return null;
    }

    private WeiboPreCreateUserInfo getWeiboPreCreateUserInfo(Context ctx, String personId) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)personId)) {
            return null;
        }
        return WeiboAppDAO.getWeiboPreCreateUserInfo(ctx, personId);
    }

    private void enableWeiboSystem(Context ctx, String email, String systemType, String testUrl) throws BOSException {
        WeiboGlobal.updateDomain(ctx, this.getDomainByEmail(email));
        WeiboGlobal.updateEnable(ctx, "true");
        WeiboGlobal.updateWeiboSystem(ctx, systemType, testUrl);
    }

    private void enableWeiboSystem(Context ctx, String email) throws BOSException {
        WeiboGlobal.updateDomain(ctx, this.getDomainByEmail(email));
        WeiboGlobal.updateEnable(ctx, "true");
    }

    private String getDomainByEmail(String email) {
        return email.substring(email.lastIndexOf("@") + 1);
    }

    @Override
    protected boolean _bind(Context ctx, String email, String psw, boolean isAdmin, String weiboSystemType, String testUrl) throws BOSException, EASBizException {
        boolean isAdminWeibo;
        AccessToken token = this.getWeiboToken(ctx, email = email.trim(), psw);
        if (token == null || StringUtils.isEmpty((String)token.getToken())) {
            return false;
        }
        String personId = this.getCurrentPersonId(ctx);
        if (isAdmin && !(isAdminWeibo = this.isAdminWeiboUser(ctx, email))) {
            return false;
        }
        String weiboUserId = this.getWeiboUserId(ctx, email);
        if (isAdmin) {
            this.enableWeiboSystem(ctx, email, weiboSystemType, testUrl);
        }
        if (isAdmin && !StringUtils.isEmpty((String)personId)) {
            WeiboAppDAO.bindMapping(ctx, email, null, weiboUserId, token.getToken(), TokenSecureUtil.encode(token.getTokenSecret()));
        }
        if (personId == null) {
            personId = "";
        }
        WeiboAppDAO.bindMapping(ctx, email, personId, weiboUserId, token.getToken(), TokenSecureUtil.encode(token.getTokenSecret()));
        return true;
    }

    private AccessToken getWeiboToken(Context ctx, String email, String psw) {
        AccessToken token = null;
        try {
            token = this.getWeibo(ctx).getXAuthAccessToken(email, psw, "client_auth");
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u670d\u52a1AccessToken\u51fa\u9519", (Throwable)e);
        }
        return token;
    }

    @Override
    protected WeiboRegisterInfo _getRegisterInfo(Context ctx) throws BOSException, EASBizException {
        String domain = null;
        String email = null;
        String personId = null;
        try {
            domain = this._getDomain(ctx);
            PersonRegisterInfo info = WeiboAppDAO.getPeronInfoByUserId(ctx, ctx.getCaller().toString());
            if (info != null) {
                email = info.getEmail();
                personId = info.getPersonId();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u57df\u540d\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        return new WeiboRegisterInfo(personId, domain, email);
    }

    @Override
    protected String _getWeiboIdbyUserId(Context ctx, String userId) throws BOSException, EASBizException {
        String[] weiboIds = null;
        try {
            weiboIds = WeiboAppDAO.getWeiboInfoByUserId(ctx, userId);
        }
        catch (SQLException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u5fae\u535a\u8d26\u53f7\u51fa\u9519\uff0cuserId:" + userId), (Throwable)e);
        }
        String weiboId = "";
        if (weiboIds != null && !StringUtils.isEmpty((String)weiboIds[0])) {
            weiboId = weiboIds[0];
        } else if (weiboIds != null && weiboIds.length > 1) {
            weiboId = this.getWeiboUserId(ctx, weiboIds[1]);
        }
        return weiboId;
    }

    private String getWeiboUserId(Context ctx, String email) {
        if (StringUtils.isEmpty((String)email)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            User user = weibo.verifyCredentials();
            if (user != null) {
                logger.info((Object)("\u5fae\u535a\u670d\u52a1\u9a8c\u8bc1\u7528\u6237,isAdmin=" + user.isAdmin()));
                return user.getId();
            }
        }
        catch (WeiboException e) {
            logger.error((Object)("\u5fae\u535a\u670d\u52a1\u9a8c\u8bc1\u7528\u6237\u5931\u8d25\uff0cemail:" + email), (Throwable)e);
        }
        return null;
    }

    private boolean isAdminWeiboUser(Context ctx, String email) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            User user = weibo.verifyCredentials();
            if (user != null) {
                logger.info((Object)("\u5fae\u535a\u670d\u52a1\u9a8c\u8bc1\u7528\u6237,isAdmin=" + user.isAdmin()));
                return user.isAdmin();
            }
        }
        catch (WeiboException e) {
            logger.error((Object)("\u5fae\u535a\u670d\u52a1\u9a8c\u8bc1\u7528\u6237\u5931\u8d25\uff0cemail:" + email), (Throwable)e);
        }
        return false;
    }

    @Override
    protected String _getWeiboIdbyPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        String[] weiboIds = this.getWeiboInfoByPersonId(ctx, personId);
        if (weiboIds != null && !StringUtils.isEmpty((String)weiboIds[0])) {
            return weiboIds[0];
        }
        return this.getWeiboUserId(ctx, weiboIds[1]);
    }

    protected String getWeiboIdsbyPersonIds(Context ctx, String personIds) throws BOSException, EASBizException {
        String weiboIds = "";
        String[] personIdArray = personIds.split(";");
        if (personIdArray.length < 1) {
            return null;
        }
        for (int i = 0; i < personIdArray.length - 1; ++i) {
            String weiboId = this._getWeiboIdbyPersonId(ctx, personIdArray[i]);
            if (StringUtils.isEmpty((String)weiboId)) continue;
            weiboIds = weiboIds + weiboId + ";";
        }
        String weiboId = this._getWeiboIdbyPersonId(ctx, personIdArray[personIdArray.length - 1]);
        if (StringUtils.isEmpty((String)weiboId)) {
            return weiboIds;
        }
        weiboIds = weiboIds + weiboId;
        return weiboIds;
    }

    private String[] getWeiboInfoByPersonId(Context ctx, String personId) throws BOSException {
        String[] weiboIds = null;
        try {
            weiboIds = WeiboAppDAO.getWeiboInfoByPersonId(ctx, personId);
        }
        catch (SQLException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u5fae\u535a\u8d26\u53f7\u51fa\u9519\uff0cpersonId:" + personId), (Throwable)e);
        }
        return weiboIds;
    }

    private String[] getWeiboInfoByUserId(Context ctx, String userId) throws BOSException {
        String[] weiboIds = null;
        try {
            weiboIds = WeiboAppDAO.getWeiboInfoByUserId(ctx, userId);
        }
        catch (SQLException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u5fae\u535a\u8d26\u53f7\u51fa\u9519\uff0cuserId:" + userId), (Throwable)e);
        }
        return weiboIds;
    }

    @Override
    protected boolean _addBillConfig(Context ctx, String bosType, String desc) throws BOSException, EASBizException {
        try {
            WeiboAppDAO.addWeiboBillConfig(ctx, bosType, desc);
            return true;
        }
        catch (SQLException e) {
            logger.error((Object)("\u65b0\u589e\u5355\u636e\u914d\u7f6e\u51fa\u9519\uff0cbosType:" + bosType), (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _deleteBillConfig(Context ctx, String configId) throws BOSException, EASBizException {
        try {
            WeiboAppDAO.deleteWeiboBillConfig(ctx, configId);
            return true;
        }
        catch (SQLException e) {
            logger.error((Object)("\u5220\u9664\u5355\u636e\u914d\u7f6e\u51fa\u9519\uff0cconfigId:" + configId), (Throwable)e);
            return false;
        }
    }

    @Override
    protected Map _getBillConfigListInfo(Context ctx, int start, int size) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int count = WeiboAppDAO.countWeiboBillConfig(ctx);
            if (count > 0) {
                map.put("count", count);
                List list = WeiboAppDAO.getWeiboBillConfigList(ctx, start, size);
                map.put("result", list);
                return map;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5355\u636e\u914d\u7f6e\u5217\u8868\u51fa\u9519", (Throwable)e);
        }
        map.put("count", 0);
        map.put("result", new ArrayList());
        return map;
    }

    @Override
    protected Map _getBindPersonList(Context ctx, int start, int size) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int count = WeiboAppDAO.countWeiboBindPerson(ctx);
            if (count > 0) {
                map.put("count", count);
                List<WeiboBindPersonInfo> list = WeiboAppDAO.getWeiboBindPersonList(ctx, start, size);
                map.put("result", list);
                return map;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u5355\u636e\u914d\u7f6e\u5217\u8868\u51fa\u9519", (Throwable)e);
        }
        map.put("count", 0);
        map.put("result", new ArrayList());
        return map;
    }

    @Override
    protected String _getAdminEmail(Context ctx) throws BOSException, EASBizException {
        try {
            String[] admin = WeiboAppDAO.getWeiboAdminToken(ctx);
            return admin[0];
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u7ba1\u7406\u5458\u90ae\u7bb1\u8d26\u53f7\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean _batchCreateWeiboUser(Context ctx, int size) throws BOSException, EASBizException {
        String domain = this._getDomain(ctx);
        if (StringUtils.isEmpty((String)domain)) {
            logger.error((Object)"EAS\u91d1\u8776\u5fae\u535a\u7ed1\u5b9a\u57df\u540d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6279\u91cf\u521b\u5efa\u5fae\u535a\u7528\u6237");
            return false;
        }
        HashSet<String> emailSet = new HashSet<String>();
        IRowSet rs = WeiboAppDAO.getUnCreatedPersonSet(ctx, domain, size);
        try {
            Weibo adminWeibo = this.getAdminWeibo(ctx);
            while (rs.next()) {
                String id = rs.getString("personId");
                String name = rs.getString("personName");
                String email = rs.getString("email");
                String position = rs.getString("position");
                String org = rs.getString("org");
                if (emailSet.contains(email)) continue;
                User user = null;
                try {
                    user = adminWeibo.createUnVerifiedUser(email, StringUtils.cnulls((String)name), StringUtils.cnulls((String)org), StringUtils.cnulls((String)position));
                    emailSet.add(email);
                }
                catch (Exception e) {
                    logger.error((Object)("\u91d1\u8776\u5fae\u535a\u521b\u5efa\u672a\u8ba4\u8bc1\u8d26\u53f7\u51fa\u9519\uff0c\u804c\u5458\u540d\uff1a" + name + "\uff0c \u90ae\u7bb1\uff1a" + email));
                    logger.error((Object)e.getMessage());
                }
                if (user == null) continue;
                WeiboAppDAO.registerMapping(ctx, email, id, user.getId());
            }
            return true;
        }
        catch (SQLException e) {
            logger.error((Object)"\u6279\u91cf\u521b\u5efa\u5fae\u535a\u7528\u6237\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    protected Map _getUnreadCount(Context ctx) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        String personId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)personId)) {
            return null;
        }
        String email = null;
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, personId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            countMap.put("comments", Integer.valueOf("0"));
            countMap.put("dm", Integer.valueOf("0"));
            countMap.put("followers", Integer.valueOf("0"));
            countMap.put("mentions", Integer.valueOf("0"));
            countMap.put("rt", Integer.valueOf("0"));
            return countMap;
        }
        email = weiboInfo[1];
        return this.getWeiboUnread(ctx, email);
    }

    private Map getWeiboUnread(Context ctx, String email) {
        if (StringUtils.isEmpty((String)email)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            Count count = weibo.getUnread();
            if (count != null) {
                HashMap<String, Integer> countMap = new HashMap<String, Integer>();
                countMap.put("comments", Integer.valueOf(count.getComments() + ""));
                countMap.put("dm", Integer.valueOf(count.getDm() + ""));
                countMap.put("followers", Integer.valueOf(count.getFollowers() + ""));
                countMap.put("mentions", Integer.valueOf(count.getMentions() + ""));
                countMap.put("rt", Integer.valueOf(count.getRt() + ""));
                return countMap;
            }
        }
        catch (WeiboException e) {
            logger.error((Object)("\u5fae\u535a\u670d\u52a1\u83b7\u53d6\u672a\u8bfb\u6761\u6570\u5931\u8d25\uff0cemail:" + email), (Throwable)e);
        }
        catch (JSONException e) {
            logger.error((Object)("\u5fae\u535a\u670d\u52a1\u83b7\u53d6\u672a\u8bfb\u6761\u6570\u8f6c\u6362JSON\u6570\u636e\u5931\u8d25\uff0cemail:" + email), (Throwable)e);
        }
        return null;
    }

    private String createWeiboUser(Context ctx) throws EASBizException, BOSException {
        String domain;
        String email = this._getEmailbyUserId(ctx, ctx.getCaller().toString());
        if (!this.isEmailInDomain(email = email.trim(), domain = this._getDomain(ctx))) {
            return null;
        }
        String weiboUserId = this.createUnverifiedWeiboUser(ctx, email);
        if (StringUtils.isEmpty((String)weiboUserId)) {
            return null;
        }
        return email;
    }

    private boolean isEmailInDomain(String email, String domain) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        return email.endsWith("@" + domain);
    }

    @Override
    protected boolean _deleteBindEamil(Context ctx) throws BOSException, EASBizException {
        String personId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)personId)) {
            return false;
        }
        WeiboAppDAO.deleteBindMapping(ctx, personId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _sendDirectMessage(Context ctx, String personId, String content) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personId)) {
            return false;
        }
        String currPersonId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)currPersonId)) {
            return false;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, currPersonId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        String weiboUserId = this._getWeiboIdbyPersonId(ctx, personId);
        if (StringUtils.isEmpty((String)weiboUserId)) {
            logger.error((Object)"\u63a5\u6536\u77ed\u90ae\u7684\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            logger.info((Object)("\u53d1\u9001\u77ed\u90ae\uff0cfrom email\uff1a" + email + " to weiboUserId: " + weiboUserId));
            DirectMessage dm = weibo.sendDirectMessage(weiboUserId, content);
            boolean bl = dm != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u77ed\u90ae\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    @Override
    protected String _getWeiboSystemUrl(Context ctx) throws BOSException, EASBizException {
        String weiboSystemUrl = WeiboGlobal.getWeiboUrl(ctx);
        return weiboSystemUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _uploadDirectMessage(Context ctx, String personIds, String content, byte[] fileBytes, String fileName) throws BOSException, EASBizException {
        WeiboAccessInfo accessInfo;
        if (StringUtils.isEmpty((String)personIds)) {
            return false;
        }
        String currPersonId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)currPersonId)) {
            return false;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, currPersonId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        String weiboIds = this.getWeiboIdsbyPersonIds(ctx, personIds);
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            accessInfo = WeiboAppDAO.getAccessInfo(ctx, currPersonId);
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6AccessToken\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            accessInfo = new WeiboAccessInfo();
        }
        weibo.setToken(accessInfo.getToken(), TokenSecureUtil.decode(accessInfo.getTokenSecret()));
        logger.info((Object)("_uploadDirectMessage,token:" + accessInfo.getToken() + " ,TokenSecret: " + accessInfo.getTokenSecret()));
        try {
            logger.info((Object)("\u53d1\u9001\u5e26\u9644\u4ef6\u77ed\u90ae\uff0cfrom email\uff1a" + email + " to weiboUserIds: " + weiboIds));
            String fileDir = System.getProperty("java.io.tmpdir");
            File file = this.saveFile(fileBytes, fileDir, fileName);
            DirectMessage dm = weibo.uploadDirectMessage(weiboIds, content, file);
            boolean bl = dm != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u5e26\u9644\u4ef6\u77ed\u90ae\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u5e26\u9644\u4ef6\u77ed\u90ae,\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveFile(byte[] fileBytes, String fileDir, String fileName) throws IOException {
        if (!fileDir.endsWith("\\") && !fileDir.endsWith("/")) {
            fileDir = fileDir + "/";
        }
        File file = new File(fileDir + fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(fileBytes);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _updateStatus(Context ctx, String content) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return false;
        }
        String personId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)personId)) {
            return false;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, personId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        Weibo weibo = this.getWeiboNoToken(ctx);
        weibo.setUserId(email);
        try {
            Status status = weibo.updateStatus(content);
            boolean bl = status != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u53d1\u9001\u5fae\u535a\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _updateStatus4Community(Context ctx, String content) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return false;
        }
        String personId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)personId)) {
            return false;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, personId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        weibo.switch2CommunityWeibo();
        try {
            Status status = weibo.updateStatus(content);
            boolean bl = status != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u53d1\u9001\u5fae\u535a\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            weibo.switch2CommonWeibo();
            weibo = null;
        }
        return false;
    }

    @Override
    protected List _batchCreateWeiboUserAndToken(Context ctx) throws BOSException {
        ArrayList<String> errorList = new ArrayList<String>();
        try {
            String domain = this._getDomain(ctx);
            if (StringUtils.isEmpty((String)domain)) {
                logger.error((Object)"EAS\u91d1\u8776\u5fae\u535a\u7ed1\u5b9a\u57df\u540d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6279\u91cf\u521b\u5efa\u5fae\u535a\u7528\u6237");
                return null;
            }
            HashSet<String> emailSet = new HashSet<String>();
            IRowSet rs = WeiboAppDAO.getUnCreatedPersonSet(ctx, domain, 30000);
            Weibo adminWeibo = this.getAdminWeibo(ctx);
            while (rs.next()) {
                String id = rs.getString("personId");
                String name = rs.getString("personName");
                String email = rs.getString("email");
                String position = rs.getString("position");
                String org = rs.getString("org");
                if (emailSet.contains(email)) continue;
                try {
                    boolean isExist = adminWeibo.userExists(email);
                    if (isExist) {
                        UserTokenList userTokenList = adminWeibo.batchGetAccessToken(email);
                        if (userTokenList != null && userTokenList.items != null && userTokenList.items.size() > 0) {
                            UserTokenList.TokenItem item = userTokenList.items.get(0);
                            if (item.tokenString != null && !item.tokenString.equals("")) {
                                WeiboAppDAO.bindMappingWithToken(ctx, email, id, item.userId, item.tokenString, TokenSecureUtil.encode(item.tokenSecret));
                            }
                        }
                    } else {
                        UserAndToken userAndToken = adminWeibo.createUserAndToken(email, StringUtils.cnulls((String)name), StringUtils.cnulls((String)org), StringUtils.cnulls((String)position));
                        if (userAndToken != null && userAndToken.user != null) {
                            WeiboAppDAO.bindMappingWithToken(ctx, email, id, userAndToken.user.getId(), userAndToken.tokenString, TokenSecureUtil.encode(userAndToken.tokenTokenSecret));
                        }
                    }
                    emailSet.add(email);
                }
                catch (Exception e) {
                    logger.error((Object)("\u91d1\u8776\u5fae\u535a\u521b\u5efa\u7528\u6237\u5e76\u751f\u6210accessToken\u51fa\u9519\uff0c\u804c\u5458\u540d\uff1a" + name + "\uff0c \u90ae\u7bb1\uff1a" + email));
                    errorList.add(id);
                    logger.error((Object)e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u6279\u91cf\u521b\u5efa\u5fae\u535a\u7528\u6237\u5e76\u751f\u6210accessToken\u5931\u8d25", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"\u6279\u91cf\u521b\u5efa\u5fae\u535a\u7528\u6237\u5e76\u751f\u6210accessToken,\u83b7\u53d6EAS\u91d1\u8776\u5fae\u535a\u7ed1\u5b9a\u57df\u540d\u5931\u8d25", (Throwable)e);
        }
        return errorList;
    }

    @Override
    protected boolean _adminCreateUnverifiedWeiboUser(Context ctx, String email, String personId) throws BOSException {
        String name = "";
        String department = "";
        String jobTitle = "";
        try {
            WeiboPreCreateUserInfo info;
            PersonRegisterInfo personInfo = WeiboAppDAO.getPeronInfoByPersonId(ctx, personId);
            if (personInfo != null) {
                name = personInfo.getName();
            }
            if ((info = this.getWeiboPreCreateUserInfo(ctx, personId)) != null) {
                department = info.getDepartment();
                jobTitle = info.getJobTitle();
            }
        }
        catch (SQLException e2) {
            logger.error((Object)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u76f8\u5173\u7684\u804c\u5458\u4fe1\u606f\u51fa\u9519", (Throwable)e2);
        }
        Weibo adminWeibo = this.getAdminWeibo(ctx);
        UserAndToken userAndToken = null;
        try {
            userAndToken = adminWeibo.createUserAndToken(email, StringUtils.cnulls((String)name), StringUtils.cnulls((String)department), StringUtils.cnulls((String)jobTitle));
        }
        catch (WeiboException e) {
            logger.error((Object)("\u91d1\u8776\u5fae\u535a\u521b\u5efa\u7528\u6237\u5e76\u751f\u6210accessToken\u51fa\u9519\uff0c\u804c\u5458\u540d\uff1a" + name + "\uff0c \u90ae\u7bb1\uff1a" + email));
            return false;
        }
        if (userAndToken != null && userAndToken.user != null) {
            WeiboAppDAO.bindMappingWithToken(ctx, email, personId, userAndToken.user.getId(), userAndToken.tokenString, TokenSecureUtil.encode(userAndToken.tokenTokenSecret));
        }
        return true;
    }

    @Override
    protected String _getWeiboCommentUrl(Context ctx) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        WeiboPrepareInfo info = this._getPrepareInfo(ctx);
        String weiboUrl = "http://" + this._getWeiboUrl(ctx) + "/activity/reply?appKey=" + this._getAppKey(ctx) + "&t=p";
        try {
            weiboUrl = this.getLoginUrl(ctx, "/activity/reply?appKey=" + this._getAppKey(ctx) + "&t=p", info.getLoginToken());
        }
        catch (Exception e) {
            logger.error((Object)"_getWeiboCommentUrl error", (Throwable)e);
        }
        logger.info((Object)("_getWeiboCommentUrl:" + weiboUrl));
        return weiboUrl;
    }

    @Override
    protected String _getWeiboMentionUrl(Context ctx) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        WeiboPrepareInfo info = this._getPrepareInfo(ctx);
        String weiboUrl = "http://" + this._getWeiboUrl(ctx) + "/activity/atme?appKey=" + this._getAppKey(ctx) + "&t=p";
        try {
            weiboUrl = this.getLoginUrl(ctx, "/activity/atme?appKey=" + this._getAppKey(ctx) + "&t=p", info.getLoginToken());
        }
        catch (Exception e) {
            logger.error((Object)"_getWeiboMentionUrl error", (Throwable)e);
        }
        logger.info((Object)("_getWeiboMentionUrl:" + weiboUrl));
        return weiboUrl;
    }

    @Override
    protected String _getWeiboMySendUrl(Context ctx) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        WeiboPrepareInfo info = this._getPrepareInfo(ctx);
        String weiboUrl = "http://" + this._getWeiboUrl(ctx) + "/activity/?appKey=" + this._getAppKey(ctx) + "&t=p";
        try {
            weiboUrl = this.getLoginUrl(ctx, "/activity/?appKey=" + this._getAppKey(ctx) + "&t=p", info.getLoginToken());
        }
        catch (Exception e) {
            logger.error((Object)"_getWeiboMySendUrl error", (Throwable)e);
        }
        logger.info((Object)("_getWeiboMySendUrl:" + weiboUrl));
        return weiboUrl;
    }

    @Override
    protected boolean _bindNoPerson(Context ctx, String email, String psw, String userId) throws BOSException {
        AccessToken token = this.getWeiboToken(ctx, email = email.trim(), psw);
        if (token == null || StringUtils.isEmpty((String)token.getToken())) {
            return false;
        }
        String weiboUserId = this.getWeiboUserId(ctx, email);
        if (userId == null) {
            userId = "";
        }
        WeiboAppDAO.bindMapping(ctx, email, userId, weiboUserId, token.getToken(), TokenSecureUtil.encode(token.getTokenSecret()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _sendDirectMessageNoPerson(Context ctx, String userId, String personId, String content) throws BOSException, EASBizException {
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, userId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        String weiboUserId = this._getWeiboIdbyPersonId(ctx, personId);
        if (StringUtils.isEmpty((String)weiboUserId)) {
            logger.error((Object)"\u63a5\u6536\u77ed\u90ae\u7684\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            logger.info((Object)("\u53d1\u9001\u77ed\u90ae\uff0cfrom email\uff1a" + email + " to weiboUserId: " + weiboUserId));
            DirectMessage dm = weibo.sendDirectMessage(weiboUserId, content);
            boolean bl = dm != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u77ed\u90ae\u5931\u8d25\uff08\u6ca1\u6709\u804c\u5458\uff09\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    @Override
    protected String _getLocalWeiboIdByPersonId(Context ctx, String personId) throws BOSException {
        String[] weiboIds = this.getWeiboInfoByPersonId(ctx, personId);
        if (weiboIds != null && !StringUtils.isEmpty((String)weiboIds[0])) {
            return weiboIds[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _adminSendDirectMessage(Context ctx, String personId, String content) throws BOSException, EASBizException {
        String weiboUserId = this._getWeiboIdbyPersonId(ctx, personId);
        if (StringUtils.isEmpty((String)weiboUserId)) {
            logger.error((Object)"\u63a5\u6536\u77ed\u90ae\u7684\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        Weibo weibo = this.getAdminWeibo(ctx);
        try {
            logger.info((Object)("\u7ba1\u7406\u5458\u53d1\u9001\u77ed\u90ae\uff0cfrom email\uff1a" + weibo.getUserId() + " to weiboUserId: " + weiboUserId));
            DirectMessage dm = weibo.sendDirectMessage(weiboUserId, content);
            boolean bl = dm != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u77ed\u90ae\u5931\u8d25\uff08\u7ba1\u7406\u5458\uff09\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected User _getWeiboUser(Context ctx, String userId) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        String[] weiboInfo = this.getWeiboInfoByUserId(ctx, userId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return null;
        }
        String email = weiboInfo[1];
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            User user;
            User user2 = user = weibo.showUser(weiboUserId);
            return user2;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u901a\u8fc7userId\u83b7\u53d6\u5fae\u535aUser\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return null;
    }

    @Override
    protected String _getWeiboFocusUrl(Context ctx) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        WeiboPrepareInfo info = this._getPrepareInfo(ctx);
        String weiboUrl = "http://" + this._getWeiboUrl(ctx) + "/activity/follow?appKey=" + this._getAppKey(ctx) + "&t=p";
        try {
            weiboUrl = this.getLoginUrl(ctx, "/activity/follow?appKey=" + this._getAppKey(ctx) + "&t=p", info.getLoginToken());
        }
        catch (Exception e) {
            logger.error((Object)"_getWeiboFocusUrl error", (Throwable)e);
        }
        logger.info((Object)("_getWeiboFocusUrl:" + weiboUrl));
        return weiboUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _sendDirectMessageByWeiboId(Context ctx, String weiboIds, String content) throws BOSException, EASBizException {
        String currPersonId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)currPersonId)) {
            return false;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, currPersonId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            logger.info((Object)("\u53d1\u9001\u77ed\u90ae\uff0cfrom email\uff1a" + email + " to weiboUserId: " + weiboIds));
            DirectMessage dm = weibo.sendDirectMessage(weiboIds, content);
            boolean bl = dm != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u77ed\u90ae\u5931\u8d25.\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _uploadDirectMessageByWeiboId(Context ctx, String weiboIds, String content, byte[] file, String fileName) throws BOSException, EASBizException {
        WeiboAccessInfo accessInfo;
        String currPersonId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)currPersonId)) {
            return false;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, currPersonId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            accessInfo = WeiboAppDAO.getAccessInfo(ctx, currPersonId);
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6AccessToken\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            accessInfo = new WeiboAccessInfo();
        }
        weibo.setToken(accessInfo.getToken(), TokenSecureUtil.decode(accessInfo.getTokenSecret()));
        logger.info((Object)("_uploadDirectMessage,token:" + accessInfo.getToken() + " ,TokenSecret: " + accessInfo.getTokenSecret()));
        try {
            logger.info((Object)("\u53d1\u9001\u5e26\u9644\u4ef6\u77ed\u90ae\uff0cfrom email\uff1a" + email + " to weiboUserIds: " + weiboIds));
            String fileDir = System.getProperty("java.io.tmpdir");
            File f = this.saveFile(file, fileDir, fileName);
            DirectMessage dm = weibo.uploadDirectMessage(weiboIds, content, f);
            boolean bl = dm != null;
            return bl;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u5e26\u9644\u4ef6\u77ed\u90ae\u5931\u8d25.\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u5e26\u9644\u4ef6\u77ed\u90ae,\u521b\u5efa\u6587\u4ef6\u5931\u8d25.\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    @Override
    protected String _getLocalWeiboIdByUserId(Context ctx, String userId) throws BOSException {
        String[] weiboIds = this.getWeiboInfoByUserId(ctx, userId);
        if (weiboIds != null && !StringUtils.isEmpty((String)weiboIds[0])) {
            return weiboIds[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected User _getWeiboUserByWeiboId(Context ctx, String weiboUserId) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        String currPersonId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)currPersonId)) {
            return null;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, currPersonId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return null;
        }
        String email = weiboInfo[1];
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            User user;
            User user2 = user = weibo.showUser(weiboUserId);
            return user2;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u901a\u8fc7weiboUserId\u83b7\u53d6\u5fae\u535aUser\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return null;
    }

    @Override
    protected String _getWeiboAllGroupUrl(Context ctx) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        WeiboPrepareInfo info = this._getPrepareInfo(ctx);
        String weiboUrl = "http://" + this._getWeiboUrl(ctx) + "/group/mine";
        try {
            weiboUrl = this.getLoginUrl(ctx, "/group/mine", info.getLoginToken());
        }
        catch (Exception e) {
            logger.error((Object)"_getWeiboAllGroupUrl error", (Throwable)e);
        }
        logger.info((Object)("_getWeiboAllGroupUrl:" + weiboUrl));
        return weiboUrl;
    }

    @Override
    protected String _getWeiboGroupUrl(Context ctx, String groupId) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        WeiboPrepareInfo info = this._getPrepareInfo(ctx);
        String weiboUrl = "http://" + this._getWeiboUrl(ctx) + "/group/" + groupId + "/home";
        try {
            weiboUrl = this.getLoginUrl(ctx, "/group/" + groupId + "/home", info.getLoginToken());
        }
        catch (Exception e) {
            logger.error((Object)"_getWeiboGroupUrl error", (Throwable)e);
        }
        logger.info((Object)("_getWeiboGroupUrl:" + weiboUrl));
        return weiboUrl;
    }

    private String getLoginUrl(Context ctx, String widgetUrl, String lgtk) throws Exception {
        StringBuilder url = new StringBuilder("http://" + this._getWeiboUrl(ctx) + "/snsapi/oauth/login?lgtk=");
        url.append(URLEncoder.encode(lgtk, "UTF-8"));
        url.append("&to=");
        url.append(URLEncoder.encode(widgetUrl, "UTF-8"));
        return url.toString();
    }

    @Override
    protected String _getWeiboGroupUrl2(Context ctx, String groupId, String domain) throws BOSException, EASBizException {
        if (!this._isWeiboEnable(ctx)) {
            return null;
        }
        WeiboPrepareInfo info = this._getPrepareInfo(ctx);
        String weiboUrl = "http://" + this._getWeiboUrl(ctx) + "/group/" + groupId + "/home";
        try {
            StringBuilder url = new StringBuilder("http://" + this._getWeiboUrl(ctx) + "/snsapi/oauth/login?lgtk=");
            url.append(URLEncoder.encode(info.getLoginToken(), "UTF-8"));
            url.append("&toNetwork=");
            url.append(URLEncoder.encode(domain, "UTF-8"));
            url.append("&to=");
            url.append(URLEncoder.encode("/group/" + groupId + "/home", "UTF-8"));
            weiboUrl = url.toString();
        }
        catch (Exception e) {
            logger.error((Object)"_getWeiboGroupUrl error", (Throwable)e);
        }
        logger.info((Object)("_getWeiboGroupUrl:" + weiboUrl));
        return weiboUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _sendDirectMessageByWeiboId2(Context ctx, String weiboIds, String content, boolean sendMail) throws BOSException, EASBizException {
        String currPersonId = this.getCurrentPersonId(ctx);
        if (StringUtils.isEmpty((String)currPersonId)) {
            return false;
        }
        String[] weiboInfo = this.getWeiboInfoByPersonId(ctx, currPersonId);
        if (weiboInfo == null || StringUtils.isEmpty((String)weiboInfo[1])) {
            logger.error((Object)"\u5f53\u524d\u804c\u5458\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed1\u5b9a\u90ae\u7bb1\u8d26\u53f7");
            return false;
        }
        String email = weiboInfo[1];
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            logger.info((Object)("\u53d1\u9001\u77ed\u90ae\uff0cfrom email\uff1a" + email + " to weiboUserId: " + weiboIds + ",sendMail=" + sendMail));
            if (weiboIds != null && !"".equals(weiboIds)) {
                String[] weibos = weiboIds.split(",");
                for (int i = 0; weibos != null && i < weibos.length; ++i) {
                    if (weiboInfo[0].equals(weibos[i])) continue;
                    DirectMessage directMessage = weibo.sendDirectMessage(weibos[i], content, sendMail);
                }
            }
            boolean weibos = true;
            return weibos;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u91d1\u8776\u5fae\u535a\u670d\u52a1\u53d1\u9001\u77ed\u90ae\u5931\u8d25.\uff01", (Throwable)e);
        }
        finally {
            weibo = null;
        }
        return false;
    }

    @Override
    protected String _getEasLoginName(Context ctx, String weiboId) throws BOSException {
        try {
            return WeiboAppDAO.getUserNameByWeiboId(ctx, weiboId);
        }
        catch (SQLException e) {
            logger.error((Object)("\u6839\u636e\u5fae\u535aId\u83b7\u53d6EAS\u767b\u5f55\u7528\u6237\u51fa\u9519:" + weiboId), (Throwable)e);
            return null;
        }
    }
}

