/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.ActivityComment;
import weibo4j.Picture;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Activity
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 4069573686251578633L;
    public String id;
    public String type;
    public String title;
    public String verb;
    public Date published;
    public Date updated;
    public String ownerId;
    public String ownerName;
    public String target;
    public List<ActivityComment> comments;
    public List<Picture> pictures;
    public int commentCount;
    public String content;

    Activity(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONObject actorJson;
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.type = json.getString("type");
            this.published = new Date(json.getLong("published"));
            this.updated = new Date(json.getLong("updated"));
            this.title = json.getString("title");
            this.verb = json.getString("verb");
            this.title = json.getString("title");
            JSONObject targetJson = json.getJSONObject("target");
            if (targetJson != null) {
                this.target = targetJson.getString("id");
            }
            if ((actorJson = json.getJSONObject("actor")) != null) {
                this.ownerId = actorJson.getString("id");
                this.ownerName = actorJson.getString("name");
            }
            this.commentCount = json.getInt("commentCount");
            if (json.get("comments") instanceof JSONArray) {
                JSONArray commentsJsonList = json.getJSONArray("comments");
                this.comments = ActivityComment.constructList(commentsJsonList);
            }
            if (json.get("attachments") instanceof JSONArray) {
                JSONArray picturesJsonList = json.getJSONArray("attachments");
                this.pictures = Picture.constructList(picturesJsonList);
            }
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    Activity(JSONObject json) throws WeiboException {
        try {
            JSONObject actorJson;
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.type = json.getString("type");
            this.published = new Date(json.getLong("published"));
            this.updated = new Date(json.getLong("updated"));
            this.title = json.getString("title");
            this.verb = json.getString("verb");
            this.title = json.getString("title");
            JSONObject targetJson = json.getJSONObject("target");
            if (targetJson != null) {
                this.target = targetJson.getString("id");
            }
            if ((actorJson = json.getJSONObject("actor")) != null) {
                this.ownerId = actorJson.getString("id");
                this.ownerName = actorJson.getString("name");
            }
            this.commentCount = json.getInt("commentCount");
            if (json.get("comments") instanceof JSONArray) {
                JSONArray commentsJsonList = json.getJSONArray("comments");
                this.comments = ActivityComment.constructList(commentsJsonList);
            }
            if (json.get("attachments") instanceof JSONArray) {
                JSONArray picturesJsonList = json.getJSONArray("attachments");
                this.pictures = Picture.constructList(picturesJsonList);
            }
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    static List<Activity> constructList(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<Activity> activities = new ArrayList<Activity>(size);
            for (int i = 0; i < size; ++i) {
                activities.add(new Activity(list.getJSONObject(i)));
            }
            return activities;
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + list.toString(), je);
        }
    }
}

