/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class ActivityComment
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -4767165400814896586L;
    public String id;
    public String ownerId;
    public String ownerName;
    public String content;
    public Date published;
    public String replyCommentId;
    public String replyUserId;

    ActivityComment(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.published = new Date(json.getLong("sendTime"));
            this.ownerId = json.getString("ownerId");
            this.ownerName = json.getString("ownerName");
            this.replyCommentId = json.getString("commentId");
            this.replyUserId = json.getString("repliedOwnerId");
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    ActivityComment(JSONObject json) throws WeiboException {
        try {
            this.id = json.getString("id");
            this.content = json.getString("content");
            this.published = new Date(json.getLong("sendTime"));
            this.ownerId = json.getString("ownerId");
            this.ownerName = json.getString("ownerName");
            this.replyCommentId = json.getString("commentId");
            this.replyUserId = json.getString("repliedOwnerId");
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    public static List<ActivityComment> constructList(JSONArray commentsJsonList) throws WeiboException, JSONException {
        if (commentsJsonList != null) {
            int size = commentsJsonList.length();
            ArrayList<ActivityComment> comments = new ArrayList<ActivityComment>(size);
            for (int i = 0; i < size; ++i) {
                comments.add(new ActivityComment(commentsJsonList.getJSONObject(i)));
            }
            return comments;
        }
        return null;
    }
}

