/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class UserTokenList
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -5554226687946678110L;
    public List<TokenItem> items;

    UserTokenList(Response res) throws WeiboException {
        super(res);
        JSONArray jsonArray = res.asJSONArray();
        int size = jsonArray.length();
        this.items = new ArrayList<TokenItem>(size);
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                this.items.add(new TokenItem(jsonObject));
                continue;
            }
            catch (JSONException je) {
                throw new WeiboException(je.getMessage() + ":" + jsonArray.toString(), je);
            }
        }
    }

    public static class TokenItem
    extends WeiboResponse
    implements Serializable {
        public String tokenString;
        public String tokenSecret;
        public String email;
        public String userId;
        public int state;
        public String msg;
        private static final long serialVersionUID = 2363066731828713162L;

        TokenItem(JSONObject json) throws WeiboException {
            try {
                this.email = json.getString("email");
                this.userId = json.getString("userId");
                this.state = json.getInt("result");
                if (this.state == 1) {
                    this.tokenString = json.getString("tokenString");
                    this.tokenSecret = json.getString("tokenSecret");
                } else {
                    this.msg = json.getString("msg");
                }
            }
            catch (JSONException je) {
                throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
            }
        }
    }
}

