/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.wssc.ImageLogFactory;
import com.kingdee.eas.base.wssc.ImageLogInfo;
import com.kingdee.eas.base.wssc.ImageOperation;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ClearImageLog {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.ClearImageLog");
    private int days = 15;

    protected void _dumpData(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = DBUtils.getConnection((Context)ctx);
            CoreBaseCollection list = this.getImageLogIDs(cn);
            if (list.isEmpty()) {
                logger.info((Object)"Finish dump imageLog, total 0 records.");
                return;
            }
            this.clearDirtyLogDataBatch(cn);
            this.transferImageLogDataBatch(ctx, list);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreBaseCollection getImageLogIDs(Connection cn) throws SQLException {
        CoreBaseCollection result = new CoreBaseCollection();
        ImageLogInfo logInfo = null;
        String tSql = " SELECT FID,FIMAGENO,FOPERATION,FSUCCESS,FPARAM,FRESPONSE,FEXCEPTION FROM T_WSC_IMAGELOG WHERE FSUCCESS = 0 AND DATEDIFF(Day,FCREATETIME,GETDATE()) <= " + this.days;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = cn.prepareStatement(tSql);
            rs = ps.executeQuery();
            while (rs.next()) {
                logInfo = new ImageLogInfo();
                logInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                logInfo.setImageNo(rs.getString("FIMAGENO"));
                logInfo.setOperation(ImageOperation.getEnum(rs.getString("FOPERATION")));
                logInfo.setSuccess(rs.getBoolean("FSUCCESS"));
                logInfo.setParam(rs.getString("FPARAM"));
                logInfo.setException(rs.getString("FEXCEPTION"));
                result.add((CoreBaseInfo)logInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDirtyLogDataBatch(Connection cn) throws SQLException {
        try (PreparedStatement ps = null;){
            String sql = " TRUNCATE TABLE T_WSC_IMAGELOG ";
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }

    private void transferImageLogDataBatch(Context ctx, CoreBaseCollection colls) throws EASBizException, BOSException {
        logger.error((Object)("colls.size\uff1a" + colls.size()));
        ImageLogFactory.getLocalInstance(ctx).addnewBatchData(colls);
    }
}

