/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.imageNew.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.wssc.imageNew.util.MultiImageConfig;
import java.io.IOException;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class DKWSLinuxUtils {
    private static Logger logger = Logger.getLogger(DKWSLinuxUtils.class);

    public static String assertResponseCode(Context ctx, String imageSysId, String url, Object params) throws Exception {
        HashMap<String, Object> hashMap = DKWSLinuxUtils.doPost(ctx, imageSysId, url, params);
        String errorCode = (String)hashMap.get("errorCode");
        if (!"1".equals(errorCode)) {
            throw new SSCException(SSCException.UNKNOW, new Object[]{"\u9519\u8bef\u7801\u4e3a\uff1a" + errorCode + "\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + hashMap.get("errorText")});
        }
        return errorCode;
    }

    public static String getResponseCode(Context ctx, String imageSysId, String url, Object params) throws Exception {
        HashMap<String, Object> hashMap = DKWSLinuxUtils.doPost(ctx, imageSysId, url, params);
        String errorCode = (String)hashMap.get("errorCode");
        return errorCode;
    }

    public static String getResponseBody(Context ctx, String imageSysId, String url, Object params) throws Exception {
        HashMap<String, Object> hashMap = DKWSLinuxUtils.doPost(ctx, imageSysId, url, params);
        String errorText = (String)hashMap.get("errorText");
        return errorText;
    }

    public static HashMap<String, Object> doPost(Context ctx, String imageSysId, String url, Object paramsObj) throws Exception {
        url = "http://" + MultiImageConfig.getPropertiesValue(ctx, imageSysId, "image.ip").trim() + ":" + MultiImageConfig.getPropertiesValue(ctx, imageSysId, "image.port").trim() + url;
        String params = JSONUtils.convertObjectToJson((Context)ctx, (Object)paramsObj);
        String responseStr = DKWSLinuxUtils.postInterface(url, params, true);
        HashMap hashMap = JSONUtils.convertJsonToObject((Context)ctx, (String)responseStr);
        return hashMap;
    }

    public static String postInterface(String url, String params, boolean outPutLog) throws Exception {
        if (outPutLog) {
            logger.error((Object)("url[" + url + "]--params[" + params + "]"));
        } else {
            logger.debug((Object)("url[" + url + "]--params[" + params + "]"));
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity("InputJson=" + params, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (outPutLog) {
                logger.error((Object)("response--state:" + state));
            } else {
                logger.debug((Object)("response--state:" + state));
            }
            HttpEntity responseEntity = response.getEntity();
            String jsonString = EntityUtils.toString((HttpEntity)responseEntity, (String)charSet);
            if (outPutLog) {
                logger.error((Object)("response--jsonString:" + jsonString));
            } else {
                logger.debug((Object)("response--jsonString:" + jsonString));
            }
            String string = jsonString;
            return string;
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }
}

