/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.ddsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncDeptBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncURLUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DDSyncDeptService
extends SyncDeptBaseService {
    private static Logger logger = Logger.getLogger(DDSyncDeptService.class);

    public DDSyncDeptService(SyncContext ctx) {
        super(ctx);
    }

    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        if (syncType != null) {
            return super.sync(itemType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncAddNewOrg(String itemType) throws BOSException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        String sql = this.getAddNewOrgSql();
        IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
        String[] syncJsonKey = this.getSyncJsonKey(itemType);
        String[] syncJsonValue = this.getSyncJsonValue(itemType);
        String[] syncLogColName = this.getSyncLogColName(itemType);
        String[] syncLogColValue = this.getSyncLogColValue(itemType);
        JSONArray dataArray = new JSONArray();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("logColName", syncLogColName);
        ArrayList logArrays = new ArrayList();
        String result = null;
        try {
            ArrayList<String> logValue = null;
            int id = this.getMaxOrgId();
            while (rowSet.next()) {
                int i;
                JSONObject dataJSON = new JSONObject();
                if (rowSet.getString(1) == null) continue;
                for (i = 0; i < syncJsonKey.length; ++i) {
                    if ("id".equals(syncJsonKey[i])) {
                        dataJSON.put(syncJsonKey[i], (Object)(++id));
                        continue;
                    }
                    dataJSON.put(syncJsonKey[i], (Object)rowSet.getString(syncJsonValue[i]));
                }
                logValue = new ArrayList<String>();
                for (i = 0; i < syncLogColName.length; ++i) {
                    logValue.add(rowSet.getString(syncLogColValue[i]));
                }
                logArrays.add(logValue);
                dataArray.add((Object)dataJSON);
            }
            logMap.put("logColValue", logArrays);
            result = this.syncDept(this.syncCtx, dataArray, itemType, logMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncDept(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException, IOException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        JSONArray logArray = new JSONArray();
        JSONObject response = null;
        String result = "";
        boolean flag = true;
        try {
            if (baseType != null) {
                if (SyncItemType.AddNewOrg.equals((Object)baseType)) {
                    String url = this.getSyncURL(itemType);
                    List logParamList = (List)logList.get("logColValue");
                    for (int i = 0; i < dataArray.size(); ++i) {
                        List logInfo = (List)logParamList.get(i);
                        JSONObject dataJSON = dataArray.getJSONObject(i);
                        String easParentId = dataJSON.getString("parentid");
                        String parentId = null;
                        if ("00000000-0000-0000-0000-000000000000CCE7AED4".equals(easParentId)) {
                            parentId = "1";
                        } else {
                            String sql = "select FDDORGId from T_PM_EASDDORGMAP WHERE FEASORGID = '" + easParentId + "'";
                            IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
                            if (rs.next()) {
                                parentId = rs.getString("fddorgid");
                                dataJSON.put("parentid", (Object)parentId);
                            }
                        }
                        if (StringUtils.isEmpty((String)parentId)) {
                            // empty if block
                        }
                        dataJSON.put("parentid", (Object)parentId);
                        response = SyncCommunitcateUtil.getSyncResponse(dataJSON, url);
                        int errorCode = Integer.parseInt(response.getString("errcode"));
                        if (errorCode == 0) {
                            String updateSql = "update T_PM_EASDDORGMAP set fddorgid = " + response.getString("id") + " where forglongname ='" + logInfo.get(0).toString() + "'";
                            EasXtSyncUtil.execute(this.ctx, updateSql);
                        }
                        logArray.add((Object)response);
                    }
                } else {
                    flag = false;
                    result = super.syncDept(syncCtx, dataArray, itemType, logList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (flag) {
                SyncLogUtils.syncLog(syncCtx, logList, logArray, syncType);
            }
        }
        if (flag) {
            result = JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, syncType));
        }
        return result;
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            if (SyncItemType.AddNewOrg.equals((Object)baseType)) {
                head = new String[]{"id", "name", "parentid"};
                return head;
            }
            return super.getSyncJsonKey(itemType);
        }
        return null;
    }

    @Override
    protected String getAddNewOrgSql() throws BOSException {
        return DDSyncConfigUtil.getInstance().getValue("selectAddNewOrgInfo");
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewOrg.equals((Object)baseType)) {
            head = new String[]{"fddorgid", "fname", "fparentId"};
            return head;
        }
        return super.getSyncJsonValue(itemType);
    }

    @Override
    protected String getSyncURL(String itemType) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        String url = null;
        if (type != null) {
            if (SyncItemType.AddNewOrg.equals((Object)type)) {
                url = DDSyncURLUtil.getSyncUrl(this.ctx, "/department/create");
                return url;
            }
            if (SyncItemType.GetAllOrg.equals((Object)type)) {
                url = DDSyncURLUtil.getSyncUrl(this.ctx, "/department/list");
                return url;
            }
            if (SyncItemType.MoveOrg.equals((Object)type) || SyncItemType.UpdateOrgName.equals((Object)type) || SyncItemType.SetOrgWeights.equals((Object)type)) {
                url = DDSyncURLUtil.getSyncUrl(this.ctx, "/department/update");
                return url;
            }
            if (SyncItemType.DeleteOrg.equals((Object)type)) {
                url = DDSyncURLUtil.getSyncUrl(this.ctx, "/department/delete");
                return url;
            }
        }
        return url;
    }

    protected int getMaxOrgId() throws BOSException {
        String sql = "select max(fddorgid + 0) fid from T_dd_org";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        try {
            if (rs.next()) {
                int maxId = Integer.parseInt(rs.getString("fid"));
                return maxId;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 2;
    }

    @Override
    protected void updateOrgStatus() throws BOSException {
        long t2 = System.currentTimeMillis();
        String sql = SyncConfigUtil.getInstance().getValue("updateOrgStatus");
        logger.error((Object)("*****updateOrgStatus***" + sql));
        EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
        logger.error((Object)("*****updateOrgStatus cost ***" + (System.currentTimeMillis() - t2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncUpdateOrgInfo(String itemType) throws BOSException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.SetOrgWeights.equals((Object)baseType)) {
            String sql = this.getUpdateOrgSql(itemType);
            IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
            this.updateMapWeight();
            String[] syncJsonKey = this.getSyncJsonKey(itemType);
            String[] syncJsonValue = this.getSyncJsonValue(itemType);
            String[] syncLogColName = this.getSyncLogColName(itemType);
            String[] syncLogColValue = this.getSyncLogColValue(itemType);
            JSONArray dataArray = new JSONArray();
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logColName", syncLogColName);
            ArrayList logArrays = new ArrayList();
            String result = null;
            try {
                ArrayList<String> logValue = null;
                while (rowSet.next()) {
                    int i;
                    JSONObject dataJSON = new JSONObject();
                    if (rowSet.getString(1) == null) continue;
                    for (i = 0; i < syncJsonKey.length; ++i) {
                        dataJSON.put(syncJsonKey[i], (Object)rowSet.getObject(syncJsonValue[i]).toString());
                    }
                    logValue = new ArrayList<String>();
                    for (i = 0; i < syncLogColName.length; ++i) {
                        logValue.add(rowSet.getObject(syncLogColValue[i]).toString());
                    }
                    logArrays.add(logValue);
                    dataArray.add((Object)dataJSON);
                }
                logMap.put("logColValue", logArrays);
                result = this.syncDept(this.syncCtx, dataArray, itemType, logMap);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
            }
            finally {
                if (rowSet != null) {
                    try {
                        rowSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            return result;
        }
        return super.syncUpdateOrgInfo(itemType);
    }

    private void updateMapWeight() throws BOSException {
        long t3 = System.currentTimeMillis();
        String dbType = (String)this.ctx.get((Object)"dbType");
        String valueKey = "";
        if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
            valueKey = "updateOrgWeights_Oracle";
        } else if ("MS SQL Server".equals(dbType)) {
            valueKey = "updateOrgWeights_sqlServer";
        } else if ("DB2 UDB".equals(dbType)) {
            valueKey = "updateOrgWeights_DB2";
        } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
            valueKey = "updateOrgWeights_PG";
        }
        if (!StringUtils.isEmpty((String)valueKey)) {
            String sql = "/*dialect*/" + SyncConfigUtil.getInstance().getValue(valueKey);
            logger.error((Object)("*****updateOrgWeights***" + sql));
            EasXtSyncUtil.execute(this.ctx, this.fillTemplateSql(sql, 0));
            logger.error((Object)("*****updateOrgWeights cost ***" + (System.currentTimeMillis() - t3)));
        }
    }

    @Override
    protected String getUpdateOrgSql(String itemType) throws BOSException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.SetOrgWeights.equals((Object)baseType)) {
            String dbType = (String)this.ctx.get((Object)"dbType");
            String valueKey = "";
            if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
                valueKey = "selectUpdateOrgWeights_Oracle";
            } else if ("MS SQL Server".equals(dbType)) {
                valueKey = "selectUpdateOrgWeights_sqlServer";
            } else if ("DB2 UDB".equals(dbType)) {
                valueKey = "selectUpdateOrgWeights_DB2";
            } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
                valueKey = "updateOrgWeights_PG";
            }
            String sql = "/*dialect*/" + DDSyncConfigUtil.getInstance().getValue(valueKey);
            return sql;
        }
        return super.getUpdateOrgSql(itemType);
    }
}

