/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.ddsync.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.AbstactBaseSyncHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.ExportExcelTools;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.DDSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.PageResult;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class DDSyncHelper
extends AbstactBaseSyncHelper {
    private Context ctx = null;
    private static Map<String, Map> config = new HashMap<String, Map>();

    public DDSyncHelper(Context ctx) {
        this.ctx = ctx;
    }

    public DDSyncHelper() {
    }

    @Override
    public Map getConfig() {
        if (config.get(this.ctx.getAIS()) != null) {
            return config.get(this.ctx.getAIS());
        }
        this.initConfig();
        return config.get(this.ctx.getAIS());
    }

    public Map getConfig(Context ctx) {
        if (config.get(ctx.getAIS()) != null) {
            return config.get(ctx.getAIS());
        }
        this.initConfig();
        return config.get(ctx.getAIS());
    }

    public void setConfig(Map config0) {
        config.put(this.ctx.getAIS(), config0);
    }

    private void initConfig() {
        String sql = "SELECT TOP 1 FSettingMsg FROM T_BS_SYNCSAVESETTING where ftype = 1 ORDER BY FCreateTime DESC";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            HashMap<String, String> config0 = new HashMap<String, String>();
            if (iRowSet != null && iRowSet.next()) {
                String settingMsg = iRowSet.getString("FSettingMsg");
                if (StringUtils.isEmpty((String)settingMsg)) {
                    config0.put("mCloud", "https://oapi.dingtalk.com");
                    config.put(this.ctx.getAIS(), config0);
                } else {
                    String[] str = settingMsg.split(";");
                    for (int i = 0; i < str.length; ++i) {
                        String[] val = str[i].split("==");
                        String configKey = val[0];
                        String configValue = "0";
                        if (val.length > 1) {
                            configValue = val[1];
                        }
                        config0.put(configKey, configValue);
                    }
                    config.put(this.ctx.getAIS(), config0);
                }
            } else {
                config0.put("mCloud", "https://oapi.dingtalk.com");
                config.put(this.ctx.getAIS(), config0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean saveConfig(Context ctx, Map map, boolean isInit) throws BOSException {
        if (isInit) {
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlList.add("truncate table T_PM_EASDTUSERMAP");
            sqlList.add("truncate table T_DD_USER");
            sqlList.add("truncate table T_PM_EASDDORGMAP");
            sqlList.add("truncate table T_DD_ORG");
            sqlList.add("truncate table T_DD_SYNCDEPTLOG");
            sqlList.add("truncate table T_DD_SYNCPERSONLOG");
            sqlList.add("truncate table T_PM_EASDDORGLEADERMAP");
            sqlList.add("truncate table T_DD_ORGLEADER");
            sqlList.add("truncate table T_DD_SYNCORGLEADERLOG");
            sqlList.add("delete from t_bs_synchtime where ftype = 1");
            sqlList.add("delete from T_BS_SYNCSAVESETTING where ftype = 1");
            for (int i = 0; i < sqlList.size(); ++i) {
                DbUtil.execute((Context)ctx, (String)(sqlList.get(i) + ""));
            }
            DDSyncURLUtil.clearTokenCache();
        }
        boolean flag = false;
        if (map == null) {
            return flag;
        }
        if (ctx != null) {
            StringBuffer setting = new StringBuffer();
            map.put("dbCode", ctx.getAIS());
            boolean sFlag = false;
            String secret = "";
            for (Object key : map.keySet()) {
                if ("secret".equalsIgnoreCase(key.toString()) && StringUtils.isEmpty((String)((String)map.get(key)))) {
                    Map config2 = this.getConfig(ctx);
                    secret = config2.get("secret").toString();
                    setting.append(key.toString() + "==" + secret + ";");
                    sFlag = true;
                    continue;
                }
                setting.append(key.toString() + "==" + map.get(key) + ";");
            }
            String detailLogMsg = this.getDetailLogMsg(map, this.getConfig(ctx));
            detailLogMsg = "\u540c\u6b65\u5de5\u5177(\u9489\u9489)-\u4fee\u6539\u540c\u6b65\u53c2\u6570: \r\n" + detailLogMsg;
            String companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            IObjectPK beginLog = LogUtil.beginLog((Context)ctx, (String)"\u540c\u6b65\u5de5\u5177(\u9489\u9489)-\u4fee\u6539\u540c\u6b65\u53c2\u6570", (BOSObjectType)new BOSObjectType("F4AF4F04"), (IObjectPK)ctx.getCaller(), (String)detailLogMsg, (String)"XTSync_Operate", (String)companyId);
            if (null != beginLog) {
                String sql = "update T_LOG_App set FENTITYALIAS_L2 = '\u540c\u6b65\u5de5\u5177' where fid = '" + beginLog.toString() + "'";
                try {
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            DDSyncHelper.saveSetting(ctx, setting.toString());
            LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
            if (sFlag) {
                map.put("secret", secret);
            }
            config.put(ctx.getAIS(), map);
            flag = true;
        }
        return flag;
    }

    private static void saveSetting(Context ctx, String setting) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BS_SYNCSAVESETTING(FID,FSettingMsg,FType,FCreateTime) values(?,?,?,?)");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(BOSUuid.create((String)"F4AF4F04").toString());
        param.add(setting);
        param.add(1);
        param.add(new Timestamp(new Date().getTime()));
        params.add(param.toArray());
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map getSyncRecordMap(SyncContext syncCtx) throws BOSException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] syncTypeOName = new String[]{"UpdateOrgName", "AddNewOrg", "MoveOrg", "DeleteOrg", "SetOrgWeights"};
        String[] syncTypeOValue = new String[]{"3", "1", "4", "2", "5"};
        syncCtx.setLogTableName("T_DD_SYNCDEPTLOG");
        for (int i = 0; i < syncTypeOName.length; ++i) {
            map.put(syncTypeOName[i], SyncLogUtils.getSyncLogCount(syncCtx, syncTypeOValue[i], syncCtx.getFSyncTimeID(), null, true));
            map.put(syncTypeOName[i] + "1", SyncLogUtils.getSyncLogCount(syncCtx, syncTypeOValue[i], syncCtx.getFSyncTimeID(), null, false));
        }
        String[] syncTypePName = new String[]{"UpdatePersonCell", "UpdatePersonEmail", "UpdatePersonOrg", "UpdatePersonName", "UpdatePersonNumber", "UpdatePersonGender", "UpdatePersonPosition", "UpdatePersonTelephone", "UpdatePersonAddress", "UpdatePersonHireDate", "UpdatePersonWeights", "UpdatePersonCustom", "DeletePerson", "AddNewPerson"};
        String[] syncTypePValue = new String[]{"15", "13", "9", "11", "17", "16", "10", "14", "12", "45", "19", "21", "7", "6"};
        syncCtx.setLogTableName("T_DD_SYNCPERSONLOG");
        for (int i = 0; i < syncTypePName.length; ++i) {
            map.put(syncTypePName[i], SyncLogUtils.getSyncLogCount(syncCtx, syncTypePValue[i], syncCtx.getFSyncTimeID(), null, true));
            map.put(syncTypePName[i] + "1", SyncLogUtils.getSyncLogCount(syncCtx, syncTypePValue[i], syncCtx.getFSyncTimeID(), null, false));
        }
        String[] syncTypePartName = new String[]{"BatchUpdatePersonPartJob"};
        String[] syncTypePartValue = new String[]{"100"};
        syncCtx.setLogTableName("T_DD_SYNCPARTLOG");
        for (int i = 0; i < syncTypePartName.length; ++i) {
            map.put(syncTypePartName[i], SyncLogUtils.getSyncLogCount(syncCtx, syncTypePartValue[i], syncCtx.getFSyncTimeID(), null, true));
            map.put(syncTypePartName[i] + "1", SyncLogUtils.getSyncLogCount(syncCtx, syncTypePartValue[i], syncCtx.getFSyncTimeID(), null, false));
        }
        return map;
    }

    @Override
    protected String getBaseSql(SyncHighItemType highItemType) throws BOSException {
        String sql = null;
        if (SyncHighItemType.Dept.equals((Object)highItemType)) {
            sql = DDSyncConfigUtil.getInstance().getValue("getDeptSyncLog");
        } else if (SyncHighItemType.Person.equals((Object)highItemType)) {
            sql = DDSyncConfigUtil.getInstance().getValue("getPersonSyncLog");
        } else if (SyncHighItemType.PartJob.equals((Object)highItemType)) {
            sql = DDSyncConfigUtil.getInstance().getValue("getPartSyncLog");
        } else if (SyncHighItemType.DeptLeader.equals((Object)highItemType)) {
            sql = DDSyncConfigUtil.getInstance().getValue("getOrgLeaderSyncLog");
        }
        return sql;
    }

    @Override
    public String getTableName(String type) {
        if ("USER_NOSYNC_TABLE".equals(type)) {
            return "T_DD_NOSYNCPERSON";
        }
        if ("ORG_NOSYNC_TABLE".equals(type)) {
            return "T_DD_NOSYNCORG";
        }
        if ("USER_SYNC_TABLE".equals(type)) {
            return "T_DD_USER";
        }
        if ("ORG_SYNC_TABLE".equals(type)) {
            return "T_DD_ORG";
        }
        if ("USER_MAPPING_TABLE".equals(type)) {
            return "T_PM_EASDTUSERMAP";
        }
        return null;
    }

    @Override
    public String[] getFilterColName(SyncHighItemType highItemType, boolean isAll) {
        String[] filterColName = null;
        if (SyncHighItemType.Dept.equals((Object)highItemType)) {
            filterColName = new String[]{"forglongname", "foldorglongname"};
            return filterColName;
        }
        if (SyncHighItemType.Person.equals((Object)highItemType)) {
            filterColName = new String[]{"fpersonname", "fcell", "femail", "forglongname", "fposition", "ftelephone", "faddress"};
            return filterColName;
        }
        if (SyncHighItemType.PartJob.equals((Object)highItemType)) {
            filterColName = new String[]{"fpersonname", "fcell", "forglongname", "fjobtitles"};
            return filterColName;
        }
        if (SyncHighItemType.DeptLeader.equals((Object)highItemType)) {
            filterColName = new String[]{"fpersonname", "fcell", "forglongname", "forglongnames"};
            return filterColName;
        }
        return null;
    }

    @Override
    protected String buildFilterSql(String[] filterColName, String filter, SyncHighItemType highItemType) {
        StringBuilder sql = new StringBuilder();
        if (SyncHighItemType.PartJob.equals((Object)highItemType)) {
            sql.append(" AND (umap." + filterColName[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterColName.length; ++i) {
                if ("FPERSONNAME".equalsIgnoreCase(filterColName[i]) || "FCELL".equalsIgnoreCase(filterColName[i]) || "FORGLONGNAME".equalsIgnoreCase(filterColName[i])) {
                    sql.append(" or umap." + filterColName[i] + " like '%" + filter + "%'");
                    continue;
                }
                sql.append(" or log." + filterColName[i] + " like '%" + filter + "%'");
            }
        } else {
            return super.buildFilterSql(filterColName, filter, highItemType);
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    protected Map getSyncLogColBase(String syncType) {
        HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
        String[] baseCol = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(syncType);
        String syncTypeValue = "";
        if (baseType != null) {
            syncTypeValue = baseType.getValue();
            switch (Integer.parseInt(syncTypeValue)) {
                case 1: {
                    baseCol = new String[]{"fid", "forglongname", "ferrormsg", "fisbindsucc"};
                    break;
                }
                case 2: {
                    baseCol = new String[]{"fid", "forglongname", "ferrormsg"};
                    break;
                }
                case 3: {
                    baseCol = new String[]{"fid", "foldorglongname", "forglongname", "ferrormsg"};
                    break;
                }
                case 4: {
                    baseCol = new String[]{"fid", "foldorglongname", "forglongname", "ferrormsg"};
                    break;
                }
                case 5: {
                    baseCol = new String[]{"fid", "forglongname", "fweight", "ferrormsg"};
                    break;
                }
                case 6: {
                    baseCol = new String[]{"fid", "fpersonname", "fcell", "femail", "forglongname", "fposition", "faddress", "fhiredate", "finservice", "ferrormsg", "fisbindsucc"};
                    break;
                }
                case 7: {
                    baseCol = new String[]{"fid", "fpersonname", "fcell", "ferrormsg"};
                    break;
                }
                case 8: 
                case 9: {
                    baseCol = new String[]{"fid", "fpersonname", "foldorglongname", "forglongname", "ferrormsg"};
                    break;
                }
                case 10: {
                    baseCol = new String[]{"fid", "fpersonname", "fposition", "ferrormsg"};
                    break;
                }
                case 11: {
                    baseCol = new String[]{"fid", "fpersonname", "ferrormsg"};
                    break;
                }
                case 12: {
                    baseCol = new String[]{"fid", "fpersonname", "faddress", "ferrormsg"};
                    break;
                }
                case 13: {
                    baseCol = new String[]{"fid", "fpersonname", "femail", "ferrormsg"};
                    break;
                }
                case 14: {
                    baseCol = new String[]{"fid", "fpersonname", "ftelephone", "ferrormsg"};
                    break;
                }
                case 15: {
                    baseCol = new String[]{"fid", "fpersonname", "fcell", "ferrormsg"};
                    break;
                }
                case 16: {
                    baseCol = new String[]{"fid", "fpersonname", "fgender", "ferrormsg"};
                    break;
                }
                case 17: {
                    baseCol = new String[]{"fid", "fpersonname", "fpersonnumber", "ferrormsg"};
                    break;
                }
                case 18: 
                case 19: {
                    baseCol = new String[]{"fid", "fpersonname", "fweight", "ferrormsg"};
                    break;
                }
                case 20: 
                case 21: {
                    break;
                }
                case 22: 
                case 23: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "forglongname", "forglongnames", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 45: {
                    baseCol = new String[]{"fid", "fpersonname", "fHireDate", "ferrormsg"};
                }
            }
        } else {
            DDSyncItemType ddSyncType = DDSyncUtil.getDDSyncEnum(syncType);
            syncTypeValue = ddSyncType.getValue();
            switch (Integer.parseInt(syncTypeValue)) {
                case 100: {
                    baseCol = new String[]{"fid", "fpersonname", "fcell", "forglongname", "fjobtitles", "ferrormsg"};
                    break;
                }
                case 101: {
                    baseCol = new String[]{"fid", "fpersonname", "fcell", "forglongname", "forglongnames", "ferrormsg"};
                }
            }
        }
        syncLogMap.put("syncLogCol", baseCol);
        syncLogMap.put("syncTypeValue", syncTypeValue);
        return syncLogMap;
    }

    @Override
    protected String getPersonPartJobTiltle(String xtIdOrCell) throws BOSException {
        String sql2 = "SELECT 1 FROM T_WX_PART WHERE 1=2";
        return sql2;
    }

    @Override
    protected String getXtOrgLeaderSql(Context ctx, String orgLongName) throws BOSException {
        return "SELECT distinct leader.fuserid,u.fpersonname leaderName FROM T_DD_orgleader leader inner join t_DD_user u on leader.fuserid = u.fuserid";
    }

    @Override
    protected String getXTPersonStatus(String status) {
        return "\u5728\u804c";
    }

    @Override
    protected String getXtOrgFormOrgMap() throws BOSException {
        return DDSyncConfigUtil.getInstance().getValue("getXtOrgFromOrgMap");
    }

    @Override
    protected Map getExportColName(SyncContext syncCtx, String syncType, String subAction) {
        if ("viewOrgLog".equalsIgnoreCase(subAction)) {
            return this.getAllSyncLogColBase(syncType, subAction);
        }
        if ("viewPersonLog".equalsIgnoreCase(subAction)) {
            String syncTypeValue = null;
            SyncItemType baseType = SyncBaseUtil.getBaseEnum(syncType);
            if (baseType != null) {
                syncTypeValue = baseType.getValue();
            }
            String[] baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fpersonnumber", "fcell", "femail", "foldorglongname", "forglongname", "fposition", "fgender", "faddress", "fhiredate", "ftelephone", "fweight", "finservice", "fisbindsucc", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
            HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
            syncLogMap.put("syncLogCol", baseCol);
            syncLogMap.put("syncTypeValue", syncTypeValue);
            return syncLogMap;
        }
        if ("viewPartJobLog".equalsIgnoreCase(subAction)) {
            return this.getAllSyncLogColBase("BatchUpdatePersonPartJob", subAction);
        }
        return null;
    }

    @Override
    protected String[] getExportTiltle(String subAction) {
        if ("viewPersonLog".equalsIgnoreCase(subAction)) {
            return new String[]{"FID", "\u540c\u6b65\u7c7b\u578b", "\u540c\u6b65\u65f6\u95f4", "\u59d3\u540d", "\u7f16\u7801(\u5de5\u53f7)", "\u624b\u673a", "\u90ae\u7bb1", "\u539f\u7ec4\u7ec7\u957f\u540d\u79f0", "\u73b0\u7ec4\u7ec7\u957f\u540d\u79f0", "\u804c\u4f4d", "\u6027\u522b", "\u5730\u5740", "\u5165\u804c\u65e5\u671f", "\u5ea7\u673a", "\u6392\u5e8f\u7801", "\u5728\u804c\u72b6\u6001", "\u7ed1\u5b9a\u72b6\u6001", "\u6d88\u606f\u7801", "\u65e5\u5fd7\u8be6\u60c5", "\u662f\u5426\u6210\u529f", "\u540c\u6b65\u6279\u6b21\u53f7"};
        }
        if ("viewXtUser".equalsIgnoreCase(subAction)) {
            return new String[]{"\u4eba\u5458UserId", "\u59d3\u540d", "\u7f16\u7801(\u5de5\u53f7)", "\u624b\u673a", "\u90ae\u7bb1", "\u7ec4\u7ec7\u957f\u540d\u79f0", "\u6027\u522b", "\u804c\u4f4d", "\u5730\u5740", "\u529e\u516c\u7535\u8bdd", "\u5165\u804c\u65e5\u671f", "\u6392\u5e8f", "\u72b6\u6001"};
        }
        return super.getExportTiltle(subAction);
    }

    @Override
    public String getAllXtUser(SyncContext syncCtx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = param.getString("filter");
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        String sql = DDSyncConfigUtil.getInstance().getValue("getAllSyncPerson");
        int page = param.getIntValue("page");
        int rowCount = param.getIntValue("rowCount");
        StringBuilder sqlB = new StringBuilder(sql);
        sqlB.append(" WHERE 1=1 ");
        String[] filterCol = this.getAllSyncFilterCol("PERSON");
        if (!StringUtils.isEmpty((String)filter)) {
            sqlB.append(" AND " + filterCol[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterCol.length; ++i) {
                sqlB.append(" OR " + filterCol[i] + " LIKE '%" + filter + "%'");
            }
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)("select count(*) from (" + sqlB.toString() + ") tmp"));
            sqlB.append(" ORDER BY FORGLONGNAME");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sqlB.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fuserid", rs.getString("fuserid"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("fposition", rs.getString("fposition"));
                map.put("faddress", rs.getString("faddress"));
                map.put("ftelephone", rs.getString("ftelephone"));
                map.put("fgender", rs.getInt("fgender") == 1 ? "\u7537" : (rs.getInt("fgender") == 2 ? "\u5973" : "\u672a\u8bbe\u7f6e"));
                map.put("fweight", rs.getString("fweight"));
                map.put("fstatus", rs.getString("fstatus"));
                map.put("index", index);
                map.put("fpersonnumber", rs.getString("fpersonnumber"));
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    @Override
    protected String[] getAllSyncFilterCol(String type) {
        if ("ORG".equals(type)) {
            return new String[]{"FORGLONGNAME", "FNAME"};
        }
        return new String[]{"FCELL", "FEMAIL", "FPERSONNAME", "FPOSITION", "FORGLONGNAME", "FSTATUS", "FPERSONNUMBER"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getEasXtUserDetail(SyncContext syncCtx, com.alibaba.fastjson.JSONObject condition) throws BOSException {
        String xtid = null;
        String userid = condition.getString("userid") == null ? null : condition.getString("userid").trim();
        String personid = condition.getString("personid") == null ? null : condition.getString("personid").trim();
        Context ctx = syncCtx.getCtx();
        ArrayList<String> param = new ArrayList<String>();
        DDSyncConfigUtil instance = DDSyncConfigUtil.getInstance();
        String getEasPersonDetail = instance.getValue("getEasPersonDetail");
        String getXtPersonDetail = instance.getValue("getXtPersonDetail");
        String getXtIdFromUMap = "select " + syncCtx.getMappingUserIdColnum() + " from " + syncCtx.getMappingTableName() + " umap where 1 = 1 ";
        if (!StringUtils.isEmpty((String)userid) && !"null".equalsIgnoreCase(userid)) {
            getEasPersonDetail = getEasPersonDetail + " and u.fid = ?";
            getXtIdFromUMap = getXtIdFromUMap + " and umap.fuserid = ?";
            param.add(userid);
        } else {
            getEasPersonDetail = getEasPersonDetail + " and p.fid = ?";
            getXtIdFromUMap = getXtIdFromUMap + " and umap.fpersonid = ?";
            param.add(personid);
        }
        IRowSet rs0 = DbUtil.executeQuery((Context)ctx, (String)getXtIdFromUMap, (Object[])param.toArray());
        try {
            if (rs0.next()) {
                xtid = rs0.getString(syncCtx.getMappingUserIdColnum());
                getXtPersonDetail = getXtPersonDetail + " and u.fuserid = '" + xtid + "'";
            } else {
                getXtPersonDetail = getXtPersonDetail + " and 1=2";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs0 != null) {
                try {
                    rs0.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getEasPersonDetail, (Object[])param.toArray());
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)getXtPersonDetail);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> tmpMap = null;
        try {
            tmpMap = new HashMap<String, HashMap<String, String>>();
            if (rs.next()) {
                String orgLongName;
                map = new HashMap();
                map.put("fname", rs.getString("fpersonname"));
                map.put("fpersonnumber", rs.getString("fpersonnumber"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("fposition", rs.getString("FPosition"));
                String string = orgLongName = rs.getString("FOrgLongName") == null ? "" : rs.getString("FOrgLongName");
                if (orgLongName.indexOf("_") > 0) {
                    orgLongName = orgLongName.substring(orgLongName.indexOf("_") + 1).replaceAll("_", "\\\\");
                    map.put("orgtop", "false");
                } else {
                    map.put("orgtop", "true");
                }
                map.put("forglongname", orgLongName);
                String userDelete = rs.getString("FIsDelete");
                int personInService = rs.getInt("FinService");
                String deletedStatus = rs.getString("fdeletedStatus");
                String status = "";
                switch (personInService) {
                    case 1: {
                        status = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        status = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        status = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        status = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        status = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        status = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                if (!"1".equals(userDelete) && !"2".equals(deletedStatus)) {
                    map.put("fstatus", status);
                } else {
                    map.put("fstatus", "\u7528\u6237\u5df2\u5220\u9664");
                }
                map.put("fgender", Genders.getEnum((int)rs.getInt("FGender")) == null ? "\u672a\u8bbe\u7f6e" : Genders.getEnum((int)rs.getInt("FGender")).getAlias());
                map.put("faddress", rs.getString("faddress"));
                map.put("ftelephone", rs.getString("ftelephone"));
                map.put("fcontact", "");
                Map easLeaderAndJob = this.getLeaderAndJob(ctx, "EAS", rs.getString("fcell"));
                map.put("leaderName", (String)easLeaderAndJob.get("leaderName"));
                map.put("leaderPosition", (String)easLeaderAndJob.get("leaderPosition"));
                map.put("partJob", (String)easLeaderAndJob.get("partJob"));
                map.put("fhireDate", rs.getString("fhireDate"));
                tmpMap.put("easPerson", map);
            } else {
                map = new HashMap();
                map.put("fname", "");
                map.put("fpersonnumber", "");
                map.put("fcell", "");
                map.put("femail", "");
                map.put("fposition", "");
                map.put("forglongname", "");
                map.put("orgtop", "true");
                map.put("fstatus", "");
                map.put("fgender", "");
                map.put("faddress", "");
                map.put("ftelephone", "");
                map.put("fcontact", "");
                map.put("leaderName", "");
                map.put("leaderPosition", "");
                map.put("partJob", "");
                map.put("fhireDate", "");
                tmpMap.put("easPerson", map);
            }
            if (rs1.next()) {
                map = new HashMap();
                map.put("fname", rs1.getString("fpersonname"));
                map.put("fpersonnumber", rs1.getString("fpersonnumber"));
                map.put("fcell", rs1.getString("fcell"));
                map.put("femail", rs1.getString("femail"));
                map.put("fposition", rs1.getString("FPosition"));
                map.put("forglongname", rs1.getString("FOrgLongName"));
                map.put("orgtop", StringUtils.isEmpty((String)rs1.getString("FParentId")) ? "true" : "false");
                String status = rs1.getString("FStatus");
                map.put("fstatus", this.getXTPersonStatus(status));
                map.put("fgender", Genders.getEnum((int)rs1.getInt("FGender")) == null ? "\u4e0d\u786e\u5b9a" : Genders.getEnum((int)rs1.getInt("FGender")).getAlias());
                map.put("faddress", rs1.getString("faddress"));
                map.put("ftelephone", rs1.getString("ftelephone"));
                map.put("fcontact", "");
                Map easLeaderAndJob = this.getLeaderAndJob(ctx, "XT", rs1.getString("fuserid"));
                map.put("leaderName", (String)easLeaderAndJob.get("leaderName"));
                map.put("leaderPosition", (String)easLeaderAndJob.get("leaderPosition"));
                map.put("partJob", (String)easLeaderAndJob.get("partJob"));
                map.put("fhireDate", rs1.getString("fhireDate"));
                tmpMap.put("xtPerson", map);
            } else {
                map = new HashMap();
                map.put("fname", "");
                map.put("fpersonnumber", "");
                map.put("fcell", "");
                map.put("femail", "");
                map.put("fposition", "");
                map.put("forglongname", "");
                map.put("orgtop", "true");
                map.put("fstatus", "");
                map.put("fgender", "");
                map.put("faddress", "");
                map.put("ftelephone", "");
                map.put("fcontact", "");
                map.put("leaderName", "");
                map.put("leaderPosition", "");
                map.put("partJob", "");
                map.put("fpersonnumber", "");
                map.put("fhireDate", "");
                tmpMap.put("xtPerson", map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.fromObject(tmpMap).toString();
    }

    @Override
    protected Map getAllSyncLogColBase(String syncType, String subAction) {
        HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
        String[] baseCol = null;
        String syncTypeValue = null;
        if ("ALL".equalsIgnoreCase(syncType)) {
            baseCol = "viewOrgLog".equalsIgnoreCase(subAction) ? new String[]{"fid", "ftype", "fcreatetime", "foldorglongname", "forglongname", "fweight", "fisbindsucc", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid", "fhiredate"} : new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fpersonnumber", "fcell", "femail", "foldorglongname", "forglongname", "fposition", "fgender", "faddress", "ftelephone", "fweight", "finservice", "fisbindsucc", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
        } else {
            SyncItemType baseType = SyncBaseUtil.getBaseEnum(syncType);
            if (baseType != null) {
                syncTypeValue = baseType.getValue();
                switch (Integer.parseInt(syncTypeValue)) {
                    case 1: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "forglongname", "fisbindsucc", "fweight", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 2: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 3: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "foldorglongname", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 4: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "foldorglongname", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 5: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "forglongname", "fweight", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 6: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fposition", "fgender", "faddress", "ftelephone", "fweight", "finservice", "fisbindsucc", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid", "fhiredate"};
                        break;
                    }
                    case 7: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "finservice", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 8: 
                    case 9: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "foldorglongname", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 10: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fposition", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 11: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 12: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "faddress", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 13: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 14: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "ftelephone", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 15: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 16: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fgender", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 17: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fpersonnumber", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 19: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fweight", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 20: 
                    case 21: {
                        break;
                    }
                    case 45: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fhiredate", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    }
                }
            } else {
                DDSyncItemType ddSyncType = DDSyncUtil.getDDSyncEnum(syncType);
                syncTypeValue = ddSyncType.getValue();
                switch (Integer.parseInt(syncTypeValue)) {
                    case 100: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "forglongname", "fjobtitles", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                        break;
                    }
                    case 101: {
                        baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "forglongname", "forglongnames", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    }
                }
            }
        }
        syncLogMap.put("syncLogCol", baseCol);
        syncLogMap.put("syncTypeValue", syncTypeValue);
        return syncLogMap;
    }

    @Override
    public HSSFWorkbook exportAllXtUser(SyncContext syncCtx, com.alibaba.fastjson.JSONObject param) throws BOSException {
        String filter = param.getString("filter");
        String subAction = param.getString("subAction");
        String sql = DDSyncConfigUtil.getInstance().getValue("getAllSyncPerson");
        StringBuilder sqlB = new StringBuilder(sql);
        sqlB.append(" WHERE 1=1 ");
        String[] filterCol = this.getAllSyncFilterCol("PERSON");
        if (!StringUtils.isEmpty((String)filter)) {
            sqlB.append(" AND " + filterCol[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterCol.length; ++i) {
                sqlB.append(" OR " + filterCol[i] + " LIKE '%" + filter + "%'");
            }
        }
        IRowSet rs = null;
        ArrayList<Map> rows = new ArrayList<Map>();
        try {
            sqlB.append(" ORDER BY FORGLONGNAME");
            rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sqlB.toString());
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fuserid", rs.getString("fuserid"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("fpersonnumber", rs.getString("fpersonnumber"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("fposition", rs.getString("fposition"));
                map.put("faddress", rs.getString("faddress"));
                map.put("ftelephone", rs.getString("ftelephone"));
                map.put("fgender", rs.getInt("fgender") == 1 ? "\u7537" : (rs.getInt("fgender") == 2 ? "\u5973" : "\u672a\u8bbe\u7f6e"));
                map.put("fweight", rs.getString("fweight"));
                String status = null;
                switch (rs.getInt("fstatus")) {
                    case 1: {
                        status = "\u5df2\u6fc0\u6d3b";
                        break;
                    }
                    case 2: {
                        status = "\u5df2\u7981\u7528";
                        break;
                    }
                    case 4: {
                        status = "\u672a\u6fc0\u6d3b";
                        break;
                    }
                    case 5: {
                        status = "\u9000\u51fa\u4f01\u4e1a";
                        break;
                    }
                    default: {
                        status = "\u672a\u77e5";
                    }
                }
                map.put("fstatus", status);
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        ExportExcelTools et = new ExportExcelTools();
        String[] exportTiltle = this.getExportTiltle(subAction);
        String fileName = this.getExportFileName(subAction);
        String[] baseCol = new String[]{"fuserid", "fname", "fpersonnumber", "fcell", "fcmail", "forglongname", "fgender", "fposition", "faddress", "ftelephone", "fweight", "fstatus"};
        return et.writeWorkBook(rows, fileName, exportTiltle, baseCol);
    }
}

