/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.ddsync.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.HttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncHelper;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DDSyncURLUtil {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.trdsync.ddsync.util.DDSyncURLUtil");
    public static Map tokenMap = null;
    public static final String DEFAULT_MCLOUD = "https://oapi.dingtalk.com";
    public static final String DD_TOKEN = "/gettoken";
    public static final String BASEURL = null;
    public static final String GETALL_ORG = "/department/list";
    public static final String ADDNEW_ORG = "/department/create";
    public static final String UPDATE_ORG = "/department/update";
    public static final String DELETE_ORG = "/department/delete";
    public static final String GETALL_PERSON = "/user/listbypage";
    public static final String ADDNEW_PERSON = "/user/create";
    public static final String UPDATE_PERSON = "/user/update";
    public static final String DELETE_PERSON = "/user/delete";
    public static final String GETONE_PERSON = "/user/get";
    public static final String GETUSERS_ROLE = "/topapi/role/simplelist";
    public static final String ADDUSERS_ROLE = "/topapi/role/addrolesforemps";
    public static final String DELUSERS_ROLE = "/topapi/role/removerolesforemps";
    public static final String LEADERID_ROLE = "1538662010";
    public static final long EXPIRES_IN = 0x6DDD00L;

    public static String getSyncUrl(Context ctx, String syncTypeUrl) throws BOSException {
        String secret;
        String eip;
        Map config = new DDSyncHelper(ctx).getConfig(ctx);
        String mCloud = config.get("mCloud") == null ? DEFAULT_MCLOUD : (String)config.get("mCloud");
        String token = DDSyncURLUtil.getToken(mCloud, eip = (String)config.get("eip"), secret = (String)config.get("secret"));
        if (StringUtils.isEmpty((String)token)) {
            throw new BOSException("token\u4e3a\u7a7a");
        }
        String syncUrl = mCloud + syncTypeUrl + "?access_token=" + token;
        return syncUrl;
    }

    private static String getToken(String headUrl, String corpid, String corpsecret) {
        if (tokenMap == null) {
            tokenMap = new HashMap();
            DDSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
        } else if (tokenMap.get("effectime") == null || tokenMap.get("token") == null) {
            DDSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
        } else {
            long currentTimeMillis;
            long effectTime = (Long)tokenMap.get("effectime");
            if (effectTime <= (currentTimeMillis = System.currentTimeMillis())) {
                DDSyncURLUtil.sendToken(headUrl, corpid, corpsecret);
            }
        }
        return tokenMap.get("token") == null ? null : tokenMap.get("token").toString();
    }

    private static void sendToken(String headUrl, String corpid, String corpsecret) {
        HashMap<String, String> tokenParam = new HashMap<String, String>();
        tokenParam.put("corpid", corpid);
        tokenParam.put("corpsecret", corpsecret);
        try {
            JSONObject tokenResult = HttpSendUtil.startGet(headUrl + DD_TOKEN, tokenParam);
            if (tokenResult.getInteger("errcode") != 0) {
                logger.error((Object)("\u83b7\u53d6token\u5931\u8d25:" + tokenResult.getString("errmsg")));
            } else {
                String token = tokenResult.getString("access_token");
                long effectime = System.currentTimeMillis() + 0x6DDD00L;
                tokenMap.put("token", token);
                tokenMap.put("effectime", effectime - 300000L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8c03\u7528\u83b7\u53d6token\u63a5\u53e3\u5931\u8d25;" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void clearTokenCache() {
        if (tokenMap != null) {
            tokenMap.clear();
        }
    }

    public static long getTime() {
        return new Date().getTime();
    }
}

