/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wxsync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.IBaseSync;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncServiceFactoryHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.WXSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.imp.WXSyncDeptLeaderService;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.imp.WXSyncDeptService;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.imp.WXSyncPartService;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.imp.WXSyncPersonService;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.imp.WXSyncRelationsService;
import com.kingdee.eas.base.xtsync.trdsync.wxsync.util.WXSyncUtil;
import java.util.List;
import java.util.Map;

public class WXSyncServiceFactoryHelper
extends SyncServiceFactoryHelper {
    public static final String ORG_MAPPING_TABLE = "T_PM_EASWXORGMAP";
    public static final String ORG_SYNC_TABLE = "T_WX_ORG";
    public static final String ORG_SYNCLOG_TABLE = "T_WX_SYNCDEPTLOG";
    public static final String ORG_WX_ID = "FWXORGID";
    public static final String ORG_WX_PARENTID = "FWXPARENTID";
    public static final String ORG_WX_NOSYNCORG = "T_WX_NOSYNCORG";
    public static final String USER_MAPPING_TABLE = "T_PM_EASWXUSERMAP";
    public static final String USER_SYNC_TABLE = "T_WX_USER";
    public static final String USER_WX_ID = "FXTID";
    public static final String USER_SYNCLOG_TABLE = "T_WX_SYNCPERSONLOG";
    public static final String USER_WX_NOSYNCPERSON = "T_WX_NOSYNCPERSON";
    public static final String PART_MAPPING_TABLE = "T_PM_EASWXPARTMAP";
    public static final String PART_SYNC_TABLE = "T_WX_PART";
    public static final String PART_SYNCLOG_TABLE = "T_WX_SYNCPARTLOG";
    public static final String DEPRLEADER_MAPPING_TABLE = "T_PM_EASWXORGLEADERMAP";
    public static final String DEPRLEADER_SYNC_TABLE = "T_WX_ORGLEADER";
    public static final String DEPRLEADER_SYNCLOG_TABLE = "T_WX_SYNCORGLEADERLOG";
    public static final String RELATIONS_MAPPING_TABLE = "T_PM_EASWXRELATIONSMAP";
    public static final String RELATIONS_SYNC_TABLE = "T_WX_RELATIONS";
    public static final String RELATIONS_SYNCLOG_TABLE = "T_WX_SYNCRELATIONSLOG";
    public static List<SyncItemType> enumList = null;

    @Override
    protected IBaseSync getSyncServiceImpByType(Context ctx, String syncItemType, int type) throws BOSException {
        SyncItemType syncType = SyncBaseUtil.getBaseEnum(syncItemType);
        if (syncType != null) {
            return super.getSyncServiceImpByType(ctx, syncItemType, type);
        }
        WXSyncItemType wxType = WXSyncUtil.getWXSyncEnum(syncItemType);
        IBaseSync baseSync = null;
        switch (Integer.parseInt(wxType.getValue())) {
            case 100: {
                SyncContext syncPartCtx = this.getSyncContextByType(SyncHighItemType.PartJob, type);
                syncPartCtx.setCtx(ctx);
                baseSync = this.getPartServiceImp(syncPartCtx);
                break;
            }
            case 101: {
                SyncContext syncLeaderCtx = this.getSyncContextByType(SyncHighItemType.DeptLeader, type);
                syncLeaderCtx.setCtx(ctx);
                baseSync = this.getDeptLeaderServiceImp(syncLeaderCtx);
                break;
            }
            case 102: {
                SyncContext syncRelationCtx = this.getSyncContextByType(SyncHighItemType.Relations, type);
                syncRelationCtx.setCtx(ctx);
                baseSync = this.getRelationsServiceImp(syncRelationCtx);
            }
        }
        return baseSync;
    }

    @Override
    protected void init(Map syncImpMap) {
        super.init(syncImpMap);
    }

    @Override
    public SyncContext getSyncContextByType(SyncHighItemType itemType, int type) {
        SyncContext syncCtx = new SyncContext();
        syncCtx.setType(type);
        if (SyncHighItemType.Dept.equals((Object)itemType)) {
            syncCtx.setMappingTableName(ORG_MAPPING_TABLE);
            syncCtx.setSyncTableName(ORG_SYNC_TABLE);
            syncCtx.setMappingOrgIdColnum(ORG_WX_ID);
            syncCtx.setMappingOrgParentIdColnum(ORG_WX_PARENTID);
            syncCtx.setLogTableName(ORG_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.Dept);
            syncCtx.setNoSyncTableName(ORG_WX_NOSYNCORG);
        } else if (SyncHighItemType.Person.equals((Object)itemType)) {
            syncCtx.setMappingTableName(USER_MAPPING_TABLE);
            syncCtx.setSyncTableName(USER_SYNC_TABLE);
            syncCtx.setLogTableName(USER_SYNCLOG_TABLE);
            syncCtx.setMappingUserIdColnum(USER_WX_ID);
            syncCtx.setMappingOrgIdColnum(ORG_WX_ID);
            syncCtx.setHighItemType(SyncHighItemType.Person);
            syncCtx.setNoSyncTableName(USER_WX_NOSYNCPERSON);
        } else if (SyncHighItemType.PartJob.equals((Object)itemType)) {
            syncCtx.setMappingTableName(PART_MAPPING_TABLE);
            syncCtx.setSyncTableName(PART_SYNC_TABLE);
            syncCtx.setLogTableName(PART_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.PartJob);
            syncCtx.setNoSyncTableName(USER_WX_NOSYNCPERSON);
        } else if (SyncHighItemType.DeptLeader.equals((Object)itemType)) {
            syncCtx.setMappingTableName(DEPRLEADER_MAPPING_TABLE);
            syncCtx.setSyncTableName(DEPRLEADER_SYNC_TABLE);
            syncCtx.setLogTableName(DEPRLEADER_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.DeptLeader);
            syncCtx.setNoSyncTableName(USER_WX_NOSYNCPERSON);
        } else if (SyncHighItemType.Relations.equals((Object)itemType)) {
            syncCtx.setMappingTableName(RELATIONS_MAPPING_TABLE);
            syncCtx.setSyncTableName(RELATIONS_SYNC_TABLE);
            syncCtx.setLogTableName(RELATIONS_SYNCLOG_TABLE);
            syncCtx.setHighItemType(SyncHighItemType.Relations);
            syncCtx.setNoSyncTableName(USER_WX_NOSYNCPERSON);
        }
        return syncCtx;
    }

    @Override
    protected IBaseSync getDeptServiceImp(SyncContext ctx) {
        return new WXSyncDeptService(ctx);
    }

    @Override
    protected IBaseSync getPersonServiceImp(SyncContext ctx) {
        return new WXSyncPersonService(ctx);
    }

    @Override
    protected IBaseSync getDeptLeaderServiceImp(SyncContext syncDeptLeaderCtx) {
        return new WXSyncDeptLeaderService(syncDeptLeaderCtx);
    }

    @Override
    protected IBaseSync getPartServiceImp(SyncContext syncPartCtx) {
        return new WXSyncPartService(syncPartCtx);
    }

    @Override
    protected IBaseSync getRelationsServiceImp(SyncContext syncPartCtx) {
        return new WXSyncRelationsService(syncPartCtx);
    }
}

