/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.web.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncType;
import com.kingdee.eas.base.xtsync.web.AbstractEasXtSyncService;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class SyncDeptService
extends AbstractEasXtSyncService {
    private Context ctx;

    public SyncDeptService(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public String beforeSync(EasXtSyncType syncType) throws BOSException, EasXtException {
        logger.error((Object)"*******1 \tSyncDeptService beforeSync ******** ");
        long time1 = System.currentTimeMillis();
        this.updateXtOrgNew(this.ctx);
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 \t\u4ece\u8baf\u901a\u62c9\u6570\u636e\u5230T_XT_ORG\uff0cupdateXtOrg(ctx) \u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        this.updateOrgLongName(this.ctx);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******3 \t\u66f4\u65b0\u7ec4\u7ec7\u957f\u540d\u79f0\uff0cupdateOrgLongName(ctx) \u8017\u65f6\uff1a" + (time3 - time2) + "\u6beb\u79d2"));
        this.updateOrgName(this.ctx);
        long time4 = System.currentTimeMillis();
        logger.error((Object)("*******5 \t\u66f4\u65b0\u7ec4\u7ec7\u540d\u79f0\uff0cupdateOrgName(ctx) \u8017\u65f6\uff1a" + (time4 - time3) + "\u6beb\u79d2"));
        this.updateOrgStatus(this.ctx);
        long time5 = System.currentTimeMillis();
        logger.error((Object)("*******6 \t\u66f4\u65b0\u7ec4\u7ec7\u5c01\u5b58\u72b6\u6001\uff0c\u540c\u6b65\u65f6\u5220\u9664\uff0cupdateOrgStatus(ctx) \u8017\u65f6\uff1a" + (time5 - time4) + "\u6beb\u79d2"));
        this.updateOrgParentId(this.ctx);
        long time6 = System.currentTimeMillis();
        logger.error((Object)("*******7 \t\u66f4\u65b0\u7ec4\u7ec7\u4e0a\u7ea7id\u7528\u4e0e\u7ec4\u7ec7\u632a\u52a8\uff0cupdateOrgParentId(ctx) \u8017\u65f6\uff1a" + (time6 - time5) + "\u6beb\u79d2"));
        this.insertNewOrgToMap(this.ctx);
        long time7 = System.currentTimeMillis();
        logger.error((Object)("*******8 \t\u65b0\u589e\u7ec4\u7ec7\u5230orgmap\u8868\uff0cinsertNewOrgToMap(ctx) \u8017\u65f6\uff1a" + (time7 - time6) + "\u6beb\u79d2"));
        this.insertNoSyncOrg(this.ctx);
        long time8 = System.currentTimeMillis();
        logger.error((Object)("*******9 \t\u65b0\u589e\u90e8\u95e8\u63d2\u5165\u4e0d\u540c\u6b65\u8868\uff0cinsertNoSyncOrg(ctx) \u8017\u65f6\uff1a" + (time8 - time7) + "\u6beb\u79d2"));
        logger.error((Object)("*******10 \tSyncDeptService beforeSync \u603b\u8017\u65f6\uff1a" + (time8 - time1) + "\u6beb\u79d2"));
        return "true";
    }

    @Override
    public String sync(EasXtSyncItemType itemType) throws BOSException, EASBizException, EasXtException {
        String syncValue = "";
        logger.error((Object)"*******1 \tSyncDeptService sync *******");
        long time1 = System.currentTimeMillis();
        if (EasXtSyncItemType.AddNewOrg.equals((Object)itemType)) {
            syncValue = this.syncAddNewOrg(this.ctx, itemType);
        } else if (EasXtSyncItemType.DeleteOrg.equals((Object)itemType)) {
            syncValue = this.syncDeleteOrg(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdateOrgName.equals((Object)itemType)) {
            syncValue = this.syncUpdateOrgName(this.ctx, itemType);
        } else if (EasXtSyncItemType.MoveOrg.equals((Object)itemType)) {
            syncValue = this.syncMoveOrg(this.ctx, itemType);
        } else if (EasXtSyncItemType.SetOrgWeights.equals((Object)itemType)) {
            syncValue = this.syncUpdateOrgWeights(this.ctx, itemType);
        } else {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tSyncDeptService sync itemType:" + (Object)((Object)itemType) + " \u603b\u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        return syncValue;
    }

    @Override
    public String afterSync(EasXtSyncType itemType) throws BOSException, EASBizException {
        logger.error((Object)"*******1 \tSyncDeptService afterSync *******");
        long time1 = System.currentTimeMillis();
        this.updateXtOrgNew(this.ctx);
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******1 \tSyncDeptService \u518d\u6b21\u4ece\u8baf\u901a\u62c9\u6570\u636e\u5230T_XT_ORG\uff0cupdateXtOrg(ctx) \u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        this.bindOrgByOrgLongName(this.ctx);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tSyncDeptService \u6309\u7ec4\u7ec7\u957f\u540d\u79f0\u7ed1\u5b9a\u7ec4\u7ec7\uff0cbindOrgByOrgLongName(ctx) \u8017\u65f6\uff1a" + (time3 - time2) + "\u6beb\u79d2"));
        logger.error((Object)("*******3 \tSyncDeptService afterSync \u603b\u8017\u65f6:" + (time3 - time1) + "\u6beb\u79d2"));
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncAddNewOrg(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectAddNewOrgInfo");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray orgArray = new JSONArray();
        boolean fullUpdate = false;
        try {
            while (rowSet.next()) {
                if (rowSet.getString(1) == null) continue;
                orgArray.add((Object)rowSet.getString(1));
                if (orgArray.size() / 500 <= 0) continue;
                fullUpdate = true;
                this.syncDept(ctx, orgArray, itemType, orgArray);
                logger.error((Object)"******addNewOrg one more again********");
                orgArray = new JSONArray();
            }
            if (orgArray.size() > 0) {
                this.syncDept(ctx, orgArray, itemType, orgArray);
                logger.error((Object)"******addNewOrg over********");
                orgArray = new JSONArray();
            }
            if (rowSet.size() > 0) {
                this.MoveOrgAfterAdd(ctx, fullUpdate);
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncDeleteOrg(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = easXtSyncUtil.getValue("selectDeleteOrgInfo");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray orgArray = new JSONArray();
        JSONArray logArr = new JSONArray();
        try {
            while (rowSet.next()) {
                if (rowSet.getString(1) == null) continue;
                orgArray.add((Object)rowSet.getString("FXtOrgId"));
                logArr.add((Object)rowSet.getString("FOrgLongName"));
                if (orgArray.size() / 500 <= 0) continue;
                this.syncDept(ctx, orgArray, itemType, logArr);
                logger.error((Object)"******DeleteOrg one more again********");
                orgArray = new JSONArray();
                logArr = new JSONArray();
            }
            if (orgArray.size() > 0) {
                this.syncDept(ctx, orgArray, itemType, logArr);
                logger.error((Object)"******DeleteOrg over********");
                orgArray = new JSONArray();
                logArr = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            sql = easXtSyncUtil.getValue("updateOrgRealDelete");
            EasXtSyncUtil.execute(ctx, sql);
        }
        catch (BOSException e) {
            logger.equals("\u5220\u9664\u5df2\u5220\u9664\u7684\u7ec4\u7ec7\u4e2d\u95f4\u8868\u51fa\u9519");
            e.printStackTrace();
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncUpdateOrgName(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectUpdateOrgName");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray orgArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                if (rowSet.getString(1) == null || rowSet.getString(2) == null) continue;
                JSONObject orgJson = new JSONObject();
                orgJson.put("todepartment", (Object)rowSet.getString("orgLongName"));
                orgJson.put("orgId", (Object)rowSet.getString("orgId"));
                orgArray.add((Object)orgJson);
                JSONObject logO = new JSONObject();
                logO.put("todepartment", (Object)rowSet.getString("orgLongName"));
                logO.put("orgId", (Object)rowSet.getString("orgId"));
                logO.put("department", (Object)rowSet.getString("oldOrgLongName"));
                logArray.add((Object)logO);
                if (orgArray.size() / 500 <= 0) continue;
                this.syncDept(ctx, orgArray, itemType, logArray);
                logger.error((Object)"******UpdateOrgName one more again********");
                orgArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (orgArray.size() > 0) {
                this.syncDept(ctx, orgArray, itemType, logArray);
                logger.error((Object)"******UpdateOrgName over********");
                orgArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncUpdateOrgWeights(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectUpdateOrgWeights");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray orgArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                if (rowSet.getString("weights") == null || rowSet.getString("orgId") == null) continue;
                JSONObject orgJson = new JSONObject();
                orgJson.put("weights", (Object)rowSet.getString("weights"));
                orgJson.put("orgId", (Object)rowSet.getString("orgId"));
                orgArray.add((Object)orgJson);
                JSONObject logO = new JSONObject();
                logO.put("weights", (Object)rowSet.getString("weights"));
                logO.put("orgId", (Object)rowSet.getString("orgId"));
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logArray.add((Object)logO);
                if (orgArray.size() / 500 <= 0) continue;
                this.syncDept(ctx, orgArray, itemType, logArray);
                logger.error((Object)"******UpdateOrgName one more again********");
                orgArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (orgArray.size() > 0) {
                this.syncDept(ctx, orgArray, itemType, logArray);
                logger.error((Object)"******UpdateOrgName over********");
                orgArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String syncMoveOrg(Context ctx, EasXtSyncItemType itemType) throws BOSException, EASBizException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectMoveOrg");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray orgArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        JSONArray orgIdAndLongNumberArray = new JSONArray();
        try {
            while (rowSet.next()) {
                if (rowSet.getString(1) == null || rowSet.getString(2) == null) continue;
                JSONObject orgJson = new JSONObject();
                orgJson.put("orgId", (Object)rowSet.getString("orgId"));
                orgJson.put("moveToOrgId", (Object)rowSet.getString("moveToOrgId"));
                orgArray.add((Object)orgJson);
                JSONObject logO = new JSONObject();
                logO.put("oldPdepartment", (Object)rowSet.getString("oldPdepartment"));
                logO.put("todepartment", (Object)rowSet.getString("toPdepartment"));
                logO.put("department", (Object)rowSet.getString("department"));
                logArray.add((Object)logO);
                JSONObject idAndNumber = new JSONObject();
                idAndNumber.put("moveToOrgId", (Object)rowSet.getString("moveToOrgId"));
                idAndNumber.put("department", (Object)rowSet.getString("department"));
                orgIdAndLongNumberArray.add((Object)idAndNumber);
                this.syncDept(ctx, orgArray, itemType, logArray);
                logger.error((Object)"******UpdateOrgName one more again********");
                orgArray = new JSONArray();
                logArray = new JSONArray();
            }
            this.updateXtTable(ctx, orgIdAndLongNumberArray);
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    private void syncDept(Context ctx, JSONArray orgArray, EasXtSyncItemType itemType, JSONArray logArray) throws BOSException, EasXtException {
        logger.error((Object)("*****" + itemType.getName() + "********"));
        boolean isAll = true;
        JSONObject result = null;
        try {
            JSONObject response = null;
            if (EasXtSyncItemType.DeleteOrg.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncDeleteOrgInfoNew(orgArray);
            } else if (EasXtSyncItemType.UpdateOrgName.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncUpdateOrgNameNew(orgArray);
            } else if (EasXtSyncItemType.AddNewOrg.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncAddNewOrgInfo(orgArray);
            } else if (EasXtSyncItemType.MoveOrg.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncMoveOrgInfo(orgArray);
            } else if (EasXtSyncItemType.SetOrgWeights.equals((Object)itemType)) {
                response = XtCommunicateUtil.getInstance(ctx).syncUpdateOrgWeights(orgArray);
            } else {
                return;
            }
            if (response.getBooleanValue("success")) {
                logger.error((Object)("***" + itemType.getName() + "  success*********"));
                isAll = false;
                result = response;
            } else {
                logger.error((Object)("***" + itemType.getName() + "  fail*********" + response.toString()));
                result = response;
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
            }
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)("***" + itemType.getName() + "  exception*********"));
            e.printStackTrace();
            throw e;
        }
        finally {
            EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        }
    }

    private void MoveOrgAfterAdd(Context ctx, boolean fullUpdate) throws EASBizException, BOSException {
        if (fullUpdate) {
            this.afterSync(null);
            this.syncMoveOrg(ctx, EasXtSyncItemType.MoveOrg);
        } else {
            JSONArray result = this.getOrgBySyncTime(ctx);
            if (result != null) {
                logger.error((Object)("\u83b7\u53d6\u672c\u6b21\u540c\u6b65\u65b0\u589e\u7ec4\u7ec7\u6570\u636e\u4e3a\uff1a" + result.toJSONString()));
                this.insertIntoXtOrgTable(ctx, result);
                this.bindOrgByOrgLongName(ctx);
                String sql = EasXtSyncUtil.getInstance(ctx).getValue("updateOrgXtParentId");
                EasXtSyncUtil.execute(ctx, sql);
                this.syncMoveOrg(ctx, EasXtSyncItemType.MoveOrg);
            }
        }
    }

    private void updateXtTable(Context ctx, JSONArray orgIdAndLongNumberArray) {
        String sql = "SELECT TOP 1 FID FROM T_XT_SYNCHTIME ORDER BY FSYNCHTIME DESC";
        IRowSet rs = null;
        IRowSet rs_update = null;
        String syncTime = null;
        try {
            rs = EasXtSyncUtil.executeQuery(ctx, sql);
            if (rs.next() && StringUtils.isEmpty((String)(syncTime = rs.getString("fid")))) {
                return;
            }
            String sql_move = "SELECT FORGLONGNAME,FOLDORGLONGNAME FROM T_XT_SYNCDEPTLOG WHERE FTYPE = 20 AND FSUCCESS = 1 AND FSYNCTIMEID = '" + syncTime + "'";
            rs_update = EasXtSyncUtil.executeQuery(ctx, sql_move);
            while (rs_update.next()) {
                String orgOldLongName = rs_update.getString("FOLDORGLONGNAME");
                String orgParentId = this.getParentId(orgOldLongName, orgIdAndLongNumberArray);
                if (StringUtils.isEmpty((String)orgParentId)) {
                    logger.error((Object)("\u632a\u52a8\u7ec4\u7ec7\u7684\u76ee\u6807ID\u4e3a\u7a7a;\u76ee\u6807\u4e0a\u7ea7\u957f\u540d\u79f0\u4e3a" + rs_update.getString("FORGLONGNAME")));
                    continue;
                }
                String orgLongName = rs_update.getString("FORGLONGNAME");
                orgLongName = orgLongName.contains("\\") ? orgLongName + orgOldLongName.substring(orgOldLongName.lastIndexOf("\\"), orgOldLongName.length()) : orgOldLongName.substring(orgOldLongName.lastIndexOf("\\") + 1, orgOldLongName.length());
                String updateXtOrg = "UPDATE T_XT_ORG SET FORGLONGNAME = '" + orgLongName + "' ,FPARENTID = '" + orgParentId + "' where FORGLONGNAME = '" + orgOldLongName + "'";
                EasXtSyncUtil.execute(ctx, updateXtOrg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
    }

    private String getParentId(String orgOldLongName, JSONArray orgIdAndLongNumberArray) {
        for (int i = 0; i < orgIdAndLongNumberArray.size(); ++i) {
            JSONObject orgIdAndLong = orgIdAndLongNumberArray.getJSONObject(i);
            String longNumber = orgIdAndLong.getString("department");
            if (!orgOldLongName.equals(longNumber)) continue;
            return orgIdAndLong.getString("moveToOrgId");
        }
        return null;
    }
}

