/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.web.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncType;
import com.kingdee.eas.base.xtsync.web.AbstractEasXtSyncService;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtViewDataUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

public class SyncPersonService
extends AbstractEasXtSyncService {
    private Context ctx;

    public SyncPersonService(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public String beforeSync(EasXtSyncType syncType) throws BOSException {
        boolean isFirst = "1900-01-01 01:01:01".equals(EasXtCommonUtils.getLastCheckTime(this.ctx));
        logger.error((Object)"*******1 \tSyncPersonService beforeSync *******");
        long time1 = System.currentTimeMillis();
        this.updateXtUser(this.ctx, syncType);
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tSyncPersonService \u4ece\u8baf\u901a\u62c9\u6570\u636e\u5230T_XT_USER\uff0cupdateXtUser(ctx, syncType) \u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        this.updateUserStatus(this.ctx);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******3 \tSyncPersonService \u66f4\u65b0\u7528\u6237\u72b6\u6001\uff0cupdateUserStatus(ctx) \u8017\u65f6\uff1a" + (time3 - time2) + "\u6beb\u79d2"));
        this.updateUserMapByPersonNotInServ(this.ctx);
        long time4 = System.currentTimeMillis();
        logger.error((Object)("*******4 \tSyncPersonService \u66f4\u65b0\u79bb\u804c\u4eba\u5458\uff0cupdateUserStatus(ctx) \u8017\u65f6\uff1a" + (time4 - time3) + "\u6beb\u79d2"));
        this.fillUserId(this.ctx);
        long time5 = System.currentTimeMillis();
        logger.error((Object)("*******5 \tSyncPersonService \u8865\u2014\u2014\u5145\u7528\u6237\u4fe1\u606f\uff0cfillUserId(ctx) \u8017\u65f6\uff1a" + (time5 - time4) + "\u6beb\u79d2"));
        this.updateUserInfo(this.ctx);
        long time6 = System.currentTimeMillis();
        logger.error((Object)("*******6 \tSyncPersonService \u66f4\u65b0\u804c\u5458\u57fa\u672c\u4fe1\u606f\uff0cupdateUserInfo(ctx) \u8017\u65f6\uff1a" + (time6 - time5) + "\u6beb\u79d2"));
        this.insertNewPersonToMap(this.ctx);
        long time7 = System.currentTimeMillis();
        logger.error((Object)("*******7 \tSyncPersonService \u65b0\u589e\u804c\u5458\u540c\u6b65T_PM_EASXTUSERMAP\uff0cinsertNewPersonToMap(ctx) \u8017\u65f6\uff1a" + (time7 - time6) + "\u6beb\u79d2"));
        this.setDefaultNull(this.ctx);
        long time8 = System.currentTimeMillis();
        logger.error((Object)("*******8 \tSyncPersonService \u68c0\u67e5\u5b8c\u6210\u540e,\u8bbe\u7f6et_pm_easxtusermap\u4e2d''\u7684\u5b57\u6bb5\u4e3anull\uff0c\u517c\u5bb9sql server\u548coracle\uff0csetDefaultNull(ctx) \u8017\u65f6\uff1a" + (time8 - time7) + "\u6beb\u79d2"));
        this.updateSynchStatus(this.ctx);
        long time9 = System.currentTimeMillis();
        logger.error((Object)("*******9 \tSyncPersonService \u66f4\u65b0\u662f\u5426\u53ef\u540c\u6b65\u5b57\u6bb5\uff0cupdateSynchStatus(ctx) \u8017\u65f6\uff1a" + (time9 - time8) + "\u6beb\u79d2"));
        if (!isFirst) {
            this.insertNoSyncPerson(this.ctx);
            this.insertNoSyncPersonByPosition(this.ctx);
        }
        long time10 = System.currentTimeMillis();
        logger.error((Object)("*******10 \tSyncPersonService \u90e8\u95e8\uff08\u804c\u4f4d\uff09\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u540c\u6b65\u540e\uff0c\u5176\u4e0b\u65b0\u589e\u7684\u804c\u5458\u4e0d\u540c\u6b65\u5230\u4e91\u4e4b\u5bb6   \uff0cinsertNoSyncPerson(ctx) \u975e\u9996\u6b21 " + !isFirst + " \u8017\u65f6\uff1a" + (time10 - time9) + "\u6beb\u79d2"));
        this.syncIsExistsUser(this.ctx);
        long time11 = System.currentTimeMillis();
        logger.error((Object)("*******11 SyncPersonService beforeSync \u603b \u8017\u65f6\uff1a" + (time11 - time1) + "\u6beb\u79d2"));
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJob(Context ctx, EasXtSyncType syncType) {
        block17: {
            try {
                EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
                Map xtConfig = easXtSyncUtil.getXtConfig(ctx);
                if (!"0".equals(xtConfig.get("isInitJob"))) break block17;
                logger.error((Object)"**********\u521d\u59cb\u5316\u804c\u4f4d\u5f00\u59cb***********");
                String sql = "";
                sql = EasXtSyncType.Incre.equals((Object)syncType) ? EasXtSyncUtil.getInstance(ctx).getValue("selectAddJob") : EasXtSyncUtil.getInstance(ctx).getValue("selectAllJob");
                IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
                JSONArray dataArray = new JSONArray();
                JSONArray logArray = new JSONArray();
                try {
                    while (rowSet.next()) {
                        JSONObject o = new JSONObject();
                        o.put("openId", (Object)rowSet.getString("fxtId"));
                        o.put("name", (Object)rowSet.getString("fpersonname"));
                        o.put("jobTitle", (Object)"");
                        dataArray.add((Object)o);
                        JSONObject logO = new JSONObject();
                        logO.put("department", (Object)rowSet.getString("forglongname"));
                        logO.put("name", (Object)rowSet.getString("fpersonname"));
                        logO.put("phone", (Object)rowSet.getString("fcell"));
                        logO.put("email", (Object)rowSet.getString("femail"));
                        logO.put("jobTitle", (Object)rowSet.getString("fposition"));
                        logO.put("personId", (Object)rowSet.getString("fpersonId"));
                        logO.put("birthday", null);
                        logO.put("officePhone1", (Object)"");
                        logO.put("officePhone2", (Object)"");
                        logO.put("weights", (Object)rowSet.getString("fweights"));
                        logO.put("gender", (Object)rowSet.getString("fgender"));
                        logO.put("number", (Object)rowSet.getString("fpersonnumber"));
                        logO.put("openId", (Object)rowSet.getString("fxtId"));
                        logArray.add((Object)logO);
                        if (dataArray.size() / 500 <= 0) continue;
                        this.syncPerson(ctx, dataArray, logArray, EasXtSyncItemType.UpdatePersonPosition);
                        logger.error((Object)"****initJob  one more again****");
                        dataArray = new JSONArray();
                        logArray = new JSONArray();
                    }
                    if (dataArray.size() > 0) {
                        this.syncPerson(ctx, dataArray, logArray, EasXtSyncItemType.UpdatePersonPosition);
                        logger.error((Object)"*******initJob over*****");
                        dataArray = new JSONArray();
                        logArray = new JSONArray();
                    }
                    logger.error((Object)"**********\u521d\u59cb\u5316\u804c\u4f4d\u7ed3\u675f***********");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e instanceof BOSException) {
                        throw (BOSException)((Object)e);
                    }
                }
                finally {
                    if (rowSet != null) {
                        try {
                            rowSet.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String sync(EasXtSyncItemType itemType) throws BOSException, EASBizException {
        String syncValue = "";
        logger.error((Object)"*******1 \tSyncPersonService sync *******");
        long time1 = System.currentTimeMillis();
        if (EasXtSyncItemType.AddNewPerson.equals((Object)itemType)) {
            syncValue = this.syncAddNewPersonInfo(this.ctx, itemType);
        } else if (EasXtSyncItemType.DeletePerson.equals((Object)itemType)) {
            syncValue = this.syncDeletePersonInfo(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonStatus.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonStatus(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonOrg.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonOrg(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonOther.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfo(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonCell.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonCell(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonName.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoNew(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonGender.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoNew(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonPosition.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoNew(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonWeights.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoNew(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonCustom.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoCuston(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonNumber.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoNew(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonBirthday.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoNew(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonHireDate.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonInfoNew(this.ctx, itemType);
        } else if (EasXtSyncItemType.UpdatePersonEmail.equals((Object)itemType)) {
            syncValue = this.syncUpdatePersonEmail(this.ctx, itemType);
        } else {
            throw new BOSException("\u672a\u77e5\u7c7b\u578b\u5f02\u5e38\uff0cType is \uff1a" + (Object)((Object)itemType));
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tSyncPersonService sync itemType:" + (Object)((Object)itemType) + " \u603b\u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        return syncValue;
    }

    @Override
    public String afterSync(EasXtSyncType syncType) throws BOSException {
        logger.error((Object)"*******1 \tSyncPersonService afterSync *******");
        long time1 = System.currentTimeMillis();
        this.updateXtUser(this.ctx, syncType);
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tSyncPersonService afterSync \u518d\u6b21\u4ece\u8baf\u901a\u62c9\u6570\u636e\u5230T_XT_USER\uff0cupdateXtUser(ctx, syncType) \u8017\u65f6:" + (time2 - time1) + "\u6beb\u79d2"));
        this.bindByNameAndCell(this.ctx);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******3 \tSyncPersonService afterSync \u6309\u59d3\u540d\u7535\u8bdd\u7ed1\u5b9a\uff0cbindByNameAndCell(ctx) \u8017\u65f6:" + (time3 - time2) + "\u6beb\u79d2"));
        this.bindByNameAndMail(this.ctx);
        long time4 = System.currentTimeMillis();
        logger.error((Object)("*******4 \tSyncPersonService afterSync \u6309\u59d3\u540d\u90ae\u7bb1\u7ed1\u5b9a\uff0cbindByNameAndMail(ctx)\u8017\u65f6\uff1a" + (time4 - time3) + "\u6beb\u79d2"));
        logger.error((Object)("*******5 \tSyncPersonService afterSync \u603b\u8017\u65f6:" + (time4 - time1) + "\u6beb\u79d2"));
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncAddNewPersonInfo(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectAddNewUserInfo");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray jsonArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                JSONObject account = new JSONObject();
                String birthday = SyncPersonService.getBirthdyStr(rowSet.getString("birthday"));
                account.put("mobile", (Object)rowSet.getString("cell"));
                account.put("email", (Object)rowSet.getString("email"));
                o.put("account", (Object)account);
                o.put("name", (Object)rowSet.getString("easPersonName"));
                o.put("department", (Object)rowSet.getString("orgLongName"));
                o.put("jobTitle", (Object)rowSet.getString("position"));
                o.put("gender", (Object)rowSet.getString("gender"));
                o.put("birthday", (Object)birthday);
                o.put("hireDate", (Object)SyncPersonService.getBirthdyStr(rowSet.getString("hireDate")));
                o.put("weights", (Object)rowSet.getInt("weights"));
                if (this.isItemUpdate(ctx, "isUpdatePersonNumber")) {
                    o.put("jobNo", (Object)rowSet.getString("easpersonnumber"));
                }
                o.put("regSource", (Object)"EAS");
                jsonArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("gender", (Object)rowSet.getString("gender"));
                logO.put("birthday", (Object)rowSet.getString("birthday"));
                logO.put("hireDate", (Object)rowSet.getString("hireDate"));
                logO.put("weights", (Object)rowSet.getInt("weights"));
                logArray.add((Object)logO);
                if (jsonArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******addnewperson one more again*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (jsonArray.size() > 0) {
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******addnewperson over*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncDeletePersonInfo(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = easXtSyncUtil.getValue("selectDeletedUser1");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray jsonArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                jsonArray.add((Object)rowSet.getString("xtId"));
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("openId", (Object)rowSet.getString("xtId"));
                logArray.add((Object)logO);
                if (jsonArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******deleteperson one more again*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (jsonArray.size() > 0) {
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******deleteperson over*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdatePersonStatus(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = easXtSyncUtil.getValue("selectUpdatePersonStatus");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray jsonArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("xtId"));
                int ftype = rowSet.getInt("ftype");
                String type = "";
                switch (ftype) {
                    case 1: {
                        type = "2";
                        break;
                    }
                    case 0: {
                        type = "1";
                        break;
                    }
                    case 2: {
                        type = "1";
                        break;
                    }
                    case 3: {
                        type = "1";
                        break;
                    }
                    case 4: {
                        type = "2";
                        break;
                    }
                    default: {
                        type = "3";
                    }
                }
                o.put("type", (Object)"1");
                jsonArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("type", (Object)rowSet.getString("ftype"));
                logO.put("openId", (Object)rowSet.getString("xtId"));
                logArray.add((Object)logO);
                if (jsonArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******deleteperson one more again*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (jsonArray.size() > 0) {
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******deleteperson over*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        sql = easXtSyncUtil.getValue("deleteUsersWithProblem");
        EasXtSyncUtil.execute(ctx, sql);
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdatePersonInfo(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectUserChanged");
        String configSql = "and ((easxt.FPosition is not null and ltrim(rtrim(easxt.FPosition)) != ltrim(rtrim(xt.FPosition))) or (p.FGender != xt.FGender)) and not exists(select nsp.fpersonid from T_XT_NoSyncPerson nsp where nsp.fpersonid = easxt.fpersonid)";
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        try {
            JSONArray dataArray = new JSONArray();
            JSONArray logArray = new JSONArray();
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("xtId"));
                o.put("name", (Object)rowSet.getString("easPersonName"));
                o.put("jobTitle", (Object)rowSet.getString("position"));
                o.put("gender", (Object)rowSet.getString("FGender"));
                dataArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("birthday", (Object)rowSet.getString("fbirthday"));
                logO.put("officePhone1", (Object)rowSet.getString("fofficePhone1"));
                logO.put("officePhone2", (Object)rowSet.getString("fofficePhone2"));
                logO.put("weights", (Object)rowSet.getString("findex"));
                logO.put("gender", (Object)rowSet.getString("FGender"));
                logO.put("openId", (Object)rowSet.getString("xtId"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"****syncUpdatePersonInfo  one more again****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"****syncUpdatePersonInfo over****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdatePersonInfoNew(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        StringBuffer sql = new StringBuffer(EasXtSyncUtil.getInstance(ctx).getValue("selectUserChangedNew"));
        if (EasXtSyncItemType.UpdatePersonGender.equals((Object)itemType)) {
            sql.append(" and (p.FGender != xt.FGender or xt.FGender is null)");
        } else if (EasXtSyncItemType.UpdatePersonName.equals((Object)itemType)) {
            sql.append(" and (ltrim(rtrim(case when(easxt.FUserId is null) then easxt.FPersonName else easxt.FUserName end)) != ltrim(rtrim(xt.FPersonName)) or xt.FPersonName is null or xt.FPersonName = '')");
        } else if (EasXtSyncItemType.UpdatePersonPosition.equals((Object)itemType)) {
            sql.append(" and (ltrim(rtrim(easxt.FPosition)) != ltrim(rtrim(xt.FPosition)) or xt.FPosition is null or xt.FPosition = '')");
        } else if (EasXtSyncItemType.UpdatePersonWeights.equals((Object)itemType)) {
            sql.append(" and (easxt.fweights != xt.fweights or xt.fweights is null)");
        } else if (EasXtSyncItemType.UpdatePersonNumber.equals((Object)itemType)) {
            sql.append(" and (ltrim(rtrim(easxt.FPersonNumber)) != ltrim(rtrim(xt.FPersonNumber)) or xt.FPersonNumber is null or xt.FPersonNumber = '')");
        } else if (EasXtSyncItemType.UpdatePersonBirthday.equals((Object)itemType)) {
            sql.append(" and p.FBirthday is not null and (p.FBirthday != xt.FBirthday2 or xt.FBirthday2 is null)");
        } else if (EasXtSyncItemType.UpdatePersonHireDate.equals((Object)itemType)) {
            sql.append(" and easxt.FHireDate is not null and (easxt.FHireDate != xt.FHireDate or xt.FHireDate is null)");
        }
        String noSyncSql = " and not exists(select nsp.fpersonid from T_XT_NoSyncPerson nsp where nsp.fpersonid = easxt.fpersonid)";
        sql.append(noSyncSql);
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql.toString());
        try {
            JSONArray dataArray = new JSONArray();
            JSONArray logArray = new JSONArray();
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("xtId"));
                if (EasXtSyncItemType.UpdatePersonGender.equals((Object)itemType)) {
                    o.put("gender", (Object)rowSet.getString("FGender"));
                } else if (EasXtSyncItemType.UpdatePersonName.equals((Object)itemType)) {
                    o.put("name", (Object)rowSet.getString("easPersonName"));
                } else if (EasXtSyncItemType.UpdatePersonPosition.equals((Object)itemType)) {
                    o.put("jobTitle", (Object)rowSet.getString("position"));
                } else if (EasXtSyncItemType.UpdatePersonWeights.equals((Object)itemType)) {
                    o.put("weights", (Object)rowSet.getString("weights"));
                } else if (EasXtSyncItemType.UpdatePersonNumber.equals((Object)itemType)) {
                    o.put("jobNo", (Object)rowSet.getString("easpersonnumber"));
                } else if (EasXtSyncItemType.UpdatePersonBirthday.equals((Object)itemType)) {
                    String birthDay = SyncPersonService.getBirthdyStr(rowSet.getString("fbirthday"));
                    if (StringUtils.isEmpty((String)birthDay)) {
                        o.put("birthday", (Object)"");
                    } else {
                        o.put("birthday", (Object)birthDay);
                    }
                } else if (EasXtSyncItemType.UpdatePersonHireDate.equals((Object)itemType)) {
                    String hireDate = SyncPersonService.getBirthdyStr(rowSet.getString("fhiredate"));
                    if (StringUtils.isEmpty((String)hireDate)) continue;
                    o.put("hireDate", (Object)hireDate);
                }
                dataArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("birthday", (Object)rowSet.getString("fbirthday"));
                logO.put("hireDate", (Object)SyncPersonService.getBirthdyStr(rowSet.getString("fhiredate")));
                logO.put("officePhone1", (Object)rowSet.getString("fofficePhone1"));
                logO.put("officePhone2", (Object)rowSet.getString("fofficePhone2"));
                logO.put("weights", (Object)rowSet.getString("findex"));
                logO.put("gender", (Object)rowSet.getString("FGender"));
                logO.put("number", (Object)rowSet.getString("easpersonnumber"));
                logO.put("openId", (Object)rowSet.getString("xtId"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"****syncUpdatePersonInfo  one more again****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"****syncUpdatePersonInfo over****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdatePersonInfoCuston(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        Map config = null;
        StringBuffer sql = new StringBuffer();
        try {
            config = this._getXtConfig(ctx);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        String customSql = (String)config.get("customSql");
        if (null == config || !this.isItemUpdate(ctx, "isUpdatePersonCustom") || StringUtils.isEmpty((String)customSql)) {
            return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
        }
        sql.append(customSql);
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql.toString());
        try {
            JSONArray dataArray = new JSONArray();
            JSONArray logArray = new JSONArray();
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                ResultSetMetaData rsMeta = rowSet.getMetaData();
                int columnCount = rsMeta.getColumnCount();
                JSONArray contact = new JSONArray();
                String openId = null;
                for (int i = 1; i <= columnCount; ++i) {
                    JSONObject customObj = new JSONObject();
                    String columnName = rsMeta.getColumnName(i);
                    String columnValue = rowSet.getString(columnName);
                    if ("openId".equalsIgnoreCase(columnName)) {
                        openId = rowSet.getString(columnName);
                        continue;
                    }
                    customObj.put("name", (Object)columnName);
                    customObj.put("value", (Object)columnValue);
                    customObj.put("type", (Object)"O");
                    contact.add((Object)customObj);
                }
                if (StringUtils.isEmpty(openId)) continue;
                o.put("contact", (Object)contact);
                o.put("openId", openId);
                dataArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)"\u65e0");
                logO.put("name", (Object)"\u65e0");
                logO.put("phone", (Object)"\u65e0");
                logO.put("email", (Object)"\u65e0");
                logO.put("jobTitle", (Object)"\u65e0");
                logO.put("personId", (Object)"\u65e0");
                logO.put("birthday", null);
                logO.put("officePhone1", (Object)"\u65e0");
                logO.put("officePhone2", (Object)"\u65e0");
                logO.put("weights", (Object)"-1");
                logO.put("gender", (Object)"0");
                logO.put("contact", (Object)(openId + "======" + contact.toString()));
                logO.put("openId", (Object)rowSet.getString("openId"));
                logArray.add((Object)logO);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"****syncUpdatePersonInfoCuston  one more again****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"****syncUpdatePersonInfoCuston over****");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdatePersonCell(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectChangeCellUserInfo");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray jsonArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("phone", (Object)rowSet.getString("cell"));
                o.put("openId", (Object)rowSet.getString("fxtid"));
                jsonArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("openId", (Object)rowSet.getString("fxtid"));
                logArray.add((Object)logO);
                if (jsonArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******selectChangeCellUserInfo one more again*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (jsonArray.size() > 0) {
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******selectChangeCellUserInfo over*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdatePersonEmail(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectChangeEmailUserInfo");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray jsonArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("email", (Object)rowSet.getString("email"));
                o.put("openId", (Object)rowSet.getString("fxtid"));
                jsonArray.add((Object)o);
                JSONObject logO = new JSONObject();
                logO.put("department", (Object)rowSet.getString("orgLongName"));
                logO.put("todepartment", (Object)rowSet.getString("orgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("openId", (Object)rowSet.getString("fxtid"));
                logArray.add((Object)logO);
                if (jsonArray.size() / 200 <= 0) continue;
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******selectChangeEmailUserInfo one more again*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (jsonArray.size() > 0) {
                this.syncPerson(ctx, jsonArray, logArray, itemType);
                logger.error((Object)"*******selectChangeEmailUserInfo over*****");
                jsonArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdatePersonOrg(Context ctx, EasXtSyncItemType itemType) throws BOSException, EasXtException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("selectOrgChanged");
        IRowSet rowSet = EasXtSyncUtil.executeQuery(ctx, sql);
        JSONArray dataArray = new JSONArray();
        JSONArray logArray = new JSONArray();
        try {
            while (rowSet.next()) {
                JSONObject o = new JSONObject();
                o.put("openId", (Object)rowSet.getString("xtId"));
                o.put("department", (Object)rowSet.getString("orgLongName"));
                JSONObject logO = new JSONObject();
                logO.put("todepartment", (Object)rowSet.getString("orgLongName"));
                logO.put("department", (Object)rowSet.getString("oldOrgLongName"));
                logO.put("name", (Object)rowSet.getString("easPersonName"));
                logO.put("phone", (Object)rowSet.getString("cell"));
                logO.put("email", (Object)rowSet.getString("email"));
                logO.put("jobTitle", (Object)rowSet.getString("position"));
                logO.put("personId", (Object)rowSet.getString("easPersonId"));
                logO.put("openId", (Object)rowSet.getString("xtId"));
                logArray.add((Object)logO);
                dataArray.add((Object)o);
                if (dataArray.size() / 500 <= 0) continue;
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******updateXtByOrg one more again********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
            if (dataArray.size() > 0) {
                this.syncPerson(ctx, dataArray, logArray, itemType);
                logger.error((Object)"******updateXtByOrg over********");
                dataArray = new JSONArray();
                logArray = new JSONArray();
            }
        }
        catch (EasXtException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(ctx, itemType));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncPerson(Context ctx, JSONArray dataArray, JSONArray logArray, EasXtSyncItemType itemType) throws EasXtException, BOSException {
        JSONObject result;
        boolean isAll;
        block21: {
            JSONObject response;
            String description;
            block19: {
                block20: {
                    logger.error((Object)("*****" + itemType.getName() + "********"));
                    isAll = true;
                    description = "\u4e91\u4e4b\u5bb6\u63a5\u53e3\u8bbf\u95ee\u5f02\u5e38";
                    result = null;
                    response = null;
                    if (EasXtSyncItemType.AddNewPerson.equals((Object)itemType)) {
                        response = XtCommunicateUtil.getInstance(ctx).syncAddNewPersonInfoNew(dataArray);
                        break block19;
                    }
                    if (EasXtSyncItemType.DeletePerson.equals((Object)itemType)) {
                        response = XtCommunicateUtil.getInstance(ctx).deletePersonStatus(dataArray);
                        break block19;
                    }
                    if (EasXtSyncItemType.UpdatePersonStatus.equals((Object)itemType)) {
                        XtCommunicateUtil.getInstance(ctx);
                        response = XtCommunicateUtil.updatePersonStatus(dataArray);
                        break block19;
                    }
                    if (EasXtSyncItemType.UpdatePersonOrg.equals((Object)itemType)) {
                        response = XtCommunicateUtil.getInstance(ctx).syncUpdateUserOrgInfo(dataArray);
                        break block19;
                    }
                    if (EasXtSyncItemType.UpdatePersonOther.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonName.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonGender.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonPosition.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonCustom.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonNumber.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonWeights.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonBirthday.equals((Object)itemType) || EasXtSyncItemType.UpdatePersonHireDate.equals((Object)itemType)) {
                        response = XtCommunicateUtil.getInstance(ctx).syncUpdatePersonInfo(dataArray);
                        break block19;
                    }
                    if (EasXtSyncItemType.UpdatePersonCell.equals((Object)itemType)) {
                        response = XtCommunicateUtil.getInstance(ctx).syncUpdatePersonCell(dataArray);
                        break block19;
                    }
                    if (!EasXtSyncItemType.UpdatePersonEmail.equals((Object)itemType)) break block20;
                    response = XtCommunicateUtil.getInstance(ctx).syncUpdatePersonEmail(dataArray);
                    break block19;
                }
                if (null == logArray || null != logArray && logArray.size() == 0) {
                    logArray = dataArray;
                }
                EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
                return;
            }
            try {
                if (response.getBooleanValue("success")) {
                    logger.error((Object)("***" + itemType.getName() + "  success*********"));
                    isAll = false;
                    result = response;
                    if (EasXtSyncItemType.DeletePerson.equals((Object)itemType)) {
                        try {
                            EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
                            String sql = "delete from t_xt_user where fid in (" + EasXtCommonUtils.getIncludeStr((String[])dataArray.toArray((Object[])new String[dataArray.size()])) + ")";
                            EasXtSyncUtil.execute(ctx, sql);
                            sql = "delete from t_pm_easxtusermap where fxtid in (" + EasXtCommonUtils.getIncludeStr((String[])dataArray.toArray((Object[])new String[dataArray.size()])) + ")";
                            EasXtViewDataUtil.updatePersonRealDelete(ctx, dataArray);
                        }
                        catch (BOSException e) {
                            logger.error((Object)"\u5220\u9664\u4eba\u5458\u540e\u5220\u9664\u4e2d\u95f4\u8868\u548c\u8baf\u901a\u4eba\u5458\u8868\u51fa\u9519\uff1a");
                            e.printStackTrace();
                        }
                    }
                    break block21;
                }
                logger.error((Object)("***" + itemType.getName() + "  fail*********" + response.toString()));
                description = response.getString("error");
                result = response;
                if (300 == response.getIntValue("errorCode")) throw new EasXtException(EasXtException.OPENCLOUD);
                if (301 != response.getIntValue("errorCode")) break block21;
                throw new EasXtException(EasXtException.OPENCLOUD);
            }
            catch (EasXtException e) {
                try {
                    e.printStackTrace();
                    throw e;
                    catch (BOSException e2) {
                        logger.error((Object)("***" + itemType.getName() + "  exception*********"));
                        e2.printStackTrace();
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (null == logArray || null != logArray && logArray.size() == 0) {
                        logArray = dataArray;
                    }
                    EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
                    throw throwable;
                }
            }
        }
        if (null == logArray || null != logArray && logArray.size() == 0) {
            logArray = dataArray;
        }
        EasXtSyncLogUtils.syncLog(ctx, logArray, result, itemType, isAll);
        return;
    }

    private void updateSyncResult4UserMap(Context ctx, JSONArray data) {
        String bindSucUserSql = "update T_PM_EASXTUSERMAP set FXtId=? where FCell = ? ";
        JSONObject retPerson = new JSONObject();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = new ArrayList<String>();
        int msgCode = 209;
        String phone = "";
        for (int i = 0; i < data.size(); ++i) {
            retPerson = (JSONObject)data.get(i);
            msgCode = retPerson.getIntValue("msgCode");
            phone = retPerson.getString("phone");
            if (209 != msgCode || StringUtils.isEmpty((String)phone)) continue;
            param = new ArrayList();
            param.add(retPerson.getString("openId"));
            param.add(phone);
            params.add(param.toArray());
        }
        try {
            EasXtSyncUtil.executeBatch(ctx, bindSucUserSql, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static String getBirthdyStr(String birthday) {
        if (StringUtils.isEmpty((String)birthday) || "null".equalsIgnoreCase(birthday) || birthday.length() < 10) {
            return "";
        }
        return birthday.substring(0, 10);
    }
}

