/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.xtutil;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtilExt;
import com.kingdee.eas.base.xtsync.xtutil.HttpUtil;
import com.kingdee.eas.base.xtsync.xtutil.Properties;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EasXtSyncUtil {
    private static Logger logger = Logger.getLogger(EasXtSyncUtil.class);
    private Document doc = null;
    private static Map config = null;
    private static Map cpConfig = null;
    private String initCheckTime = "1900-01-01 01:01:01";
    private static EasXtSyncUtil instance = null;
    private long xmlFileTime = 0L;
    private static String GETTOKEN = "https://www.yunzhijia.com/gateway/oauth2/token/getAccessToken";
    private static String BINDYZJ = "https://yunzhijia.com/gateway/openorg/erp/addErpTypeNoCover?accessToken=";
    private static String DEFAULT_HELPURL = "http://club.kingdee.com/forum.php?mod=viewthread&tid=1176217&page=1&extra=#pid3225964";
    private static String FILE_SQL = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "eas_web.war" + File.separator + "base" + File.separator + "xtsync" + File.separator + "easXtSync.xml";
    private static String FILE_CONFIG = System.getProperty("eas.properties.dir") + File.separator + "easXtSyncConfig.properties";
    public static String VERSION_CONFIG = "";
    private static String DEFAULT_MCLOUD = "https://kingdee.yunzhijia.com";
    private static String DEFAULT_MANAGEURL = "http://yunzhijia.com/space/c/manage";

    private EasXtSyncUtil() {
        this.loadXml();
    }

    public static EasXtSyncUtil getInstance(Context ctx) {
        if (instance == null) {
            instance = new EasXtSyncUtil();
        }
        EasXtSyncUtil.loadSetting(ctx);
        return instance;
    }

    public boolean isChangeEip(String eip) {
        return eip != null && !"".equals(eip) && !eip.equals(config.get("eip"));
    }

    private boolean isReloadXml() {
        File file = new File(FILE_SQL);
        long lastModefiedTime = file.lastModified();
        if (this.xmlFileTime == 0L || this.xmlFileTime < lastModefiedTime) {
            this.xmlFileTime = lastModefiedTime;
            return true;
        }
        return false;
    }

    private static void loadSetting(Context ctx) {
        config = new Properties();
        cpConfig = new Properties();
        String sql = "SELECT TOP 1 FSettingMsg,FCpSettingMsg FROM T_XT_SaveSetting ORDER BY FCreateTime DESC";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (iRowSet != null && iRowSet.next()) {
                String configValue;
                String configKey;
                String[] val;
                int i;
                String[] str;
                String settingMsg = iRowSet.getString("FSettingMsg");
                String cpSettingMsg = iRowSet.getString("FCpSettingMsg");
                if (StringUtils.isEmpty((String)settingMsg)) {
                    config.put("mCloud", DEFAULT_MCLOUD);
                    config.put("manageUrl", DEFAULT_MANAGEURL);
                    config.put("helpUrl", "");
                } else {
                    str = settingMsg.split(";");
                    for (i = 0; i < str.length; ++i) {
                        val = str[i].split("==");
                        configKey = val[0];
                        configValue = "0";
                        if (val.length > 1) {
                            configValue = val[1];
                        }
                        config.put(configKey, configValue);
                    }
                }
                if (StringUtils.isEmpty((String)cpSettingMsg)) {
                    cpConfig.put("cooperativeKey", "");
                    cpConfig.put("isStart", "0");
                    cpConfig.put("isHiddenName", "1");
                } else {
                    str = cpSettingMsg.split(";");
                    for (i = 0; i < str.length; ++i) {
                        val = str[i].split("==");
                        configKey = val[0];
                        configValue = "0";
                        if (val.length > 1) {
                            configValue = val[1];
                        }
                        cpConfig.put(configKey, configValue);
                    }
                }
            } else {
                config.put("mCloud", DEFAULT_MCLOUD);
                config.put("manageUrl", DEFAULT_MANAGEURL);
                config.put("helpUrl", DEFAULT_HELPURL);
                cpConfig.put("cooperativeKey", "");
                cpConfig.put("isStart", "0");
                cpConfig.put("isHiddenName", "1");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Map getXtConfig(Context ctx) {
        if (EasXtSyncUtil.isFirstSync(ctx)) {
            EasXtSyncUtil.loadSetting(ctx);
        }
        Properties properties = (Properties)config;
        return this.createOldProperties(properties);
    }

    public Map getCpConfig(Context ctx) {
        if (EasXtSyncUtil.isFirstSync(ctx)) {
            EasXtSyncUtil.loadSetting(ctx);
        }
        Properties properties = (Properties)cpConfig;
        return this.createOldProperties(properties);
    }

    private Map createOldProperties(Properties properties) {
        java.util.Properties propertiesByDB = properties.getPropertiesByDB();
        Set<String> set = propertiesByDB.stringPropertyNames();
        java.util.Properties newConfig = new java.util.Properties();
        for (String key : set) {
            String value = propertiesByDB.getProperty(key);
            newConfig.put(key, value);
        }
        return newConfig;
    }

    public String getEid() {
        return (String)config.get("eip");
    }

    public String getCloud() {
        return (String)config.get("mCloud");
    }

    public boolean writeInitXtConfig() {
        String mCloud = (String)config.get("mCloud");
        String manageUrl = (String)config.get("manageUrl");
        String helpUrl = (String)config.get("helpUrl");
        String customSql = (String)config.get("customSql");
        mCloud = StringUtils.isEmpty((String)mCloud) || "null".equals(mCloud) ? DEFAULT_MCLOUD : mCloud;
        manageUrl = StringUtils.isEmpty((String)manageUrl) || "null".equals(manageUrl) ? DEFAULT_MANAGEURL : manageUrl;
        helpUrl = StringUtils.isEmpty((String)helpUrl) || "null".equals(helpUrl) ? DEFAULT_HELPURL : helpUrl;
        customSql = StringUtils.isEmpty((String)customSql) || "null".equals(customSql) ? "" : customSql;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("eip", "");
        map.put("mCloud", mCloud);
        map.put("manageUrl", manageUrl);
        map.put("helpUrl", helpUrl);
        map.put("customSql", customSql);
        map.put("isUpdateOrg", "1");
        map.put("isUpdateOrgName", "1");
        map.put("isDeleteOrg", "0");
        map.put("isMoveOrg", "0");
        map.put("isUpdateDepartmentPerson", "0");
        map.put("isUpdatePerson", "1");
        map.put("isDeletePerson", "0");
        map.put("isUpdatePersonOrg", "0");
        map.put("isUpdatePersonSupplementaryInfo", "0");
        map.put("isUpdateSuperiorsMsg", "0");
        map.put("isUpdatePartSuperiorsMsg", "0");
        map.put("isUpdatePluralityMsg", "0");
        map.put("isUpdateMobile", "0");
        map.put("isUpdatePersonName", "0");
        map.put("isUpdatePersonNumber", "0");
        map.put("isUpdatePersonPosition", "0");
        map.put("isUpdatePersonGender", "0");
        map.put("isUpdatePersonWeights", "0");
        map.put("isUpdatePersonCustom", "0");
        map.put("isUpdateCellFromXtAuto", "0");
        map.put("isUpdateOrgWeights", "0");
        map.put("isAutoUpdateCell", "0");
        map.put("isExistsUser", "0");
        map.put("isUpdatePersonBirthday", "0");
        map.put("isUpdatePersonHireDate", "0");
        map.put("cooperativeKey", "");
        map.put("isStart", "0");
        map.put("isHiddenName", "1");
        map.put("isUpdatePersonEmail", "0");
        return this.writeXtConfig(null, map);
    }

    public boolean writeXtConfig(Context ctx, Map map) {
        boolean flag = false;
        if (map == null) {
            return flag;
        }
        String eip = ((String)map.get("eip")).trim();
        String dbCode = "";
        String mcloud = ((String)map.get("mCloud")).trim();
        String manageUrl = (String)map.get("manageUrl");
        String helpUrl = (String)map.get("helpUrl");
        String customSql = (String)map.get("customSql");
        helpUrl = StringUtils.isEmpty((String)helpUrl) ? DEFAULT_HELPURL : helpUrl;
        String isUpdateOrg = (String)map.get("isUpdateOrg");
        String isUpdateOrgName = (String)map.get("isUpdateOrgName");
        String isDeleteOrg = (String)map.get("isDeleteOrg");
        String isMoveOrg = (String)map.get("isMoveOrg");
        String isUpdateDepartmentPerson = (String)map.get("isUpdateDepartmentPerson");
        String isUpdatePerson = (String)map.get("isUpdatePerson");
        String isDeletePerson = (String)map.get("isDeletePerson");
        String isUpdatePersonOrg = (String)map.get("isUpdatePersonOrg");
        String isUpdatePersonSupplementaryInfo = (String)map.get("isUpdatePersonSupplementaryInfo");
        String isUpdateSuperiorsMsg = (String)map.get("isUpdateSuperiorsMsg");
        String isUpdatePartSuperiorsMsg = (String)map.get("isUpdatePartSuperiorsMsg");
        String isUpdatePluralityMsg = (String)map.get("isUpdatePluralityMsg");
        String isUpdateMobile = (String)map.get("isUpdateMobile");
        String isUpdatePersonName = (String)map.get("isUpdatePersonName");
        String isUpdatePersonNumber = (String)map.get("isUpdatePersonNumber");
        String isUpdatePersonPosition = (String)map.get("isUpdatePersonPosition");
        String isUpdatePersonGender = (String)map.get("isUpdatePersonGender");
        String isUpdatePersonWeights = (String)map.get("isUpdatePersonWeights");
        String isUpdatePersonCustom = (String)map.get("isUpdatePersonCustom");
        String isUpdateCellFromXtAuto = (String)map.get("isUpdateCellFromXtAuto");
        String isUpdateOrgWeights = (String)map.get("isUpdateOrgWeights");
        String isAutoUpdateCell = (String)map.get("isAutoUpdateCell");
        String isUpdatePersonBirthday = (String)map.get("isUpdatePersonBirthday");
        String isExistsUser = (String)map.get("isExistsUser");
        String isUpdatePersonHireDate = (String)map.get("isUpdatePersonHireDate");
        String cooperativeKey = ((String)map.get("cooperativeKey")).trim();
        String isStart = (String)map.get("isStart");
        String isHiddenName = (String)map.get("isHiddenName");
        String isUpdatePersonEmail = (String)map.get("isUpdatePersonEmail");
        if (ctx != null) {
            dbCode = ctx.getAIS();
            StringBuilder setting = new StringBuilder();
            setting.append("eip==" + eip + ";");
            setting.append("dbCode==" + dbCode + ";");
            setting.append("mCloud==" + mcloud + ";");
            setting.append("manageUrl==" + manageUrl + ";");
            setting.append("helpUrl==" + helpUrl + ";");
            setting.append("customSql==" + (StringUtils.isEmpty((String)customSql) ? " " : customSql) + ";");
            setting.append("isUpdateOrg==" + isUpdateOrg + ";");
            setting.append("isUpdateOrgName==" + isUpdateOrgName + ";");
            setting.append("isDeleteOrg==" + isDeleteOrg + ";");
            setting.append("isMoveOrg==" + isMoveOrg + ";");
            setting.append("isUpdateDepartmentPerson==" + isUpdateDepartmentPerson + ";");
            setting.append("isUpdatePerson==" + isUpdatePerson + ";");
            setting.append("isDeletePerson==" + isDeletePerson + ";");
            setting.append("isUpdatePersonOrg==" + isUpdatePersonOrg + ";");
            setting.append("isUpdatePersonSupplementaryInfo==" + isUpdatePersonSupplementaryInfo + ";");
            setting.append("isUpdateSuperiorsMsg==" + isUpdateSuperiorsMsg + ";");
            setting.append("isUpdatePartSuperiorsMsg==" + isUpdatePartSuperiorsMsg + ";");
            setting.append("isUpdatePluralityMsg==" + isUpdatePluralityMsg + ";");
            setting.append("isUpdateMobile==" + isUpdateMobile + ";");
            setting.append("isUpdatePersonName==" + isUpdatePersonName + ";");
            setting.append("isUpdatePersonNumber==" + isUpdatePersonNumber + ";");
            setting.append("isUpdatePersonPosition==" + isUpdatePersonPosition + ";");
            setting.append("isUpdatePersonGender==" + isUpdatePersonGender + ";");
            setting.append("isUpdatePersonWeights==" + isUpdatePersonWeights + ";");
            setting.append("isUpdatePersonCustom==" + isUpdatePersonCustom + ";");
            setting.append("isUpdateCellFromXtAuto==" + isUpdateCellFromXtAuto + ";");
            setting.append("isUpdateOrgWeights==" + isUpdateOrgWeights + ";");
            setting.append("isAutoUpdateCell==" + isAutoUpdateCell + ";");
            setting.append("isUpdatePersonBirthday==" + isUpdatePersonBirthday + ";");
            setting.append("isExistsUser==" + isExistsUser + ";");
            setting.append("isUpdatePersonHireDate==" + isUpdatePersonHireDate + ";");
            setting.append("isUpdatePersonEmail==" + isUpdatePersonEmail + ";");
            StringBuffer cpSetting = new StringBuffer();
            cpSetting.append("cooperativeKey==" + cooperativeKey + ";");
            cpSetting.append("isStart==" + isStart + ";");
            cpSetting.append("isHiddenName==" + isHiddenName + ";");
            StringBuilder detailLogMsg = new StringBuilder();
            detailLogMsg.append("\u3010\u4e91\u4e4b\u5bb6\u5730\u5740\u3011 \uff1a ");
            detailLogMsg.append(mcloud);
            detailLogMsg.append(";\n");
            detailLogMsg.append("\u3010\u4f01\u4e1a\u6ce8\u518c\u53f7\u3011 \uff1a ");
            detailLogMsg.append(eip);
            detailLogMsg.append(";\n");
            detailLogMsg.append(this.formatString(isUpdateOrgName));
            detailLogMsg.append("\u3010\u66f4\u65b0\u7ec4\u7ec7\u540d\u79f0\u3011;\n");
            detailLogMsg.append(this.formatString(isMoveOrg));
            detailLogMsg.append("\u3010\u7ec4\u7ec7\u632a\u52a8\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdateOrgWeights));
            detailLogMsg.append("\u3010\u66f4\u65b0\u7ec4\u7ec7\u6392\u5e8f\u3011;\n");
            detailLogMsg.append(this.formatString(isDeleteOrg));
            detailLogMsg.append("\u3010\u5220\u9664\u7ec4\u7ec7\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdateOrg));
            detailLogMsg.append("\u3010\u65b0\u589e\u7ec4\u7ec7\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePerson));
            detailLogMsg.append("\u3010\u65b0\u589e\u4eba\u5458\u3011;\n");
            detailLogMsg.append(this.formatString(isDeletePerson));
            detailLogMsg.append("\u3010\u5220\u9664\u4eba\u5458\u3011;\n");
            detailLogMsg.append(this.formatString(isExistsUser));
            detailLogMsg.append("\u3010\u4ec5\u540c\u6b65\u5173\u8054\u7528\u6237\u7684\u804c\u5458\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdateMobile));
            detailLogMsg.append("\u3010\u4eceEAS\u66f4\u65b0\u624b\u673a\u5230\u4e91\u4e4b\u5bb6\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonOrg));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u7ec4\u7ec7\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonName));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u59d3\u540d\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonNumber));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u7f16\u7801\uff08\u4f01\u4e1a\u5de5\u53f7\uff09\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonEmail));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u90ae\u7bb1\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonGender));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u6027\u522b\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonPosition));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u804c\u4f4d\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonWeights));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u6392\u5e8f\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonBirthday));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u751f\u65e5\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePersonHireDate));
            detailLogMsg.append("\u3010\u66f4\u65b0\u4eba\u5458\u5165\u804c\u65e5\u671f\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdateDepartmentPerson));
            detailLogMsg.append("\u3010\u540c\u6b65\u90e8\u95e8\u8d1f\u8d23\u4eba\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePluralityMsg));
            detailLogMsg.append("\u3010\u540c\u6b65\u90e8\u95e8\u517c\u804c\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdateSuperiorsMsg));
            detailLogMsg.append("\u3010\u540c\u6b65\u4e0a\u7ea7\u3011;\n");
            detailLogMsg.append(this.formatString(isUpdatePartSuperiorsMsg));
            detailLogMsg.append("\u3010\u5305\u542b\u517c\u804c\u804c\u4f4d\u6c47\u62a5\u4e0a\u7ea7\u3011;\n");
            detailLogMsg.append(this.formatString(isAutoUpdateCell));
            detailLogMsg.append("\u3010\u4ece\u4e91\u4e4b\u5bb6\u66f4\u65b0\u624b\u673a\u5230EAS\u3011;\n");
            String companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            IObjectPK beginLog = LogUtil.beginLog((Context)ctx, (String)"\u540c\u6b65\u5de5\u5177-\u4fee\u6539\u9879\u76ee\u53c2\u6570", (BOSObjectType)new BOSObjectType("F4AF4F04"), (IObjectPK)ctx.getCaller(), (String)detailLogMsg.toString(), (String)"XTSync_Operate", (String)companyId);
            if (null != beginLog) {
                String sql = "update T_LOG_App set FENTITYALIAS_L2 = '\u540c\u6b65\u5de5\u5177' where fid = '" + beginLog.toString() + "'";
                try {
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            EasXtSyncUtil.saveSetting(ctx, setting.toString(), cpSetting.toString());
            LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
            flag = true;
        }
        config.put("eip", eip);
        config.put("dbCode", dbCode);
        config.put("mCloud", mcloud);
        config.put("manageUrl", manageUrl);
        config.put("helpUrl", helpUrl);
        config.put("customSql", customSql);
        config.put("isUpdateOrg", isUpdateOrg);
        config.put("isUpdateOrgName", isUpdateOrgName);
        config.put("isDeleteOrg", isDeleteOrg);
        config.put("isMoveOrg", isMoveOrg);
        config.put("isUpdateDepartmentPerson", isUpdateDepartmentPerson);
        config.put("isUpdatePerson", isUpdatePerson);
        config.put("isDeletePerson", isDeletePerson);
        config.put("isUpdatePersonOrg", isUpdatePersonOrg);
        config.put("isUpdatePersonSupplementaryInfo", isUpdatePersonSupplementaryInfo);
        config.put("isUpdateSuperiorsMsg", isUpdateSuperiorsMsg);
        config.put("isUpdatePartSuperiorsMsg", isUpdatePartSuperiorsMsg);
        config.put("isUpdatePluralityMsg", isUpdatePluralityMsg);
        config.put("isUpdateMobile", isUpdateMobile);
        config.put("isUpdatePersonName", isUpdatePersonName);
        config.put("isUpdatePersonNumber", isUpdatePersonNumber);
        config.put("isUpdatePersonPosition", isUpdatePersonPosition);
        config.put("isUpdatePersonGender", isUpdatePersonGender);
        config.put("isUpdatePersonWeights", isUpdatePersonWeights);
        config.put("isUpdatePersonCustom", isUpdatePersonCustom);
        config.put("isUpdateCellFromXtAuto", isUpdateCellFromXtAuto);
        config.put("isUpdateOrgWeights", isUpdateOrgWeights);
        config.put("isAutoUpdateCell", isAutoUpdateCell);
        config.put("isUpdatePersonBirthday", isUpdatePersonBirthday);
        config.put("isExistsUser", isExistsUser);
        config.put("isUpdatePersonHireDate", isUpdatePersonHireDate);
        config.put("isUpdatePersonEmail", isUpdatePersonEmail);
        config.put("cooperativeKey", cooperativeKey);
        config.put("isStart", isStart);
        config.put("isHiddenName", isHiddenName);
        return flag;
    }

    private String formatString(String s) {
        return "1".equals(s) ? "\u542f\u7528" : "\u7981\u7528";
    }

    private void bindYZJ(String eip, String secret) {
        try {
            JSONObject requestJson = new JSONObject();
            requestJson.put("eid", (Object)eip);
            requestJson.put("secret", (Object)secret);
            requestJson.put("timestamp", (Object)new Date().getTime());
            requestJson.put("scope", (Object)"resGroupSecret");
            JSONObject tokenJson = HttpUtil.sendPostByJson(GETTOKEN, requestJson);
            if (tokenJson.getBoolean("success").booleanValue()) {
                JSONObject dataJson = tokenJson.getJSONObject("data");
                String token = dataJson.getString("accessToken");
                JSONObject requestData = new JSONObject();
                requestData.put("eid", (Object)eip);
                requestData.put("erpId", (Object)104);
                HttpUtil.sendPostByForm(BINDYZJ + token, requestData);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public boolean writeXtConfig(Map map) {
        return this.writeXtConfig(null, map);
    }

    private void loadXml() {
        if (!this.isReloadXml()) {
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(FILE_SQL);
            SAXReader reader = new SAXReader();
            this.doc = reader.read((InputStream)is);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getValue(String key) throws BOSException {
        String value = EasXtSyncUtilExt.getInstance().getValue(key);
        if (value == null) {
            this.loadXml();
            Element element = this.doc.elementByID(key);
            if (element == null) {
                throw new BOSException("\u4ece\u914d\u7f6e\u6587\u4ef6\uff08" + FILE_SQL + "\u4ee5\u53ca\u6269\u5c55\u6587\u4ef6\uff09\u83b7\u53d6\u67e5\u8be2\u952e\u503c\u4e3a\uff08" + key + "\uff09SQL\u4e3a\u7a7a");
            }
            value = element.getTextTrim();
        }
        return value;
    }

    public boolean isFirstCheck(String checkTime) {
        return checkTime.equals(this.initCheckTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downloadPdf() {
        InputStream in = null;
        try {
            in = new FileInputStream(System.getProperty("eas.properties.dir") + File.separator + "cloudPermission.pdf");
            byte[] size = new byte[in.available()];
            in.read(size);
            byte[] byArray = size;
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFirstSync(Context ctx) {
        boolean isFirst = true;
        IRowSet rowSet1 = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID FROM T_XT_SaveSetting");
        try {
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet1 != null && rowSet1.next()) {
                isFirst = false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return isFirst;
    }

    private static void saveSetting(Context ctx, String xtSetting, String cpSetting) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_XT_SaveSetting(FID,FSettingMsg,FCpSettingMsg,FCreateTime) values(?,?,?,?)");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(BOSUuid.create((String)"F4AF4F04").toString());
        param.add(xtSetting);
        param.add(cpSetting);
        param.add(new Timestamp(new Date().getTime()));
        params.add(param.toArray());
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public boolean isItemUpdate(String updateItem) {
        if (StringUtils.isEmpty((String)updateItem)) {
            return false;
        }
        if (null != config) {
            return "1".equals(config.get(updateItem));
        }
        return false;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            return rs;
        }
        catch (BOSException e) {
            logger.error((Object)("sql exception, sql is:" + sql));
            e.printStackTrace();
            throw new BOSException("sql execute exception, please collect server logs for check or feedback");
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, int start, int rows) throws BOSException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)rows);
            return rs;
        }
        catch (BOSException e) {
            logger.error((Object)("sql exception, sql is:" + sql));
            e.printStackTrace();
            throw new BOSException("sql execute exception, please collect server logs for check or feedback");
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            return rs;
        }
        catch (BOSException e) {
            logger.error((Object)("sql exception, sql is:" + sql));
            e.printStackTrace();
            throw new BOSException("sql execute exception, please collect server logs for check or feedback");
        }
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)("sql exception, sql is:" + sql));
            e.printStackTrace();
            throw new BOSException("sql execute exception, please collect server logs for check or feedback");
        }
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)("sql exception, sql is:" + sql));
            e.printStackTrace();
            throw new BOSException("sql execute exception, please collect server logs for check or feedback");
        }
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql, (List)paramsList);
        }
        catch (BOSException e) {
            logger.error((Object)("sql exception, sql is:" + sql));
            e.printStackTrace();
            throw new BOSException("sql execute exception, please collect server logs for check or feedback");
        }
    }

    static {
        ResourceBundle resource = ResourceBundle.getBundle("conf.XTConstant");
        VERSION_CONFIG = resource.getString("xtsync_version");
    }
}

