/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.ConstantPool;
import java.util.Hashtable;

public class Context {
    private static Hashtable threads = new Hashtable();
    public static final String CONSTANT_POOL = "ConstantPool";
    public static final String DEBUG = "Debug";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getCurrent() {
        Hashtable hashtable = threads;
        synchronized (hashtable) {
            Hashtable x = (Hashtable)threads.get(Thread.currentThread());
            if (x == null) {
                x = new Hashtable();
                threads.put(Thread.currentThread(), x);
            }
            return x;
        }
    }

    public static Object get(String name) {
        return Context.get(name, null);
    }

    public static Object get(String name, Object defaultValue) {
        Hashtable h = Context.getCurrent();
        if (h.containsKey(name)) {
            return h.get(name);
        }
        return defaultValue;
    }

    public static void set(String name, Object value) {
        Context.getCurrent().put(name, value);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String x = (String)Context.get(name);
        if (x == null) {
            return defaultValue;
        }
        return new Boolean(x);
    }

    public static boolean getBoolean(String name) {
        return Context.getBoolean(name, false);
    }

    public static void setBoolean(String name, boolean b) {
        Context.set(name, new Boolean(b).toString());
    }

    public static void setConstantPool(ConstantPool pool) {
        Context.set(CONSTANT_POOL, pool);
    }

    public static ConstantPool getConstantPool() {
        return (ConstantPool)Context.get(CONSTANT_POOL);
    }

    public static void setDebug(boolean b) {
        Context.setBoolean(DEBUG, b);
    }

    public static boolean isDebug() {
        return Context.getBoolean(DEBUG);
    }
}

