/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.ByteCodeWriter;
import com.tool.classfile.CodeException;
import com.tool.classfile.ConstantPool;
import com.tool.classfile.Context;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.SourceWriter;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.InstructionWriter;
import com.tool.classfile.pcodes.Instruction_goto;
import com.tool.classfile.pcodes.Instruction_jsr;
import com.tool.classfile.pcodes.Instruction_jump;
import com.tool.classfile.pcodes.Instruction_lookup;
import com.tool.classfile.pcodes.Instruction_ret;
import com.tool.classfile.pcodes.Instruction_return;
import com.tool.classfile.pcodes.Instruction_switch;
import com.tool.classfile.pcodes.Instruction_throw;
import com.tool.classfile.pcodes.Label;
import com.tool.classfile.pcodes.LocalVariable;
import com.tool.classfile.pcodes.OperandStack;
import com.tool.classfile.sc;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class ByteCodes {
    public Vector codes = new Vector();
    public Vector local_variable_table = new Vector();
    public Vector exception_table = new Vector();
    public int max_stack;
    public int max_locals;
    static /* synthetic */ Class class$com$tool$classfile$pcodes$Label;

    public void addLocalVariable(LocalVariable var, Label start, Label end) {
        this.local_variable_table.addElement(new LocalVariableTable(var, start, end));
    }

    public void addExceptionTable(Label start, Label end, Label target, String type) {
        this.exception_table.addElement(new ExceptionTable(start, end, target, type));
    }

    public byte[] buildInfo(ConstantPool pool) {
        ByteCodeWriter out = new ByteCodeWriter();
        byte[] codes = this.buildCodes(pool);
        Checker checker = new Checker();
        checker.check();
        out.writeu2(checker.stack.max_stack);
        out.writeu2(this.max_locals);
        out.writeu4(codes.length);
        out.write(codes);
        out.writeu2(this.exception_table.size());
        int i = 0;
        while (i < this.exception_table.size()) {
            ExceptionTable item = (ExceptionTable)this.exception_table.elementAt(i);
            out.writeu2(item.start.start_pc);
            out.writeu2(item.end.start_pc);
            out.writeu2(item.target.start_pc);
            out.writeu2(pool.getClass(item.type));
            ++i;
        }
        out.writeu2(2);
        byte[] lvInfo = this.buildLocalVariableInfo(pool);
        out.writeu2(pool.getString("LocalVariableTable"));
        out.writeu4(lvInfo.length);
        out.write(lvInfo);
        byte[] lnInfo = this.buildLineNumberInfo();
        out.writeu2(pool.getString("LineNumberTable"));
        out.writeu4(lnInfo.length);
        out.write(lnInfo);
        return out.toByteArray();
    }

    public Label[] getLineNumberTable() {
        Vector<Label> ls = new Vector<Label>();
        int last_number = 0;
        int i = 0;
        while (i < this.codes.size()) {
            Label l = (Label)this.codes.elementAt(i);
            if (l.line_number != last_number && l.line_number != 0) {
                ls.addElement(l);
                last_number = l.line_number;
            }
            ++i;
        }
        return (Label[])sc.toArray(class$com$tool$classfile$pcodes$Label == null ? (class$com$tool$classfile$pcodes$Label = ByteCodes.class$("com.tool.classfile.pcodes.Label")) : class$com$tool$classfile$pcodes$Label, ls);
    }

    private byte[] buildLineNumberInfo() {
        Label[] ls = this.getLineNumberTable();
        ByteCodeWriter out = new ByteCodeWriter();
        out.writeu2(ls.length);
        int i = 0;
        while (i < ls.length) {
            out.writeu2(ls[i].start_pc);
            out.writeu2(ls[i].line_number);
            ++i;
        }
        return out.toByteArray();
    }

    private byte[] buildLocalVariableInfo(ConstantPool pool) {
        ByteCodeWriter out = new ByteCodeWriter();
        int varCount = 0;
        int i = 0;
        while (i < this.local_variable_table.size()) {
            LocalVariableTable item = (LocalVariableTable)this.local_variable_table.elementAt(i);
            if (item.var.name != null) {
                ++varCount;
            }
            ++i;
        }
        out.writeu2(varCount);
        int i2 = 0;
        while (i2 < this.local_variable_table.size()) {
            LocalVariableTable item = (LocalVariableTable)this.local_variable_table.elementAt(i2);
            if (item.var.name != null) {
                out.writeu2(item.start.start_pc);
                out.writeu2(item.end.start_pc - item.start.start_pc);
                out.writeu2(pool.getString(item.var.name));
                out.writeu2(pool.getString(item.var.type));
                out.writeu2(item.var.index);
            }
            ++i2;
        }
        return out.toByteArray();
    }

    private byte[] buildCodes(ConstantPool pool) {
        Context.setConstantPool(pool);
        InstructionWriter out = new InstructionWriter(pool, this);
        int i = 0;
        while (i < this.codes.size()) {
            Label x = (Label)this.codes.elementAt(i);
            x.start_pc = out.current_pc();
            if (x instanceof Instruction) {
                Instruction instr = (Instruction)x;
                instr.write(out);
            }
            ++i;
        }
        return out.toByteArray();
    }

    public void dumpCodes(PrintWriter out) throws IOException {
        int i = 0;
        while (i < this.codes.size()) {
            Object x = this.codes.elementAt(i);
            if (x instanceof Instruction) {
                Instruction instr = (Instruction)x;
                out.println(instr.start_pc + "\t" + instr.toString());
            }
            ++i;
        }
    }

    public void dump(PrintWriter out) throws IOException {
        out.println("max_stack:\t" + this.max_stack);
        out.println("max_locals:\t" + this.max_locals);
        this.dumpCodes(out);
        this.dumpExceptionTable(out);
        this.dumpLocalVariableTable(out);
        this.dumpLineNumberTable(out);
    }

    public void dumpExceptionTable(PrintWriter out) throws IOException {
        out.println("Exceptions");
        out.println("\tstart\tend\ttarget\tcatch_type");
        int i = 0;
        while (i < this.exception_table.size()) {
            ExceptionTable item = (ExceptionTable)this.exception_table.elementAt(i);
            out.print("\t" + item.start.start_pc + "\t" + item.end.start_pc + "\t" + item.target.start_pc + "\t");
            if (item.type == null) {
                out.println("any");
            } else {
                out.println(sc.javaType(item.type));
            }
            ++i;
        }
    }

    public void dumpLocalVariableTable(PrintWriter out) throws IOException {
        out.println("LocalVariableTable");
        out.println("\tstart\tend\tname\ttype");
        int i = 0;
        while (i < this.local_variable_table.size()) {
            LocalVariableTable item = (LocalVariableTable)this.local_variable_table.elementAt(i);
            if (item.var.name != null) {
                out.println("\t" + item.start.start_pc + "\t" + item.end.start_pc + "\t" + item.var.name + "\t" + sc.javaType(item.var.type));
            }
            ++i;
        }
    }

    public void dumpLineNumberTable(PrintWriter out) throws IOException {
        out.println("LineNumberTable");
        out.println("\tline\tstart_pc");
        Label[] ls = this.getLineNumberTable();
        int i = 0;
        while (i < ls.length) {
            out.println("\t" + ls[i].line_number + "\t" + ls[i].start_pc);
            ++i;
        }
    }

    public void buildAsm(MethodDefinition method, SourceWriter out) throws IOException {
        int i = 0;
        while (i < this.codes.size()) {
            Label label = (Label)this.codes.elementAt(i);
            int start_pc = label.start_pc;
            int next_pc = -1;
            if (i < this.codes.size() - 1) {
                next_pc = ((Label)this.codes.elementAt((int)(i + 1))).start_pc;
            }
            if (label instanceof Instruction) {
                int j = 0;
                while (j < this.local_variable_table.size()) {
                    LocalVariableTable item = (LocalVariableTable)this.local_variable_table.elementAt(j);
                    if (!item.var.isParameter && item.end.start_pc == start_pc) {
                        out.writeLine("/*end of variable " + item.var.name + " */");
                    }
                    ++j;
                }
                int j2 = 0;
                while (j2 < this.local_variable_table.size()) {
                    LocalVariableTable item = (LocalVariableTable)this.local_variable_table.elementAt(j2);
                    if (!item.var.isParameter && (item.start.start_pc == 0 && start_pc == 0 || item.start.start_pc == next_pc)) {
                        if (item.var.name == null) {
                            item.var.name = "#" + item.var.index;
                        }
                        out.writeLine(sc.javaType(item.var.type) + " " + item.var.name + ";");
                    }
                    ++j2;
                }
                Instruction instr = (Instruction)label;
                instr.line_number = out.line_number();
                out.writeLine("" + instr.start_pc + "\t" + instr.toString());
            }
            ++i;
        }
    }

    public void checkCodes() throws CodeException {
        new Checker().check();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Checker {
        CheckItem[] items;
        OperandStack stack = new OperandStack();
        boolean debug = Context.isDebug();

        Checker() {
            if (ByteCodes.this.codes.size() == 0) {
                this.items = new CheckItem[0];
            } else {
                Label l = (Label)ByteCodes.this.codes.elementAt(ByteCodes.this.codes.size() - 1);
                int end_pc = l.start_pc;
                if (l instanceof Instruction) {
                    end_pc += ((Instruction)l).length();
                }
                this.items = new CheckItem[end_pc];
            }
            int line_number = 0;
            int i = 0;
            while (i < ByteCodes.this.codes.size()) {
                Label l = (Label)ByteCodes.this.codes.elementAt(i);
                if (l.line_number != 0) {
                    line_number = l.line_number;
                }
                if (l instanceof Instruction) {
                    CheckItem item = new CheckItem();
                    item.instr = (Instruction)l;
                    item.line_number = line_number;
                    this.items[l.start_pc] = item;
                }
                ++i;
            }
        }

        void check() throws CodeException {
            if (this.items.length == 0) {
                return;
            }
            this.check(0);
            int i = 0;
            while (i < ByteCodes.this.exception_table.size()) {
                ExceptionTable item = (ExceptionTable)ByteCodes.this.exception_table.elementAt(i);
                int start_pc = item.target.start_pc;
                CodeException.assertThat(this.items[start_pc] != null);
                if (this.items[start_pc].checked) {
                    this.items[start_pc].checkFailed("enter exception_handler codes.");
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < ByteCodes.this.exception_table.size()) {
                ExceptionTable item = (ExceptionTable)ByteCodes.this.exception_table.elementAt(i2);
                int start_pc = item.target.start_pc;
                this.stack.clear();
                this.stack.push("Ljava/lang/Object;");
                this.check(start_pc);
                ++i2;
            }
            if (this.debug) {
                boolean conti = true;
                block2: while (conti) {
                    conti = false;
                    int i3 = 0;
                    while (i3 < this.items.length) {
                        if (this.items[i3] != null && !this.items[i3].checked) {
                            this.items[i3].checkWarning("code not reachable.");
                            this.stack.clear();
                            this.check(i3);
                            conti = true;
                            continue block2;
                        }
                        ++i3;
                    }
                }
            }
        }

        private void check(int start_pc) throws CodeException {
            Object save = this.stack.checkPoint();
            while (true) {
                if (start_pc >= this.items.length) {
                    throw new CodeException("end of codes without return.");
                }
                CheckItem item = this.items[start_pc];
                CodeException.assertThat(item != null);
                if (item.checked) {
                    if (item.stack_size == this.stack.size()) break;
                    item.checkFailed("invalid stack size " + item.stack_size + "!=" + this.stack.size());
                    break;
                }
                if (this.debug) {
                    System.out.println(item.instr.start_pc + "\tline=" + item.line_number + "\t" + "stack=" + this.stack.toString());
                    System.out.println("\t" + item.instr);
                    System.out.println();
                }
                item.stack_size = this.stack.size();
                item.checked = true;
                Instruction instr = item.instr;
                try {
                    instr.checkStack(this.stack);
                }
                catch (CodeException e) {
                    e.printStackTrace();
                    item.checkFailed(e.getMessage());
                }
                if (instr instanceof Instruction_jump) {
                    Instruction_jump jump = (Instruction_jump)instr;
                    this.check(jump.target.start_pc);
                    if (instr instanceof Instruction_jsr) {
                        this.stack.pop();
                    } else if (instr instanceof Instruction_goto) {
                        break;
                    }
                } else {
                    if (instr instanceof Instruction_switch) {
                        Instruction_switch sw = (Instruction_switch)instr;
                        int i = 0;
                        while (i < sw.case_targets.length) {
                            this.check(sw.case_targets[i].start_pc);
                            ++i;
                        }
                        this.check(sw.default_target.start_pc);
                        break;
                    }
                    if (instr instanceof Instruction_lookup) {
                        Instruction_lookup lk = (Instruction_lookup)instr;
                        int i = 0;
                        while (i < lk.case_targets.length) {
                            this.check(lk.case_targets[i].start_pc);
                            ++i;
                        }
                        this.check(lk.default_target.start_pc);
                        break;
                    }
                    if (instr instanceof Instruction_ret || instr instanceof Instruction_return || instr instanceof Instruction_throw) break;
                }
                start_pc += instr.length();
            }
            this.stack.reverse(save);
        }
    }

    private class CheckItem {
        Instruction instr = null;
        int line_number = 0;
        boolean checked = false;
        int stack_size = 0;

        private CheckItem() {
        }

        String title() {
            String s = "(start_pc=" + this.instr.start_pc;
            if (this.line_number > 0) {
                s = s + ", line=" + this.line_number;
            }
            s = s + "  " + this.instr + ")\t";
            return s;
        }

        void checkFailed(String message) throws CodeException {
            throw new CodeException(this.title() + message);
        }

        void checkWarning(String message) {
            System.out.println("***warning:\t" + this.title() + message);
            System.out.println();
        }
    }

    public class LocalVariableTable {
        public LocalVariable var;
        public Label start;
        public Label end;

        LocalVariableTable(LocalVariable _var, Label _start, Label _end) {
            this.var = _var;
            this.start = _start;
            this.end = _end;
        }
    }

    public class ExceptionTable {
        public Label start;
        public Label end;
        public Label target;
        public String type;

        ExceptionTable(Label _start, Label _end, Label _target, String _type) {
            this.start = _start;
            this.end = _end;
            this.target = _target;
            this.type = _type;
        }
    }
}

