/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.Const;
import com.tool.classfile.FieldRef;
import com.tool.classfile.InterfaceMethodRef;
import com.tool.classfile.MethodRef;
import com.tool.classfile.pcodes.CodesWriter;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.Instruction_array_load;
import com.tool.classfile.pcodes.Instruction_array_store;
import com.tool.classfile.pcodes.Instruction_arraylength;
import com.tool.classfile.pcodes.Instruction_bitwise;
import com.tool.classfile.pcodes.Instruction_checkcast;
import com.tool.classfile.pcodes.Instruction_cmp;
import com.tool.classfile.pcodes.Instruction_const;
import com.tool.classfile.pcodes.Instruction_convert;
import com.tool.classfile.pcodes.Instruction_dup;
import com.tool.classfile.pcodes.Instruction_getfield;
import com.tool.classfile.pcodes.Instruction_getstatic;
import com.tool.classfile.pcodes.Instruction_goto;
import com.tool.classfile.pcodes.Instruction_if;
import com.tool.classfile.pcodes.Instruction_if_cmp;
import com.tool.classfile.pcodes.Instruction_if_null;
import com.tool.classfile.pcodes.Instruction_iinc;
import com.tool.classfile.pcodes.Instruction_instanceof;
import com.tool.classfile.pcodes.Instruction_invoke;
import com.tool.classfile.pcodes.Instruction_invokestatic;
import com.tool.classfile.pcodes.Instruction_jsr;
import com.tool.classfile.pcodes.Instruction_lookup;
import com.tool.classfile.pcodes.Instruction_math;
import com.tool.classfile.pcodes.Instruction_monitorenter;
import com.tool.classfile.pcodes.Instruction_monitorexit;
import com.tool.classfile.pcodes.Instruction_multinewarray;
import com.tool.classfile.pcodes.Instruction_neg;
import com.tool.classfile.pcodes.Instruction_new;
import com.tool.classfile.pcodes.Instruction_newarray;
import com.tool.classfile.pcodes.Instruction_nop;
import com.tool.classfile.pcodes.Instruction_pop;
import com.tool.classfile.pcodes.Instruction_putfield;
import com.tool.classfile.pcodes.Instruction_putstatic;
import com.tool.classfile.pcodes.Instruction_ret;
import com.tool.classfile.pcodes.Instruction_return;
import com.tool.classfile.pcodes.Instruction_shift;
import com.tool.classfile.pcodes.Instruction_swap;
import com.tool.classfile.pcodes.Instruction_switch;
import com.tool.classfile.pcodes.Instruction_throw;
import com.tool.classfile.pcodes.Instruction_var_load;
import com.tool.classfile.pcodes.Instruction_var_store;
import com.tool.classfile.pcodes.Label;
import com.tool.classfile.pcodes.LocalVariable;
import com.tool.classfile.sc;
import java.util.Vector;

public class CodesBlock {
    public final CodesWriter codesWriter;
    public final Vector codes = new Vector();
    public final Vector vars = new Vector();
    public final Label start = new Label();
    public final Label end = new Label();

    public CodesBlock(CodesWriter _codesWriter) {
        this.codesWriter = _codesWriter;
    }

    void appendToCodes() {
        this.codesWriter.appendLabel(this.start);
        int i = 0;
        while (i < this.codes.size()) {
            Object x = this.codes.elementAt(i);
            if (x instanceof CodesBlock) {
                ((CodesBlock)x).appendToCodes();
            } else {
                this.codesWriter.appendLabel((Label)x);
            }
            ++i;
        }
        this.codesWriter.appendLabel(this.end);
        int i2 = 0;
        while (i2 < this.vars.size()) {
            this.codesWriter.deleteVariable((LocalVariable)this.vars.elementAt(i2));
            ++i2;
        }
    }

    public LocalVariable declareVariable(String name, String type) {
        LocalVariable var = this.codesWriter.declareVariable(name, type);
        this.vars.addElement(var);
        return var;
    }

    public CodesBlock createSubBlock() {
        return new CodesBlock(this.codesWriter);
    }

    public void appendBlock(CodesBlock block) {
        this.codes.addElement(block);
    }

    public void appendLabel(Label l) {
        this.codes.addElement(l);
    }

    public void appendInstr(Instruction instr) {
        this.appendLabel(instr);
    }

    public void _array_load(int op_code) {
        this.appendInstr(new Instruction_array_load(op_code));
    }

    public void _array_load(String type) {
        if (sc.isBoolean(type) || sc.isByte(type)) {
            this._array_load(51);
        } else if (sc.isChar(type)) {
            this._array_load(52);
        } else if (sc.isShort(type)) {
            this._array_load(53);
        } else if (sc.isInteger(type)) {
            this._array_load(46);
        } else if (sc.isLong(type)) {
            this._array_load(47);
        } else if (sc.isFloat(type)) {
            this._array_load(48);
        } else if (sc.isDouble(type)) {
            this._array_load(49);
        } else if (sc.isObject(type)) {
            this._array_load(50);
        } else {
            CodeException.assertThat(false);
        }
    }

    public void _array_store(int op_code) {
        this.appendInstr(new Instruction_array_store(op_code));
    }

    public void _array_store(String type) {
        if (sc.isBoolean(type) || sc.isByte(type)) {
            this._array_store(84);
        } else if (sc.isChar(type)) {
            this._array_store(85);
        } else if (sc.isShort(type)) {
            this._array_store(86);
        } else if (sc.isInteger(type)) {
            this._array_store(79);
        } else if (sc.isLong(type)) {
            this._array_store(80);
        } else if (sc.isFloat(type)) {
            this._array_store(81);
        } else if (sc.isDouble(type)) {
            this._array_store(82);
        } else if (sc.isObject(type)) {
            this._array_store(83);
        } else {
            CodeException.assertThat(false);
        }
    }

    public void _array_length() {
        this.appendInstr(new Instruction_arraylength());
    }

    public void _checkcast(String className) {
        this.appendInstr(new Instruction_checkcast(className));
    }

    public void _bitwise(int op_code) {
        this.appendInstr(new Instruction_bitwise(op_code));
    }

    public void _bitwise(String oper, String type) {
        this._bitwise(sc.opc_math_base(oper) + sc.opc_type_level(type));
    }

    public void _math(int op_code) {
        this.appendInstr(new Instruction_math(op_code));
    }

    public void _math(String oper, String type) {
        this._math(sc.opc_math_base(oper) + sc.opc_type_level(type));
    }

    public void _cmp(int op_code) {
        this.appendInstr(new Instruction_cmp(op_code));
    }

    public void _const(Const value) {
        this.appendInstr(new Instruction_const(value));
    }

    public void _const(boolean v) {
        this._const(new Const(v));
    }

    public void _const(char v) {
        this._const(new Const(v));
    }

    public void _const(byte v) {
        this._const(new Const(v));
    }

    public void _const(short v) {
        this._const(new Const(v));
    }

    public void _const(int v) {
        this._const(new Const(v));
    }

    public void _const(long v) {
        this._const(new Const(v));
    }

    public void _const(float v) {
        this._const(new Const(v));
    }

    public void _const(double v) {
        this._const(new Const(v));
    }

    public void _const(String v) {
        this._const(new Const(v));
    }

    public void _convert(int op_code) {
        this.appendInstr(new Instruction_convert(op_code));
    }

    public void _convert(String fromType, String toType) {
        if (!this.convert(fromType, toType)) {
            throw new CodeException("Can't convert '" + sc.javaType(fromType) + "' to '" + sc.javaType(toType) + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean convert(String fromType, String toType) {
        if (fromType.equals(toType)) {
            return true;
        }
        if (sc.isVoid(fromType) || sc.isVoid(toType)) {
            return false;
        }
        if (toType.equals("VALUE")) {
            return true;
        }
        if (toType.equals("N")) {
            return sc.isNumber(fromType);
        }
        if (sc.isObject(fromType)) {
            return sc.isObject(toType);
        }
        if (sc.isObject(toType)) {
            return false;
        }
        if (sc.isInteger(fromType)) {
            if (sc.isInteger(sc.pcodeType(toType))) {
                return true;
            }
            if (sc.isLong(toType)) {
                this._convert(133);
                return true;
            } else if (sc.isFloat(toType)) {
                this._convert(134);
                return true;
            } else {
                if (!sc.isDouble(toType)) return false;
                this._convert(135);
            }
            return true;
        } else if (sc.isLong(fromType)) {
            if (sc.isInteger(sc.pcodeType(toType))) {
                this._convert(136);
                return true;
            } else if (sc.isFloat(toType)) {
                this._convert(137);
                return true;
            } else {
                if (!sc.isDouble(toType)) return false;
                this._convert(138);
            }
            return true;
        } else if (sc.isFloat(fromType)) {
            if (sc.isInteger(sc.pcodeType(toType))) {
                this._convert(139);
                return true;
            } else if (sc.isLong(toType)) {
                this._convert(140);
                return true;
            } else {
                if (!sc.isDouble(toType)) return false;
                this._convert(141);
            }
            return true;
        } else if (sc.isDouble(fromType)) {
            if (sc.isInteger(sc.pcodeType(toType))) {
                this._convert(142);
                return true;
            } else if (sc.isLong(toType)) {
                this._convert(143);
                return true;
            } else {
                if (!sc.isFloat(toType)) return false;
                this._convert(144);
            }
            return true;
        } else {
            if (sc.isByte(fromType)) {
                this._convert(145);
            } else if (sc.isChar(fromType)) {
                this._convert(146);
            } else if (sc.isShort(fromType)) {
                this._convert(147);
            } else if (!sc.isBoolean(fromType)) {
                return false;
            }
            if (sc.isInteger(toType)) return true;
            return this.convert("I", toType);
        }
    }

    public void _dup(int op_code) {
        this.appendInstr(new Instruction_dup(op_code));
    }

    public void _getfield(FieldRef ref) {
        this.appendInstr(new Instruction_getfield(ref));
    }

    public void _getfield(String full_field_name) throws Exception {
        this._getfield(sc.javaField(full_field_name));
    }

    public void _getstatic(FieldRef ref) {
        this.appendInstr(new Instruction_getstatic(ref));
    }

    public void _getstatic(String full_field_name) throws Exception {
        this._getstatic(sc.javaField(full_field_name));
    }

    public void _putfield(FieldRef ref) {
        this.appendInstr(new Instruction_putfield(ref));
    }

    public void _putfield(String full_field_name) throws Exception {
        this._putfield(sc.javaField(full_field_name));
    }

    public void _putstatic(FieldRef ref) {
        this.appendInstr(new Instruction_putstatic(ref));
    }

    public void _putstatic(String full_field_name) throws Exception {
        this._putstatic(sc.javaField(full_field_name));
    }

    public void _goto(Label target) {
        this.appendInstr(new Instruction_goto(167, target));
    }

    public void _goto_w(Label target) {
        this.appendInstr(new Instruction_goto(200, target));
    }

    public void _if_cmp(int op_code, Label target) {
        this.appendInstr(new Instruction_if_cmp(op_code, target));
    }

    public void _if_null(Label target) {
        this.appendInstr(new Instruction_if_null(198, target));
    }

    public void _if_not_null(Label target) {
        this.appendInstr(new Instruction_if_null(199, target));
    }

    public void _if(int op_code, Label target) {
        this.appendInstr(new Instruction_if(op_code, target));
    }

    public void _iinc(LocalVariable var, int inc_value) {
        this.appendInstr(new Instruction_iinc(var, var.index, inc_value));
    }

    public void _instanceof(String className) {
        this.appendInstr(new Instruction_instanceof(className));
    }

    public void _invoke(int op_code, MethodRef ref) {
        this.appendInstr(new Instruction_invoke(op_code, ref));
    }

    public void _invokevirtual(MethodRef ref) {
        this._invoke(182, ref);
    }

    public void _invokevirtual(String full_method_name) throws Exception {
        this._invokevirtual(sc.javaMethod(full_method_name));
    }

    public void _invokespecial(MethodRef ref) {
        this._invoke(183, ref);
    }

    public void _invokespecial(String full_method_name) throws Exception {
        this._invokespecial(sc.javaMethod(full_method_name));
    }

    public void _invokeinterface(InterfaceMethodRef ref) {
        this._invoke(185, ref);
    }

    public void _invokeinterface(String full_method_name) throws Exception {
        this._invokeinterface(new InterfaceMethodRef(sc.javaMethodByName(full_method_name)));
    }

    public void _invokestatic(MethodRef ref) {
        this.appendInstr(new Instruction_invokestatic(ref));
    }

    public void _invokestatic(String full_method_name) throws Exception {
        this._invokestatic(sc.javaMethod(full_method_name));
    }

    public void _jsr(Label target) {
        this.appendInstr(new Instruction_jsr(168, target));
    }

    public void _jsr_w(Label target) {
        this.appendInstr(new Instruction_jsr(201, target));
    }

    public void _switch(int min, int max, Label[] targets, Label default_target) {
        this.appendInstr(new Instruction_switch(min, max, targets, default_target));
    }

    public void _lookup(int[] cases, Label[] targets, Label default_target) {
        this.appendInstr(new Instruction_lookup(cases, targets, default_target));
    }

    public void _monitorenter() {
        this.appendInstr(new Instruction_monitorenter());
    }

    public void _monitorexit() {
        this.appendInstr(new Instruction_monitorexit());
    }

    public void _neg(int op_code) {
        this.appendInstr(new Instruction_neg(op_code));
    }

    public void _neg(String type) {
        if (sc.isInteger(type)) {
            this._neg(116);
        } else if (sc.isFloat(type)) {
            this._neg(118);
        } else if (sc.isLong(type)) {
            this._neg(117);
        } else if (sc.isDouble(type)) {
            this._neg(119);
        } else {
            CodeException.assertThat(false);
        }
    }

    public void _new(String className) {
        this.appendInstr(new Instruction_new(className));
    }

    public void _multinewarray(String type, int dims) {
        this.appendInstr(new Instruction_multinewarray(type, dims));
    }

    public void _newarray(String type) {
        this.appendInstr(new Instruction_newarray(188, type));
    }

    public void _nop() {
        this.appendInstr(new Instruction_nop());
    }

    public void _ret(LocalVariable var) {
        this.appendInstr(new Instruction_ret(var, var.index));
    }

    public void _return(int op_code) {
        this.appendInstr(new Instruction_return(op_code));
    }

    public void _return() {
        this._return(177);
    }

    public void _return(String type) {
        this._return(172 + sc.opc_type_level(type));
    }

    public void _shift(int op_code) {
        this.appendInstr(new Instruction_shift(op_code));
    }

    public void _shift(String oper, String type) {
        if (sc.isInteger(type = sc.pcodeType(type))) {
            if (oper.equals("<<")) {
                this._shift(120);
            } else if (oper.equals(">>")) {
                this._shift(122);
            } else if (oper.equals(">>>")) {
                this._shift(124);
            } else {
                CodeException.assertThat(false);
            }
        } else if (sc.isLong(type)) {
            if (oper.equals("<<")) {
                this._shift(121);
            } else if (oper.equals(">>")) {
                this._shift(123);
            } else if (oper.equals(">>>")) {
                this._shift(125);
            } else {
                CodeException.assertThat(false);
            }
        } else {
            CodeException.assertThat(false);
        }
    }

    public void _swap() {
        this.appendInstr(new Instruction_swap());
    }

    public void _throw() {
        this.appendInstr(new Instruction_throw());
    }

    public void _var_load(int op_code, LocalVariable var) {
        this.appendInstr(new Instruction_var_load(op_code, var, var.index));
    }

    public void _var_load(LocalVariable var) {
        this._var_load(21 + sc.opc_type_level(var.type), var);
    }

    public void _var_store(int op_code, LocalVariable var) {
        this.appendInstr(new Instruction_var_store(op_code, var, var.index));
    }

    public void _var_store(LocalVariable var) {
        this._var_store(54 + sc.opc_type_level(var.type), var);
    }

    public void appendLineNumber(int line_number) {
        Label l = new Label();
        l.line_number = line_number;
        this.appendLabel(l);
    }

    public void _this() {
        this._var_load(this.codesWriter.method._this);
    }

    public void _null() {
        this._const((Const)null);
    }

    public void _pop(String type) {
        if (sc.isCategory2(type)) {
            this.appendInstr(new Instruction_pop(88));
        } else {
            this.appendInstr(new Instruction_pop(87));
        }
    }

    public void _dup(String type) {
        if (sc.isCategory2(type)) {
            this._dup(92);
        } else {
            this._dup(89);
        }
    }

    public void _cmp(String type, String oper) {
        Label trueLabel = new Label();
        Label finishLabel = new Label();
        type = sc.pcodeType(type);
        int op = 0;
        if (sc.isInteger(type)) {
            if (oper.equals("==")) {
                op = 159;
            } else if (oper.equals("<=")) {
                op = 164;
            } else if (oper.equals("<")) {
                op = 161;
            } else if (oper.equals(">=")) {
                op = 162;
            } else if (oper.equals(">")) {
                op = 163;
            } else if (oper.equals("!=")) {
                op = 160;
            } else {
                CodeException.assertThat(false);
            }
            this._if_cmp(op, trueLabel);
        } else if (sc.isObject(type)) {
            op = oper.equals("==") ? 165 : 166;
            this._if_cmp(op, trueLabel);
        } else {
            this._compare(type);
            if (oper.equals("==")) {
                op = 153;
            } else if (oper.equals("<=")) {
                op = 158;
            } else if (oper.equals("<")) {
                op = 155;
            } else if (oper.equals(">=")) {
                op = 156;
            } else if (oper.equals(">")) {
                op = 157;
            } else if (oper.equals("!=")) {
                op = 154;
            } else {
                CodeException.assertThat(false);
            }
            this._if(op, trueLabel);
        }
        this._const(0);
        this._goto(finishLabel);
        this.appendLabel(trueLabel);
        this._const(1);
        this.appendLabel(finishLabel);
    }

    public void _compare(String type) {
        type = sc.pcodeType(type);
        Label gt = new Label();
        Label lt = new Label();
        Label next = new Label();
        if (sc.isInteger(type)) {
            this._if_cmp(163, gt);
            this._if_cmp(161, lt);
            this._const(0);
            this._goto(next);
            this.appendLabel(gt);
            this._const(1);
            this._goto(next);
            this.appendLabel(lt);
            this._const(-1);
            this.appendLabel(next);
        } else if (sc.isLong(type)) {
            this._cmp(148);
        } else if (sc.isFloat(type)) {
            this._cmp(149);
        } else if (sc.isDouble(type)) {
            this._cmp(151);
        } else {
            CodeException.assertThat(false);
        }
    }
}

