/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.Context;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.pcodes.ByteCodes;
import com.tool.classfile.pcodes.CodesBlock;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.Instruction_var_store;
import com.tool.classfile.pcodes.Label;
import com.tool.classfile.pcodes.LocalVariable;
import com.tool.classfile.sc;
import java.util.Hashtable;
import java.util.Vector;

public class CodesWriter
extends ByteCodes {
    public final MethodDefinition method;
    public final Label start = new Label();
    public final Label end = new Label();
    public final CodesBlock main = new CodesBlock(this);
    public int current_pc = 0;
    private boolean finished = false;
    private int new_var_index;
    private Vector var_indexs = new Vector();
    private Hashtable var_inused = new Hashtable();
    static /* synthetic */ Class class$com$tool$classfile$pcodes$CodesWriter$Variable;

    public CodesWriter(MethodDefinition _method) {
        this.method = _method;
        Context.setConstantPool(this.method.parent.pool);
        if (this.method._this != null) {
            super.addLocalVariable(this.method._this, this.start, this.end);
        }
        int i = 0;
        while (i < this.method.args.length) {
            super.addLocalVariable(this.method.args[i], this.start, this.end);
            ++i;
        }
        this.appendLabel(this.start);
        this.new_var_index = this.method.args_max_index + 1;
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.main.appendToCodes();
        this.max_locals = this.new_var_index;
        Variable[] vars = (Variable[])sc.toArray(class$com$tool$classfile$pcodes$CodesWriter$Variable == null ? (class$com$tool$classfile$pcodes$CodesWriter$Variable = CodesWriter.class$("com.tool.classfile.pcodes.CodesWriter$Variable")) : class$com$tool$classfile$pcodes$CodesWriter$Variable, this.var_inused.keys());
        int i = 0;
        while (i < vars.length) {
            if (vars[i].asigned) {
                this.appendLabel(vars[i].end);
                super.addLocalVariable(vars[i], vars[i].start, vars[i].end);
            }
            ++i;
        }
        this.appendLabel(this.end);
    }

    public void appendLabel(Label l) {
        l.start_pc = this.current_pc;
        this.codes.addElement(l);
        if (l instanceof Instruction) {
            Instruction instr = (Instruction)l;
            this.current_pc += instr.length();
            if (instr instanceof Instruction_var_store) {
                Instruction_var_store instr_var_store = (Instruction_var_store)instr;
                this.assignedVariable(instr_var_store.var);
            }
        }
    }

    public void appendInstr(Instruction instr) {
        this.appendLabel(instr);
    }

    public LocalVariable declareVariable(String name, String type) {
        int i = 0;
        while (i < this.var_indexs.size()) {
            Variable var1 = (Variable)this.var_indexs.elementAt(i);
            if (sc.isCategory2(type) == sc.isCategory2(var1.type) && !this.var_inused.containsKey(var1)) {
                Variable var = new Variable(name, type, var1.index);
                this.var_indexs.setElementAt(var, i);
                this.var_inused.put(var, new Integer(i));
                return var;
            }
            ++i;
        }
        Variable var = new Variable(name, type, this.new_var_index++);
        this.var_indexs.addElement(var);
        this.var_inused.put(var, new Integer(this.var_indexs.size() - 1));
        if (sc.isCategory2(type)) {
            ++this.new_var_index;
        }
        return var;
    }

    private void assignedVariable(LocalVariable var) {
        if (var.isParameter) {
            return;
        }
        Variable v = (Variable)var;
        CodeException.assertThat(this.var_inused.containsKey(v), "var not declared or deleted.");
        if (!v.asigned) {
            v.asigned = true;
            this.appendLabel(v.start);
        }
    }

    public void deleteVariable(LocalVariable var) {
        CodeException.assertThat(var instanceof Variable);
        Variable v = (Variable)var;
        CodeException.assertThat(this.var_inused.containsKey(v), "var not declared or deleted.");
        this.var_inused.remove(v);
        this.appendLabel(v.end);
        if (v.asigned) {
            super.addLocalVariable(v, v.start, v.end);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Variable
    extends LocalVariable {
        final Label start = new Label();
        final Label end = new Label();
        boolean asigned = false;

        Variable(String name, String type, int index) {
            super(name, type, index);
        }
    }
}

