/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.opc;
import com.tool.classfile.pcodes.InstructionWriter;
import com.tool.classfile.pcodes.Label;
import com.tool.classfile.pcodes.OperandStack;
import com.tool.classfile.sc;

public abstract class Instruction
extends Label {
    public int op_code;

    Instruction(int _op_code) {
        this.op_code = _op_code;
    }

    public final void write(InstructionWriter out) {
        this.start_pc = out.current_pc();
        this.finalWrite(out);
        if (this.start_pc + this.length() != out.current_pc()) {
            throw new CodeException();
        }
    }

    protected abstract void finalWrite(InstructionWriter var1);

    public abstract int length();

    public void checkStack(OperandStack stack) throws CodeException {
        String desc = opc.opc_types[this.op_code];
        CodeException.assertThat(desc != null);
        int i = desc.length() - 1;
        while (i > 0) {
            String type = sc.op_type(desc.charAt(i));
            stack.pop(type);
            --i;
        }
        String returnType = sc.op_type(desc.charAt(0));
        CodeException.assertThat(!returnType.equals("VALUE"));
        if (sc.isValue(returnType)) {
            stack.push(returnType);
        }
    }
}

