/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.InstructionWriter;
import com.tool.classfile.pcodes.Label;

public class Instruction_lookup
extends Instruction {
    public Label default_target;
    public int[] case_values;
    public Label[] case_targets;

    public Instruction_lookup(int[] _values, Label[] _cases, Label _default) {
        super(171);
        this.case_values = _values;
        this.case_targets = _cases;
        this.default_target = _default;
        CodeException.assertThat(this.case_values.length == this.case_targets.length);
    }

    public int length() {
        return this.fill_length() + 9 + this.case_targets.length * 8;
    }

    private int fill_length() {
        int l = (this.start_pc + 1) % 4;
        if (l == 0) {
            return 0;
        }
        return 4 - l;
    }

    protected void finalWrite(InstructionWriter out) {
        out.writeu1(this.op_code);
        int fl = this.fill_length();
        int i = 0;
        while (i < fl) {
            out.writeu1(0);
            ++i;
        }
        out.writeInt(this.default_target.start_pc - this.start_pc);
        out.writeInt(this.case_values.length);
        int i2 = 0;
        while (i2 < this.case_values.length) {
            out.writeInt(this.case_values[i2]);
            out.writeInt(this.case_targets[i2].start_pc - this.start_pc);
            ++i2;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("switch\r\n");
        int i = 0;
        while (i < this.case_values.length) {
            sb.append("\t\tcase " + this.case_values[i] + "\t: " + this.case_targets[i].start_pc + "\r\n");
            ++i;
        }
        sb.append("\t\tdefault \t: " + this.default_target.start_pc + "\r\n");
        return sb.toString();
    }
}

