/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.InstructionWriter;
import com.tool.classfile.pcodes.Label;

public class Instruction_switch
extends Instruction {
    public final int min_value;
    public final int max_value;
    public final Label default_target;
    public final Label[] case_targets;

    public Instruction_switch(int min, int max, Label[] _cases, Label _default) {
        super(170);
        this.min_value = min;
        this.max_value = max;
        this.default_target = _default;
        this.case_targets = _cases;
    }

    public int length() {
        return this.fill_length() + 13 + this.case_targets.length * 4;
    }

    private int fill_length() {
        int l = (this.start_pc + 1) % 4;
        if (l == 0) {
            return 0;
        }
        return 4 - l;
    }

    protected void finalWrite(InstructionWriter out) {
        out.writeu1(this.op_code);
        int fl = this.fill_length();
        int i = 0;
        while (i < fl) {
            out.writeu1(0);
            ++i;
        }
        out.writeInt(this.default_target.start_pc - this.start_pc);
        out.writeInt(this.min_value);
        out.writeInt(this.max_value);
        int i2 = 0;
        while (i2 < this.case_targets.length) {
            out.writeInt(this.case_targets[i2].start_pc - this.start_pc);
            ++i2;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("switch\r\n");
        int i = this.min_value;
        while (i <= this.max_value) {
            sb.append("\t\tcase " + i + "\t: " + this.case_targets[i - this.min_value].start_pc + "\r\n");
            ++i;
        }
        sb.append("\t\tdefault \t: " + this.default_target.start_pc + "\r\n");
        return sb.toString();
    }
}

