/*
 * Decompiled with CFR 0.152.
 */
package com.tool.simplecode;

import com.tool.classfile.pcodes.Label;
import com.tool.classfile.sc;
import com.tool.simplecode.BuildEnv;
import com.tool.simplecode.Value;
import com.tool.simplecode.Variable;
import java.io.IOException;

public abstract class Unit {
    public final Label start = new Label();
    public final Label end = new Label();
    public final int level;
    public int line_number = 0;
    public Unit parent = null;

    public Unit(int _level) {
        this.level = _level;
    }

    public void buildSource(BuildEnv env, int reqLevel) throws IOException {
        this.line_number = env.out.line_number();
        if (reqLevel == -1) {
            this.genSource(env);
            if (this.level != -2) {
                env.out.writeString(";");
            }
        } else if (reqLevel < this.level) {
            env.out.writeString("(");
            this.genSource(env);
            env.out.writeString(")");
        } else {
            this.genSource(env);
        }
    }

    protected abstract void genSource(BuildEnv var1) throws IOException;

    public String buildCodes(BuildEnv env, String requiredType) throws IOException {
        this.start.line_number = this.line_number;
        this.parent = env.current_unit;
        env.current_unit = this;
        this.enter(env);
        env.current_block.appendLabel(this.start);
        String type = this.genCodes(env, requiredType);
        if (!type.equals(requiredType)) {
            if (sc.isVoid(requiredType)) {
                env.current_block._pop(type);
                type = "V";
            } else if (!sc.isValue(requiredType) && !sc.isObject(requiredType)) {
                env.current_block._convert(type, requiredType);
                type = requiredType;
            }
        }
        env.current_block.appendLabel(this.end);
        this.leave(env);
        env.current_unit = this.parent;
        return type;
    }

    protected abstract String genCodes(BuildEnv var1, String var2) throws IOException;

    protected void enter(BuildEnv env) throws IOException {
    }

    protected void leave(BuildEnv env) throws IOException {
    }

    static Unit toUnit(Unit unit) {
        if (unit == null) {
            return null;
        }
        if (unit instanceof Variable) {
            return new VarUnit((Variable)unit);
        }
        if (unit instanceof Value) {
            return new ValueUnit((Value)unit);
        }
        return unit;
    }

    static Unit[] toUnit(Unit[] units) {
        if (units == null) {
            return new Unit[0];
        }
        Unit[] us = new Unit[units.length];
        int i = 0;
        while (i < us.length) {
            us[i] = Unit.toUnit(units[i]);
            ++i;
        }
        return us;
    }

    public static Unit[] array(Unit p1) {
        Unit[] args = new Unit[]{p1};
        return args;
    }

    public static Unit[] array(Unit p1, Unit p2) {
        Unit[] args = new Unit[]{p1, p2};
        return args;
    }

    public static Unit[] array(Unit p1, Unit p2, Unit p3) {
        Unit[] args = new Unit[]{p1, p2, p3};
        return args;
    }

    public static Unit[] array(Unit p1, Unit p2, Unit p3, Unit p4) {
        Unit[] args = new Unit[]{p1, p2, p3, p4};
        return args;
    }

    static class ValueUnit
    extends Unit {
        Value value;

        ValueUnit(Value _value) {
            super(1);
            this.value = _value;
        }

        protected String genCodes(BuildEnv env, String requiredType) throws IOException {
            if (this.value == null || this.value.value == null) {
                env.current_block._null();
            } else {
                env.current_block._const(this.value.value);
            }
            if (this.value == null || this.value.value == null) {
                return "Ljava/lang/Object;";
            }
            return this.value.value.type;
        }

        protected void genSource(BuildEnv env) throws IOException {
            if (this.value == null || this.value.value == null) {
                env.out.writeString("null");
            } else {
                env.out.writeString(this.value.value.toString());
            }
        }
    }

    static class VarUnit
    extends Unit {
        Variable var;

        VarUnit(Variable _var) {
            super(1);
            this.var = _var;
        }

        protected String genCodes(BuildEnv env, String requiredType) throws IOException {
            env.current_block._var_load(this.var.var);
            return this.var.type;
        }

        protected void genSource(BuildEnv env) throws IOException {
            env.out.writeString(this.var.name);
        }
    }
}

