/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class XDateUtils {
    private static final char[] NUMBER_FONT = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final char[] WEEK_FONT = new char[]{'\u65e5', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d'};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;

    public static String parseDateL(String yyyymmdd) {
        char[] c = yyyymmdd.toCharArray();
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            tmp.append(c[i]);
            if (3 == i) {
                tmp.append("-");
            }
            if (5 != i) continue;
            tmp.append("-");
        }
        return tmp.toString();
    }

    public static String parseDate(String yyyy_mm_dd) {
        try {
            char[] c = yyyy_mm_dd.toCharArray();
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i < c.length; ++i) {
                if ('-' == c[i]) continue;
                tmp.append(c[i]);
            }
            return tmp.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getDateL() {
        return XDateUtils.getFormatter("yyyy\u5e74MM\u6708dd\u65e5").format(new Date());
    }

    public static String getDateTime(long i) {
        return XDateUtils.getFormatter("yyyyMMddHHmm").format(new Date(i));
    }

    public static String getDate() {
        return XDateUtils.getFormatter("yyyy\u5e74M\u6708d\u65e5").format(new Date());
    }

    public static String getDateC() {
        return XDateUtils.toChinese(XDateUtils.getFormatter("yyyy\u5e74M\u6708d\u65e5").format(new Date()));
    }

    public static String getWeekDay() {
        return "\u661f\u671f" + WEEK_FONT[XDateUtils.getWeekDayCore() - 1];
    }

    private static int getWeekDayCore() {
        Calendar cal = Calendar.getInstance();
        return cal.get(7);
    }

    public static String getYear() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(1));
    }

    public static String getYearC() {
        return XDateUtils.toChinese(XDateUtils.getYear());
    }

    public static String getMonth() {
        return XDateUtils.getFormatter("M").format(new Date());
    }

    public static String getMonthL() {
        return XDateUtils.getFormatter("MM").format(new Date());
    }

    public static String getMonthC() {
        return XDateUtils.toChinese(XDateUtils.getMonth());
    }

    public static String getDay() {
        return XDateUtils.getFormatter("d").format(new Date());
    }

    public static String getDayL() {
        return XDateUtils.getFormatter("dd").format(new Date());
    }

    public static String getDayC() {
        return XDateUtils.toChinese(XDateUtils.getDay());
    }

    private static long calTargetTime(int days) {
        return new Date().getTime() + (long)days * 86400000L;
    }

    private static long calTargetTime(String yyyy_mm_dd, String days) {
        return XDateUtils.parse(yyyy_mm_dd).getTime() + (long)Integer.parseInt(days) * 86400000L;
    }

    public static String getDistDateL(int days) {
        return XDateUtils.getFormatter("yyyy-MM-dd").format(new Date(XDateUtils.calTargetTime(days)));
    }

    public static String getDistDateL(String days) {
        return XDateUtils.getDistDateL(Integer.parseInt(days));
    }

    public static String getSystemDate() {
        return XDateUtils.getFormatter("yyyyMMddHHmm").format(new Date(XDateUtils.calTargetTime(0)));
    }

    public static String getDistDate(int days) {
        return XDateUtils.getFormatter("yyyy-M-d").format(new Date(XDateUtils.calTargetTime(days)));
    }

    public static String getDistDate(String days) {
        return XDateUtils.getDistDate(Integer.parseInt(days));
    }

    public static String getDistDateLC(int days) {
        return XDateUtils.getFormatter("yyyy\u5e74MM\u6708dd\u65e5").format(new Date(XDateUtils.calTargetTime(days)));
    }

    public static String getDistDateLC(String days) {
        return XDateUtils.getDistDateLC(Integer.parseInt(days));
    }

    public static String getDistDateS(int days) {
        return XDateUtils.getFormatter("yyyy\u5e74MM\u6708dd\u65e5").format(new Date(XDateUtils.calTargetTime(days)));
    }

    public static String getDistDateS(String days) {
        return XDateUtils.getDistDateS(Integer.parseInt(days));
    }

    public static String getDistDateSC(int days) {
        return XDateUtils.toChinese(XDateUtils.getFormatter("yyyy\u5e74MM\u6708dd\u65e5").format(new Date(XDateUtils.calTargetTime(days))));
    }

    public static String getDistDateSC(String days) {
        return XDateUtils.getDistDateSC(Integer.parseInt(days, 10));
    }

    private static Date parse(String yyyy_mm_dd, String format) {
        return XDateUtils.getFormatter(format).parse(yyyy_mm_dd, new ParsePosition(0));
    }

    public static Date parseL(String timeStr, String format) {
        return XDateUtils.getFormatter(format).parse(timeStr, new ParsePosition(0));
    }

    public static Date parse(String yyyy_mm_dd) {
        return XDateUtils.parse(yyyy_mm_dd, "yyyy-MM-dd");
    }

    public static String parseDateL2(String yyyy_mm_dd) {
        return XDateUtils.getFormatter("yyyy\u5e74MM\u6708dd\u65e5").format(XDateUtils.parse(yyyy_mm_dd));
    }

    public static String parseTime(String yyyyMMddHHmm) {
        return XDateUtils.getFormatter("yyyy\u5e74M\u6708d\u65e5H\u65f6m\u5206").format(XDateUtils.parse(yyyyMMddHHmm, "yyyyMMddHHmm"));
    }

    public static String parseDate2(String yyyy_mm_dd) {
        try {
            return XDateUtils.getFormatter("yyyy\u5e74M\u6708d\u65e5").format(XDateUtils.parse(yyyy_mm_dd));
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String parseDateC2(String yyyy_mm_dd) {
        return XDateUtils.toChinese(XDateUtils.getFormatter("yyyy\u5e74M\u6708d\u65e5").format(XDateUtils.parse(yyyy_mm_dd)));
    }

    public static String parseWeekDay(String yyyy_mm_dd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(XDateUtils.parse(yyyy_mm_dd));
        return "\u661f\u671f" + WEEK_FONT[cal.get(7) - 1];
    }

    public static String parseYear(String yyyy_mm_dd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(XDateUtils.parse(yyyy_mm_dd));
        return String.valueOf(cal.get(1));
    }

    public static String parseYearC(String yyyy_mm_dd) {
        return XDateUtils.toChinese(XDateUtils.parseYear(yyyy_mm_dd));
    }

    public static String parseMonth(String yyyy_mm_dd) {
        return XDateUtils.getFormatter("M").format(XDateUtils.parse(yyyy_mm_dd));
    }

    public static String parseMonthL(String yyyy_mm_dd) {
        return XDateUtils.getFormatter("MM").format(XDateUtils.parse(yyyy_mm_dd));
    }

    public static String parseMonthC(String yyyy_mm_dd) {
        return XDateUtils.toChinese(XDateUtils.getFormatter("M").format(XDateUtils.parse(yyyy_mm_dd)));
    }

    public static String parseDay(String yyyy_mm_dd) {
        return XDateUtils.getFormatter("d").format(XDateUtils.parse(yyyy_mm_dd));
    }

    public static String parseDayL(String yyyy_mm_dd) {
        return XDateUtils.getFormatter("dd").format(XDateUtils.parse(yyyy_mm_dd));
    }

    public static String parseDayC(String yyyy_mm_dd) {
        return XDateUtils.toChinese(XDateUtils.getFormatter("d").format(XDateUtils.parse(yyyy_mm_dd)));
    }

    public static String getDistDateL(String yyyy_mm_dd, String days) {
        return XDateUtils.getFormatter("yyyy-MM-dd").format(new Date(XDateUtils.calTargetTime(yyyy_mm_dd, days)));
    }

    public static String getDistDate(String yyyy_mm_dd, String days) {
        return XDateUtils.getFormatter("yyyy-M-d").format(new Date(XDateUtils.calTargetTime(yyyy_mm_dd, days)));
    }

    public static String getDistDateSL(String yyyy_mm_dd, String days) {
        return XDateUtils.getFormatter("yyyy\u5e74MM\u6708dd\u65e5").format(new Date(XDateUtils.calTargetTime(yyyy_mm_dd, days)));
    }

    public static String getDistDateS(String yyyy_mm_dd, String days) {
        return XDateUtils.getFormatter("yyyy\u5e74M\u6708d\u65e5").format(new Date(XDateUtils.calTargetTime(yyyy_mm_dd, days)));
    }

    public static String getDistDateC(String yyyy_mm_dd, String days) {
        return XDateUtils.toChinese(XDateUtils.getDistDateS(yyyy_mm_dd, days));
    }

    private static SimpleDateFormat getFormatter(String format) {
        return new SimpleDateFormat(format);
    }

    public static String toChinese(String str) {
        int n = 0;
        StringBuffer tmp = new StringBuffer();
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (Character.isDigit(c[i])) {
                n = Character.getNumericValue(c[i]);
                tmp.append(NUMBER_FONT[n]);
                continue;
            }
            tmp.append(c[i]);
        }
        return tmp.toString();
    }
}

