/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.url.service.config;

import com.kingdee.eas.cp.common.url.service.config.AbstractConfigFileParser;
import com.kingdee.eas.cp.common.url.service.config.IBindBean;
import com.kingdee.eas.cp.common.url.service.config.UrlServiceBean;
import com.kingdee.eas.cp.common.url.service.util.UrlServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UrlServiceConfigFileParser
extends AbstractConfigFileParser {
    private String serviceID;
    private static final Class BIND_BEAN = UrlServiceBean.class;
    private UrlServiceBean bean;

    public UrlServiceConfigFileParser(String serviceID) {
        if (serviceID == null || serviceID.equals("")) {
            throw new IllegalArgumentException("id is illegal !");
        }
        this.serviceID = serviceID;
        this.bean = (UrlServiceBean)UrlServiceUtil.initBindBean(BIND_BEAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBindBean readFile(String fileName) throws SAXException, IOException {
        DocumentBuilder builder = null;
        try {
            builder = this.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        File file = null;
        file = this.validateFileName(fileName) ? new File(this.getDefaultConfigFileDirectory() + fileName) : new File(this.getDefaultConfigFile());
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            Document doc = builder.parse(fis);
            this.parseConfigFileDefinitions(doc);
        }
        return this.bean;
    }

    private void parseConfigFileDefinitions(Document doc) {
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        int num = nl.getLength();
        for (int i = 0; i < num; ++i) {
            Element ele;
            String id;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !this.serviceID.equals(id = (ele = (Element)node).getAttribute("id"))) continue;
            this.parsePropertyElements(ele);
        }
    }

    private void parsePropertyElements(Element ele) {
        NodeList nl = ele.getChildNodes();
        int num = nl.getLength();
        for (int i = 0; i < num; ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !"property".equals(node.getNodeName())) continue;
            Element _ele = (Element)node;
            String propName = _ele.getAttribute("name");
            String val = this.parsePropertyValue(_ele);
            UrlServiceUtil.invokeSetPropertyMethod(this.bean, propName, val);
        }
    }

    private String parsePropertyValue(Element ele) {
        NodeList nl = ele.getChildNodes();
        int num = nl.getLength();
        for (int i = 0; i < num; ++i) {
            Element _ele;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !(_ele = (Element)node).getTagName().equals("value")) continue;
            Node _node = _ele.getChildNodes().item(0);
            if (_node == null) {
                return "";
            }
            return _node.getNodeValue();
        }
        return "";
    }
}

