/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.filters;

import com.apusic.web.fileupload.FileItemFactory;
import com.apusic.web.fileupload.FileItemIterator;
import com.apusic.web.fileupload.FileItemStream;
import com.apusic.web.fileupload.PartItemFactory;
import com.apusic.web.fileupload.ServletFileUpload;
import com.kingdee.eas.cp.common.web.filters.ContentCachingRequestWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AttachmentFilter
implements Filter {
    private List<String> allowedExtensions = null;
    private boolean enabled = false;

    public void init(FilterConfig fConfig) throws ServletException {
        this.enabled = AttachmentFilter.parseBoolean(fConfig.getInitParameter("enableAttachmentFilter"), false);
        List emptyLi = Collections.emptyList();
        String allowedExtensions = fConfig.getInitParameter("allowedExtensions");
        this.allowedExtensions = allowedExtensions == null ? emptyLi : Arrays.asList(allowedExtensions.split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.enabled || !ServletFileUpload.isMultipartContent((HttpServletRequest)((HttpServletRequest)request))) {
            chain.doFilter(request, response);
        } else {
            ContentCachingRequestWrapper wrapper = new ContentCachingRequestWrapper((HttpServletRequest)request);
            try {
                if (!this.checkFileAttack((ServletRequest)wrapper)) {
                    ((HttpServletResponse)response).sendError(403, "\u7981\u6b62\u7684\u6587\u4ef6\u7c7b\u578b");
                    return;
                }
                chain.doFilter((ServletRequest)wrapper, response);
            }
            finally {
                try {
                    wrapper.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void destroy() {
    }

    private boolean checkFileAttack(ServletRequest request) {
        ContentCachingRequestWrapper httpServletRequest = (ContentCachingRequestWrapper)request;
        boolean flag = true;
        try {
            ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)new PartItemFactory());
            FileItemIterator ite = fileUpload.getItemIterator((HttpServletRequest)httpServletRequest);
            while (ite.hasNext()) {
                FileItemStream stream = ite.next();
                String fileName = stream.getName();
                if (fileName == null) continue;
                boolean singleFlag = false;
                String lowercaseFilename = fileName.toLowerCase();
                for (String extension : this.allowedExtensions) {
                    if (!lowercaseFilename.endsWith("." + extension)) continue;
                    singleFlag = true;
                    break;
                }
                if (singleFlag) continue;
                flag = false;
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            httpServletRequest.outputOnce();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return flag;
    }

    private static boolean parseBoolean(String paramVal, boolean defVal) {
        if (paramVal != null) {
            if ("true".equalsIgnoreCase(paramVal = paramVal.trim())) {
                return true;
            }
            if ("false".equalsIgnoreCase(paramVal)) {
                return false;
            }
            return defVal;
        }
        return defVal;
    }
}

