/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.filters;

import com.apusic.util.Uuid;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ContentCachingRequestWrapper
extends HttpServletRequestWrapper {
    private File tempFile = null;
    private FileOutputStream cacheFileOut = null;
    private ServletInputStream inputStream;
    private BufferedReader reader;
    private boolean hasOutput;

    public ContentCachingRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        int contentLength = request.getContentLength();
        this.tempFile = File.createTempFile(Uuid.randomUUID().toString(), ".apusicdat");
        this.cacheFileOut = new FileOutputStream(this.tempFile);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.hasOutput && this.inputStream == null) {
            this.inputStream = new FileBasedServletInputStream(new FileInputStream(this.tempFile));
        }
        if (this.inputStream == null) {
            this.inputStream = new ContentCachingInputStream(this.getRequest().getInputStream());
        }
        return this.inputStream;
    }

    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        return enc != null ? enc : "ISO-8859-1";
    }

    public BufferedReader getReader() throws IOException {
        if (this.hasOutput && this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tempFile), this.getCharacterEncoding()));
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.reader;
    }

    public void outputOnce() {
        try {
            if (this.cacheFileOut != null) {
                this.cacheFileOut.flush();
                this.cacheFileOut.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.inputStream = null;
        this.hasOutput = true;
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.tempFile.delete();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private boolean isFormPost() {
        String contentType = this.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded") && "POST".equalsIgnoreCase(this.getMethod());
    }

    private class ContentCachingInputStream
    extends ServletInputStream {
        private final ServletInputStream is;
        private boolean overflow = false;
        private boolean finished = false;

        public ContentCachingInputStream(ServletInputStream is) throws FileNotFoundException {
            this.is = is;
        }

        public int read() throws IOException {
            int ch = this.is.read();
            if (ch == -1) {
                this.finished = true;
            }
            ContentCachingRequestWrapper.this.cacheFileOut.write(ch);
            return ch;
        }

        public int read(byte[] b) throws IOException {
            int count = this.is.read(b);
            if (count == -1) {
                this.finished = true;
            }
            this.writeToCache(b, 0, count);
            return count;
        }

        private void writeToCache(byte[] b, int off, int count) throws IOException {
            if (!this.overflow && count > 0) {
                ContentCachingRequestWrapper.this.cacheFileOut.write(b, off, count);
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count = this.is.read(b, off, len);
            if (count == -1) {
                this.finished = true;
            }
            this.writeToCache(b, off, count);
            return count;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int count = this.is.readLine(b, off, len);
            if (count == -1) {
                this.finished = true;
            }
            this.writeToCache(b, off, count);
            return count;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }

    private class FileBasedServletInputStream
    extends ServletInputStream {
        private FileInputStream is;
        private boolean finished = false;

        public FileBasedServletInputStream(FileInputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            int ch = this.is.read();
            if (ch == -1) {
                this.finished = true;
            }
            return ch;
        }

        public int read(byte[] b) throws IOException {
            int count = this.is.read(b);
            if (count == -1) {
                this.finished = true;
            }
            return count;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count = this.is.read(b, off, len);
            if (count == -1) {
                this.finished = true;
            }
            return count;
        }

        public void close() throws IOException {
            this.is.close();
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

