/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;

public class SetCharacterEncodingFilter
implements Filter {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    protected String encoding = null;
    protected FilterConfig filterConfig = null;
    protected boolean ignore = true;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
        String value = filterConfig.getInitParameter("ignore");
        this.ignore = value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        this.logger.debug((Object)("[EAS Portal] SetCharacterEncodingFilter end init.Parameter encoding=" + this.encoding + ",ignore=" + this.ignore));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String encoding;
        if ((this.ignore || request.getCharacterEncoding() == null) && (encoding = this.selectEncoding(request)) != null) {
            this.logger.debug((Object)("[EAS Portal] SetCharacterEncodingFilter set encoding =" + encoding));
            request.setCharacterEncoding(encoding);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
        this.logger.debug((Object)"[EAS Portal] SetCharacterEncodingFilter was destroyed.");
    }

    protected String selectEncoding(ServletRequest request) {
        return this.encoding;
    }
}

