/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import java.util.ArrayList;

public class DataCenterManager {
    private Context ctx = null;

    public DataCenterManager(Context _ctx) {
        this.ctx = _ctx;
    }

    public ArrayList getDCList() {
        DCRegister dcRegister = new DCRegister();
        ArrayList dcList = null;
        try {
            dcList = dcRegister.getDCList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcList;
    }

    public String getDBTypeScript(int nSelect) {
        ArrayList dcList = this.getDCList();
        StringBuffer dcStr = new StringBuffer("");
        if (dcList != null) {
            for (int i = 0; i < dcList.size(); ++i) {
                DCInfo di = (DCInfo)dcList.get(i);
                dcStr.append("dbType[" + i + "]='" + di.getDBType() + "';\n");
            }
        }
        return dcStr.toString();
    }

    public String getItemString(int nSelect) {
        ArrayList dcList = this.getDCList();
        StringBuffer dcStr = new StringBuffer("");
        if (dcList != null) {
            for (int i = 0; i < dcList.size(); ++i) {
                DCInfo di = (DCInfo)dcList.get(i);
                dcStr.append("<item itemid='");
                dcStr.append(di.getNumber());
                dcStr.append("' data='");
                dcStr.append(di.getNumber());
                dcStr.append("' desc='");
                dcStr.append(di.getName(this.ctx.getLocale().toString().toUpperCase()));
                if (i == nSelect) {
                    dcStr.append("' selected='true");
                }
                dcStr.append("'/>\n");
            }
        }
        return dcStr.toString();
    }

    public String getOptionString() {
        ArrayList dcList = this.getDCList();
        StringBuffer dcStr = new StringBuffer("");
        if (dcList != null) {
            for (int i = 0; i < dcList.size(); ++i) {
                DCInfo di = (DCInfo)dcList.get(i);
                dcStr.append("<option value='");
                dcStr.append(di.getNumber());
                dcStr.append("'>");
                dcStr.append(di.getName(this.ctx.getLocale().toString().toUpperCase()));
                dcStr.append("</option>");
            }
        }
        return dcStr.toString();
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getDatacenterName(Context ctx) {
        if (ctx == null || ctx.getAIS() == null || ctx.getAIS().trim().length() == 0) {
            return "";
        }
        ArrayList dcList = this.getDCList();
        if (dcList != null) {
            DCInfo di = null;
            for (int i = 0; i < dcList.size(); ++i) {
                di = (DCInfo)dcList.get(i);
                if (!di.getNumber().equals(ctx.getAIS())) continue;
                return di.getName(ctx.getLocale().toString().toUpperCase());
            }
        }
        return "";
    }

    public DCInfo getDCInfo(String dcNumber) {
        if (dcNumber == null || "".equals(dcNumber)) {
            return null;
        }
        ArrayList dcList = this.getDCList();
        if (dcList != null) {
            DCInfo di = null;
            for (int i = 0; i < dcList.size(); ++i) {
                di = (DCInfo)dcList.get(i);
                if (!di.getNumber().equals(dcNumber)) continue;
                return di;
            }
        }
        return null;
    }
}

