/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.myeas.IMyEasInvokeEntry;
import com.kingdee.eas.base.myeas.MyEasInvokeEntryFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.ContextManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.PortalPersonalSetUtil;
import com.kingdee.eas.cp.common.web.util.WebContext;
import com.kingdee.eas.cp.eip.sso.web.EASRequestWrapper;
import com.kingdee.eas.portal.web.cache.CacheResource;
import com.kingdee.eas.portal.web.configuration.PortalConfig;
import com.kingdee.eas.portal.web.control.PortalParamBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class WebContextUtil {
    public static final String SSO_LOGOUT_TURN = "easssologout";
    public static final String EAS_SESSIONID_PARMNAME = "easSessionId";
    public static final String EAS_SESSIONID_KEY = "SessionId";
    private static final String SKINPATHITEM = "defaultColorStyle";
    private static final String SKINPATH = "skinPath";
    private static final String DEFAULTPATH = "/skin/01";
    private static final String SIMPLE_STRING = "_simple";
    private static final String APP_SERVER_TYPE_APUSIC = "apusic";
    public static final String PERSONALSET_PATH = "/easWebClient/personalset";
    private static Logger logger = Logger.getLogger((String)WebContextUtil.class.getName());

    public static void createWebContext(HttpServletRequest request) throws BOSLoginException {
        WebContext easWebContext = new WebContext();
        String SessionID = request.getParameter(EAS_SESSIONID_PARMNAME);
        easWebContext.setSessionId(SessionID);
        Context ctxs = null;
        try {
            ctxs = SessionManager.getInstance().getSession(SessionID).getContext();
            ctxs.put((Object)EAS_SESSIONID_KEY, (Object)SessionID);
            easWebContext.setEasContext(ctxs);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctxs);
            WebContextUtil.setUserSkinPath(request, user, easWebContext);
        }
        catch (Exception e) {
            throw new BOSLoginException("[Eas Auth]Eas server context is null,please check eas app server url is or not right.sessionId=[" + SessionID + "]", (Throwable)e);
        }
        request = new EASRequestWrapper(request, easWebContext);
    }

    public static void createWebContext(HttpServletRequest request, Context ctx) throws BOSLoginException {
        String SessionID = null;
        WebContext easWebContext = new WebContext();
        Context context = null;
        String isPureWeb = request.getParameter("isPureWeb");
        if (isPureWeb == null) {
            isPureWeb = (String)request.getAttribute("isPureWeb");
        }
        if ("true".equals(isPureWeb)) {
            SessionID = ctx.getContextID();
            HttpSession session = request.getSession();
            session.setAttribute("pureWebContext", (Object)ctx);
            easWebContext.setEasContext(ctx);
            context = ctx;
            UserInfo uInfo = (UserInfo)ctx.get((Object)"UserInfo");
            uInfo.getDefOrgUnit().getId();
            try {
                IOrgSwitchFacade iOrgSwitchFacade = OrgSwitchFacadeFactory.getRemoteInstance();
                HashMap map = null;
                map = ContextUtil.getCurrentOrgUnit((Context)ctx) != null && ContextUtil.getCurrentOrgUnit((Context)ctx).getId() != null ? iOrgSwitchFacade.getOrgs(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString()) : iOrgSwitchFacade.getOrgs(uInfo.getDefOrgUnit().getId().toString());
                ContextManager contextManager = new ContextManager(ctx);
                contextManager.setContext((Map)map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Context ctxs = null;
            SessionID = request.getParameter(EAS_SESSIONID_PARMNAME);
            ctxs = SessionManager.getInstance().getSession(SessionID).getContext();
            ctxs.put((Object)EAS_SESSIONID_KEY, (Object)SessionID);
            context = ctx;
        }
        easWebContext.setSessionId(SessionID);
        try {
            easWebContext.setEasContext(context);
        }
        catch (Exception e) {
            throw new BOSLoginException("[Eas Auth]Eas server context is null,please check eas app server url is or not right.sessionId=[" + SessionID + "]", (Throwable)e);
        }
        request = new EASRequestWrapper(request, easWebContext);
    }

    public static WebContext getWebContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebContext webContext = (WebContext)session.getAttribute("easWebContextSessionId");
        return webContext;
    }

    public static Context getEasContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Context ctx = (Context)session.getAttribute("pureWebContext");
        if (ctx != null) {
            return ctx;
        }
        return WebContextUtil.getRealEasContext(request);
    }

    public static Context getRealEasContext(HttpServletRequest request) {
        WebContext webContext = WebContextUtil.getWebContext(request);
        Context ctx = null;
        if (webContext != null) {
            String sessionID = webContext.getSessionId();
            try {
                SessionInfo tempSessionInfo = SessionManager.getInstance().getSession(sessionID);
                ctx = tempSessionInfo != null ? tempSessionInfo.getContext() : null;
            }
            catch (Exception e) {
                logger.error((Object)(logger.getName() + ":getRealEasContext:sessionID=" + sessionID));
                logger.error((Object)(logger.getName() + ":getRealEasContext:get eas user server context fails. context is null." + e.getMessage()), (Throwable)e);
            }
        } else {
            logger.debug((Object)(logger.getName() + ":getRealEasContext:easWebContextSessionId-webContext is null."));
        }
        return ctx;
    }

    public static String getPortalContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        return contextPath;
    }

    public static String getUserSkinPath(HttpServletRequest request) {
        String skin = WebContextUtil.getPortalContextPath(request);
        WebContext webContext = WebContextUtil.getWebContext(request);
        if (webContext != null) {
            skin = (String)webContext.get("user_skin");
        } else {
            HttpSession session = request.getSession();
            String absolutePath = null;
            absolutePath = (String)session.getAttribute("user_skin");
            if (StringUtils.isEmpty((String)absolutePath)) {
                absolutePath = WebContextUtil.readCookieOfColorStyle(request);
                if (StringUtils.isEmpty((String)absolutePath)) {
                    String dafaultSkinPath = WebContextUtil.getDefaultSkinPathFull();
                    skin = skin + dafaultSkinPath;
                } else {
                    skin = skin + absolutePath;
                }
                session.setAttribute("user_skin", (Object)skin);
            } else {
                skin = absolutePath;
            }
        }
        return skin;
    }

    public static String readCookieOfColorStyle(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        Cookie tempCookie = null;
        String webColorStyle = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                tempCookie = cookies[i];
                if (!"EasWebColorStyle".equals(tempCookie.getName())) continue;
                webColorStyle = tempCookie.getValue();
                break;
            }
            if (webColorStyle == null) {
                webColorStyle = WebContextUtil.getPortalContextPath(request) + WebContextUtil.getDefaultColorStyle();
            } else {
                if (webColorStyle.indexOf(SIMPLE_STRING) >= 0) {
                    webColorStyle = webColorStyle.substring(0, webColorStyle.indexOf(SIMPLE_STRING));
                }
                webColorStyle = WebContextUtil.filterXssColorStyle(webColorStyle);
                webColorStyle = WebContextUtil.getPortalContextPath(request) + webColorStyle;
            }
        }
        return webColorStyle;
    }

    public static String filterXssColorStyle(String webColorStyle) {
        if (!(DEFAULTPATH.equals(webColorStyle) || "/skin/02".equals(webColorStyle) || "/skin/03".equals(webColorStyle) || "/skin/04".equals(webColorStyle))) {
            return WebContextUtil.getDefaultColorStyle();
        }
        return webColorStyle;
    }

    public static String getLoginFormByColorStyle(String webColorPath) {
        String redirectToLogin = null;
        if (StringUtils.isEmpty((String)webColorPath)) {
            return WebContextUtil.getDefaultLoginPage();
        }
        redirectToLogin = DEFAULTPATH.equals(webColorPath) ? "/login_withForm_blue.jsp" : ("/skin/02".equals(webColorPath) ? "login_withForm_orange.jsp" : ("/skin/03".equals(webColorPath) ? "login_withForm_green.jsp" : ("/skin/04".equals(webColorPath) ? "login_withForm_red.jsp" : WebContextUtil.getDefaultLoginPage())));
        return redirectToLogin;
    }

    public static String getLoginFormByColorStyle(HttpServletRequest request) {
        String redirectToLogin = null;
        HttpSession session = request.getSession();
        String loginForm_color = (String)session.getAttribute("user_skin");
        if (StringUtils.isEmpty((String)loginForm_color)) {
            loginForm_color = WebContextUtil.readCookieOfColorStyle(request);
            if (StringUtils.isEmpty((String)loginForm_color)) {
                return WebContextUtil.getDefaultLoginPage();
            }
        } else {
            loginForm_color = loginForm_color.substring(WebContextUtil.getPortalContextPath(request).length());
        }
        redirectToLogin = DEFAULTPATH.equals(loginForm_color) ? "/login_withForm_blue.jsp" : ("/skin/02".equals(loginForm_color) ? "login_withForm_orange.jsp" : ("/skin/03".equals(loginForm_color) ? "login_withForm_green.jsp" : ("/skin/04".equals(loginForm_color) ? "login_withForm_red.jsp" : WebContextUtil.getDefaultLoginPage())));
        return redirectToLogin;
    }

    public static BigDecimal getUserRefreshTime() {
        return new BigDecimal("15.00").multiply(new BigDecimal("60.00"));
    }

    public static int[] getUserScreenResolutionTime() {
        return new int[]{1024, 768};
    }

    public static String getCompany() {
        return EASResource.getString((String)"com.kingdee.eas.portal.portalPublic", (String)"companyName");
    }

    public static PortalParamBean getPortalParamBean(HttpServletRequest request) {
        return PortalParamBean.getInstance((HttpServletRequest)request);
    }

    public static void setUserSkinPath(HttpServletRequest request, String skinPath) throws BOSException, EASBizException, BOSLoginException {
        WebContext webContext = WebContextUtil.getWebContext(request);
        if (webContext == null) {
            return;
        }
    }

    public static void setUserSkinPath(HttpServletRequest request, UserInfo userInfo) throws BOSException, EASBizException, BOSLoginException {
        WebContext webContext = WebContextUtil.getWebContext(request);
        WebContextUtil.setUserSkinPath(request, userInfo, webContext);
    }

    public static void setUserSkinPath(HttpServletRequest request, UserInfo userInfo, WebContext webContext) throws BOSException, EASBizException, BOSLoginException {
        IMyEasInvokeEntry ime = MyEasInvokeEntryFactory.getRemoteInstance();
        String uiStyleID = ime.getUIStyleForWeb(userInfo.getId().toString());
        String skinPath = WebContextUtil.getPortalContextPath(request) + WebContextUtil.getSkinPath(uiStyleID);
        if (webContext != null) {
            webContext.put("user_skin", skinPath);
        }
    }

    public static String getSkinPath(String uiStyleID) {
        String skinPath = "";
        if (StringUtils.isEmpty((String)uiStyleID)) {
            return WebContextUtil.getDefaultSkinPathFull();
        }
        skinPath = uiStyleID.equals("01b278d3-00fd-1000-e000-0005c0a813b2A8506915") ? "/skin/02" : (uiStyleID.equals("01b278d3-00fd-1000-e000-0004c0a813b2A8506915") ? "/skin/03" : (uiStyleID.equals("01b278d3-00fd-1000-e000-0006c0a813b2A8506915") ? DEFAULTPATH : (uiStyleID.equals("01b278d3-00fd-1000-e000-0003c0a813b2A8506915") ? "/skin/04" : WebContextUtil.getDefaultSkinPath())));
        return skinPath;
    }

    public static int[] getColorValue(String colorStyle) {
        if (StringUtils.isEmpty((String)colorStyle)) {
            return WebContextUtil.getDefaultSkinColor();
        }
        int[] tempColor = null;
        tempColor = colorStyle.indexOf("/skin/03") > 0 ? WebContext.CRYSTAL_BLUE_SKIN_COLOR_VALUE : (colorStyle.indexOf(DEFAULTPATH) > 0 ? WebContext.DIAMON_BLUE_THEME_SKIN_COLOR_VALUE : (colorStyle.indexOf("/skin/02") > 0 ? WebContext.ELEGANCE_BLUE_SKIN_COLOR_VALUE : (colorStyle.indexOf("/skin/04") > 0 ? WebContext.RED_THEME_SKIN_COLOR_VALUE : WebContextUtil.getDefaultSkinColor())));
        return tempColor;
    }

    public static int[] getLabelColorValue(String colorStyle) {
        if (StringUtils.isEmpty((String)colorStyle)) {
            return WebContextUtil.getDefaultLabelColor();
        }
        int[] tempColor = null;
        tempColor = colorStyle.indexOf("/skin/03") > 0 ? WebContext.CRYSTAL_BLUE_LABEL_COLOR_VALUE : (colorStyle.indexOf(DEFAULTPATH) > 0 ? WebContext.DIAMON_BLUE_THEME_LABEL_COLOR_VALUE : (colorStyle.indexOf("/skin/02") > 0 ? WebContext.ELEGANCE_BLUE_LABEL_COLOR_VALUE : (colorStyle.indexOf("/skin/04") > 0 ? WebContext.RED_THEME_LABEL_COLOR_VALUE : WebContextUtil.getDefaultLabelColor())));
        return tempColor;
    }

    public static String getDefaultColorStyle() {
        return WebContextUtil.getDefaultSkinPathFull();
    }

    public static String getInstallMode(HttpServletRequest request) {
        Cookie[] cooks = request.getCookies();
        Cookie cook = null;
        String mode = null;
        for (int i = 0; cooks != null && i < cooks.length; ++i) {
            cook = cooks[i];
            if (!"installMode".equals(cook.getName())) continue;
            mode = cook.getValue();
        }
        if (mode == null) {
            ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem("defaultInstallMode");
            mode = configItem.getProperty("installMode");
        }
        if (mode == null || "".equals(mode)) {
            return "started";
        }
        return mode;
    }

    public static String encodePassword(String userName, String password) {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return encodedPassword;
    }

    public static String decodePassword(String userName, String encodedPassword) {
        String password = "";
        try {
            password = CryptoTean.decrypt((String)userName, (String)encodedPassword);
        }
        catch (CryptException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return password;
    }

    public static String getDbType(String dbType) {
        if ("MS SQL Server".equals(dbType)) {
            return "0";
        }
        if ("DB2 UDB".equals(dbType)) {
            return "1";
        }
        return "2";
    }

    public static String render(HttpServletRequest request, String resName) {
        if (!StringUtils.isEmpty((String)resName) && resName.indexOf(PERSONALSET_PATH) > -1) {
            return resName + "?v=" + PortalPersonalSetUtil.getReloadTimeMark();
        }
        StringBuffer buf = new StringBuffer(WebContextUtil.getPortalContextPath(request));
        buf.append(CacheResource.getInstance().getRenderName(resName, WebContextUtil.isGZipSupport(request)));
        return buf.toString();
    }

    private static boolean isGZipSupport(HttpServletRequest request) {
        String encodingString = request.getHeader("Accept-Encoding");
        return encodingString != null && encodingString.indexOf("gzip") != -1;
    }

    public static String renderSkin(HttpServletRequest request, String resName) {
        String ctxPath = WebContextUtil.getPortalContextPath(request);
        if (!resName.startsWith("/")) {
            resName = "/" + resName;
        }
        StringBuffer buf = new StringBuffer(ctxPath);
        String skinPath = WebContextUtil.getUserSkinPath(request);
        buf.append(CacheResource.getInstance().getRenderName(skinPath.substring(ctxPath.length()) + resName, WebContextUtil.isGZipSupport(request)));
        return buf.toString();
    }

    public static String getskinPathByColorId(String colorId) {
        if (StringUtils.isEmpty((String)colorId)) {
            return "";
        }
        String skinPath = null;
        if (colorId.equals("01b278d3-00fd-1000-e000-0006c0a813b2A8506915")) {
            skinPath = DEFAULTPATH;
        } else if (colorId.equals("01b278d3-00fd-1000-e000-0005c0a813b2A8506915")) {
            skinPath = "/skin/02";
        } else if (colorId.equals("01b278d3-00fd-1000-e000-0004c0a813b2A8506915")) {
            skinPath = "/skin/03";
        } else if (colorId.equals("01b278d3-00fd-1000-e000-0003c0a813b2A8506915")) {
            skinPath = "/skin/04";
        }
        return skinPath;
    }

    public static String getDefaultSkinPath() {
        String defaultSkinPath = null;
        ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem(SKINPATHITEM);
        if (configItem == null) {
            defaultSkinPath = DEFAULTPATH;
        }
        defaultSkinPath = !StringUtils.isEmpty((String)(defaultSkinPath = configItem.getProperty(SKINPATH))) ? DEFAULTPATH : DEFAULTPATH;
        return defaultSkinPath;
    }

    public static String getValueByKey(String configitemname, String key) {
        String keyvalue = "";
        ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem(configitemname);
        if (configItem == null) {
            return keyvalue;
        }
        keyvalue = configItem.getProperty(key);
        if (null == keyvalue) {
            keyvalue = "";
        }
        return keyvalue;
    }

    public static String getDefaultSkinPathFull() {
        String defaultSkinPath = null;
        ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem(SKINPATHITEM);
        if (configItem == null) {
            defaultSkinPath = DEFAULTPATH;
        }
        if (StringUtils.isEmpty((String)(defaultSkinPath = configItem.getProperty(SKINPATH)))) {
            defaultSkinPath = DEFAULTPATH;
        }
        if (defaultSkinPath.indexOf(SIMPLE_STRING) >= 0) {
            defaultSkinPath = DEFAULTPATH;
        }
        return defaultSkinPath;
    }

    public static int[] getDefaultSkinColor() {
        String defaultSkinPath = WebContextUtil.getDefaultSkinPath();
        defaultSkinPath.replaceAll("", "");
        int[] tempColor = null;
        tempColor = "/skin/03".equalsIgnoreCase(defaultSkinPath) ? WebContext.CRYSTAL_BLUE_SKIN_COLOR_VALUE : (DEFAULTPATH.equalsIgnoreCase(defaultSkinPath) ? WebContext.DIAMON_BLUE_THEME_SKIN_COLOR_VALUE : ("/skin/02".equalsIgnoreCase(defaultSkinPath) ? WebContext.ELEGANCE_BLUE_SKIN_COLOR_VALUE : ("/skin/04".equalsIgnoreCase(defaultSkinPath) ? WebContext.RED_THEME_SKIN_COLOR_VALUE : WebContext.DIAMON_BLUE_THEME_SKIN_COLOR_VALUE)));
        return tempColor;
    }

    public static int[] getDefaultLabelColor() {
        String defaultSkinPath = WebContextUtil.getDefaultSkinPath();
        int[] tempColor = null;
        tempColor = "/skin/03".equalsIgnoreCase(defaultSkinPath) ? WebContext.CRYSTAL_BLUE_LABEL_COLOR_VALUE : (DEFAULTPATH.equalsIgnoreCase(defaultSkinPath) ? WebContext.DIAMON_BLUE_THEME_LABEL_COLOR_VALUE : ("/skin/02".equalsIgnoreCase(defaultSkinPath) ? WebContext.ELEGANCE_BLUE_LABEL_COLOR_VALUE : ("/skin/04".equalsIgnoreCase(defaultSkinPath) ? WebContext.RED_THEME_LABEL_COLOR_VALUE : WebContext.DIAMON_BLUE_THEME_LABEL_COLOR_VALUE)));
        return tempColor;
    }

    public static String getDefaultLoginPage() {
        String defaultSkinPath = WebContextUtil.getDefaultSkinPath();
        String redirectToLogin = "";
        redirectToLogin = DEFAULTPATH.equalsIgnoreCase(defaultSkinPath) ? "/login_withForm_blue.jsp" : ("/skin/02".equalsIgnoreCase(defaultSkinPath) ? "login_withForm_orange.jsp" : ("/skin/03".equalsIgnoreCase(defaultSkinPath) ? "login_withForm_green.jsp" : ("/skin/04".equalsIgnoreCase(defaultSkinPath) ? "login_withForm_red.jsp" : "/login_withForm_blue.jsp")));
        return redirectToLogin;
    }

    public String getEasContextPath() {
        String url = "/easweb";
        ConfigurationItem configItem = PortalConfig.getConfiguration().getConfigItem("eas_web");
        if (configItem != null) {
            url = configItem.getProperty("url");
        }
        return url;
    }

    public static String getColorSchema(HttpServletRequest request) {
        String userSkinPath = WebContextUtil.getUserSkinPath(request);
        if (userSkinPath == null) {
            return "01";
        }
        return userSkinPath.substring(userSkinPath.length() - 2);
    }

    public static void initRpcConfig(Context ctx) {
        String sessionid = ctx.getContextID();
        WebContextUtil.initRpcInnerConfig(ctx, sessionid);
    }

    public static void initRpcInnerConfig(Context ctx, String sessionid) {
        HashMap<String, String> envContext = new HashMap<String, String>();
        String rpcUrl = "";
        ConfigurationItem configItem = PortalConfig.getConfigurationItem((String)"rpcUrl");
        if (configItem != null) {
            rpcUrl = configItem.getProperty("rpcUrl");
        }
        if (!StringUtils.isEmpty((String)rpcUrl)) {
            envContext.put("URL", rpcUrl);
        } else {
            String serverType = System.getProperty("APP_SERVER_TYPE");
            if (serverType != null && APP_SERVER_TYPE_APUSIC.equalsIgnoreCase(serverType)) {
                envContext.put("URL", "[LOCAL]");
            } else {
                envContext.put("URL", "tcp://127.0.0.1:" + ORMRPConfig.getTcpConnectionPort());
            }
        }
        if (envContext.get("URL").equals("[LOCAL]")) {
            envContext.put("BOSCTX", (String)ctx);
            System.setProperty("remoteMode", "false");
        } else {
            envContext.put("SESSIONID", sessionid);
            System.setProperty("remoteMode", "true");
        }
        GeniusBOSFactory.setEnvContext(envContext);
    }
}

